<?php
$site_setting = site_setting();

$display_executive_summary = "block";
if ($executive_summary_file != '') $display_executive_summary = "none";

if ($term_sheet_file != '') $display_terms_sheet = "none";
$display_terms_sheet = "block";

?>

<script src="<?php echo base_url(); ?>js/jquery.form.js"></script>
<script type="text/javascript">
    var equity_id = <?php echo $id;?>;
    var executive_summary_status = '<?php echo $executive_summary_status;?>';
    var term_sheet_status = '<?php echo $term_sheet_status;?>';
</script>

<?php
$attributes = array(
    'id' => 'investor_deal_document_form',
    'name' => 'investor_deal_document_form',
    'enctype' => 'multipart/form-data',
    'class' => 'edit_project',
    'method' => 'post',
    'accept-charset' => 'UTF-8'
);
echo form_open_multipart('start_equity/investor_deal_document/', $attributes);
?>
<div class="sr-only" id="investor_deal_document_image"></div>
</form>
<?php
$attributes = array(
    'id' => 'video_form',
    'name' => 'video_form',
    'enctype' => 'multipart/form-data',
    'class' => 'edit_project',
    'method' => 'post',
    'accept-charset' => 'UTF-8'
);
echo form_open_multipart('start_equity/video_save/', $attributes);
?>
<div class="sr-only" id="edit_video_form_image"></div>
</form>

<section>
<div class="container padTB50">
<div class="campaign-title-text">

    <h2><?php echo PRE_FUNDING_DETAILS; ?></h2>

    <p>
        <?php echo ADD_YOUR_PRE_FUDING; ?>
    </p>

</div>

<div id="page_we">
<div class="row">
<?php


echo $this->load->view(THEME_LOCATION . 'start_equity/create_step_sidebar', $id); ?>
<div class="col-md-9 create-campain-right" id="previous_funding">
<div class="create-campain-bg">
    <div class="create-campain-group">
        <div class="project-form-headline">
            <h3><?php echo EQUITY_PREVIOUS_FUNDING; ?></h3>

            <p><?php echo ADD_FUNDING_FROM_PREV; ?></p>
        </div>

        <div class="in-form step-form form-horizontal create-campain-form">
            <div class="previous_funding_img" id="load-previous-funding-data">


            </div>
            <div class="perk-div" id="prev-funding-box">
                <div class="row">
                    <div class="col-lg-6">
                        <div class="form-group">
                            <label class="control-label" for="project_title"><?php echo FUNDING_SOURCE; ?></label>
                            <select name="funding_source" id="funding_source" class="selectpicker">
                                <option value=""><?php echo SELECT_FUNDING_SOURCE; ?></option>
                                <?php
                                if ($funding_source_data) {
                                    foreach ($funding_source_data as $funding_source) {
                                        ?>
                                        <option
                                            value="<?php echo $funding_source['funding_source_name']; ?>"><?php echo $funding_source['funding_source_name']; ?></option>
                                    <?php
                                    }
                                }
                                ?>
                            </select>
                            <span class="funding_source_error create_step_error"></span>
                        </div>
                        <div class="form-group">
                            <label class="control-label" for="amount"><?php echo FUNDING_AMOUNT; ?></label>

                            <div class="in-amount">
                                <span class="in-currency"><?php echo set_currency(null, $id, 'yes'); ?> </span>
                                <input name="funding_amount" id="funding_amount" type="text" value=""
                                       class="form-control">
                                <input name="prev_funding_equity_id" id="prev_funding_equity_id" type="hidden"
                                       value="<?php echo $id; ?>" placeholder="" class="form-control">
                                <input name="prev_funding_id" id="prev_funding_id" type="hidden" value="0"
                                       placeholder="" class="form-control">
                                <span class="funding_amount_error create_step_error"></span>
                            </div>

                        </div>
                    </div>
                    <div class="col-lg-6">
                        <div class="form-group">
                            <label class="control-label" for="project_title"><?php echo EQUITY_FUNDING_TYPE; ?></label>
                            <select name="funding_type" id="funding_type" class="selectpicker">
                                <option value=""><?php echo SELECT_EQUITY_FUNDING_TYPE; ?></option>
                                <?php
                                if ($funding_type_data) {
                                    foreach ($funding_type_data as $funding_type) {
                                        ?>
                                        <option
                                            value="<?php echo $funding_type['funding_type_name']; ?>"><?php echo $funding_type['funding_type_name']; ?></option>
                                    <?php
                                    }
                                }
                                ?>
                            </select>
                            <span class="funding_type_error create_step_error"></span>
                        </div>
                        <div class="form-group">
                            <label class="control-label" for="amount"><?php echo FUNDING_DATE; ?></label>

                            <div class="in-amount">
                                <div class="in-input-icon">
                                    <input type="text" class="form-control datepicker" name="funding_date" value=""
                                           id="funding_date">
                                    <i class="glyphicon glyphicon-calendar"></i>
                                </div>
                                <span class="funding_date_error create_step_error"></span>
                            </div>

                        </div>
                    </div>
                    <div class="clearfix"></div>
                </div>

            </div>
            <div class="campain-group-footer clearfix">
                <div class="pull-right">
                    <button class="btn-grey btn-cancel" id="ajax-cancel-previous-funding-source" style="display:none;"
                            type="button"><?php echo CANCEL; ?></button>
                    <button class="btn-grey plus-icon" id="ajax-add-previous-funding-source"
                            type="button"><?php echo ADD_PREV_FUNDING_SOURCE; ?></button>

                </div>
            </div>
        </div>
    </div>
</div>

<div class="create-campain-bg marT10 smallwidth" id="investors">
    <div class="create-campain-group">
        <div class="project-form-headline">
            <?php
            $attributes = array(
                'id' => 'investor_image_form',
                'name' => 'investor_image_form',
                'enctype' => 'multipart/form-data',
                'class' => 'edit_project',
                'method' => 'post',
                'accept-charset' => 'UTF-8'
            );
            echo form_open_multipart('start_equity/investor_save/', $attributes);
            ?>
            <div class="sr-only" id="edit_investor_image"></div>
            </form>
            <h3><?php echo INVESTORS; ?></h3>
        </div>
        <div class="in-form step-form form-horizontal create-campain-form">
            <div class="row">
                <div class="col-lg-12 in-media-list" id="load-investor-list">
                </div>
            </div>
            <div class="perk-div">
                <div class="row" id="investor-box">
                    <span id="error-investor"></span>

                    <div class="col-lg-12">
                        <div class="row">
                            <div class="col-lg-6">
                                <div class="form-group">
                                    <label class="control-label"
                                           for="project_title"><?php echo INVESTOR_TYPE; ?></label>
                                    <select name="investor_type" id="investor_type" class="selectpicker">
                                        <option value=""><?php echo SELECT_INVESTOR_TYPE; ?></option>
                                        <?php
                                        if ($investor_type_data) {
                                            foreach ($investor_type_data as $investor_type) {
                                                ?>
                                                <option
                                                    value="<?php echo $investor_type['investor_type_name']; ?>"><?php echo $investor_type['investor_type_name']; ?></option>
                                            <?php
                                            }
                                        }
                                        ?>
                                    </select>
                                    <input name="investor_equity_id" id="investor_equity_id" type="hidden"
                                           value="<?php echo $id; ?>" placeholder="" class="form-control">
                                    <input name="investor_id" id="investor_id" type="hidden" value="0" placeholder=""
                                           class="form-control">
                                    <span class="investor_type_error create_step_error"></span>
                                </div>
                            </div>
                            <div class="col-lg-6 col-sm-12">
                                <div class="form-group">
                                    <label class="control-label"
                                           id="investor_label_change"><?php echo FIRST_AND_LAST_NAME; ?></label>

                                    <div class="in-amount">
                                        <input name="investor_name" id="investor_name" type="text" value=""
                                               placeholder="" class="form-control">
                                    </div>
                                    <span class="investor_name_error create_step_error"></span>
                                </div>
                            </div>
                        </div>
                        <div class="row" id="hide_desc">
                            <div class="col-lg-3 col-md-4 col-sm-3">
                                <div class="form-group">
                                    <label class="control-label" for="amount"><?php echo INVESTOR_PHOTO; ?><label
                                            class="control-label pd0"><span class="question-sign" data-trigger="hover"
                                                                            data-html="true" data-container="body"
                                                                            data-toggle="popover" data-placement="right"
                                                                            data-content="PNG, JPG or GIF <br/><br/><b>Recommended size:</b><br/>170 x 170 pixels <br> Max Size: <?php echo $upload_limit; ?>MB"><i
                                                    class="glyphicon glyphicon-question-sign"></i></span></label></label>

                                    <div class="campain-card-img member-pro-img">
                                        <div class="member-logo">
                                            <img src="<?php echo base_url(); ?>images/member_img.jpg" id="team_img2"
                                                 class="img-thumbnail"/>
                                            <span class="member_image_error create_step_error"></span>
                                        </div>
                                        <div class="upload browsefile topspace pull-left" id="investor_image_display">
                                            <input type="file" id="investor_image" name="investor_image"
                                                   class="filestyle for_secondimageAjax" data-input="false"
                                                   data-buttonName="btn-main" data-iconName="glyphicon-picture"
                                                   data-buttonText="<?= BROWSE ?>" title=""/>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-9 col-md-8 col-sm-9">
                                <div class="row">

                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label class="control-label"><?php echo EMAIL_ADDRESS; ?></label>

                                            <div class="in-amount">
                                                <input name="email" id="email" type="text" value="" placeholder=""
                                                       class="form-control">
                                            </div>
                                            <span class="email_error create_step_error"></span>
                                        </div>
                                    </div>
                                    <div class="col-lg-12">
                                        <div class="form-group">
                                            <label class="control-label"><?php echo INVESTOR_BIO; ?></label>

                                            <div class="in-amount">
                                                <textarea class="form-control" rows="5" name="investor_description"
                                                          id="investor_description"></textarea>
                                                <span class="investor_description_error create_step_error"></span>
                                                <!--<p class="smallfont">160 Characters</p>-->
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>

                </div>

            </div>
            <div class="campain-group-footer clearfix">
                <div class="pull-right">
                    <button class="btn-grey btn-cancel" id="ajax-investor-cancel" style="display:none;"
                            type="button"><?php echo CANCEL; ?></button>
                    <button class="btn-grey plus-icon" id="ajax-investor-add"><?php echo ADD_INVESTORS; ?></button>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="create-campain-bg marT10" id="deal_documents">
<div class="create-campain-group">
<div class="project-form-headline">
    <h3><?php echo DEAL_DOCUMENTS; ?></h3>

    <p><?php echo AN_EXECUTIVE_SUMMARY_AND_TERM_SHEET_ARE_REQUIRED; ?></p>
</div>
<div class="in-form step-form form-horizontal create-campain-form">
<div class="row">
<div class="col-lg-12">
<?php

$field_readonly = '';
if ($status_check) {

    $field_readonly = 'data-disabled="true"';
}
//if owner allow to upload file
if ($site_setting['sign_contract_upload_by'] == 0 && $site_setting['contract_copy_status'] == 0) {
    ?>
    <div class="form-group" id="box-contract-copy" stye="display:<?php echo
    $display_executive_summary;?>">

        <div class="doc-left">
            <label class="checkedselector-label marR10"><?php echo SIGN_CONTRACT; ?><span class="form_star">*</span>
                <label class="control-label pd0"><span class="question-sign" data-trigger="hover"
                                                       data-html="true" data-container="body"
                                                       data-toggle="popover" data-placement="right"
                                                       data-content="<?php echo RECOMMENDED_FILE_FORMAT_SHOULD_BE_IMG_DOC; ?>"><i
                            class="glyphicon glyphicon-question-sign"></i></span></label></label>
            <span class="contract_copy_file_error create_step_error"></span>

            <p class="profile-time" id="">


                <span id="contract_copy_file_path">  <?php echo $contract_copy_file; ?></span>
                <?php if (!$status_check) { ?>

                    <a href="javascript:void(0)" class="delete-contract-copy"><i
                            class="fa fa-close"></i></a>
                <?php } ?>
            </p>
            </p>
        </div>
        <div class="doc-right clearfix">


            <div class="doc-browse">
                <div class="campain-card-img campain-card-img2">

                    <div class="ploader ploader-card-img" id="pmimage">
                        <div id="loader_pitch" class="loader"></div>
                    </div>
                    <div class="upload  " id="contract_copy_file_display">
                        <input type="file" id="contract_copy_file" name="contract_copy_file"
                               class="filestyle for_secondimageAjax " data-input="false"
                               data-buttonName="btn-main" data-iconName="glyphicon-file"
                               data-buttonText="<?= BROWSE ?>" title=""/>
                    </div>

                </div>
            </div>
        </div>
    </div>

<?php
}

?>
<div class="form-group" id="box-load-executive-summary"
     stye="display:<?php echo $display_executive_summary; ?>">
    <input type="hidden" name="document_case" id="document_case" value="0">
    <input type="hidden" name="deal_document_id" id="deal_document_id" value="">
    <input type="hidden" name="equity_id" id="equity_id" value="<?php echo $id; ?>">

    <div class="doc-left">
        <label class="checkedselector-label marR10"><?php echo EXECUTIVE_SUMMARY; ?><span class="form_star">*</span>
            <label class="control-label pd0"><span class="question-sign" data-trigger="hover"
                                                   data-html="true" data-container="body"
                                                   data-toggle="popover" data-placement="right"
                                                   data-content="<?php echo RECOMMENDED_FILE_FORMAT_SHOULD_BE_IMG_DOC; ?>"><i
                        class="glyphicon glyphicon-question-sign"></i></span></label></label>
        <span class="executive_summary_file_error create_step_error"></span>

        <p class="profile-time" id="">


            <span id="executive_summary_file_path">  <?php echo $executive_summary_file; ?></span>
            <?php if (!$status_check) { ?>
                <!-- <a href="javascript:void(0)" class="delete-executive-document"><i class="fa fa-close"></i></a> -->
                <a class="delete_executive_document" title="<?php echo DELETE; ?>" href="javascript:void(0);"
                   data-toggle="modal" data-target="#confirmDeleteexecutivedocument"><i class="fa fa-close"></i></a>
            <?php } ?>
        </p>
        </p>
    </div>
    <div class="doc-right clearfix">
        <div class="switch-btn">
            <div id="label-switch" class="make-switch switch-event" data-on-label="<?php echo PRIVATEC; ?>"
                 data-off-label="<?php echo PUBLICC; ?>">
                <input type="checkbox" id="executive_summary_status" name="executive_summary_status"
                       value="1">
            </div>
        </div>


        <div class="doc-browse">
            <div class="campain-card-img campain-card-img2">
                <input type="hidden" id="file_name1" name="file_name" class="browse inputDefault_S"
                       value=""/>

                <div class="ploader ploader-card-img" id="pmimage">
                    <div id="loader_pitch" class="loader"></div>
                </div>
                <div class="upload brand-orignew " id="executive_summary_file_display">
                    <input type="file" id="executive_summary_file"
                           name="executive_summary_file" <?php echo $field_readonly; ?>
                           class="filestyle for_secondimageAjax " data-input="false"
                           data-buttonName="btn-main" data-iconName="glyphicon-file"
                           data-buttonText="<?= BROWSE ?>" title=""/>
                </div>

            </div>
        </div>
    </div>
    <div aria-hidden="true" aria-labelledby="confirmDeleteLabel" class="modal fade" id="confirmDeleteexecutivedocument"
         role="dialog">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <button aria-hidden="true" class="close" data-dismiss="modal" type="button">&times;</button>
                    <h4 class="modal-title"><?php echo DELETE_PARMANENTLY; ?></h4>
                </div>
                <div class="modal-body">
                    <p><?php echo ARE_YOU_SURE_ABOUT_THIS; ?></p>
                </div>
                <div class="modal-footer">
                    <button class="btn btn-default" data-dismiss="modal" type="button"><?php echo CANCEL; ?></button>
                    <a class="btn btn-danger delete-executive-document" href="javascript:void(0)"
                       rel=""><?php echo DELETE; ?></a>
                    <!-- <button class="btn btn-danger" id="confirm" type="button">Delete</button> -->
                </div>
            </div>
        </div>
    </div>
</div>
<div class="form-group" id="box-load-terms-sheet" stye="display:<?php echo
$display_terms_sheet;?>">
    <div class="doc-left">
        <label class="checkedselector-label marR10"><?php echo TERM_SHEET; ?><span
                class="form_star">*</span> <label class="control-label pd0"><span class="question-sign"
                                                                                  data-trigger="hover"
                                                                                  data-html="true"
                                                                                  data-container="body"
                                                                                  data-toggle="popover"
                                                                                  data-placement="right"
                                                                                  data-content="<?php echo RECOMMENDED_FILE_FORMAT_SHOULD_BE_IMG_DOC; ?>"><i
                        class="glyphicon glyphicon-question-sign"></i></span></label></label>
        <span class="term_sheet_file_path_error create_step_error"></span>

        <p class="profile-time">

            <span id="term_sheet_file_path">  <?php echo $term_sheet_file; ?></span>
            <?php if (!$status_check) { ?>
                <!-- <a href="javascript:void(0)" class="delete-termsheet-document"><i class="fa fa-close"></i></a> -->
                <a class="delete_termsheet_document" title="<?php echo DELETE; ?>" href="javascript:void(0);"
                   data-toggle="modal" data-target="#confirmDeletetermsheetdocument"><i class="fa fa-close"></i></a>
            <?php } ?>
        </p>

    </div>
    <div aria-hidden="true" aria-labelledby="confirmDeleteLabel" class="modal fade" id="confirmDeletetermsheetdocument"
         role="dialog">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <button aria-hidden="true" class="close" data-dismiss="modal" type="button">&times;</button>
                    <h4 class="modal-title"><?php echo DELETE_PARMANENTLY; ?></h4>
                </div>
                <div class="modal-body">
                    <p><?php echo ARE_YOU_SURE_ABOUT_THIS; ?></p>
                </div>
                <div class="modal-footer">
                    <button class="btn btn-default" data-dismiss="modal" type="button"><?php echo CANCEL; ?></button>
                    <a class="btn btn-danger delete-termsheet-document" href="javascript:void(0)"
                       rel=""><?php echo DELETE; ?></a>
                    <!-- <button class="btn btn-danger" id="confirm" type="button">Delete</button> -->
                </div>
            </div>
        </div>
    </div>
    <div class="doc-right clearfix">
        <div class="switch-btn">
            <div id="label-switch" class="make-switch switch-event" data-on-label="<?php echo PRIVATEC; ?>"
                 data-off-label="<?php echo PUBLICC; ?>">
                <input type="checkbox" id="term_sheet_status" name="term_sheet_status" value="1"
                       >

            </div>
        </div>

        <div class="doc-browse">
            <div class="campain-card-img campain-card-img2">

                <div class="ploader ploader-card-img" id="pmimage">
                    <div id="loader_pitch" class="loader"></div>
                </div>
                <div class="upload brand-orignew" id="term_sheet_file_display">
                    <input type="file" id="term_sheet_file"
                           name="term_sheet_file" <?php echo $field_readonly; ?>
                           class="filestyle for_secondimageAjax " data-input="false"
                           data-buttonName="btn-main" data-iconName="glyphicon-file"
                           data-buttonText="<?= BROWSE ?>" title=""/>
                </div>

            </div>
        </div>
    </div>
</div>

</div>
</div>
<hr>
<div class="row">
    <div class="col-lg-12 previous_funding_img" id="load-deal-document-list">


    </div>
    <div class="col-lg-12 perk-div addDocs selectbox_height" id="addDoc">
        <p><?php echo ADD_ADDITIONAL_DOCS_OR_FILES; ?></p>

        <div class="clearfix">
            <div class="doc-left">
                <div class="form-group" id="deal_document_type_selecbox">
                    <select name="deal_document_type" id="deal_document_type" class="selectpicker">
                        <option value=""><?php echo SELECT; ?></option>
                        <?php
                        if ($document_type_data) {
                            foreach ($document_type_data as $document_type) {
                                ?>
                                <option
                                    value="<?php echo $document_type['document_type_name']; ?>"><?php echo $document_type['document_type_name']; ?></option>
                            <?php
                            }
                        }
                        ?>
                        <option value="addnew" class="div-show"><?php echo ADD_CUSTOM_DOCUMENT; ?></option>
                    </select>
                    <span class="deal_document_type_error create_step_error"></span>
                </div>
            </div>
            <div class="custom_textbox">
                <input name="deal_document_type_other" id="deal_document_type_other" type="text" value=""
                       placeholder="<?php echo DOCUMENT_NAME; ?>" class="form-control">
                <span class="deal_document_type_other_error create_step_error"></span>
            </div>
            <div class="doc-right">
                <div class="switch-btn">
                    <div id="custom-document-switch" class="make-switch" data-on-label="<?php echo PRIVATEC; ?>"
                         data-off-label="<?php echo PUBLICC; ?>">
                        <input type="checkbox" id="deal_document_status" name="deal_document_status" value="1">
                    </div>
                </div>
                <div class="doc-browse">
                    <div class="form-group accessMT46">
                        <div class="campain-card-img campain-card-img2">
                            <input type="hidden" id="file_name1" name="file_name" class="browse inputDefault_S"
                                   value=""/>

                            <div class="ploader ploader-card-img" id="pmimage">
                                <div id="loader_pitch" class="loader"></div>
                            </div>
                            <div class="upload brand-orignew" id="deal_document_other_display">
                                <input type="file" id="deal_document_other" name="deal_document_other"
                                       class="filestyle for_secondimageAjax" data-input="false"
                                       data-buttonName="btn-main" data-iconName="glyphicon-file"
                                       data-buttonText="<?= BROWSE ?>" title=""/>
                            </div>
                            <span class="deal_document_other_error create_step_error"></span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="pull-right document_button_update" style="display:none;">
            <button class="btn-grey btn-cancel" id="ajax-doc-cancel" style=""><?php echo CANCEL; ?></button>
            <button class="btn-grey" id="deal_document_update"><?php echo UPDATE; ?></button>
        </div>
    </div>
</div>


</div>
</div>
</div>

<div class="create-campain-bg marT10 " id="video_gallery">
    <div class="create-campain-group">
        <div class="project-form-headline">
            <h3><?php echo VIDEO_GALLERY; ?></h3>

            <p><?php echo ADD_MORE_VIDEO; ?></p>
        </div>

        <!--  <div class="alert alert-danger alert-message errorAjax3 error_change" style="display: none;"></div>
         <div class="alert alert-success alert-message successAjax131 success_change" style="display:none"></div>  -->
        <div class="in-form form-horizontal create-campain-form" id="video-box">

            <div class="row">

                <!--VIDEO  -->

                <div class="col-lg-12 clearfix">

                    <div class="video-list in-media-list" id="load-video-list">


                    </div>

                    <div class="perk-div">

                        <div class="row">
                            <div class="col-lg-6">
                                <div class="form-group">
                                    <label class="control-label" for="project_title"><?php echo URL; ?></label>
                                    <input name="media_video_name" id="media_video_name" type="text" value=""
                                           placeholder="YouTube or Vimeo Link" class="form-control">
                                    <input name="equity_id" id="equity_id" type="hidden" value="<?php echo $id; ?>"
                                           placeholder="" class="form-control">
                                    <input name="video_id" id="video_id" type="hidden" value="0" placeholder=""
                                           class="form-control">
                                    <span class="media_video_name_error create_step_error"></span>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="form-group">
                                    <label class="control-label" for="project_title"><?php echo TITLE; ?></label>
                                    <input name="media_video_title" id="media_video_title" type="text" value=""
                                           placeholder="" class="form-control">
                                    <span class="media_video_title_error create_step_error"></span>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="form-group">
                                    <label class="control-label" for="project_title"><?php echo DESCRIPTION; ?></label>
                                    <textarea class="form-control" rows="4" name="media_video_desc"
                                              id="media_video_desc"></textarea>
                                    <span class="media_video_desc_error create_step_error"></span>
                                </div>
                                <div id="video-switch" class="make-switch" data-on-label="<?php echo PRIVATEC; ?>"
                                     data-off-label="<?php echo PUBLICC; ?>">
                                    <input type="checkbox" name="media_video_status" id="media_video_status" value="1">
                                </div>
                            </div>
                        </div>

                    </div>
                    <div class="campain-group-footer clearfix">
                        <div class="pull-right">
                            <button class="btn-grey btn-cancel" id="ajax-video-cancel"
                                    style="display:none;"><?php echo CANCEL; ?></button>
                            <button class="btn-grey plus-icon" id="ajax-video-add"><?php echo ADD_VIDEO; ?></button>
                        </div>
                    </div>

                </div>


            </div>
        </div>
    </div>
</div>

<div class="create-campain-bg marT10 for_createstep3ajax" id="image_gallery">
    <div class="create-campain-group">
        <div class="project-form-headline">
            <h3><?php echo IMAGE_GALLERY; ?></h3>

            <p><?php echo ADD_MORE_IMAGE; ?></p>
        </div>
        <div class="alert alert-danger alert-message errorAjax14" style="display: none;"></div>
        <div class="alert alert-success alert-message successAjax141" style="display: none;"><span><?php echo IMAGE_UPLOADED_SUCCESSFULLY;?></span>
        </div>
        <?php
        $attributes = array(
            'id' => 'image_form',
            'name' => 'image_form',
            'enctype' => 'multipart/form-data',
            'class' => 'edit_project',
            'method' => 'post',
            'accept-charset' => 'UTF-8'
        );
        echo form_open_multipart('start_equity/image_save/', $attributes);
        ?>
        <div class="sr-only" id="edit_image_form"></div>

        <div class="in-form form-horizontal create-campain-form" id="image-box">


            <div class="row">

                <!--Image  -->

                <div class="col-lg-12 marT10 clearfix">

                    <div class="addimage-list in-media-list" id="load-image-list">


                    </div>

                    <div class="perk-div">

                        <div class="row">
                            <div class="col-lg-6">
                                <div class="form-group">
                                    <label class="control-label" for="project_title"><?php echo BROWSE; ?></label>

                                    <div id="picture_file_field_image">
                                        <input type="file" value="" class="filestyle project_picture"
                                               data-buttonName="btn-main" data-buttonText="<?= ADD_IMAGE_ ?>"
                                               data-iconName="glyphicon-picture" name="image" id="image"/>
                                    </div>
                                    <span class="image_error create_step_error"></span>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="form-group">
                                    <label class="control-label" for="project_title"><?php echo TITLE; ?></label>
                                    <input name="image_name" id="image_name" type="text" value="" placeholder=""
                                           class="form-control">

                                    <input name="equity_id" id="equity_id" type="hidden" value="<?php echo $id; ?>"
                                           placeholder="" class="form-control">
                                    <input name="image_id" id="image_id" type="hidden" value="0" placeholder=""
                                           class="form-control">
                                    <span class="image_name_error create_step_error"></span>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="form-group">
                                    <label class="control-label" for="project_title"><?php echo DESCRIPTION; ?></label>
                                    <textarea class="form-control" rows="4" name="image_desc"
                                              id="image_desc"></textarea>
                                    <span class="image_desc_error create_step_error"></span>
                                </div>
                                <div id="image-switch" class="make-switch" data-on-label="<?php echo PRIVATEC; ?>"
                                     data-off-label="<?php echo PUBLICC; ?>">
                                    <input type="checkbox" name="image_status" id="image_status" value="1">
                                </div>
                            </div>
                        </div>

                    </div>
                    <div class="campain-group-footer clearfix">
                        <div class="pull-right">
                            <button class="btn-grey btn-cancel" id="ajax-image-cancel"
                                    style="display:none;"><?php echo CANCEL; ?></button>
                            <button class="btn-grey plus-icon" id="ajax-image-add"><?php echo ADD_IMAGE; ?></button>
                        </div>
                    </div>

                </div>

            </div>

        </div>
        </form>
    </div>
</div>

</div>
</div>
<div class="create-campain-footer text-right">

    <input type="hidden" name="id" id="id" value="<?php echo $id; ?>">

    <a href="<?php echo site_url('start_equity/create_step5/' . $id); ?>"
       class="create-campain-btn"> <?php echo NEXT; ?></a>
</div>
</div>

</div>
</section>


<script type="text/javascript">

function change_status(type) {

    if (type = 'executive_summery') {
        if ($("#executive_summary_status").is(":checked")) {
            var executive_summary_status = 1;

        }
        else {
            var executive_summary_status = 0;

        }
    }
    if (type = 'term_sheet') {
        if ($("#term_sheet_status").is(":checked")) {
            var term_sheet_status = 1;

        }
        else {
            var term_sheet_status = 0;

        }
    }

    var equity_id_value = '<?php echo $id;?>';
    var mapdata = {
        "equity_id": equity_id_value,
        "executive_summary_status": executive_summary_status,
        "term_sheet_status": term_sheet_status,
        "document_change": type
    };

    var getStatusUrl = '<?php echo site_url('start_equity/document_change_status')?>';//alert(getStatusUrl)
    $.ajax({
        url: getStatusUrl,
        dataType: 'text',
        type: 'POST',
        timeout: 99999,
        global: false,
        data: mapdata,
        //data:{'perk[]':mapdata},
        success: function (data) {

        },
        error: function (XMLHttpRequest, textStatus, errorThrown) {

        }
    });


}


/**************Start: Funding Source code***********************/
//add record from table
var max = new Date().decrement('day', 0)
new Picker.Date($('#funding_date'), {
    timePicker: false,
    positionOffset: {x: 5, y: 0},
    pickerClass: 'datepicker_bootstrap',
    useFadeInOut: !Browser.ie,
    dateFormat: '%Y-%m-%d', maxDate: max, onSelect: function (date, input) {
        var newd = date;
        document.getElementById('funding_date').value = date.format('%Y-%m-%d');
    }
});
$("body").on("click", "#ajax-add-previous-funding-source", function (event) {

    PopupOpen();
    var previous_funding_id = $.trim($("#prev_funding_id").val());
    var funding_source = $.trim($("#funding_source").val());
    var funding_amount = $.trim($("#funding_amount").val());
    var funding_type = $.trim($("#funding_type").val());
    var funding_date = $.trim($("#funding_date").val());

    $.post("<?php echo site_url('start_equity/prev_funding_save')?>", {
        funding_source: funding_source,
        funding_amount: funding_amount,
        funding_type: funding_type,
        funding_date: funding_date,
        previous_funding_id: previous_funding_id,
        equity_id: equity_id
    }, function (result) {
        var result = $.parseJSON(result);
        var error = result.error;
        var msg = result.msg;
        var url = result.url;

        PopupClose();

        if (url != '') {
            location.href = url;
        }
        else if (error == true) {
            var funding_amount_error = result.funding_amount_error;
            $(".funding_amount_error").html(funding_amount_error);
            var funding_source_error = result.funding_source_error;
            $(".funding_source_error").html(funding_source_error);
            var funding_type_error = result.funding_type_error;
            $(".funding_type_error").html(funding_type_error);
            var funding_date_error = result.funding_date_error;
            $(".funding_date_error").html(funding_date_error);
        }
        else {
            empty_previous_funding_form();
            list_previous_funding_data();
            $("#ajax-cancel-previous-funding-source").hide();
            $("#ajax-add-previous-funding-source").html('<?php echo ADD_PREV_FUNDING_SOURCE;?>');
            $("#ajax-add-previous-funding-source").addClass("plus-icon");
        }
    });
});
//load particular team record with form
$("body").on("click", ".edit-previous-funding", function (event) {

    var prev_funding_id = $(this).attr("rel");

    $.post("<?php echo site_url('start_equity/edit_prev_funding')?>", {
        prev_funding_id: prev_funding_id,
        equity_id: equity_id
    }, function (result) {

        var result = $.parseJSON(result);
        var error = result.error;
        var msg = result.msg;
        var url = result.url;

        if (url != '') {
            //location.href=url;
        }
        if (error == true) {
            //$("#error-msg-company-industry").html(msg);
        }
        else {
            $(".funding_amount_error").html('');

            $(".funding_source_error").html('');

            $(".funding_type_error").html('');

            $(".funding_date_error").html('');
            $("#ajax-cancel-previous-funding-source").show();
            $("#ajax-add-previous-funding-source").html('<?php echo UPDATE_PREV_FUNDING_SOURCE;?>');
             $("#ajax-add-previous-funding-source").removeClass("plus-icon");
            var prev_funding_id = result.previous_funding.previous_funding_id;
            $("#prev_funding_id").val(prev_funding_id);
            var funding_amount = result.previous_funding.funding_amount;
            $("#funding_amount").val(funding_amount);
            var funding_date = result.previous_funding.funding_date;

            var funding_new_date = GetFormattedDate(funding_date);


            $("#funding_date").val(funding_new_date);

            var funding_source = result.previous_funding.funding_source;
            $('select[name=funding_source]').val(funding_source);
            $('select[name=funding_source]').change();
            $('select[name=funding_source]').selectpicker('refresh');
            var funding_type = result.previous_funding.funding_type;
            $('select[name=funding_type]').val(funding_type);
            $('select[name=funding_type]').change();
            $('select[name=funding_type]').selectpicker('refresh');


        }
    });
});
//delete record from table
$("body").on("click", ".delete-previous-funding", function (event) {
    var previous_funding_id = $(this).attr("rel");
    $('#confirmDeletepreviousfunding').modal('toggle');
    PopupOpen();
    // $(this).parent().parent().parent().remove();
    $.post("<?php echo site_url('start_equity/delete_prev_funding')?>", {
        previous_funding_id: previous_funding_id,
        equity_id: equity_id
    }, function (result) {
        $(".funding_amount_error").html('');

        $(".funding_source_error").html('');

        $(".funding_type_error").html('');

        $(".funding_date_error").html('');

        empty_previous_funding_form();
        list_previous_funding_data();
        $("#ajax-cancel-previous-funding-source").hide();
        $("#ajax-add-previous-funding-source").html('<?php echo ADD_PREV_FUNDING_SOURCE;?>');
         $("#ajax-add-previous-funding-source").addClass("plus-icon");
        PopupClose();
    });
});
$("body").on("click", "#ajax-cancel-previous-funding-source", function (event) {


    $(".funding_amount_error").html('');

    $(".funding_source_error").html('');

    $(".funding_type_error").html('');

    $(".funding_date_error").html('');

    empty_previous_funding_form();
    list_previous_funding_data();
    $("#ajax-cancel-previous-funding-source").hide();
    $("#ajax-add-previous-funding-source").html('<?php echo ADD_PREV_FUNDING_SOURCE;?>');
     $("#ajax-add-previous-funding-source").addClass("plus-icon");

});
/*list previous funding data */
function list_previous_funding_data() {

    $.post("<?php echo site_url('start_equity/list_prev_funding')?>", {equity_id: equity_id}, function (result) {

        $('#load-previous-funding-data').html(result);

    });
}
/*list previous funding data */
function empty_previous_funding_form() {
    $(".funding_source_error").html('');
    $(".funding_type_error").html('');
    $(".funding_amount_error").html('');
    $(".funding_date_error").html('');
    $("#prev_funding_id").val(0);
    $("#funding_date").val('');
    $("#funding_amount").val('');
    $('select[name=funding_type]').val('');
    $('select[name=funding_type]').change();
    $('select[name=funding_source]').val('');
    $('select[name=funding_source]').change();
}
list_previous_funding_data();
/**************End: Funding Source code***********************/

/****************Start: investor functionality code started from here*/
$(function () {
    $("body").on("change", "#investor_image", function (event) {
        readURL(this);
        $('#edit_investor_image').children().remove();
        $(this).prependTo('#edit_investor_image').addClass('hidden-file-field');
    });

});

$(document).ready(function () {
    $("#investor_name").change(function () {
        var str_val = $.trim($("#investor_name").val());

        if (str_val == "") {
            // $("#hide_desc").hide();
        }
        else {
            $("#ajax-investor-cancel").show();
            $("#hide_desc").show();
        }
    });
    // bind form id and provide a simple callback function
    var options = {
        target: '#output1',   // target element(s) to be updated with server response
        beforeSubmit: before_investor,  // pre-submit callback
        complete: function () {

        },  // post-submit callback 
        success: after_investor,
        dataType: 'json',
        // other available options: 
        //url:       url         // override for form's 'action' attribute 
        //type:      type        // 'get' or 'post', override for form's 'method' attribute 
        //dataType:  null        // 'xml', 'script', or 'json' (expected server response type) 
        //clearForm: true        // clear all form fields after successful submit 
        //resetForm: true        // reset the form after successful submit 

        // $.ajax options can be used here too, for example: 
        //timeout:   3000 
    };
    if ((pic = jQuery('#investor_image_form')).length)
        pic.ajaxForm(options);

    //load investor data;
    list_investor_data();
    $("body").on("click", "#ajax-investor-add", function (event) {

        PopupOpen();
        $('#investor_image_form').submit();
        return false;
    });
    $("body").on("click", "#ajax-investor-cancel", function (event) {
        BlankInvestorData();
    });
    //delete record from table
    $("body").on("click", ".delete-investor", function (event) {
        var investor_id = $(this).attr("rel");
        $('#confirmDeleteinvestor').modal('toggle');
        PopupOpen();
        // $(this).parent().parent().parent().remove();
        $.post("<?php echo site_url('start_equity/delete_investor')?>", {
            investor_id: investor_id,
            equity_id: <?php echo $id;?>
        }, function (result) {
            BlankInvestorData();
            PopupClose();
            return false;
        });
    });

    //load particular team record with form
    $("body").on("click", ".edit-investor", function (event) {

        var investor_id = $(this).attr("rel");
        $.post("<?php echo site_url('start_equity/edit_investor')?>", {
            investor_id: investor_id,
            equity_id: <?php echo $id;?>
        }, function (result) {

            var result = $.parseJSON(result);
            var error = result.error;
            var msg = result.msg;
            var url = result.url;

            if (url != '') {
                location.href = url;
            }
            if (error == true) {
                $("#error-msg-company-industry").html(msg);

            }
            else {
                $("#ajax-investor-cancel").show();
                $("#ajax-investor-add").html("<?php echo UPDATE_INVESTORS;?>");
                 $("#ajax-investor-add").removeClass("plus-icon");


                $(".investor_type_error").html('');

                $(".investor_name_error").html('');

                $(".funding_type_error").html('');

                $(".email_error").html('');
                var investor_id = result.investor.investor_id;
                $("#investor_id").val(investor_id);
                var investor_name = result.investor.investor_name;
                $("#investor_name").val(investor_name);
                $("#investor_name").trigger("change");
                var investor_type = result.investor.investor_type;
                $('select[name=investor_type]').val(investor_type);
                $('select[name=investor_type]').change();
                $('select[name=investor_type]').selectpicker('refresh');
                var investor_description = result.investor.investor_description;
                $("#investor_description").val(investor_description);


                var member_image = result.investor.investor_image;
                if (result.investor.investor_image == '' || result.investor.investor_image == null) {
                    var member_image = 'no_man.jpg';
                }
                var investor_email = result.investor.investor_email;
                $("#email").val(investor_email);


                //$('#investor_type').selectpicker('refresh');
                var imgpath = '<?php echo base_url();?>images/member_img.jpg';
                if (member_image != "")imgpath = '<?php echo base_url();?>upload/equity/investor/' + member_image;
                $('#team_img2').attr('src', imgpath);

            }
        });
    });


});
/*list investor data */
function list_investor_data() {

    $.post("<?php echo site_url('start_equity/list_investor')?>", {equity_id: <?php echo $id;?>}, function (result) {

        $('#load-investor-list').html(result);

    });
}
/*call before investor data inserted for merging file image and form data */
function before_investor(formData, jqForm, options) {

    var data = $('#investor-box').closest('.create-campain-bg').find('input,textarea,select').serializeArray();
    formData.append(data);
    var queryString = $.param(formData);
    return true;
}

function BlankInvestorData() {
    $("#ajax-investor-cancel").hide();
    $('#investor-box').closest('.create-campain-bg').find('input,textarea,select').val('');
    $('#investor_type').selectpicker('refresh');
    var imgpath = '<?php echo base_url();?>images/member_img.jpg';
    $('#team_img2').attr('src', imgpath);
    $("#investor_equity_id").val(equity_id);
    $("#ajax-investor-add").html("<?php echo ADD_INVESTORS;?>");
     $("#ajax-investor-add").addClass("plus-icon");
    $("#hide_desc").hide();
    $(".investor_type_error").html('');
    $(".investor_name_error").html('');
    $(".funding_type_error").html('');
    $(".email_error").html('');
    list_investor_data();

}

// Called after successfully save investor data
function after_investor(result) {

    PopupClose();
    var error = result.error;
    var msg = result.msg;
    var url = result.url;

    if (url != '') {
        location.href = url;
    }
    else if (error == true) {
        var investor_type_error = result.investor_type_error;
        $(".investor_type_error").html(investor_type_error);
        var investor_name_error = result.investor_name_error;
        $(".investor_name_error").html(investor_name_error);
        var funding_type_error = result.funding_type_error;
        $(".funding_type_error").html(funding_type_error);
        var email_error = result.email_error;
        $(".email_error").html(email_error);
        $('.investor_description_error').html(result.investor_description_error);
        $('.member_image_error').html(result.investor_image_error);
    }
    else {

        $('#investor-box').closest('.create-campain-bg').find('input,textarea,select').val('');
        $('#investor_type').selectpicker('refresh');
        var imgpath = '<?php echo base_url();?>images/member_img.jpg';
        $('#team_img2').attr('src', imgpath);
        $("#investor_equity_id").val(equity_id);
        $("#ajax-investor-cancel").hide();
        $("#ajax-investor-add").html("<?php echo ADD_INVESTORS;?>");
          $("#ajax-investor-add").addClass("plus-icon");
        $("#hide_desc").hide();
        $(".investor_type_error").html('');
        $(".investor_name_error").html('');
        $(".funding_type_error").html('');
        $(".email_error").html('');
        $('.investor_description_error').html('');
        $('.member_image_error').html('');
        list_investor_data();
    }


}

//used for show image when browse click 
function readURL(input) {
    if (input.files && input.files[0]) {
        var reader = new FileReader();
        var imgpath = '<?php echo base_url()?>images/member_img.jpg';
        reader.onload = function (e) {
            if (e.target.result.indexOf("data:image/png") > -1 || e.target.result.indexOf("data:image/jpeg") > -1 || e.target.result.indexOf("data:image/gif") > -1) {
                $('.member_image_error').html('');
                $('#team_img2').attr('src', e.target.result);
            } else {
                $('#team_img2').attr('src', imgpath);
                $('.member_image_error').html("<?php echo PLEASE_UPLOAD_A_JPG_PNG_GIF_FILE;?>");
            }
        }

        reader.readAsDataURL(input.files[0]);
    }
}
/*End: investor functionality code started from here*/

/*Start: deal document  code started from here*/
$(function () {

    $("body").on("change", "#executive_summary_file", function (event) {
        PopupOpen();
        console.log("executive_summary_file");
        $('#investor_deal_document_image').children().remove();
        $(this).prependTo('#investor_deal_document_image').addClass('hidden-file-field');
        $("#document_case").val(0);
        $('#investor_deal_document_form').submit();
        // $(this).prependTo("#executive_summary_file_display").removeClass('hidden-file-field');
        $('#investor_deal_document_image').children().prependTo("#executive_summary_file_display");
    });

    $("body").on("change", "#term_sheet_file", function (event) {
        PopupOpen();
        console.log("term_sheet_file");
        $('#investor_deal_document_image').children().remove();
        $(this).prependTo('#investor_deal_document_image').addClass('hidden-file-field');
        $("#document_case").val(1);
        $('#investor_deal_document_form').submit();
        //$(this).prependTo("#term_sheet_file_display").removeClass('hidden-file-field');
        $('#investor_deal_document_image').children().prependTo("#term_sheet_file_display");


    });
    <?php
                                    //if owner allow to upload file
            if($site_setting['sign_contract_upload_by']==0)
            {
    ?>
    $("body").on("change", "#contract_copy_file", function (event) {
        console.log("contract_copy_file");
        $('#investor_deal_document_image').children().remove();
        $(this).prependTo('#investor_deal_document_image').addClass('hidden-file-field');
        $("#document_case").val(3);
        $('#investor_deal_document_form').submit();
        $(this).prependTo("#contract_copy_file_display").removeClass('hidden-file-field');


    });
    <?php
        }
    ?>
    $("body").on("change", "#deal_document_other", function (event) {

        console.log("deal_document_other");
        $('#investor_deal_document_image').children().remove();
        $(this).prependTo('#investor_deal_document_image').addClass('hidden-file-field');
        $("#document_case").val(2);
        if ($('.document_button_update').css('display') == 'none') {
            PopupOpen();
            $('#investor_deal_document_form').submit();
            $(this).prependTo("#deal_document_other_display").removeClass('hidden-file-field');
        }


    });

    $("body").on("click", "#deal_document_update", function (event) {
        PopupOpen();

        $("#document_case").val(2);
        $('#investor_deal_document_form').submit();
        $("#deal_document_other").prependTo("#deal_document_other_display").removeClass('hidden-file-field');
        list_deal_document_data();
    });

});

$(document).ready(function () {

    // bind form id and provide a simple callback function
    var options = {
        target: '#output1',   // target element(s) to be updated with server response
        beforeSubmit: before_investor_deal_document,  // pre-submit callback
        complete: function () {
            PopupClose();
        },  // post-submit callback 
        success: after_investor_deal_document,
        dataType: 'json',
        // other available options: 
        //url:       url         // override for form's 'action' attribute 
        //type:      type        // 'get' or 'post', override for form's 'method' attribute 
        //dataType:  null        // 'xml', 'script', or 'json' (expected server response type) 
        //clearForm: true        // clear all form fields after successful submit 
        //resetForm: true        // reset the form after successful submit 

        // $.ajax options can be used here too, for example: 
        //timeout:   3000 
    };
    if ((pic = jQuery('#investor_deal_document_form')).length)
        pic.ajaxForm(options);


    if (eval(executive_summary_status) == 1)$('#executive_summary_status').trigger('click');
//else $('#executive_summary_status').bootstrapSwitch('setState', false);
    if (eval(term_sheet_status) == 1)$('#term_sheet_status').trigger('click');
    //else $('#term_sheet_status').bootstrapSwitch('setState', false);


    $("body").on("change", "#deal_document_type", function (event) {
        if ($(this).val() === 'addnew') {
            $('.custom_textbox').show();
            $('#addDoc').addClass('open-custonText');
        } else {
            $('.custom_textbox').hide();
            $('#addDoc').removeClass('open-custonText');
        }
        $('.deal_document_type_error').html('');
        $('.deal_document_type_other_error').html('');
    });
    // default hide delete button if file not present
    <?php if($executive_summary_file==''){?>
    $(".delete_executive_document").hide();
    <?php }if($term_sheet_file==''){?>
    $(".delete_termsheet_document").hide();
    <?php }?>
    <?php if($contract_copy_file==''){?>
    $(".delete-contract-copy").hide();
    <?php }?>
    //delete record from table
    $("body").on("click", ".delete-deal-document", function (event) {
        PopupOpen();
        var deal_document_id = $(this).attr("rel");
        $('.deal_doc_' + deal_document_id).remove();
        $('#confirmDeletedeal').modal('toggle');
        // $(this).parent().parent().parent().remove();
        $.post("<?php echo site_url('start_equity/delete_deal_document')?>", {
                deal_document_id: deal_document_id,
                equity_id: equity_id
            },
            function (result) {
                var result = $.parseJSON(result);

                $("#deal_document_type").html(result.document_type_data);
                $('#deal_document_type').selectpicker('refresh');

                PopupClose();
            });
    });
    $("body").on("click", ".delete-executive-document", function (event) {
        PopupOpen();
        var deal_document_id = 'executive';
        $('#confirmDeleteexecutivedocument').modal('toggle');
        $('#executive_summary_file_path').html('');
        $('.delete_executive_document').hide();
        $.post("<?php echo site_url('start_equity/delete_deal_document')?>", {
            deal_document_id: deal_document_id,
            equity_id: equity_id
        }, function (result) {
            $('#label-switch').bootstrapSwitch('setState', false);
            PopupClose();
        });
    });

    <?php
                        //if owner allow to upload file
if($site_setting['sign_contract_upload_by']==0)
{
?>


    $("body").on("click", ".delete-contract-copy", function (event) {

        var deal_document_id = 'contract';
        $('#contract_copy_file_path').html('');
        $(this).hide();
        $.post("<?php echo site_url('start_equity/delete_deal_document')?>", {
            deal_document_id: deal_document_id,
            equity_id: equity_id
        }, function (result) {


        });
    });

    <?php
        }
    ?>
    $("body").on("click", ".delete-termsheet-document", function (event) {
        PopupOpen();
        var deal_document_id = 'terms';
        $('#term_sheet_file_path').html('');
        $('#confirmDeletetermsheetdocument').modal('toggle');
        $('.delete_termsheet_document').hide();
        $.post("<?php echo site_url('start_equity/delete_deal_document')?>", {
                deal_document_id: deal_document_id,
                equity_id: equity_id
            },
            function (result) {
                PopupClose();
                $('#term-label-switch').bootstrapSwitch('setState', false);
            });
    });
    $("body").on("click", "#ajax-doc-cancel", function (event) {

        blank_deal_document_error();
        return false;

    });

    //load particular team record with form
    $("body").on("click", ".edit-deal-document", function (event) {
        $(".document_button_update").show();

        var deal_document_id = $(this).attr("rel");
        var deal_document_case = $(this).attr("title");
        $("#document_case").val(deal_document_case);
        $.post("<?php echo site_url('start_equity/edit_deal_document')?>", {
            deal_document_id: deal_document_id,
            equity_id: equity_id
        }, function (result) {

            var result = $.parseJSON(result);
            var error = result.error;
            var msg = result.msg;
            var url = result.url;

            if (url != '') {
                location.href = url;
            }
            if (error == true) {
                $("#error-msg-company-industry").html(msg);
            }
            else {
                if (deal_document_case == 2) {
                    var file_gallery_id = result.file_gallery.id;
                    $("#deal_document_id").val(file_gallery_id);

                    var file_name = result.file_gallery.file_name;
                    $("#file_name").val(file_name);

                    var file_desc = result.file_gallery.file_desc;
                    var other = result.file_gallery.other;
                    if (other != '') {//alert(other)
                        $('select[name=deal_document_type]').val('addnew');


                        $('.custom_textbox').show();
                        $('.custom_textbox').css("display", "block");
                        $("#deal_document_type_other").val(other);
                        $('#addDoc').addClass('open-custonText');


                    }
                    else {

                        $('select[name=deal_document_type]').val(file_name);
                    }

                    $('select[name=deal_document_type]').change();
                    $('#deal_document_type').attr('disabled', true).selectpicker('refresh');
                    var status = result.file_gallery.status;
                    if (eval(status) == 1)$('#custom-document-switch').bootstrapSwitch('setState', true);
                    else $('#custom-document-switch').bootstrapSwitch('setState', false);
                    $("#deal_document_status").val(1);
                }
                if (deal_document_case == 0) {
                    //deal_document_type_selecbox
                }
                if (deal_document_case == 1) {

                }


            }
        });
    });
    list_deal_document_data();
});
/*call before investor data inserted for merging file image and form data */
function before_investor_deal_document(formData, jqForm, options) {
    console.log($("#document_case").val())
    var data = $('#deal_documents').closest('.create-campain-bg').find('input,textarea,select').serializeArray();
    formData.append(data);
    var queryString = $.param(formData);
    blank_deal_document_error();
    return true;
}
// Called after successfully save investor data
function after_investor_deal_document(result) {

    PopupClose();
    var error = result.error;
    var msg = result.msg;
    var url = result.url;
    if (url != '') {
        //location.href=url;
    }
    else if (error == true) {
        var document_case = result.document_case;

        if (eval(document_case) == 0) {

            var executive_summary_file_error = result.executive_summary_file_error;
            $(".executive_summary_file_error").html(executive_summary_file_error);
        }
        if (eval(document_case) == 1) {

            var term_sheet_file_path_error = result.term_sheet_file_path_error;
            $(".term_sheet_file_path_error").html(term_sheet_file_path_error);
        }
        if (eval(document_case) == 3) {

            var contract_copy_file_error = result.contract_copy_file_error;
            $(".contract_copy_file_error").html(contract_copy_file_error);
        }
        if (eval(document_case) == 2) {

            var deal_document_other_error = result.deal_document_other_error;
            $(".deal_document_other_error").html(deal_document_other_error);
            var deal_document_type_other_error = result.deal_document_type_other_error;
            $(".deal_document_type_other_error").html(deal_document_type_other_error);
            var deal_document_type_error = result.deal_document_type_error;
            $(".deal_document_type_error").html(deal_document_type_error);

            if (result.deal_document_type == 'addnew')
                $('.custom_textbox').show();
            else
                $('.custom_textbox').hide();
        }
    }
    else {
        var document_case = result.document_case;

        if (eval(document_case) == 0) {
            var file_path = result.image.path;
            $("#executive_summary_file_path").html(file_path);
            $(".delete_executive_document").show();

        }
        if (eval(document_case) == 3) {
            var file_path = result.image.path;
            $("#contract_copy_file_path").html(file_path);
            $(".contract-copy-document").show();

        }
        if (eval(document_case) == 1) {
            var file_path = result.image.path;
            $("#term_sheet_file_path").html(file_path);
            $(".delete_termsheet_document").show();

        }
        if (eval(document_case) == 2) {


            $('#deal_document_type').attr('disabled', false).selectpicker('refresh');
            $('select[name=deal_document_type]').val('');
            $('select[name=deal_document_type]').change();
            $('#deal_document_type').selectpicker('refresh');

            $('#custom-document-switch').bootstrapSwitch('setState', false);
            $('#deal_document_status').val(1);
            $("#deal_document_type_other").val('');
            $("#deal_document_type").html(result.document_type_data);
            $('#deal_document_type').selectpicker('refresh');

            list_deal_document_data();

        }
        var dropdown = result.dropdown;
        $("#dordown_select").html(dropdown);
        $('#project_country').selectpicker();
        $('#project_country').attr('disabled', true).selectpicker('refresh');
    }


}
/*list deal document data */
function list_deal_document_data() {

    $.post("<?php echo site_url('start_equity/list_deal_document')?>", {equity_id: <?php echo $id;?>}, function (result) {

        $('#load-deal-document-list').html(result);

    });
}
/*list deal document data */
function blank_deal_document_error() {
    $(".deal_document_other_error").html('');
    $(".deal_document_type_other_error").html('');
    $(".executive_summary_file_error").html('');
    $(".term_sheet_file_path_error").html('');
    $('#custom-document-switch').bootstrapSwitch('setState', false);
    $('#deal_document_status').val(1);
    $(".document_button_update").hide();
    $('#deal_document_type').attr('disabled', false).selectpicker('refresh');
    $('select[name=deal_document_type]').val('');
    $('select[name=deal_document_type]').change();
    $(".contract_copy_file_error").html('');
    $('#deal_document_type').selectpicker('refresh');


}

/*End: deal document code started from here*/

/****************Start: video functionality code started from here*/

$(document).ready(function () {

    // bind form id and provide a simple callback function
    var options = {
        target: '#output1',   // target element(s) to be updated with server response
        beforeSubmit: before_video,  // pre-submit callback
        complete: function () {

        },  // post-submit callback 
        success: after_video,
        dataType: 'json',
        // other available options: 
        //url:       url         // override for form's 'action' attribute 
        //type:      type        // 'get' or 'post', override for form's 'method' attribute 
        //dataType:  null        // 'xml', 'script', or 'json' (expected server response type) 
        //clearForm: true        // clear all form fields after successful submit 
        //resetForm: true        // reset the form after successful submit 

        // $.ajax options can be used here too, for example: 
        //timeout:   3000 
    };
    if ((pic = jQuery('#video_form')).length)
        pic.ajaxForm(options);

    //load investor data;
    list_video_data();
    $("body").on("click", "#ajax-video-add", function (event) {
        PopupOpen();
        $('#video_form').submit();
        return false;
    });
    //delete record from table
    $("body").on("click", ".delete-video", function (event) {

        var video_id = $(this).attr("rel");
        $('#confirmDeletevideo').modal('toggle');
        PopupOpen();
        // $(this).parent().parent().parent().remove();
        $.post("<?php echo site_url('start_equity/delete_video')?>", {
            video_id: video_id,
            equity_id: equity_id
        }, function (result) {
            BlankVideoData();
            PopupClose();
            // return false;
        });
    });
    $("body").on("click", "#ajax-video-cancel", function (event) {

        BlankVideoData();
        return false;

    });
    //load particular team record with form
    $("body").on("click", ".edit-video", function (event) {

        var video_id = $(this).attr("rel");
        $.post("<?php echo site_url('start_equity/edit_video')?>",
            {video_id: video_id, equity_id: equity_id},
            function (result) {

                var result = $.parseJSON(result);
                var error = result.error;
                var msg = result.msg;
                var url = result.url;

                if (url != '') {
                    //location.href=url;
                }
                if (error == true) {
                    $("#error-msg-company-industry").html(msg);
                }
                else {
                    $("#ajax-video-cancel").show();
                    $(".media_video_name_error").html('');
                    $(".media_video_title_error").html('');

                    $("#ajax-video-add").html('<?php echo UPDATE_VIDEO;?>');
                    $("#ajax-video-add").removeClass("plus-icon");
                    var video_id = result.video.id;
                    $("#video_id").val(video_id);

                    var media_video_title = result.video.media_video_title;
                    $("#media_video_title").val(media_video_title);
                    var media_video_name = result.video.media_video_name;
                    $("#media_video_name").val(media_video_name);
                    var media_video_desc = result.video.media_video_desc;
                    $("#media_video_desc").val(media_video_desc);
                    var media_video_status = result.video.status;

                    if (eval(media_video_status) == 1)$('#video-switch').bootstrapSwitch('setState', true);
                    else $('#video-switch').bootstrapSwitch('setState', false);
                    $('#media_video_status').val(1);
                    var image = result.video.image;


                }
            });
    });


});
/*list investor data */
function list_video_data() {

    $.post("<?php echo site_url('start_equity/list_video')?>", {equity_id: equity_id}, function (result) {

        $('#load-video-list').html(result);

    });
}
/*call before investor data inserted for merging file image and form data */
function before_video(formData, jqForm, options) {

    var data = $('#video-box').closest('.create-campain-bg').find('input,textarea,select').serializeArray();
    formData.append(data);
    var queryString = $.param(formData);
    return true;
}

// Called after successfully save investor data
function after_video(result) {
    PopupClose();
    var error = result.error;
    var msg = result.msg;
    var url = result.url;
    if (url != '') {
        location.href = url;
    }
    else if (error == true) {
        var media_video_title_error = result.media_video_title_error;
        $(".media_video_title_error").html(media_video_title_error);
        var media_video_name_error = result.media_video_name_error;
        $(".media_video_name_error").html(media_video_name_error);
        $(".media_video_desc_error").html(result.media_video_desc_error);
    }
    else {
        $('#video-box').closest('.create-campain-bg').find('input,textarea,select').val('');
        $('#video-box').closest('.create-campain-bg').find("#equity_id").val(equity_id);
        $("#ajax-video-cancel").hide();
        $("#ajax-video-add").html('<?php echo ADD_VIDEO;?>');
        $("#ajax-video-add").addClass("plus-icon");
        $(".media_video_name_error").html('');
        $(".media_video_title_error").html('');
        $(".media_video_desc_error").html('');
        $('#video-switch').bootstrapSwitch('setState', false);
        $('#media_video_status').val(1);
        list_video_data();
        $('[data-toggle="tooltip"]').tooltip();

    }


}
function BlankVideoData() {
    $('#video-box').closest('.create-campain-bg').find('input,textarea,select').val('');
    $('#video-box').closest('.create-campain-bg').find("#equity_id").val(equity_id);
    $("#ajax-video-cancel").hide();
    $("#ajax-video-add").html('<?php echo ADD_VIDEO;?>');
    $("#ajax-video-add").addClass("plus-icon");
    $(".media_video_name_error").html('');
    $(".media_video_title_error").html('');
    $(".media_video_desc_error").html('');
    $('#video-switch').bootstrapSwitch('setState', false);
    $('#media_video_status').val(1);

    list_video_data();
}
/*End: Video functionality code started from here*/
/****************Start: image functionality code started from here*/
$(function () {


    $("body").on("change", "#image", function (event) {

        //$('#edit_image_form').children().remove();
        //$(this).prependTo('#edit_image_form').addClass('hidden-file-field');
        //$(this).prependTo('#edit_image_form').addClass('hidden-file-field');
        //$(this).prependTo('#picture_file_field_image').addClass('hidden-file-field');
    });

});
$(document).ready(function () {

    // bind form id and provide a simple callback function
    var options = {
        target: '#output1',   // target element(s) to be updated with server response
        beforeSubmit: '',  // pre-submit callback
        complete: function () {

        },  // post-submit callback 
        success: after_image,
        dataType: 'json',
        // other available options: 
        //url:       url         // override for form's 'action' attribute 
        //type:      type        // 'get' or 'post', override for form's 'method' attribute 
        //dataType:  null        // 'xml', 'script', or 'json' (expected server response type) 
        //clearForm: true        // clear all form fields after successful submit 
        //resetForm: true        // reset the form after successful submit 

        // $.ajax options can be used here too, for example: 
        //timeout:   3000 
    };
    if ((pic = jQuery('#image_form')).length)
        pic.ajaxForm(options);

    //load investor data;
    list_image_data();
    $("body").on("click", "#ajax-image-add", function (event) {
        PopupOpen();
        $('#image_form').submit();
        return false;
    });
    $("body").on("click", "#ajax-image-cancel", function (event) {

        BlankImageData();
        return false;
    });

    //delete record from table
    $("body").on("click", ".delete-image", function (event) {
        var image_id = $(this).attr("rel");
        $('#confirmDeleteimage').modal('toggle');
        PopupOpen();
        // $(this).parent().parent().parent().remove();
        $.post("<?php echo site_url('start_equity/delete_image')?>", {
            image_id: image_id,
            equity_id: equity_id
        }, function (result) {
            BlankImageData();
            PopupClose();
            return false;

        });
    });

    //load particular team record with form
    $("body").on("click", ".edit-image", function (event) {

        var image_id = $(this).attr("rel");
        $.post("<?php echo site_url('start_equity/edit_image')?>", {
            image_id: image_id,
            equity_id: equity_id
        }, function (result) {

            var result = $.parseJSON(result);
            var error = result.error;
            var msg = result.msg;
            var url = result.url;

            if (url != '') {
                //location.href=url;
            }
            if (error == true) {
                $("#error-msg-company-industry").html(msg);
                $(".image_name_error").html(result.image_name_error);
                $(".image_desc_error").html(result.image_desc_error);

            }
            else {
                $("#ajax-image-cancel").show();
                $("#ajax-image-add").html("<?php echo UPDATE_IMAGE;?>");
                $("#ajax-image-add").removeClass("plus-icon");
                var image_id = result.image.equity_gallery_id;
                $("#image_id").val(image_id);
                var image_name = result.image.image_name;
                $("#image_name").val(image_name);
                var image_desc = result.image.image_desc;
                $("#image_desc").val(image_desc);

                var image_status = result.image.status;

                if (eval(image_status) == 1)$('#image-switch').bootstrapSwitch('setState', true);
                else $('#image-switch').bootstrapSwitch('setState', false);
                $(".image_error").html('');
                $(".image_name_error").html('');
                var image = result.image.image;
                var child = $("#picture_file_field_image").find("input[type=text]")
                //alert(child);
                child.val(image);
                $('[data-toggle="tooltip"]').tooltip();


            }
        });
    });


});
/*list investor data */
function list_image_data() {

    $.post("<?php echo site_url('start_equity/list_image')?>", {equity_id: equity_id}, function (result) {

        $('#load-image-list').html(result);

    });
}
/*call before investor data inserted for merging file image and form data */
function before_image(formData, jqForm, options) {

    var data = $('#image-box').closest('.create-campain-bg').find('input,textarea,select').serializeArray();
    formData.append(data);
    var queryString = $.param(formData);
    return true;
}

// Called after successfully save investor data
function after_image(result) {

    PopupClose();
    var error = result.error;
    var msg = result.msg;
    var url = result.url;
    if (url != '') {
        location.href = url;
    }
    else if (error == true) {
        var media_image_title_error = result.media_image_title_error;
        $(".media_image_title_error").html(media_image_title_error);
        var media_image_name_error = result.media_image_name_error;
        $(".media_image_name_error").html(media_image_name_error);
        $(".image_name_error").html(result.image_name_error);
        $(".image_error").html(result.image_error);
        $(".image_desc_error").html(result.image_desc_error);
    }
    else {
        $("#ajax-image-cancel").hide();
        $('#image-box').closest('.create-campain-bg').find('input,textarea,select').val('');
        $('#image_status').val(1);
        $('#image-box').closest('.create-campain-bg').find("#equity_id").val(equity_id);
        //$("#equity_id").val(equity_id);
        $("#ajax-image-add").html("<?php echo ADD_IMAGE;?>");
        $("#ajax-image-add").addClass("plus-icon");
        $('#image-switch').bootstrapSwitch('setState', false);
        $(".image_error").html('');
        $(".image_name_error").html('');
        $(".image_desc_error").html('');
        list_image_data();

    }


}
function BlankImageData() {
    $('#image-box').closest('.create-campain-bg').find('input,textarea,select').val('');

    $('#image-box').closest('.create-campain-bg').find("#equity_id").val(equity_id);
    //$("#equity_id").val(equity_id);
    $("#ajax-image-add").html("<?php echo ADD_IMAGE;?>");
    $("#ajax-image-add").addClass("plus-icon");
    $("#ajax-image-cancel").hide();
    $(".image_error").html('');
    $(".image_name_error").html('');
    $(".image_desc_error").html('');
    $('#image-switch').bootstrapSwitch('setState', false);
    $('#image_status').val(1);
    list_image_data();
}

/*End: image functionality code started from here*/

$('#investor_description').jqEasyCounter({
    'maxChars': 160,
    'maxCharsWarning': 155
});
$('#media_video_title').jqEasyCounter({
    'maxChars': 70,
    'maxCharsWarning': 65
});
$('#media_video_desc').jqEasyCounter({
    'maxChars': 160,
    'maxCharsWarning': 155
});
$('#image_name').jqEasyCounter({
    'maxChars': 70,
    'maxCharsWarning': 65
});
$('#image_desc').jqEasyCounter({
    'maxChars': 160,
    'maxCharsWarning': 155
});
$("body").on("change", "#investor_type", function (event) {

    var val = $(this).val();
    if (val != '')$("#investor_label_change").html(val)
    else $("#investor_label_change").html('<?php echo FIRST_AND_LAST_NAME;?>')

});
</script>
<style>
    .profile-time span {
        margin-right: 5px;
    }

    .profile-time .fa-close {
        font-size: 21px;
    }
</style>

<script type="text/javascript">
  $(document).ready(function () {
       $('.switch-event').on('switch-change', function (e, data) {
                change_status($(this).find('input').attr('id'));
            });
  });
</script>