<?php
if ($funder > 0) {
    foreach ($funder as $equity_funder) {
        $equity_funder_image = $equity_funder['image'];
        $preapproval_status = $equity_funder['preapproval_status'];
        $equity_user_id = $equity_funder['user_id'];

        if ($equity_funder['profile_slug']) {
            $equity_profile_slug = $equity_funder['profile_slug'];
        } else {
            $equity_profile_slug = $equity_funder['user_id'];
        }

        $equity_funder_name = $equity_funder['user_name'] . ' ' . $equity_funder['last_name'];
        $equity_funder_date_time = dateformat($equity_funder['transaction_date_time']);
        $equity_funder_amount_ret = $equity_funder['amount'];
        if ($equity_funder_amount_ret > 0)
            $equity_funder_amount = set_currency($equity_funder['preapproval_total_amount'], $equity_id);
        else $equity_funder_amount = ANONYMOUS;
        if ($equity_funder['comment'] != '') {
            $equity_funder_comment = $equity_funder['comment'];
        } else {
            $equity_funder_comment = $equity_funder['comment'];
        }

        $showlink = true;

        if ($equity_user_id == "" or $equity_user_id == 0) {
            $showlink = false;
            $equity_funder_name = ANONYMOUS;
        }
        if ($equity_funder_image != '' && is_file("upload/user/user_small_image/" . $equity_funder_image) and $showlink == true) {
            $fundersrc = base_url() . 'upload/user/user_small_image/' . $equity_funder_image;
        } else {
            $fundersrc = base_url() . 'upload/user/user_small_image/no_man.jpg';
        }
        if ($preapproval_status != 'FAIL') {
            ?>
            <li class="media">
                <div class="media-left">
                    <a href="<?php if ($showlink == true) echo site_url('user/' . $equity_profile_slug); else echo "javascript://"; ?>">
                        <img class="img-thumbnail" src="<?php echo $fundersrc; ?>">
                    </a>
                </div>
                <div class="media-body">
                    <h4 class="media-heading marB5"><a
                            href="<?php if ($showlink == true) echo site_url('user/' . $equity_profile_slug); else echo "javascript://"; ?>"><?php echo $equity_funder_name; ?></a>
                    </h4>

                    <p><span class="media-time"><?php echo $equity_funder_date_time; ?></span></p>
                    <span class="funded-amount"><?php echo $equity_funder_amount; ?></span>
                    <?php if ($equity_funder_comment != "") { ?>
                        <p class="comment-text"><i class="fa fa-quote-left"></i> <?php echo $equity_funder_comment; ?>
                        </p>
                    <?php } ?>
                </div>
            </li>
        <?php
        }
    }
    ?>
    <?php if ($total_row_display <= 5) {
        $display = 'none';
    } else {
        $display = 'block';
    }
    ?>
    <li class="show-more more_funders" style="display:<?php echo $display; ?>"><a href="javascript:void(0)"
                                                                                  onclick="show_more_funders(<?php echo $offset + 5; ?>)"><?php echo SHOW_MORE_FUNDERS; ?></a></li>
<?php
} else {
    ?>
    <li class="no-data"><?php echo THERE_IS_NO_FUNDERS_FOR_THIS_PROJECT; ?>.</li>
<?php
}
?>
                                    
                                   
