<?php
/*
 * login_with_google.php
 *
 * @(#) $Id: login_with_google.php,v 1.7 2013/07/31 11:48:04 mlemos Exp $
 *
 */

	/*
	 *  Get the http.php file from http://www.phpclasses.org/httpclient
	 */
	require('http.php');
	require('oauth_client.php');

	$client = new oauth_client_class;
	$client->server = 'Google';

	// set the offline access only if you need to call an API
	// when the user is not present and the token may expire
	$client->offline = true;

	$client->debug = false;
	$client->debug_http = true;
	$client->redirect_uri = 'http://'.$_SERVER['HTTP_HOST'].
		dirname(strtok($_SERVER['REQUEST_URI'],'?')).'/login_with_google.php';

	$client->client_id = '6730636684-kda65ld9duasn6e5359516kfu1g5raa1.apps.googleusercontent.com'; $application_line = __LINE__;
	$client->client_secret = 'XI05aHOioqxqjljHHalsAK0-';

	if(strlen($client->client_id) == 0
	|| strlen($client->client_secret) == 0)
		die('Please go to Google APIs console page '.
			'http://code.google.com/apis/console in the API access tab, '.
			'create a new client ID, and in the line '.$application_line.
			' set the client_id to Client ID and client_secret with Client Secret. '.
			'The callback URL must be '.$client->redirect_uri.' but make sure '.
			'the domain is valid and can be resolved by a public DNS.');

	/* API permissions
	 */
	$client->scope = 'https://www.googleapis.com/auth/userinfo.email '.
		'https://www.googleapis.com/auth/userinfo.profile '.
		'https://www.google.com/m8/feeds';
	if(($success = $client->Initialize()))
	{
		if(($success = $client->Process()))
		{
			if(strlen($client->authorization_error))
			{
				$client->error = $client->authorization_error;
				$success = false;
			}
			elseif(strlen($client->access_token))
			{
				$success = $client->CallAPI(
					'https://www.googleapis.com/oauth2/v1/userinfo',
					'GET', array(), array('FailOnAccessError'=>true), $user);
					
					$success = $client->CallAPI(
					'https://www.google.com/m8/feeds/contacts/default/full',
					'GET', array('max-results'=>1000), array('FailOnAccessError'=>true), $user1);
					
					//https://www.google.com/m8/feeds/contacts/{userEmail}/full

			}
		}
		$success = $client->Finalize($success);
	}
	if($client->exit)
		exit;
	if($success)
	{
?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
<head>
<title>Google OAuth client results</title>
</head>
<body>
<?php
		echo '<h1>', HtmlSpecialChars($user->name),
			' you have logged in successfully with Google!</h1>';
		echo '<pre>', HtmlSpecialChars(print_r($user, 1)), '</pre>';
		//echo '<pre>', HtmlSpecialChars(print_r($user1, 1)), '</pre>';
		$xml = simplexml_load_string($user1);
		$xml->registerXPathNamespace('gd', 'http://schemas.google.com/g/2005');
		
		$output_array = array();
		foreach ($xml->entry as $entry) {
		  foreach ($entry->xpath('gd:email') as $email) {
			$output_array[] = array((string)$entry->title, (string)$email->attributes()->address);
		  }
		}
		echo '<pre>', HtmlSpecialChars(print_r($output_array, 1)), '</pre>';
		 /*list($info, $header, $body) = $user1;
            if ($body) {
               // $oauth->logit("callcontact:INFO:response:");
                $contact = json_decode($body, true);
                //echo $contact['feed']['entry'][0]['gd$email'][0]['address'];
                //return $contact['feed']['entry'];
				echo '<pre>', HtmlSpecialChars(print_r($contact, 1)), '</pre>';
            }*/
?>
</body>
</html>
<?php
	}
	else
	{
?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
<head>
<title>OAuth client error</title>
</head>
<body>
<h1>OAuth client error</h1>
<pre>Error: <?php echo HtmlSpecialChars($client->error); ?></pre>
</body>
</html>
<?php
	}

?>
