<?php

/*********************************************************************************
 * This the fundraisingscript.com  by Rockers Technology. is paid software. It is released under the terms of
 * the following BSD License.
 *
 *  Rockers Technologies (Head Office)
 *    5038,Berthpage Dr
 *    suwanee, GA. Zip Code : 30024
 *    E-mail Address : nishu@rockersinfo.com
 *
 * Copyright � 2012-2020 by Rockers Technology , INC a domestic profit corporation has been duly incorporated under
 * the laws of the state of georiga , USA. www.rockersinfo.com
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * - Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.
 * - Redistributions in binary form must reproduce the above copyright notice, this
 *   list of conditions and the following disclaimer in the documentation and/or
 *   other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 ********************************************************************************/
class Pages extends ROCKERS_Controller
{
    function __construct()
    {
        parent::__construct();
        $this->load->model('home_model');
    }

    function index()
    {
        redirect('admin/pages/list_pages');
    }

//==========Start of Pages tab code for content pages============= 	
    /*
     Function name :add_pages()
    Parameter :none
    Return : none
    Use : Function used adding pages to the website..
    */
    function add_pages()
    {
        $check_rights = get_rights('list_pages');

        if ($check_rights == 0) {
            redirect('admin/home/dashboard/no_rights');
        }

        $data['query'] = $this->home_model->get_language('language', array('active' => 1));

        //print_r($data['query']);
		$display_place_error='';
		$footer_bar ="";$right_side ="";
		
		//var_dump($_POST);die;
        $this->load->library('form_validation');
        if($this->input->post('pages_id'))
            $one_pages = $this->home_model->get_one_tabledata('pages', array('pages_id' => SecurePostData($this->input->post('pages_id'))));
        else
            $one_pages = array();

        $this->form_validation->set_rules('pages_title', PAGES_TITLE, 'required');
        $this->form_validation->set_rules('description', PAGES_DESCRIPTION, 'required');
        $this->form_validation->set_rules('slug', SLUG, 'required|valid_slug|[pages,slug,pages_id,'.$this->input->post("pages_id").']');

        if(SecurePostData($this->input->post('slug'))){
           $_POST['slug'] = makeSlugs($this->input->post('slug'));
       }
       
       if($this->input->post("pages_id")){
           $this->form_validation->set_rules('slug', SLUG, 'required|valid_slug|slugexist[pages,slug,pages_id,'.$this->input->post("pages_id").',language_id,'.$this->input->post("language").']');
       }else{
           $this->form_validation->set_rules('slug', SLUG, 'required|valid_slug|langslugexist[pages,slug,language_id,'.$this->input->post("language").']');

       }

        $this->form_validation->set_rules('external_link', EXTERNAL_URL, 'valid_url');
        if ($this->form_validation->run() == FALSE || $display_place_error!='') {
            if (validation_errors()|| $display_place_error!='') {
                 $data["error"] = validation_errors() . $display_place_error;
            } else {
                $data["error"] = "";
            }
			
            $data["pages_id"] = SecurePostData($this->input->post('pages_id'));
            $data["pages_title"] = SecurePostData($this->input->post('pages_title'));
            $data["description"] = EditorSecurePostData($this->input->post('description'));
            $data["slug"] = str_replace('_', '-', SecurePostData($this->input->post('slug')));
            $data["active"] = SecurePostData($this->input->post('active'));
            $data["language"] = SecurePostData($this->input->post('language'));
            $data["footer_bar"] = SecurePostData($this->input->post('footer_bar'));
            $data["right_side"] = SecurePostData($this->input->post('right_side'));
            $data["external_link"] = SecurePostData($this->input->post('external_link'));
            
            $data["is_fullpage"] = SecurePostData($this->input->post('is_fullpage'));

            $data["meta_keyword"] = SecurePostData($this->input->post('meta_keyword'));
            $data["meta_description"] = SecurePostData($this->input->post('meta_description'));

            $data['site_setting'] = site_setting();
            if($one_pages) {
                $data['main_page'] = $one_pages['main_page'];
            } else
                $data['main_page'] = 0;

            $theme = 'admin';

            $this->template->set_master_template($theme . '/template.php');
            $this->template->write('title', 'Pages', '', TRUE);
            $this->template->write_view('header', 'header', $data, TRUE);
            $this->template->write_view('main_content', 'content_pages/add_pages', $data, TRUE);
            $this->template->write_view('footer', 'footer', '', TRUE);
            $this->template->render();
        } else {
            
            
            $is_fullpage=0;
            if($this->input->post('is_fullpage')){
                $is_fullpage=$this->input->post('is_fullpage');
            }
            
            $data = array(
                'pages_title' => SecurePostData($this->input->post('pages_title')),
                'description' => EditorSecurePostData($this->input->post('description')),
                'slug' => strtolower($this->input->post('slug')),
                'meta_keyword' => SecurePostData($this->input->post('meta_keyword')),
                'meta_description' => SecurePostData($this->input->post('meta_description')),
                'footer_bar' => SecurePostData($this->input->post('footer_bar')),
                'right_side' => SecurePostData($this->input->post('right_side')),
                'external_link' => SecurePostData($this->input->post('external_link')),
                'language_id' => SecurePostData($this->input->post('language')),
                'is_fullpage' => $is_fullpage
            );
            if(!$one_pages || ($one_pages && !$one_pages['main_page']))
                $data['active'] = SecurePostData($this->input->post('active'));

            if ($this->input->post('pages_id')) {
                $this->home_model->table_update('pages_id', SecurePostData($this->input->post('pages_id')), 'pages', $data);
                $msg = "update";
            } else {
                $this->home_model->table_insert('pages', $data);
                $msg = "insert";
            }
            redirect('admin/pages/list_pages/' . $msg);
        }
    }

    /*
     Function name :edit_pages()
    Parameter :$id=id of the learn more page that is selected for editing or updating.
    Return : none
    Use : Function used to view information of pages selected for updating.
    */
    /**
     * @param int $id
     */
    function edit_pages($id = 0)
    {

        $check_rights = get_rights('list_pages');

        if ($check_rights == 0) {
            redirect('admin/home/dashboard/no_rights');
        }
        $data['query'] = $this->home_model->get_language('language', array('active' => 1));
        $one_pages = $this->home_model->get_one_tabledata('pages', array('pages_id' => $id));
        $data["error"] = "";
        $data["pages_id"] = $id;
        $data["pages_title"] = $one_pages['pages_title'];
        $data["description"] = SecureShowData($one_pages['description']);
        $data["slug"] = $one_pages['slug'];
        $data["active"] = $one_pages['active'];
        $data["meta_keyword"] = $one_pages['meta_keyword'];
        $data["meta_description"] = $one_pages['meta_description'];
        $data["language"] = $one_pages['language_id'];
        $data["footer_bar"] = $one_pages['footer_bar'];
        $data["right_side"] = $one_pages['right_side'];
        $data["external_link"] = $one_pages['external_link'];
        $data["main_page"] = $one_pages['main_page'];
        
        $data["is_fullpage"] = $one_pages['is_fullpage'];

        $data['site_setting'] = site_setting();
        $theme = 'admin';

        $this->template->set_master_template($theme . '/template.php');
        $this->template->write('title', 'Pages', '', TRUE);
        $this->template->write_view('header', 'header', $data, TRUE);
        $this->template->write_view('main_content', 'content_pages/add_pages', $data, TRUE);
        $this->template->write_view('footer', 'footer', '', TRUE);
        $this->template->render();
    }

    /*
     Function name :delete_pages()
    Parameter :$id=id of the page that is to be deleted.
    Return : none
    Use : Function used to delete particular page.
    */
    /**
     * @param int $id
     */
    function delete_pages($id = 0)
    {
        $check_rights = get_rights('list_pages');
        if ($check_rights == 0) {
            redirect('admin/home/dashboard/no_rights');
        }
        $one_pages = $this->home_model->get_one_tabledata('pages', array('pages_id' => $id));
        if($one_pages['main_page']) {
            $this->session->set_flashdata('error', MAIN_PAGE_CAN_NOT_BE_DELETED);
            redirect('admin/pages/list_pages');
        } else {
            $this->db->delete('pages', array('pages_id' => $id));
            redirect('admin/pages/list_pages/delete');
        }
    }

    /*
     Function name :list_pages()
    Parameter :$msg=message string to notify admin about the operation he performed.
    Return : none
    Use : Function is used for listing all the pages
    */
    /**
     * @param string $msg
     */
    function list_pages($msg = '')
    {

        $check_rights = get_rights('list_pages');

        if ($check_rights == 0) {
            redirect('admin/home/dashboard/no_rights');
        }

        //$data['result'] = $this->pages_model->get_pages_result($offset, $limit);
        $data['result'] = get_table_data('pages', array('pages_id' => 'desc'));
        $data['msg'] = $msg;

        $data['option'] = '';
        $data['keyword'] = '';
        $data['search_type'] = 'normal';

        $data['site_setting'] = site_setting();

        $theme = 'admin';

        $this->template->set_master_template($theme . '/template.php');
        $this->template->write('title', 'Pages', '', TRUE);
        $this->template->write_view('header', 'header', $data, TRUE);
        $this->template->write_view('main_content', 'content_pages/list_pages', $data, TRUE);
        $this->template->write_view('footer', 'footer', '', TRUE);
        $this->template->render();
    }
    //==========End of Pages tab code for content pages===============

    //==========Start of FAQ tab code for content pages===============
    /*
     Function name :action_faq()
    Parameter :none
    Return : none
    Use : Function used to delete,active or inactive selected faq records.
    */
    function action_faq()
    {
        $check_rights = get_rights('list_faq');

        if ($check_rights == 0) {
            redirect('admin/home/dashboard/no_rights');
        }
        $action = SecurePostData($this->input->post('action'));
        $faq_id = SecurePostData($this->input->post('chk'));

        switch ($action) {
            case 'active':
                $msg = 'active';
                foreach ($faq_id as $id) {

                    $this->db->query("update faq set active=1 where faq_id='" . $id . "'");
                }
                break;
            case 'inactive':
                $msg = 'inactive';
                foreach ($faq_id as $id) {
                    $this->db->query("update faq set active=0 where faq_id='" . $id . "'");
                }
                break;
            case 'delete':
                $msg = 'delete';
                foreach ($faq_id as $id) {
                    $this->db->query("delete from faq where faq_id='" . $id . "'");
                }
                break;
        }
        redirect('admin/pages/list_faq/' . $msg);
        /*	if($action=='help_page')
            {
        foreach($faq_id as $id)
        {
        $this->db->query("update faq set faq_home=1 where faq_id='".$id."'");
        }

        redirect('admin/faq/list_faq/help_page');
        }

        if($action=='not_help_page')
        {
        foreach($faq_id as $id)
        {

        $this->db->query("update faq set faq_home=0 where faq_id='".$id."'");
        }

        redirect('admin/faq/list_faq/not_help_page');
        } */
    }

    /*
     Function name :add_faq()
    Parameter :none
    Return : none
    Use : Function used adding faq records to the site.
    */

    function add_faq()
    {

        $check_rights = get_rights('list_faq');

        if ($check_rights == 0) {
            redirect('admin/home/dashboard/no_rights');
        }
        $data['query'] = $this->home_model->get_language('language', array('active' => 1));

        $this->load->library('form_validation');
        $this->form_validation->set_rules('faq_category_id', FAQ_CATEGORY, 'required');
        $this->form_validation->set_rules('question', QUESTIONS, 'required');
        $this->form_validation->set_rules('answer', ANSWER, 'required');
        if ($this->form_validation->run() == FALSE) {
            if (validation_errors()) {
                $data["error"] = validation_errors();
            } else {
                $data["error"] = "";
            }
            $data["faq_id"] = SecurePostData($this->input->post('faq_id'));
            $data["faq_category_id"] = 12;
            $data["question"] = SecurePostData($this->input->post('question'));
            $data["answer"] = SecurePostData($this->input->post('answer'));
            $data["active"] = SecurePostData($this->input->post('active'));
            $data['faq_home'] = SecurePostData($this->input->post('faq_home'));
            $data['faq_order'] = SecurePostData($this->input->post('faq_order'));
            $data["language"] = SecurePostData($this->input->post('language'));
            $data['site_setting'] = site_setting();
            //	$data['category'] = $this->faq_model->get_faq_category();

            $theme = 'admin';

            $this->template->set_master_template($theme . '/template.php');
            $this->template->write('title', 'FAQ', '', TRUE);
            $this->template->write_view('header', 'header', $data, TRUE);
            $this->template->write_view('main_content', 'content_pages/add_faq', $data, TRUE);
            $this->template->write_view('footer', 'footer', '', TRUE);
            $this->template->render();
        } else {
            $data = array(
                'faq_category_id' => SecurePostData($this->input->post('faq_category_id')),
                'question' => SecurePostData($this->input->post('question')),
                'answer' => SecurePostData($this->input->post('answer')),
                'active' => SecurePostData($this->input->post('active')),
                'faq_order' => SecurePostData($this->input->post('faq_order')),
                'language_id' => SecurePostData($this->input->post('language')),
                
                'date_added' => date("Y-m-d H:i:s"),
            );
            if ($this->input->post('faq_id')) {
                $this->home_model->table_update('faq_id', SecurePostData($this->input->post('faq_id')), 'faq', $data);
                $msg = "update";
            } else {
                $this->home_model->table_insert('faq', $data);
                $msg = "insert";
            }
            redirect('admin/pages/list_faq/' . $msg);
        }
    }

    /*
     Function name :edit_faq()
    Parameter :$id=id of the faq record that is selected for editing or updating.
    Return : none
    Use : Function used to view information of faq record selected for updating.
    */
    /**
     * @param int $id
     */
    function edit_faq($id = 0)
    {
        $check_rights = get_rights('list_faq');

        if ($check_rights == 0) {
            redirect('admin/home/dashboard/no_rights');
        }
        $data['query'] = $this->home_model->get_language('language', array('active' => 1));
        $one_faq = $this->home_model->get_one_tabledata('faq', array('faq_id' => $id));
        $data["error"] = "";
        $data["faq_id"] = $id;
        $data["faq_category_id"] = $one_faq['faq_category_id'];
        $data["question"] = $one_faq['question'];
        $data["answer"] = $one_faq['answer'];
        $data["active"] = $one_faq['active'];
        $data['faq_home'] = $one_faq['faq_home'];
        $data['faq_order'] = $one_faq['faq_order'];
        $data['site_setting'] = site_setting();
        $data["language_id"] = $one_faq['language_id'];
        //$data['category'] = $this->faq_model->get_faq_category();

        $theme = 'admin';

        $this->template->set_master_template($theme . '/template.php');
        $this->template->write('title', 'FAQ', '', TRUE);
        $this->template->write_view('header', 'header', $data, TRUE);
        $this->template->write_view('main_content', 'content_pages/add_faq', $data, TRUE);
        $this->template->write_view('footer', 'footer', '', TRUE);
        $this->template->render();
    }

    /*
     Function name :list_faq()
    Parameter :$msg=message string to notify admin about the operation he performed.
    Return : none
    Use : Function is used for listing all the faq records.
    */
    /**
     * @param string $msg
     */
    function list_faq($msg = '')
    {

        $check_rights = get_rights('list_faq');

        if ($check_rights == 0) {
            redirect('admin/home/dashboard/no_rights');
        }

        $data['site_setting'] = site_setting();
        //$data['result'] = $this->faq_model->get_faq_result($offset, $limit);
        $data['result'] = get_table_data('faq', array('faq_order' => 'asc'));
        $data['msg'] = $msg;
        $data['search_type'] = 'normal';

        $theme = 'admin';

        $this->template->set_master_template($theme . '/template.php');
        $this->template->write('title', 'FAQ', '', TRUE);
        $this->template->write_view('header', 'header', $data, TRUE);
        $this->template->write_view('main_content', 'content_pages/list_faq', $data, TRUE);
        $this->template->write_view('footer', 'footer', '', TRUE);
        $this->template->render();
    }
    /*	function delete_faq($id=0)
     {
    $check_rights=get_rights('list_faq');

    if(	$check_rights==0) {
    redirect('admin/home/dashboard/no_rights');
    }

    $this->db->delete('faq',array('faq_id'=>$id));
    redirect('faq/list_faq/delete');
    }
    */
    //===============End of FAQ tab content pages..================
}
/* end of file */
