<?php
 /**
  * Stub objects for PayPalAPIInterfaceService 
  * Auto generated code 
  * 
  */
/**
 * @hasAttribute
 * On requests, you must set the currencyID attribute to one of
 * the three-character currency codes for any of the supported
 * PayPal currencies. Limitations: Must not exceed $10,000 USD
 * in any currency. No currency symbol. Decimal separator must
 * be a period (.), and the thousands separator must be a comma
 * (,).
 */
class BasicAmountType  
   extends PPXmlMessage{

	/**
	 * 
	 * @access public
	 
	 * @namespace cc
	 
	 
	 * @attribute 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $currencyID;

	/**
	 * 
	 * @access public
	 
	 * @namespace cc
	 
	 
	 * @value
	 	 	 	 
	 * @var string 	 
	 */ 
	public $value;

	/**
	 * Constructor with arguments
	 */
	public function __construct($currencyID = NULL, $value = NULL) {
		$this->currencyID = $currencyID;
		$this->value = $value;
	}


  
 
}



/**
 * @hasAttribute
 * 
 */
class MeasureType  
   extends PPXmlMessage{

	/**
	 * 
	 * @access public
	 
	 * @namespace cc
	 
	 
	 * @attribute 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $unit;

	/**
	 * 
	 * @access public
	 
	 * @namespace cc
	 
	 
	 * @value
	 	 	 	 
	 * @var double 	 
	 */ 
	public $value;

	/**
	 * Constructor with arguments
	 */
	public function __construct($unit = NULL, $value = NULL) {
		$this->unit = $unit;
		$this->value = $value;
	}


  
 
}



/**
 * @hasAttribute
 * Value of the application-specific error parameter.  
 */
class ErrorParameterType  
   extends PPXmlMessage{

	/**
	 * Value of the application-specific error parameter.  
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Value;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 
	 * @attribute 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ParamID;


}



/**
 * Error code can be used by a receiving application to
 * debugging a response message. These codes will need to be
 * uniquely defined for each application. 
 */
class ErrorType  
   extends PPXmlMessage{

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ShortMessage;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $LongMessage;

	/**
	 * Error code can be used by a receiving application to
	 * debugging a response message. These codes will need to be
	 * uniquely defined for each application. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ErrorCode;

	/**
	 * SeverityCode indicates whether the error is an application 
	 * level error or if it is informational error, i.e., warning. 
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $SeverityCode;

	/**
	 * This optional element may carry additional
	 * application-specific error variables that indicate specific
	 * information about the error condition particularly in the
	 * cases where there are multiple instances of the ErrorType
	 * which require additional context.  
     * @array
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var ErrorParameterType 	 
	 */ 
	public $ErrorParameters;


}



/**
 * Base type definition of request payload that can carry any
 * type of payload content with optional versioning information
 * and detail level requirements. 
 */
class AbstractRequestType  
   extends PPXmlMessage{

	/**
	 * This specifies the required detail level that is needed by a
	 * client application pertaining to a particular data component
	 * (e.g., Item, Transaction, etc.). The detail level is
	 * specified in the DetailLevelCodeType which has all the
	 * enumerated values of the detail level for each component. 
     * @array
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $DetailLevel;

	/**
	 * This should be the standard RFC 3066 language identification
	 * tag, e.g., en_US. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ErrorLanguage;

	/**
	 * This refers to the version of the request payload schema. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Version;


  
 
}



/**
 * Base type definition of a response payload that can carry
 * any type of payload content with following optional
 * elements: - timestamp of response message, - application
 * level acknowledgement, and - application-level errors and
 * warnings. 
 */
class AbstractResponseType  
   extends PPXmlMessage{

	/**
	 * This value represents the date and time (GMT) when the
	 * response was generated by a service provider (as a result of
	 * processing of a request). 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var dateTime 	 
	 */ 
	public $Timestamp;

	/**
	 * Application level acknowledgement code. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Ack;

	/**
	 * CorrelationID may be used optionally with an application
	 * level acknowledgement. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $CorrelationID;

	/**
	 * 
     * @array
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var ErrorType 	 
	 */ 
	public $Errors;

	/**
	 * This refers to the version of the response payload schema. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Version;

	/**
	 * This refers to the specific software build that was used in
	 * the deployment for processing the request and generating the
	 * response. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Build;


}



/**
 * Country code associated with this phone number. 
 */
class PhoneNumberType  
   extends PPXmlMessage{

	/**
	 * Country code associated with this phone number. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $CountryCode;

	/**
	 * Phone number associated with this phone. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $PhoneNumber;

	/**
	 * Extension associated with this phone number. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Extension;


  
 
}



/**
 * Person's name associated with this address. Character length
 * and limitations: 32 single-byte alphanumeric characters 
 */
class AddressType  
   extends PPXmlMessage{

	/**
	 * Person's name associated with this address. Character length
	 * and limitations: 32 single-byte alphanumeric characters
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Name;

	/**
	 * First street address. Character length and limitations: 300
	 * single-byte alphanumeric characters
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Street1;

	/**
	 * Second street address. Character length and limitations: 300
	 * single-byte alphanumeric characters
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Street2;

	/**
	 * Name of city. Character length and limitations: 120
	 * single-byte alphanumeric characters
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $CityName;

	/**
	 * State or province. Character length and limitations: 120
	 * single-byte alphanumeric characters For Canada and the USA,
	 * StateOrProvince must be the standard 2-character
	 * abbreviation of a state or province. Canadian Provinces
	 * Alberta AB British_Columbia BC Manitoba MB New_Brunswick NB
	 * Newfoundland NF Northwest_Territories NT Nova_Scotia NS
	 * Nunavut NU Ontario ON Prince_Edward_Island PE Quebec QC
	 * Saskatchewan SK Yukon YK United States Alabama  AL Alaska AK
	 * American_Samoa AS Arizona AZ Arkansas AR California CA
	 * Colorado CO Connecticut CT Delaware DE District_Of_Columbia
	 * DC Federated_States_Of_Micronesia FM Florida FL Georgia GA
	 * Guam GU Hawaii HI Idaho ID Illinois IL Indiana IN Iowa IA
	 * Kansas KS Kentucky KY Louisiana LA Maine ME Marshall_Islands
	 * MH Maryland MD Massachusetts MA Michigan MI Minnesota MN
	 * Mississippi MS Missouri MO Montana MT Nebraska NE Nevada NV
	 * New_Hampshire NH New_Jersey NJ New_Mexico NM New_York NY
	 * North_Carolina NC North_Dakota ND Northern_Mariana_Islands
	 * MP Ohio OH Oklahoma OK Oregon OR Palau PW Pennsylvania PA
	 * Puerto_Rico PR Rhode_Island RI South_Carolina SC
	 * South_Dakota SD Tennessee TN Texas TX Utah UT Vermont VT
	 * Virgin_Islands VI Virginia VA Washington WA West_Virginia WV
	 * Wisconsin WI Wyoming WY Armed_Forces_Americas AA
	 * Armed_Forces AE Armed_Forces_Pacific AP 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $StateOrProvince;

	/**
	 * ISO 3166 standard country code Character limit: Two
	 * single-byte characters. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Country;

	/**
	 * IMPORTANT: Do not set this element for SetExpressCheckout,
	 * DoExpressCheckoutPayment, DoDirectPayment,
	 * CreateRecurringPaymentsProfile or
	 * UpdateRecurringPaymentsProfile.  This element should only be
	 * used in response elements and typically  should not be used
	 * in creating request messages which specify the name of a
	 * country using the Country element (which refers to a 
	 * 2-letter country code). 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $CountryName;

	/**
	 * Telephone number associated with this address
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Phone;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $PostalCode;

	/**
	 * IMPORTANT: Do not set this element for SetExpressCheckout,
	 * DoExpressCheckoutPayment, DoDirectPayment,
	 * CreateRecurringPaymentsProfile, or
	 * UpdateRecurringPaymentsProfile.
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $AddressID;

	/**
	 * IMPORTANT: Do not set this element for SetExpressCheckout,
	 * DoExpressCheckoutPayment, DoDirectPayment,
	 * CreateRecurringPaymentsProfile or
	 * UpdateRecurringPaymentsProfile.
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $AddressOwner;

	/**
	 * IMPORTANT: Do not set this element for SetExpressCheckout,
	 * DoExpressCheckoutPayment, DoDirectPayment,
	 * CreateRecurringPaymentsProfile or
	 * UpdateRecurringPaymentsProfile.
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ExternalAddressID;

	/**
	 * IMPORTANT: Do not set this element for SetExpressCheckout,
	 * DoExpressCheckoutPayment, DoDirectPayment,
	 * CreateRecurringPaymentsProfile or
	 * UpdateRecurringPaymentsProfile.  Only applicable to
	 * SellerPaymentAddress today. Seller's international name that
	 * is associated with the payment address. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $InternationalName;

	/**
	 * IMPORTANT: Do not set this element for SetExpressCheckout,
	 * DoExpressCheckoutPayment, DoDirectPayment,
	 * CreateRecurringPaymentsProfile or
	 * UpdateRecurringPaymentsProfile. Only applicable to
	 * SellerPaymentAddress today. International state and city for
	 * the seller's payment address. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $InternationalStateAndCity;

	/**
	 * IMPORTANT: Do not set this element for SetExpressCheckout,
	 * DoExpressCheckoutPayment, DoDirectPayment,
	 * CreateRecurringPaymentsProfile or
	 * UpdateRecurringPaymentsProfile. Only applicable to
	 * SellerPaymentAddress today. Seller's international street
	 * address that is associated with the payment address. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $InternationalStreet;

	/**
	 * Status of the address on file with PayPal. IMPORTANT: Do not
	 * set this element for SetExpressCheckout,
	 * DoExpressCheckoutPayment, DoDirectPayment,
	 * CreateRecurringPaymentsProfile or
	 * UpdateRecurringPaymentsProfile. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $AddressStatus;

	/**
	 * Returns Normalization Status of the Address. Possible values
	 * are Normalized, Unnormalized, and None. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $AddressNormalizationStatus;


  
 
}



/**
 * 
 */
class PersonNameType  
   extends PPXmlMessage{

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Salutation;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $FirstName;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $MiddleName;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $LastName;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Suffix;


  
 
}



/**
 * 
 */
class IncentiveAppliedToType  
   extends PPXmlMessage{

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $BucketId;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ItemId;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var BasicAmountType 	 
	 */ 
	public $IncentiveAmount;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $SubType;


}



/**
 * 
 */
class IncentiveDetailType  
   extends PPXmlMessage{

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $RedemptionCode;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $DisplayCode;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ProgramId;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $IncentiveType;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $IncentiveDescription;

	/**
	 * 
     * @array
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var IncentiveAppliedToType 	 
	 */ 
	public $AppliedTo;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Status;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ErrorCode;


}



/**
 * 
 */
class IncentiveItemType  
   extends PPXmlMessage{

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ItemId;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var dateTime 	 
	 */ 
	public $PurchaseTime;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ItemCategoryList;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var BasicAmountType 	 
	 */ 
	public $ItemPrice;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var integer 	 
	 */ 
	public $ItemQuantity;


  
 
}



/**
 * 
 */
class IncentiveBucketType  
   extends PPXmlMessage{

	/**
	 * 
     * @array
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var IncentiveItemType 	 
	 */ 
	public $Items;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $BucketId;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $SellerId;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ExternalSellerId;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var BasicAmountType 	 
	 */ 
	public $BucketSubtotalAmt;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var BasicAmountType 	 
	 */ 
	public $BucketShippingAmt;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var BasicAmountType 	 
	 */ 
	public $BucketInsuranceAmt;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var BasicAmountType 	 
	 */ 
	public $BucketSalesTaxAmt;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var BasicAmountType 	 
	 */ 
	public $BucketTotalAmt;


  
 
}



/**
 * 
 */
class IncentiveRequestDetailsType  
   extends PPXmlMessage{

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $RequestId;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $RequestType;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $RequestDetailLevel;


  
 
}



/**
 * 
 */
class GetIncentiveEvaluationRequestDetailsType  
   extends PPXmlMessage{

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ExternalBuyerId;

	/**
	 * 
     * @array
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $IncentiveCodes;

	/**
	 * 
     * @array
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var IncentiveApplyIndicationType 	 
	 */ 
	public $ApplyIndication;

	/**
	 * 
     * @array
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var IncentiveBucketType 	 
	 */ 
	public $Buckets;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var BasicAmountType 	 
	 */ 
	public $CartTotalAmt;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var IncentiveRequestDetailsType 	 
	 */ 
	public $RequestDetails;


  
 
}



/**
 * 
 */
class GetIncentiveEvaluationResponseDetailsType  
   extends PPXmlMessage{

	/**
	 * 
     * @array
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var IncentiveDetailType 	 
	 */ 
	public $IncentiveDetails;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $RequestId;


}



/**
 * The total cost of the order to the customer. If shipping
 * cost and tax charges are known, include them in OrderTotal;
 * if not, OrderTotal should be the current sub-total of the
 * order. You must set the currencyID attribute to one of the
 * three-character currency codes for any of the supported
 * PayPal currencies. Limitations: Must not exceed $10,000 USD
 * in any currency. No currency symbol. Decimal separator must
 * be a period (.), and the thousands separator must be a comma
 * (,). 
 */
class SetExpressCheckoutRequestDetailsType  
   extends PPXmlMessage{

	/**
	 * The total cost of the order to the customer. If shipping
	 * cost and tax charges are known, include them in OrderTotal;
	 * if not, OrderTotal should be the current sub-total of the
	 * order. You must set the currencyID attribute to one of the
	 * three-character currency codes for any of the supported
	 * PayPal currencies. Limitations: Must not exceed $10,000 USD
	 * in any currency. No currency symbol. Decimal separator must
	 * be a period (.), and the thousands separator must be a comma
	 * (,).
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var BasicAmountType 	 
	 */ 
	public $OrderTotal;

	/**
	 * URL to which the customer's browser is returned after
	 * choosing to pay with PayPal. PayPal recommends that the
	 * value of ReturnURL be the final review page on which the
	 * customer confirms the order and payment. Required Character
	 * length and limitations: no limit. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ReturnURL;

	/**
	 * URL to which the customer is returned if he does not approve
	 * the use of PayPal to pay you. PayPal recommends that the
	 * value of CancelURL be the original page on which the
	 * customer chose to pay with PayPal. Required Character length
	 * and limitations: no limit
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $CancelURL;

	/**
	 * Tracking URL for ebay. Required Character length and
	 * limitations: no limit
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $TrackingImageURL;

	/**
	 * URL to which the customer's browser is returned after paying
	 * with giropay online. Optional Character length and
	 * limitations: no limit.
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $giropaySuccessURL;

	/**
	 * URL to which the customer's browser is returned after fail
	 * to pay with giropay online. Optional Character length and
	 * limitations: no limit.
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $giropayCancelURL;

	/**
	 * URL to which the customer's browser can be returned in the
	 * mEFT done page. Optional Character length and limitations:
	 * no limit.
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $BanktxnPendingURL;

	/**
	 * On your first invocation of SetExpressCheckoutRequest, the
	 * value of this token is returned by
	 * SetExpressCheckoutResponse. Optional Include this element
	 * and its value only if you want to modify an existing
	 * checkout session with another invocation of
	 * SetExpressCheckoutRequest; for example, if you want the
	 * customer to edit his shipping address on PayPal. Character
	 * length and limitations: 20 single-byte characters
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Token;

	/**
	 * The expected maximum total amount of the complete order,
	 * including shipping cost and tax charges. Optional You must
	 * set the currencyID attribute to one of the three-character
	 * currency codes for any of the supported PayPal currencies.
	 * Limitations: Must not exceed $10,000 USD in any currency. No
	 * currency symbol. Decimal separator must be a period (.), and
	 * the thousands separator must be a comma (,).
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var BasicAmountType 	 
	 */ 
	public $MaxAmount;

	/**
	 * Description of items the customer is purchasing. Optional
	 * Character length and limitations: 127 single-byte
	 * alphanumeric characters
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $OrderDescription;

	/**
	 * A free-form field for your own use, such as a tracking
	 * number or other value you want PayPal to return on
	 * GetExpressCheckoutDetailsResponse and
	 * DoExpressCheckoutPaymentResponse. Optional Character length
	 * and limitations: 256 single-byte alphanumeric characters
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Custom;

	/**
	 * Your own unique invoice or tracking number. PayPal returns
	 * this value to you on DoExpressCheckoutPaymentResponse.
	 * Optional Character length and limitations: 127 single-byte
	 * alphanumeric characters
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $InvoiceID;

	/**
	 * The value 1 indicates that you require that the customer's
	 * shipping address on file with PayPal be a confirmed address.
	 * Any value other than 1 indicates that the customer's
	 * shipping address on file with PayPal need NOT be a confirmed
	 * address. Setting this element overrides the setting you have
	 * specified in the recipient's Merchant Account Profile.
	 * Optional Character length and limitations: One single-byte
	 * numeric character.
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ReqConfirmShipping;

	/**
	 * The value 1 indicates that you require that the customer's
	 * billing address on file. Setting this element overrides the
	 * setting you have specified in Admin. Optional Character
	 * length and limitations: One single-byte numeric character. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ReqBillingAddress;

	/**
	 * The billing address for the buyer. Optional If you include
	 * the BillingAddress element, the AddressType elements are
	 * required: Name Street1 CityName CountryCode Do not set set
	 * the CountryName element. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var AddressType 	 
	 */ 
	public $BillingAddress;

	/**
	 * The value 1 indicates that on the PayPal pages, no shipping
	 * address fields should be displayed whatsoever. Optional
	 * Character length and limitations: Four single-byte numeric
	 * characters.
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $NoShipping;

	/**
	 * The value 1 indicates that the PayPal pages should display
	 * the shipping address set by you in the Address element on
	 * this SetExpressCheckoutRequest, not the shipping address on
	 * file with PayPal for this customer. Displaying the PayPal
	 * street address on file does not allow the customer to edit
	 * that address. Optional Character length and limitations:
	 * Four single-byte numeric characters.
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $AddressOverride;

	/**
	 * Locale of pages displayed by PayPal during Express Checkout.
	 * Optional Character length and limitations: Five single-byte
	 * alphabetic characters, upper- or lowercase. Allowable
	 * values: AU or en_AUDE or de_DEFR or fr_FRGB or en_GBIT or
	 * it_ITJP or ja_JPUS or en_US
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $LocaleCode;

	/**
	 * Sets the Custom Payment Page Style for payment pages
	 * associated with this button/link. PageStyle corresponds to
	 * the HTML variable page_style for customizing payment pages.
	 * The value is the same as the Page Style Name you chose when
	 * adding or editing the page style from the Profile subtab of
	 * the My Account tab of your PayPal account. Optional
	 * Character length and limitations: 30 single-byte alphabetic
	 * characters. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $PageStyle;

	/**
	 * A URL for the image you want to appear at the top left of
	 * the payment page. The image has a maximum size of 750 pixels
	 * wide by 90 pixels high. PayPal recommends that you provide
	 * an image that is stored on a secure (https) server. Optional
	 * Character length and limitations: 127
	 * @access public
	 
	 * @namespace ebl
	 
	 
	 * @name cpp-header-image
	 	 	 	 
	 * @var string 	 
	 */ 
	public $cppheaderimage;

	/**
	 * Sets the border color around the header of the payment page.
	 * The border is a 2-pixel perimeter around the header space,
	 * which is 750 pixels wide by 90 pixels high. Optional
	 * Character length and limitations: Six character HTML
	 * hexadecimal color code in ASCII
	 * @access public
	 
	 * @namespace ebl
	 
	 
	 * @name cpp-header-border-color
	 	 	 	 
	 * @var string 	 
	 */ 
	public $cppheaderbordercolor;

	/**
	 * Sets the background color for the header of the payment
	 * page. Optional Character length and limitation: Six
	 * character HTML hexadecimal color code in ASCII
	 * @access public
	 
	 * @namespace ebl
	 
	 
	 * @name cpp-header-back-color
	 	 	 	 
	 * @var string 	 
	 */ 
	public $cppheaderbackcolor;

	/**
	 * Sets the background color for the payment page. Optional
	 * Character length and limitation: Six character HTML
	 * hexadecimal color code in ASCII
	 * @access public
	 
	 * @namespace ebl
	 
	 
	 * @name cpp-payflow-color
	 	 	 	 
	 * @var string 	 
	 */ 
	public $cpppayflowcolor;

	/**
	 * Sets the cart gradient color for the Mini Cart on 1X flow.
	 * Optional Character length and limitation: Six character HTML
	 * hexadecimal color code in ASCII
	 * @access public
	 
	 * @namespace ebl
	 
	 
	 * @name cpp-cart-border-color
	 	 	 	 
	 * @var string 	 
	 */ 
	public $cppcartbordercolor;

	/**
	 * A URL for the image you want to appear above the mini-cart.
	 * The image has a maximum size of 190 pixels wide by 60 pixels
	 * high. PayPal recommends that you provide an image that is
	 * stored on a secure (https) server. Optional Character length
	 * and limitations: 127
	 * @access public
	 
	 * @namespace ebl
	 
	 
	 * @name cpp-logo-image
	 	 	 	 
	 * @var string 	 
	 */ 
	public $cpplogoimage;

	/**
	 * Customer's shipping address. Optional If you include a
	 * shipping address and set the AddressOverride element on the
	 * request, PayPal returns this same address in
	 * GetExpressCheckoutDetailsResponse. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var AddressType 	 
	 */ 
	public $Address;

	/**
	 * How you want to obtain payment. Required Authorization
	 * indicates that this payment is a basic authorization subject
	 * to settlement with PayPal Authorization and Capture. Order
	 * indicates that this payment is is an order authorization
	 * subject to settlement with PayPal Authorization and Capture.
	 * Sale indicates that this is a final sale for which you are
	 * requesting payment. IMPORTANT: You cannot set PaymentAction
	 * to Sale or Order on SetExpressCheckoutRequest and then
	 * change PaymentAction to Authorization on the final Express
	 * Checkout API, DoExpressCheckoutPaymentRequest. Character
	 * length and limit: Up to 13 single-byte alphabetic characters
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $PaymentAction;

	/**
	 * This will indicate which flow you are choosing
	 * (expresschecheckout or expresscheckout optional) Optional
	 * None Sole indicates that you are in the ExpressO flow Mark
	 * indicates that you are in the old express flow. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $SolutionType;

	/**
	 * This indicates Which page to display for ExpressO (Billing
	 * or Login) Optional None Billing indicates that you are not a
	 * paypal account holder Login indicates that you are a paypal
	 * account holder 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $LandingPage;

	/**
	 * Email address of the buyer as entered during checkout.
	 * PayPal uses this value to pre-fill the PayPal membership
	 * sign-up portion of the PayPal login page. Optional Character
	 * length and limit: 127 single-byte alphanumeric characters 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $BuyerEmail;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ChannelType;

	/**
	 * 
     * @array
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var BillingAgreementDetailsType 	 
	 */ 
	public $BillingAgreementDetails;

	/**
	 * Promo Code Optional List of promo codes supplied by
	 * merchant. These promo codes enable the Merchant Services
	 * Promotion Financing feature. 
     * @array
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $PromoCodes;

	/**
	 * Default Funding option for PayLater Checkout button. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $PayPalCheckOutBtnType;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ProductCategory;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ShippingMethod;

	/**
	 * Date and time (in GMT in the format yyyy-MM-ddTHH:mm:ssZ) at
	 * which address was changed by the user. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var dateTime 	 
	 */ 
	public $ProfileAddressChangeDate;

	/**
	 * The value 1 indicates that the customer may enter a note to
	 * the merchant on the PayPal page during checkout. The note is
	 * returned in the GetExpressCheckoutDetails response and the
	 * DoExpressCheckoutPayment response. Optional Character length
	 * and limitations: One single-byte numeric character.
	 * Allowable values: 0,1 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $AllowNote;

	/**
	 * Funding source preferences. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var FundingSourceDetailsType 	 
	 */ 
	public $FundingSourceDetails;

	/**
	 * The label that needs to be displayed on the cancel links in
	 * the PayPal hosted checkout pages. Optional Character length
	 * and limit: 127 single-byte alphanumeric characters 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $BrandName;

	/**
	 * URL for PayPal to use to retrieve shipping, handling,
	 * insurance, and tax details from your website. Optional
	 * Character length and limitations: 2048 characters. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $CallbackURL;

	/**
	 * Enhanced data for different industry segments. Optional 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var EnhancedCheckoutDataType 	 
	 */ 
	public $EnhancedCheckoutData;

	/**
	 * List of other payment methods the user can pay with.
	 * Optional Refer to the OtherPaymentMethodDetailsType for more
	 * details. 
     * @array
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var OtherPaymentMethodDetailsType 	 
	 */ 
	public $OtherPaymentMethods;

	/**
	 * Details about the buyer's account. Optional Refer to the
	 * BuyerDetailsType for more details. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var BuyerDetailsType 	 
	 */ 
	public $BuyerDetails;

	/**
	 * Information about the payment. 
     * @array
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var PaymentDetailsType 	 
	 */ 
	public $PaymentDetails;

	/**
	 * List of Fall Back Shipping options provided by merchant. 
     * @array
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var ShippingOptionType 	 
	 */ 
	public $FlatRateShippingOptions;

	/**
	 * Information about the call back timeout override. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $CallbackTimeout;

	/**
	 * Information about the call back version. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $CallbackVersion;

	/**
	 * Information about the Customer service number. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $CustomerServiceNumber;

	/**
	 * Information about the Gift message enable. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $GiftMessageEnable;

	/**
	 * Information about the Gift receipt enable. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $GiftReceiptEnable;

	/**
	 * Information about the Gift Wrap enable. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $GiftWrapEnable;

	/**
	 * Information about the Gift Wrap name. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $GiftWrapName;

	/**
	 * Information about the Gift Wrap amount. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var BasicAmountType 	 
	 */ 
	public $GiftWrapAmount;

	/**
	 * Information about the Buyer email option enable . 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $BuyerEmailOptInEnable;

	/**
	 * Information about the survey enable. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $SurveyEnable;

	/**
	 * Information about the survey question. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $SurveyQuestion;

	/**
	 * Information about the survey choices for survey question. 
     * @array
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $SurveyChoice;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $TotalType;

	/**
	 * Any message the seller would like to be displayed in the
	 * Mini Cart for UX. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $NoteToBuyer;

	/**
	 * Incentive Code Optional List of incentive codes supplied by
	 * ebay/merchant. 
     * @array
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var IncentiveInfoType 	 
	 */ 
	public $Incentives;

	/**
	 * Merchant specified flag which indicates whether to return
	 * Funding Instrument Details in DoEC or not. Optional 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ReqInstrumentDetails;

	/**
	 * This element contains information that allows the merchant
	 * to request to opt into external remember me on behalf of the
	 * buyer or to request login bypass using external remember me.
	 * Note the opt-in details are silently ignored if the
	 * ExternalRememberMeID is present. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var ExternalRememberMeOptInDetailsType 	 
	 */ 
	public $ExternalRememberMeOptInDetails;

	/**
	 * An optional set of values related to flow-specific details. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var FlowControlDetailsType 	 
	 */ 
	public $FlowControlDetails;

	/**
	 * An optional set of values related to display-specific
	 * details. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var DisplayControlDetailsType 	 
	 */ 
	public $DisplayControlDetails;

	/**
	 * An optional set of values related to tracking for external
	 * partner. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var ExternalPartnerTrackingDetailsType 	 
	 */ 
	public $ExternalPartnerTrackingDetails;

	/**
	 * Optional element that defines relationship between buckets 
     * @array
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var CoupledBucketsType 	 
	 */ 
	public $CoupledBuckets;


  
 
}



/**
 * On your first invocation of
 * ExecuteCheckoutOperationsRequest, the value of this token is
 * returned by ExecuteCheckoutOperationsResponse. Optional
 * Include this element and its value only if you want to
 * modify an existing checkout session with another invocation
 * of ExecuteCheckoutOperationsRequest; for example, if you
 * want the customer to edit his shipping address on PayPal.
 * Character length and limitations: 20 single-byte characters 
 */
class ExecuteCheckoutOperationsRequestDetailsType  
   extends PPXmlMessage{

	/**
	 * On your first invocation of
	 * ExecuteCheckoutOperationsRequest, the value of this token is
	 * returned by ExecuteCheckoutOperationsResponse. Optional
	 * Include this element and its value only if you want to
	 * modify an existing checkout session with another invocation
	 * of ExecuteCheckoutOperationsRequest; for example, if you
	 * want the customer to edit his shipping address on PayPal.
	 * Character length and limitations: 20 single-byte characters 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Token;

	/**
	 * All the Data required to initiate the checkout session is
	 * passed in this element. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var SetDataRequestType 	 
	 */ 
	public $SetDataRequest;

	/**
	 * If auto authorization is required, this should be passed in
	 * with IsRequested set to yes. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var AuthorizationRequestType 	 
	 */ 
	public $AuthorizationRequest;

	/**
	 * Constructor with arguments
	 */
	public function __construct($SetDataRequest = NULL) {
		$this->SetDataRequest = $SetDataRequest;
	}


  
 
}



/**
 * Details about Billing Agreements requested to be created. 
 */
class SetDataRequestType  
   extends PPXmlMessage{

	/**
	 * Details about Billing Agreements requested to be created. 
     * @array
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var BillingApprovalDetailsType 	 
	 */ 
	public $BillingApprovalDetails;

	/**
	 * Only needed if Auto Authorization is requested. The
	 * authentication session token will be passed in here. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var BuyerDetailType 	 
	 */ 
	public $BuyerDetail;

	/**
	 * Requests for specific buyer information like Billing Address
	 * to be returned through GetExpressCheckoutDetails should be
	 * specified under this. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var InfoSharingDirectivesType 	 
	 */ 
	public $InfoSharingDirectives;

	/**
	 * The value 1 indicates that you require to retrieve the
	 * customer's shipping address on file with PayPal. Any value
	 * other than 1 indicates that no such requirement. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var boolean 	 
	 */ 
	public $RetrieveShippingAddress;

	/**
	 * the value is required by ACS team to specify the channel
	 * which the partners are in. the channel will be used for risk
	 * assessment the value is defined in
	 * biz/User/value_object/Channel.oml Optional 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $UserChannel;

	/**
	 * The value 1 indicates that you require that the customer's
	 * shipping address on file with PayPal be a confirmed address.
	 * Any value other than 1 indicates that the customer's
	 * shipping address on file with PayPal need NOT be a confirmed
	 * address. Setting this element overrides the setting you have
	 * specified in the recipient's Merchant Account Profile.
	 * Optional 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var boolean 	 
	 */ 
	public $ReqConfirmShipping;

	/**
	 * Information about the payment. 
     * @array
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var PaymentDetailsType 	 
	 */ 
	public $PaymentDetails;

	/**
	 * An optional set of values related to tracking for external
	 * partner. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var ExternalPartnerTrackingDetailsType 	 
	 */ 
	public $ExternalPartnerTrackingDetails;

	/**
	 * URI(uniform resource identifier), the source from which the
	 * request is initiated. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $URI;


  
 
}



/**
 * 
 */
class AuthorizationRequestType  
   extends PPXmlMessage{

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var boolean 	 
	 */ 
	public $IsRequested;

	/**
	 * Constructor with arguments
	 */
	public function __construct($IsRequested = NULL) {
		$this->IsRequested = $IsRequested;
	}


  
 
}



/**
 * The Type of Approval requested - Billing Agreement or
 * Profile 
 */
class BillingApprovalDetailsType  
   extends PPXmlMessage{

	/**
	 * The Type of Approval requested - Billing Agreement or
	 * Profile
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ApprovalType;

	/**
	 * The Approval subtype - Must be MerchantInitiatedBilling for
	 * BillingAgreement ApprovalType
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ApprovalSubType;

	/**
	 * Description about the Order
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var OrderDetailsType 	 
	 */ 
	public $OrderDetails;

	/**
	 * Directives about the type of payment
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var PaymentDirectivesType 	 
	 */ 
	public $PaymentDirectives;

	/**
	 * Client may pass in its identification of this Billing
	 * Agreement. It used for the client's tracking purposes.
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Custom;

	/**
	 * Constructor with arguments
	 */
	public function __construct($ApprovalType = NULL) {
		$this->ApprovalType = $ApprovalType;
	}


  
 
}



/**
 * If Billing Address should be returned in
 * GetExpressCheckoutDetails response, this parameter should be
 * set to yes here 
 */
class InfoSharingDirectivesType  
   extends PPXmlMessage{

	/**
	 * If Billing Address should be returned in
	 * GetExpressCheckoutDetails response, this parameter should be
	 * set to yes here
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ReqBillingAddress;


  
 
}



/**
 * Description of the Order. 
 */
class OrderDetailsType  
   extends PPXmlMessage{

	/**
	 * Description of the Order.
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Description;

	/**
	 * Expected maximum amount that the merchant may pull using
	 * DoReferenceTransaction
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var BasicAmountType 	 
	 */ 
	public $MaxAmount;


  
 
}



/**
 * Type of the Payment is it Instant or Echeck or Any. 
 */
class PaymentDirectivesType  
   extends PPXmlMessage{

	/**
	 * Type of the Payment is it Instant or Echeck or Any.
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $PaymentType;


  
 
}



/**
 * Information that is used to indentify the Buyer. This is
 * used for auto authorization. Mandatory if Authorization is
 * requested. 
 */
class BuyerDetailType  
   extends PPXmlMessage{

	/**
	 * Information that is used to indentify the Buyer. This is
	 * used for auto authorization. Mandatory if Authorization is
	 * requested.
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var IdentificationInfoType 	 
	 */ 
	public $IdentificationInfo;

	/**
	 * Correlation id related to risk process done for the device.
	 * Max length is 36 Chars.
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $RiskSessionCorrelationID;


  
 
}



/**
 * Mobile specific buyer identification. 
 */
class IdentificationInfoType  
   extends PPXmlMessage{

	/**
	 * Mobile specific buyer identification.
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var MobileIDInfoType 	 
	 */ 
	public $MobileIDInfo;

	/**
	 * Contains login bypass information.
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var RememberMeIDInfoType 	 
	 */ 
	public $RememberMeIDInfo;

	/**
	 * Identity Access Token.
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var IdentityTokenInfoType 	 
	 */ 
	public $IdentityTokenInfo;


  
 
}



/**
 * The Session token returned during buyer authentication. 
 */
class MobileIDInfoType  
   extends PPXmlMessage{

	/**
	 * The Session token returned during buyer authentication.
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $SessionToken;


  
 
}



/**
 * External remember-me ID returned by
 * GetExpressCheckoutDetails on successful opt-in. The
 * ExternalRememberMeID is a 17-character alphanumeric
 * (encrypted) string that identifies the buyer's remembered
 * login with a merchant and has meaning only to the merchant.
 * If present, requests that the web flow attempt bypass of
 * login. 
 */
class RememberMeIDInfoType  
   extends PPXmlMessage{

	/**
	 * External remember-me ID returned by
	 * GetExpressCheckoutDetails on successful opt-in. The
	 * ExternalRememberMeID is a 17-character alphanumeric
	 * (encrypted) string that identifies the buyer's remembered
	 * login with a merchant and has meaning only to the merchant.
	 * If present, requests that the web flow attempt bypass of
	 * login. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ExternalRememberMeID;


  
 
}



/**
 * Identity Access token from merchant 
 */
class IdentityTokenInfoType  
   extends PPXmlMessage{

	/**
	 * Identity Access token from merchant
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $AccessToken;

	/**
	 * Constructor with arguments
	 */
	public function __construct($AccessToken = NULL) {
		$this->AccessToken = $AccessToken;
	}


  
 
}



/**
 * Allowable values: 0,1 The value 1 indicates that the
 * customer can accept push funding, and 0 means they cannot.
 * Optional Character length and limitations: One single-byte
 * numeric character. 
 */
class FundingSourceDetailsType  
   extends PPXmlMessage{

	/**
	 * Allowable values: 0,1 The value 1 indicates that the
	 * customer can accept push funding, and 0 means they cannot.
	 * Optional Character length and limitations: One single-byte
	 * numeric character. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $AllowPushFunding;

	/**
	 * Allowable values: ELV, CreditCard, ChinaUnionPay, BML,
	 * Finance This element could be used to specify the preferred
	 * funding option for a guest users. It has effect only if
	 * LandingPage element is set to Billing. Otherwise it will be
	 * ignored. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $UserSelectedFundingSource;


  
 
}



/**
 * 
 */
class BillingAgreementDetailsType  
   extends PPXmlMessage{

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $BillingType;

	/**
	 * Only needed for AutoBill billinng type. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $BillingAgreementDescription;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $PaymentType;

	/**
	 * Custom annotation field for your exclusive use. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $BillingAgreementCustom;

	/**
	 * Constructor with arguments
	 */
	public function __construct($BillingType = NULL) {
		$this->BillingType = $BillingType;
	}


  
 
}



/**
 * The timestamped token value that was returned by
 * SetExpressCheckoutResponse and passed on
 * GetExpressCheckoutDetailsRequest. Character length and
 * limitations: 20 single-byte characters 
 */
class GetExpressCheckoutDetailsResponseDetailsType  
   extends PPXmlMessage{

	/**
	 * The timestamped token value that was returned by
	 * SetExpressCheckoutResponse and passed on
	 * GetExpressCheckoutDetailsRequest. Character length and
	 * limitations: 20 single-byte characters
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Token;

	/**
	 * Information about the payer
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var PayerInfoType 	 
	 */ 
	public $PayerInfo;

	/**
	 * A free-form field for your own use, as set by you in the
	 * Custom element of SetExpressCheckoutRequest. Character
	 * length and limitations: 256 single-byte alphanumeric
	 * characters
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Custom;

	/**
	 * Your own invoice or tracking number, as set by you in the
	 * InvoiceID element of SetExpressCheckoutRequest. Character
	 * length and limitations: 127 single-byte alphanumeric
	 * characters
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $InvoiceID;

	/**
	 * Payer's contact telephone number. PayPal returns a contact
	 * telephone number only if your Merchant account profile
	 * settings require that the buyer enter one.
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ContactPhone;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var boolean 	 
	 */ 
	public $BillingAgreementAcceptedStatus;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $RedirectRequired;

	/**
	 * Customer's billing address. Optional If you have credit card
	 * mapped in your account then billing address of the credit
	 * card is returned otherwise your primary address is returned
	 * , PayPal returns this address in
	 * GetExpressCheckoutDetailsResponse.
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var AddressType 	 
	 */ 
	public $BillingAddress;

	/**
	 * Text note entered by the buyer in PayPal flow. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Note;

	/**
	 * Returns the status of the EC checkout session. Values
	 * include 'PaymentActionNotInitiated', 'PaymentActionFailed',
	 * 'PaymentActionInProgress', 'PaymentCompleted'. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $CheckoutStatus;

	/**
	 * PayPal may offer a discount or gift certificate to the
	 * buyer, which will be represented by a negativeamount. If the
	 * buyer has a negative balance, PayPal will add that amount to
	 * the current charges, which will be represented as a positive
	 * amount. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var BasicAmountType 	 
	 */ 
	public $PayPalAdjustment;

	/**
	 * Information about the individual purchased items. 
     * @array
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var PaymentDetailsType 	 
	 */ 
	public $PaymentDetails;

	/**
	 * Information about the user selected options. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var UserSelectedOptionType 	 
	 */ 
	public $UserSelectedOptions;

	/**
	 * Information about the incentives that were applied from Ebay
	 * RYP page and PayPal RYP page. 
     * @array
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var IncentiveDetailsType 	 
	 */ 
	public $IncentiveDetails;

	/**
	 * Information about the Gift message. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $GiftMessage;

	/**
	 * Information about the Gift receipt enable. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $GiftReceiptEnable;

	/**
	 * Information about the Gift Wrap name. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $GiftWrapName;

	/**
	 * Information about the Gift Wrap amount. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var BasicAmountType 	 
	 */ 
	public $GiftWrapAmount;

	/**
	 * Information about the Buyer marketing email. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $BuyerMarketingEmail;

	/**
	 * Information about the survey question. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $SurveyQuestion;

	/**
	 * Information about the survey choice selected by the user. 
     * @array
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $SurveyChoiceSelected;

	/**
	 * Contains payment request information about each bucket in
	 * the cart. 
     * @array
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var PaymentRequestInfoType 	 
	 */ 
	public $PaymentRequestInfo;

	/**
	 * Response information resulting from opt-in operation or
	 * current login bypass status. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var ExternalRememberMeStatusDetailsType 	 
	 */ 
	public $ExternalRememberMeStatusDetails;

	/**
	 * Response information resulting from opt-in operation or
	 * current login bypass status. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var RefreshTokenStatusDetailsType 	 
	 */ 
	public $RefreshTokenStatusDetails;

	/**
	 * Information about the transaction 
     * @array
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var PaymentInfoType 	 
	 */ 
	public $PaymentInfo;

	/**
	 * Indicate the tolerance a cart can be changed. Possible
	 * values are NONE = cart cannot be changed (since financing
	 * was used and country is DE). FLEXIBLE = cart can be changed
	 * If this parameter does not exist, then assume cart can be
	 * modified. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $CartChangeTolerance;

	/**
	 * Type of the payment instrument. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var InstrumentDetailsType 	 
	 */ 
	public $InstrumentDetails;


}



/**
 * 
 */
class ExecuteCheckoutOperationsResponseDetailsType  
   extends PPXmlMessage{

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var SetDataResponseType 	 
	 */ 
	public $SetDataResponse;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var AuthorizationResponseType 	 
	 */ 
	public $AuthorizationResponse;


}



/**
 * If Checkout session was initialized successfully, the
 * corresponding token is returned in this element. 
 */
class SetDataResponseType  
   extends PPXmlMessage{

	/**
	 * If Checkout session was initialized successfully, the
	 * corresponding token is returned in this element. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Token;

	/**
	 * 
     * @array
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var AddressType 	 
	 */ 
	public $ShippingAddresses;

	/**
	 * 
     * @array
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var ErrorType 	 
	 */ 
	public $SetDataError;


}



/**
 * Status will denote whether Auto authorization was successful
 * or not. 
 */
class AuthorizationResponseType  
   extends PPXmlMessage{

	/**
	 * Status will denote whether Auto authorization was successful
	 * or not. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Status;

	/**
	 * 
     * @array
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var ErrorType 	 
	 */ 
	public $AuthorizationError;


}



/**
 * How you want to obtain payment. Required Authorization
 * indicates that this payment is a basic authorization subject
 * to settlement with PayPal Authorization and Capture. Order
 * indicates that this payment is is an order authorization
 * subject to settlement with PayPal Authorization and Capture.
 * Sale indicates that this is a final sale for which you are
 * requesting payment. IMPORTANT: You cannot set PaymentAction
 * to Sale on SetExpressCheckoutRequest and then change
 * PaymentAction to Authorization on the final Express Checkout
 * API, DoExpressCheckoutPaymentRequest. Character length and
 * limit: Up to 13 single-byte alphabetic characters 
 */
class DoExpressCheckoutPaymentRequestDetailsType  
   extends PPXmlMessage{

	/**
	 * How you want to obtain payment. Required Authorization
	 * indicates that this payment is a basic authorization subject
	 * to settlement with PayPal Authorization and Capture. Order
	 * indicates that this payment is is an order authorization
	 * subject to settlement with PayPal Authorization and Capture.
	 * Sale indicates that this is a final sale for which you are
	 * requesting payment. IMPORTANT: You cannot set PaymentAction
	 * to Sale on SetExpressCheckoutRequest and then change
	 * PaymentAction to Authorization on the final Express Checkout
	 * API, DoExpressCheckoutPaymentRequest. Character length and
	 * limit: Up to 13 single-byte alphabetic characters
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $PaymentAction;

	/**
	 * The timestamped token value that was returned by
	 * SetExpressCheckoutResponse and passed on
	 * GetExpressCheckoutDetailsRequest. Required Character length
	 * and limitations: 20 single-byte characters
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Token;

	/**
	 * Encrypted PayPal customer account identification number as
	 * returned by GetExpressCheckoutDetailsResponse. Required
	 * Character length and limitations: 127 single-byte
	 * characters.
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $PayerID;

	/**
	 * URL on Merchant site pertaining to this invoice. Optional 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $OrderURL;

	/**
	 * Unique id for each API request to prevent duplicate payments
	 * on merchant side. Passed directly back to merchant in
	 * response. Optional Character length and limits: 38
	 * single-byte characters maximum. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $MsgSubID;

	/**
	 * Information about the payment Required 
     * @array
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var PaymentDetailsType 	 
	 */ 
	public $PaymentDetails;

	/**
	 * Flag to indicate if previously set promoCode shall be
	 * overriden. Value 1 indicates overriding.  
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $PromoOverrideFlag;

	/**
	 * Promotional financing code for item. Overrides any previous
	 * PromoCode setting. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $PromoCode;

	/**
	 * Contains data for enhanced data like Airline Itinerary Data.
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var EnhancedDataType 	 
	 */ 
	public $EnhancedData;

	/**
	 * Soft Descriptor supported for Sale and Auth in DEC only. For
	 * Order this will be ignored. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $SoftDescriptor;

	/**
	 * Information about the user selected options. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var UserSelectedOptionType 	 
	 */ 
	public $UserSelectedOptions;

	/**
	 * Information about the Gift message. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $GiftMessage;

	/**
	 * Information about the Gift receipt enable. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $GiftReceiptEnable;

	/**
	 * Information about the Gift Wrap name. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $GiftWrapName;

	/**
	 * Information about the Gift Wrap amount. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var BasicAmountType 	 
	 */ 
	public $GiftWrapAmount;

	/**
	 * Information about the Buyer marketing email. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $BuyerMarketingEmail;

	/**
	 * Information about the survey question. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $SurveyQuestion;

	/**
	 * Information about the survey choice selected by the user. 
     * @array
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $SurveyChoiceSelected;

	/**
	 * An identification code for use by third-party applications
	 * to identify transactions. Optional Character length and
	 * limitations: 32 single-byte alphanumeric characters 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ButtonSource = "PayPal_SDK";

	/**
	 * Merchant specified flag which indicates whether to create
	 * billing agreement as part of DoEC or not. Optional 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var boolean 	 
	 */ 
	public $SkipBACreation;

	/**
	 * Merchant specified flag which indicates to use payment
	 * details from session if available. Optional 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $UseSessionPaymentDetails;

	/**
	 * Optional element that defines relationship between buckets 
     * @array
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var CoupledBucketsType 	 
	 */ 
	public $CoupledBuckets;

	/**
	 * Optional element for the passing client id 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ClientID;

	/**
	 * Optional element for the passing product lines 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ProductLine;


  
 
}



/**
 * The timestamped token value that was returned by
 * SetExpressCheckoutResponse and passed on
 * GetExpressCheckoutDetailsRequest. Character length and
 * limitations:20 single-byte characters 
 */
class DoExpressCheckoutPaymentResponseDetailsType  
   extends PPXmlMessage{

	/**
	 * The timestamped token value that was returned by
	 * SetExpressCheckoutResponse and passed on
	 * GetExpressCheckoutDetailsRequest. Character length and
	 * limitations:20 single-byte characters
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Token;

	/**
	 * Information about the transaction 
     * @array
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var PaymentInfoType 	 
	 */ 
	public $PaymentInfo;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $BillingAgreementID;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $RedirectRequired;

	/**
	 * Memo entered by sender in PayPal Review Page note field.
	 * Optional Character length and limitations: 255 single-byte
	 * alphanumeric characters 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Note;

	/**
	 * Unique id passed in the DoEC call. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $MsgSubID;

	/**
	 * Redirect back to PayPal, PayPal can host the success page. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $SuccessPageRedirectRequested;

	/**
	 * Information about the user selected options. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var UserSelectedOptionType 	 
	 */ 
	public $UserSelectedOptions;

	/**
	 * Information about Coupled Payment transactions. 
     * @array
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var CoupledPaymentInfoType 	 
	 */ 
	public $CoupledPaymentInfo;


}



/**
 * The authorization identification number you specified in the
 * request. Character length and limits: 19 single-byte
 * characters maximum 
 */
class DoCaptureResponseDetailsType  
   extends PPXmlMessage{

	/**
	 * The authorization identification number you specified in the
	 * request. Character length and limits: 19 single-byte
	 * characters maximum
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $AuthorizationID;

	/**
	 * Information about the transaction 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var PaymentInfoType 	 
	 */ 
	public $PaymentInfo;

	/**
	 * Return msgsubid back to merchant 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $MsgSubID;

	/**
	 * Partner funding source id corresponding to the FS used in
	 * authorization. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $PartnerFundingSourceID;


}



/**
 * How you want to obtain payment. Required Authorization
 * indicates that this payment is a basic authorization subject
 * to settlement with PayPal Authorization and Capture. Sale
 * indicates that this is a final sale for which you are
 * requesting payment. NOTE: Order is not allowed for Direct
 * Payment. Character length and limit: Up to 13 single-byte
 * alphabetic characters 
 */
class DoDirectPaymentRequestDetailsType  
   extends PPXmlMessage{

	/**
	 * How you want to obtain payment. Required Authorization
	 * indicates that this payment is a basic authorization subject
	 * to settlement with PayPal Authorization and Capture. Sale
	 * indicates that this is a final sale for which you are
	 * requesting payment. NOTE: Order is not allowed for Direct
	 * Payment. Character length and limit: Up to 13 single-byte
	 * alphabetic characters
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $PaymentAction;

	/**
	 * Information about the payment Required 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var PaymentDetailsType 	 
	 */ 
	public $PaymentDetails;

	/**
	 * Information about the credit card to be charged. Required 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var CreditCardDetailsType 	 
	 */ 
	public $CreditCard;

	/**
	 * IP address of the payer's browser as recorded in its HTTP
	 * request to your website. PayPal records this IP addresses as
	 * a means to detect possible fraud. Required Character length
	 * and limitations: 15 single-byte characters, including
	 * periods, in dotted-quad format: ???.???.???.???
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $IPAddress;

	/**
	 * Your customer session identification token. PayPal records
	 * this optional session identification token as an additional
	 * means to detect possible fraud. Optional Character length
	 * and limitations: 64 single-byte numeric characters
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $MerchantSessionId;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var boolean 	 
	 */ 
	public $ReturnFMFDetails;

	/**
	 * Use this optional parameter to pass in your business name
	 * and other data describing the transaction. Optional This
	 * information is usually displayed in the account holder's
	 * statement. Example: RedCross Haiti, RedCross Uganda,
	 * Realtor.com dues, Realtor.com list fee Length 25 characters.
	 * Alphanumeric characters and dash(-), dot(.), asterisk(*),
	 * space( ) On the customer's statement, an asterisk is used to
	 * separate the DBA name and product name. The asterisk
	 * delimiter can appear in position 4, 8, or 13. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $SoftDescriptor;

	/**
	 * Use this optional parameter to pass information about how
	 * consumer should contact the merchant. Optional This
	 * information is usually displayed in the account holder's
	 * statement. For Ecom trx: phone, email or URL is allowed For
	 * Retail trx: only the actual city is allowed For details on
	 * allowed characters in Soft Descriptor City refer to the API
	 * documentation. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $SoftDescriptorCity;


  
 
}



/**
 * Type of the payment Required 
 */
class CreateMobilePaymentRequestDetailsType  
   extends PPXmlMessage{

	/**
	 * Type of the payment Required 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $PaymentType;

	/**
	 * How you want to obtain payment. Defaults to Sale. Optional
	 * Authorization indicates that this payment is a basic
	 * authorization subject to settlement with PayPal
	 * Authorization and Capture. Sale indicates that this is a
	 * final sale for which you are requesting payment. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $PaymentAction;

	/**
	 * Phone number of the user making the payment. Required 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var PhoneNumberType 	 
	 */ 
	public $SenderPhone;

	/**
	 * Type of recipient specified, i.e., phone number or email
	 * address Required 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $RecipientType;

	/**
	 * Email address of the recipient 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $RecipientEmail;

	/**
	 * Phone number of the recipipent Required 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var PhoneNumberType 	 
	 */ 
	public $RecipientPhone;

	/**
	 * Amount of item before tax and shipping 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var BasicAmountType 	 
	 */ 
	public $ItemAmount;

	/**
	 * The tax charged on the transactionTax Optional 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var BasicAmountType 	 
	 */ 
	public $Tax;

	/**
	 * Per-transaction shipping charge Optional 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var BasicAmountType 	 
	 */ 
	public $Shipping;

	/**
	 * Name of the item being ordered Optional Character length and
	 * limitations: 255 single-byte alphanumeric characters 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ItemName;

	/**
	 * SKU of the item being ordered Optional Character length and
	 * limitations: 255 single-byte alphanumeric characters 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ItemNumber;

	/**
	 * Memo entered by sender in PayPal Website Payments note
	 * field. Optional Character length and limitations: 255
	 * single-byte alphanumeric characters 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Note;

	/**
	 * Unique ID for the order. Required for non-P2P transactions
	 * Optional Character length and limitations: 255 single-byte
	 * alphanumeric characters 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $CustomID;

	/**
	 * Indicates whether the sender's phone number will be shared
	 * with recipient Optional 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var integer 	 
	 */ 
	public $SharePhoneNumber;

	/**
	 * Indicates whether the sender's home address will be shared
	 * with recipient Optional 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var integer 	 
	 */ 
	public $ShareHomeAddress;


  
 
}



/**
 * Phone number for status inquiry 
 */
class GetMobileStatusRequestDetailsType  
   extends PPXmlMessage{

	/**
	 * Phone number for status inquiry 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var PhoneNumberType 	 
	 */ 
	public $Phone;


  
 
}



/**
 * URL to which the customer's browser is returned after
 * choosing to login with PayPal. Required Character length and
 * limitations: no limit. 
 */
class SetAuthFlowParamRequestDetailsType  
   extends PPXmlMessage{

	/**
	 * URL to which the customer's browser is returned after
	 * choosing to login with PayPal. Required Character length and
	 * limitations: no limit. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ReturnURL;

	/**
	 * URL to which the customer is returned if he does not approve
	 * the use of PayPal login. Required Character length and
	 * limitations: no limit
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $CancelURL;

	/**
	 * URL to which the customer's browser is returned after user
	 * logs out from PayPal. Required Character length and
	 * limitations: no limit. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $LogoutURL;

	/**
	 * The type of the flow. Optional Character length and
	 * limitations: 127 single-byte alphanumeric characters
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $InitFlowType;

	/**
	 * The used to decide SkipLogin allowed or not. Optional
	 * Character length and limitations: 127 single-byte
	 * alphanumeric characters 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $SkipLoginPage;

	/**
	 * The name of the field Merchant requires from PayPal after
	 * user's login. Optional Character length and limitations: 256
	 * single-byte alphanumeric characters 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ServiceName1;

	/**
	 * Whether the field is required, opt-in or opt-out.  Optional
	 * Character length and limitations: 127 single-byte
	 * alphanumeric characters 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ServiceDefReq1;

	/**
	 * The name of the field Merchant requires from PayPal after
	 * user's login. Optional Character length and limitations: 256
	 * single-byte alphanumeric characters
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ServiceName2;

	/**
	 * Whether the field is required, opt-in or opt-out. Optional
	 * Character length and limitations: 127 single-byte
	 * alphanumeric characters
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ServiceDefReq2;

	/**
	 * Locale of pages displayed by PayPal during Authentication
	 * Login. Optional Character length and limitations: Five
	 * single-byte alphabetic characters, upper- or lowercase.
	 * Allowable values: AU or en_AUDE or de_DEFR or fr_FRGB or
	 * en_GBIT or it_ITJP or ja_JPUS or en_US
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $LocaleCode;

	/**
	 * Sets the Custom Payment Page Style for flow pages associated
	 * with this button/link. PageStyle corresponds to the HTML
	 * variable page_style for customizing flow pages. The value is
	 * the same as the Page Style Name you chose when adding or
	 * editing the page style from the Profile subtab of the My
	 * Account tab of your PayPal account. Optional Character
	 * length and limitations: 30 single-byte alphabetic
	 * characters. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $PageStyle;

	/**
	 * A URL for the image you want to appear at the top left of
	 * the flow page. The image has a maximum size of 750 pixels
	 * wide by 90 pixels high. PayPal recommends that you provide
	 * an image that is stored on a secure (https) server. Optional
	 * Character length and limitations: 127
	 * @access public
	 
	 * @namespace ebl
	 
	 
	 * @name cpp-header-image
	 	 	 	 
	 * @var string 	 
	 */ 
	public $cppheaderimage;

	/**
	 * Sets the border color around the header of the flow page.
	 * The border is a 2-pixel perimeter around the header space,
	 * which is 750 pixels wide by 90 pixels high. Optional
	 * Character length and limitations: Six character HTML
	 * hexadecimal color code in ASCII
	 * @access public
	 
	 * @namespace ebl
	 
	 
	 * @name cpp-header-border-color
	 	 	 	 
	 * @var string 	 
	 */ 
	public $cppheaderbordercolor;

	/**
	 * Sets the background color for the header of the flow page.
	 * Optional Character length and limitation: Six character HTML
	 * hexadecimal color code in ASCII
	 * @access public
	 
	 * @namespace ebl
	 
	 
	 * @name cpp-header-back-color
	 	 	 	 
	 * @var string 	 
	 */ 
	public $cppheaderbackcolor;

	/**
	 * Sets the background color for the payment page. Optional
	 * Character length and limitation: Six character HTML
	 * hexadecimal color code in ASCII
	 * @access public
	 
	 * @namespace ebl
	 
	 
	 * @name cpp-payflow-color
	 	 	 	 
	 * @var string 	 
	 */ 
	public $cpppayflowcolor;

	/**
	 * First Name of the user, this information is used if user
	 * chooses to signup with PayPal. Optional Character length and
	 * limitation: Six character HTML hexadecimal color code in
	 * ASCII
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $FirstName;

	/**
	 * Last Name of the user, this information is used if user
	 * chooses to signup with PayPal. Optional Character length and
	 * limitation: Six character HTML hexadecimal color code in
	 * ASCII
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $LastName;

	/**
	 * User address, this information is used when user chooses to
	 * signup for PayPal. Optional If you include a shipping
	 * address and set the AddressOverride element on the request,
	 * PayPal returns this same address in
	 * GetExpressCheckoutDetailsResponse. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var AddressType 	 
	 */ 
	public $Address;


  
 
}



/**
 * The first name of the User. Character length and
 * limitations: 127 single-byte alphanumeric characters 
 */
class GetAuthDetailsResponseDetailsType  
   extends PPXmlMessage{

	/**
	 * The first name of the User. Character length and
	 * limitations: 127 single-byte alphanumeric characters
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $FirstName;

	/**
	 * The Last name of the user. Character length and limitations:
	 * 127 single-byte alphanumeric characters
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $LastName;

	/**
	 * The email address of the user. Character length and
	 * limitations: 256 single-byte alphanumeric characters. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Email;

	/**
	 * Encrypted PayPal customer account identification number.
	 * Required Character length and limitations: 127 single-byte
	 * characters.
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $PayerID;


}



/**
 * URL to which the customer's browser is returned after
 * choosing to login with PayPal. Required Character length and
 * limitations: no limit. 
 */
class SetAccessPermissionsRequestDetailsType  
   extends PPXmlMessage{

	/**
	 * URL to which the customer's browser is returned after
	 * choosing to login with PayPal. Required Character length and
	 * limitations: no limit. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ReturnURL;

	/**
	 * URL to which the customer is returned if he does not approve
	 * the use of PayPal login. Required Character length and
	 * limitations: no limit 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $CancelURL;

	/**
	 * URL to which the customer's browser is returned after user
	 * logs out from PayPal. Required Character length and
	 * limitations: no limit. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $LogoutURL;

	/**
	 * The type of the flow. Optional Character length and
	 * limitations: 127 single-byte alphanumeric characters 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $InitFlowType;

	/**
	 * The used to decide SkipLogin allowed or not. Optional
	 * Character length and limitations: 127 single-byte
	 * alphanumeric characters 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $SkipLoginPage;

	/**
	 * contains information about API Services 
     * @array
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $RequiredAccessPermissions;

	/**
	 * contains information about API Services 
     * @array
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $OptionalAccessPermissions;

	/**
	 * Locale of pages displayed by PayPal during Authentication
	 * Login. Optional Character length and limitations: Five
	 * single-byte alphabetic characters, upper- or lowercase.
	 * Allowable values: AU or en_AUDE or de_DEFR or fr_FRGB or
	 * en_GBIT or it_ITJP or ja_JPUS or en_US 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $LocaleCode;

	/**
	 * Sets the Custom Payment Page Style for flow pages associated
	 * with this button/link. PageStyle corresponds to the HTML
	 * variable page_style for customizing flow pages. The value is
	 * the same as the Page Style Name you chose when adding or
	 * editing the page style from the Profile subtab of the My
	 * Account tab of your PayPal account. Optional Character
	 * length and limitations: 30 single-byte alphabetic
	 * characters. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $PageStyle;

	/**
	 * A URL for the image you want to appear at the top left of
	 * the flow page. The image has a maximum size of 750 pixels
	 * wide by 90 pixels high. PayPal recommends that you provide
	 * an image that is stored on a secure (https) server. Optional
	 * Character length and limitations: 127 
	 * @access public
	 
	 * @namespace ebl
	 
	 
	 * @name cpp-header-image
	 	 	 	 
	 * @var string 	 
	 */ 
	public $cppheaderimage;

	/**
	 * Sets the border color around the header of the flow page.
	 * The border is a 2-pixel perimeter around the header space,
	 * which is 750 pixels wide by 90 pixels high. Optional
	 * Character length and limitations: Six character HTML
	 * hexadecimal color code in ASCII 
	 * @access public
	 
	 * @namespace ebl
	 
	 
	 * @name cpp-header-border-color
	 	 	 	 
	 * @var string 	 
	 */ 
	public $cppheaderbordercolor;

	/**
	 * Sets the background color for the header of the flow page.
	 * Optional Character length and limitation: Six character HTML
	 * hexadecimal color code in ASCII 
	 * @access public
	 
	 * @namespace ebl
	 
	 
	 * @name cpp-header-back-color
	 	 	 	 
	 * @var string 	 
	 */ 
	public $cppheaderbackcolor;

	/**
	 * Sets the background color for the payment page. Optional
	 * Character length and limitation: Six character HTML
	 * hexadecimal color code in ASCII 
	 * @access public
	 
	 * @namespace ebl
	 
	 
	 * @name cpp-payflow-color
	 	 	 	 
	 * @var string 	 
	 */ 
	public $cpppayflowcolor;

	/**
	 * First Name of the user, this information is used if user
	 * chooses to signup with PayPal. Optional Character length and
	 * limitation: Six character HTML hexadecimal color code in
	 * ASCII 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $FirstName;

	/**
	 * Last Name of the user, this information is used if user
	 * chooses to signup with PayPal. Optional Character length and
	 * limitation: Six character HTML hexadecimal color code in
	 * ASCII 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $LastName;

	/**
	 * User address, this information is used when user chooses to
	 * signup for PayPal. Optional If you include a shipping
	 * address and set the AddressOverride element on the request,
	 * PayPal returns this same address in
	 * GetExpressCheckoutDetailsResponse. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var AddressType 	 
	 */ 
	public $Address;


  
 
}



/**
 * The first name of the User. Character length and
 * limitations: 127 single-byte alphanumeric characters 
 */
class GetAccessPermissionDetailsResponseDetailsType  
   extends PPXmlMessage{

	/**
	 * The first name of the User. Character length and
	 * limitations: 127 single-byte alphanumeric characters
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $FirstName;

	/**
	 * The Last name of the user. Character length and limitations:
	 * 127 single-byte alphanumeric characters 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $LastName;

	/**
	 * The email address of the user. Character length and
	 * limitations: 256 single-byte alphanumeric characters. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Email;

	/**
	 * contains information about API Services 
     * @array
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $AccessPermissionName;

	/**
	 * contains information about API Services 
     * @array
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $AccessPermissionStatus;

	/**
	 * Encrypted PayPal customer account identification number.
	 * Required Character length and limitations: 127 single-byte
	 * characters. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $PayerID;


}



/**
 * 
 */
class BAUpdateResponseDetailsType  
   extends PPXmlMessage{

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $BillingAgreementID;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $BillingAgreementDescription;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $BillingAgreementStatus;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $BillingAgreementCustom;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var PayerInfoType 	 
	 */ 
	public $PayerInfo;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var BasicAmountType 	 
	 */ 
	public $BillingAgreementMax;

	/**
	 * Customer's billing address. Optional If you have credit card
	 * mapped in your account then billing address of the credit
	 * card is returned otherwise your primary address is returned
	 * , PayPal returns this address in BAUpdateResponseDetails. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var AddressType 	 
	 */ 
	public $BillingAddress;


}



/**
 * MerchantPullPaymentResponseType Response data from the
 * merchant pull. 
 */
class MerchantPullPaymentResponseType  
   extends PPXmlMessage{

	/**
	 * information about the customer
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var PayerInfoType 	 
	 */ 
	public $PayerInfo;

	/**
	 * Information about the transaction 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var PaymentInfoType 	 
	 */ 
	public $PaymentInfo;

	/**
	 * Specific information about the preapproved payment 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var MerchantPullInfoType 	 
	 */ 
	public $MerchantPullInfo;


}



/**
 * MerchantPullInfoType Information about the merchant pull. 
 */
class MerchantPullInfoType  
   extends PPXmlMessage{

	/**
	 * Current status of billing agreement 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $MpStatus;

	/**
	 * Monthly maximum payment amount
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var BasicAmountType 	 
	 */ 
	public $MpMax;

	/**
	 * The value of the mp_custom variable that you specified in a
	 * FORM submission to PayPal during the creation or updating of
	 * a customer billing agreement 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $MpCustom;

	/**
	 * The value of the mp_desc variable (description of goods or
	 * services) associated with the billing agreement 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Desc;

	/**
	 * Invoice value as set by BillUserRequest API call 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Invoice;

	/**
	 * Custom field as set by BillUserRequest API call 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Custom;

	/**
	 * Note: This field is no longer used and is always empty.
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $PaymentSourceID;


}



/**
 * PaymentTransactionSearchResultType Results from a
 * PaymentTransaction search 
 */
class PaymentTransactionSearchResultType  
   extends PPXmlMessage{

	/**
	 * The date and time (in UTC/GMT format) the transaction
	 * occurred
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var dateTime 	 
	 */ 
	public $Timestamp;

	/**
	 * The time zone of the transaction 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Timezone;

	/**
	 * The type of the transaction
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Type;

	/**
	 * The email address of the payer
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Payer;

	/**
	 * Display name of the payer
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $PayerDisplayName;

	/**
	 * The transaction ID of the seller
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $TransactionID;

	/**
	 * The status of the transaction
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Status;

	/**
	 * The total gross amount charged, including any profile
	 * shipping cost and taxes
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var BasicAmountType 	 
	 */ 
	public $GrossAmount;

	/**
	 * The fee that PayPal charged for the transaction 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var BasicAmountType 	 
	 */ 
	public $FeeAmount;

	/**
	 * The net amount of the transaction 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var BasicAmountType 	 
	 */ 
	public $NetAmount;


}



/**
 * MerchantPullPayment Parameters to make initiate a pull
 * payment 
 */
class MerchantPullPaymentType  
   extends PPXmlMessage{

	/**
	 * The amount to charge to the customer. Required Only numeric
	 * characters and a decimal separator are allowed. Limit: 10
	 * single-byte characters, including two for decimals You must
	 * set the currencyID attribute to one of the three-character
	 * currency code for any of the supported PayPal currencies. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var BasicAmountType 	 
	 */ 
	public $Amount;

	/**
	 * Preapproved Payments billing agreement identification number
	 * between the PayPal customer and you. Required Character
	 * limit: 19 single-byte alphanumeric characters. The format of
	 * a billing agreement identification number is the
	 * single-character prefix B, followed by a hyphen and an
	 * alphanumeric character string: B-unique_alphanumeric_string
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $MpID;

	/**
	 * Specifies type of PayPal payment you require Optional
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $PaymentType;

	/**
	 * Text entered by the customer in the Note field during
	 * enrollment Optional
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Memo;

	/**
	 * Subject line of confirmation email sent to recipient
	 * Optional
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $EmailSubject;

	/**
	 * The tax charged on the transaction Optional
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var BasicAmountType 	 
	 */ 
	public $Tax;

	/**
	 * Per-transaction shipping charge Optional
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var BasicAmountType 	 
	 */ 
	public $Shipping;

	/**
	 * Per-transaction handling charge Optional
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var BasicAmountType 	 
	 */ 
	public $Handling;

	/**
	 * Name of purchased item Optional
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ItemName;

	/**
	 * Reference number of purchased item Optional
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ItemNumber;

	/**
	 * Your invoice number Optional
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Invoice;

	/**
	 * Custom annotation field for tracking or other use Optional
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Custom;

	/**
	 * An identification code for use by third-party applications
	 * to identify transactions. Optional Character length and
	 * limitations: 32 single-byte alphanumeric characters
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ButtonSource = "PayPal_SDK";

	/**
	 * Passed in soft descriptor string to be appended. Optional
	 * Character length and limitations: single-byte alphanumeric
	 * characters
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $SoftDescriptor;


  
 
}



/**
 * PaymentTransactionType Information about a PayPal payment
 * from the seller side 
 */
class PaymentTransactionType  
   extends PPXmlMessage{

	/**
	 * Information about the recipient of the payment 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var ReceiverInfoType 	 
	 */ 
	public $ReceiverInfo;

	/**
	 * Information about the payer 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var PayerInfoType 	 
	 */ 
	public $PayerInfo;

	/**
	 * This field is for holding ReferenceId for shippment sent
	 * from Merchant to the 3rd Party  
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $TPLReferenceID;

	/**
	 * Information about the transaction 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var PaymentInfoType 	 
	 */ 
	public $PaymentInfo;

	/**
	 * Information about an individual item in the transaction
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var PaymentItemInfoType 	 
	 */ 
	public $PaymentItemInfo;

	/**
	 * Information about an individual Offer and Coupon information
	 * in the transaction
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var OfferCouponInfoType 	 
	 */ 
	public $OfferCouponInfo;

	/**
	 * Information about Secondary Address
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var AddressType 	 
	 */ 
	public $SecondaryAddress;

	/**
	 * Information about the user selected options.  
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var UserSelectedOptionType 	 
	 */ 
	public $UserSelectedOptions;

	/**
	 * Information about the Gift message.  
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $GiftMessage;

	/**
	 * Information about the Gift receipt.  
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $GiftReceipt;

	/**
	 * Information about the Gift Wrap name.  
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $GiftWrapName;

	/**
	 * Information about the Gift Wrap amount.  
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var BasicAmountType 	 
	 */ 
	public $GiftWrapAmount;

	/**
	 * Information about the Buyer email.  
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $BuyerEmailOptIn;

	/**
	 * Information about the survey question.  
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $SurveyQuestion;

	/**
	 * Information about the survey choice selected by the user.  
     * @array
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $SurveyChoiceSelected;


}



/**
 * ReceiverInfoType Receiver information. 
 */
class ReceiverInfoType  
   extends PPXmlMessage{

	/**
	 * Email address or account ID of the payment recipient (the
	 * seller). Equivalent to Receiver if payment is sent to
	 * primary account. Character length and limitations: 127
	 * single-byte alphanumeric characters
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Business;

	/**
	 * Primary email address of the payment recipient (the seller).
	 * If you are the recipient of the payment and the payment is
	 * sent to your non-primary email address, the value of
	 * Receiver is still your primary email address. Character
	 * length and limitations: 127 single-byte alphanumeric
	 * characters
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Receiver;

	/**
	 * Unique account ID of the payment recipient (the seller).
	 * This value is the same as the value of the recipient's
	 * referral ID. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ReceiverID;


}



/**
 * PayerInfoType Payer information 
 */
class PayerInfoType  
   extends PPXmlMessage{

	/**
	 * Email address of payer Character length and limitations: 127
	 * single-byte characters
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Payer;

	/**
	 * Unique customer ID Character length and limitations: 17
	 * single-byte characters
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $PayerID;

	/**
	 * Status of payer's email address 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $PayerStatus;

	/**
	 * Name of payer 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var PersonNameType 	 
	 */ 
	public $PayerName;

	/**
	 * Payment sender's country of residence using standard
	 * two-character ISO 3166 country codes. Character length and
	 * limitations: Two single-byte characters
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $PayerCountry;

	/**
	 * Payer's business name. Character length and limitations: 127
	 * single-byte characters
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $PayerBusiness;

	/**
	 * Payer's business address
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var AddressType 	 
	 */ 
	public $Address;

	/**
	 * Business contact telephone number
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ContactPhone;

	/**
	 * Items such as merchant coupons, loyalty cards, and
	 * manufacturer coupons in the PayPal wallet.
     * @array
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var WalletItemsType 	 
	 */ 
	public $WalletItems;

	/**
	 * Details about payer's tax info. Refer to the
	 * TaxIdDetailsType for more details. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var TaxIdDetailsType 	 
	 */ 
	public $TaxIdDetails;

	/**
	 * Holds any enhanced information about the payer
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var EnhancedPayerInfoType 	 
	 */ 
	public $EnhancedPayerInfo;


  
 
}



/**
 * InstrumentDetailsType Promotional Instrument Information. 
 */
class InstrumentDetailsType  
   extends PPXmlMessage{

	/**
	 * This field holds the category of the instrument only when it
	 * is promotional. Return value 1 represents BML, 2 reprasents
	 * PLCC/Cobranded. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $InstrumentCategory;

	/**
	 * This field holds the InstrumentID issued by external party
	 * corresponding to the funding source used in payment. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $InstrumentID;


}



/**
 * BMLOfferInfoType Specific information for BML. 
 */
class BMLOfferInfoType  
   extends PPXmlMessage{

	/**
	 * Unique identification for merchant/buyer/offer combo. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $OfferTrackingID;


  
 
}



/**
 * OfferDetailsType Specific information for an offer. 
 */
class OfferDetailsType  
   extends PPXmlMessage{

	/**
	 * Code used to identify the promotion offer. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $OfferCode;

	/**
	 * Specific infromation for BML, Similar structure could be
	 * added for sepcific  promotion needs like CrossPromotions 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var BMLOfferInfoType 	 
	 */ 
	public $BMLOfferInfo;


  
 
}



/**
 * PaymentInfoType Payment information. 
 */
class PaymentInfoType  
   extends PPXmlMessage{

	/**
	 * A transaction identification number. Character length and
	 * limits: 19 single-byte characters maximum
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $TransactionID;

	/**
	 * Its Ebay transaction id. EbayTransactionID will returned for
	 * immediate pay item transaction in ECA 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $EbayTransactionID;

	/**
	 * Parent or related transaction identification number. This
	 * field is populated for the following transaction types:
	 * ReversalCapture of an authorized transaction.Reauthorization
	 * of a transaction.Capture of an order. The value of
	 * ParentTransactionID is the original OrderID.Authorization of
	 * an order. The value of ParentTransactionID is the original
	 * OrderID.Capture of an order authorization.Void of an order.
	 * The value of ParentTransactionID is the original OrderID.
	 * Character length and limits: 19 single-byte characters
	 * maximum
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ParentTransactionID;

	/**
	 * Receipt ID Character length and limitations: 16 digits in
	 * xxxx-xxxx-xxxx-xxxx format
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ReceiptID;

	/**
	 * The type of transaction cart: Transaction created via the
	 * PayPal Shopping Cart feature or by Express Checkout with
	 * multiple purchased item express-checkout: Transaction
	 * created by Express Checkout with a single purchased items
	 * send-money: Transaction created by customer from the Send
	 * Money tab on the PayPal website. web-accept: Transaction
	 * created by customer via Buy Now, Donation, or Auction Smart
	 * Logos. subscr-*: Transaction created by customer via
	 * Subscription. eot means "end of subscription term."
	 * merch-pmt: preapproved payment. mass-pay: Transaction
	 * created via MassPay. virtual-terminal: Transaction created
	 * via merchant virtual terminal. credit: Transaction created
	 * via merchant virtual terminal or API to credit a customer.
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $TransactionType;

	/**
	 * The type of payment
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $PaymentType;

	/**
	 * The type of funding source
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $RefundSourceCodeType;

	/**
	 * eCheck latest expected clear date 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var dateTime 	 
	 */ 
	public $ExpectedeCheckClearDate;

	/**
	 * Date and time of payment 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var dateTime 	 
	 */ 
	public $PaymentDate;

	/**
	 * Full amount of the customer's payment, before transaction
	 * fee is subtracted
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var BasicAmountType 	 
	 */ 
	public $GrossAmount;

	/**
	 * Transaction fee associated with the payment 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var BasicAmountType 	 
	 */ 
	public $FeeAmount;

	/**
	 * Transaction financing fee associated with the payment. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var BasicAmountType 	 
	 */ 
	public $FinancingFeeAmount;

	/**
	 * Total overall cost associated with this financing
	 * transaction. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var BasicAmountType 	 
	 */ 
	public $FinancingTotalCost;

	/**
	 * Monthly payment for this financing transaction. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var BasicAmountType 	 
	 */ 
	public $FinancingMonthlyPayment;

	/**
	 * The length of this financing term, in months. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $FinancingTerm;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $IsFinancing;

	/**
	 * Amount deposited into the account's primary balance after a
	 * currency conversion from automatic conversion through your
	 * Payment Receiving Preferences or manual conversion through
	 * manually accepting a payment. This amount is calculated
	 * after fees and taxes have been assessed. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var BasicAmountType 	 
	 */ 
	public $SettleAmount;

	/**
	 * Amount of tax for transaction 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var BasicAmountType 	 
	 */ 
	public $TaxAmount;

	/**
	 * Exchange rate for transaction 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ExchangeRate;

	/**
	 * The status of the payment: None: No status Created: A
	 * giropay payment has been initiated. Canceled-Reversal: A
	 * reversal has been canceled. For example, you won a dispute
	 * with the customer, and the funds for the transaction that
	 * was reversed have been returned to you. Completed: The
	 * payment has been completed, and the funds have been added
	 * successfully to your account balance. Denied: You denied the
	 * payment. This happens only if the payment was previously
	 * pending because of possible reasons described for the
	 * PendingReason element. Expired: This authorization has
	 * expired and cannot be captured. Failed: The payment has
	 * failed. This happens only if the payment was made from your
	 * customer's bank account. In-Progress: The transaction is in
	 * process of authorization and capture. Partially-Refunded:
	 * The transaction has been partially refunded. Pending: The
	 * payment is pending. See "PendingReason" for more
	 * information. Refunded: You refunded the payment. Reversed: A
	 * payment was reversed due to a chargeback or other type of
	 * reversal. The funds have been removed from your account
	 * balance and returned to the buyer. The reason for the
	 * reversal is specified in the ReasonCode element. Processed:
	 * A payment has been accepted. Voided: This authorization has
	 * been voided. Completed-Funds-Held: The payment has been
	 * completed, and the funds have been added successfully to
	 * your pending balance. See the "HoldDecision" field for more
	 * information.
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $PaymentStatus;

	/**
	 * The reason the payment is pending: none: No pending reason
	 * address: The payment is pending because your customer did
	 * not include a confirmed shipping address and your Payment
	 * Receiving Preferences is set such that you want to manually
	 * accept or deny each of these payments. To change your
	 * preference, go to the Preferences section of your Profile.
	 * authorization: You set PaymentAction to Authorization on
	 * SetExpressCheckoutRequest and have not yet captured funds.
	 * echeck: The payment is pending because it was made by an
	 * eCheck that has not yet cleared. intl: The payment is
	 * pending because you hold a non-U.S. account and do not have
	 * a withdrawal mechanism. You must manually accept or deny
	 * this payment from your Account Overview. multi-currency: You
	 * do not have a balance in the currency sent, and you do not
	 * have your Payment Receiving Preferences set to automatically
	 * convert and accept this payment. You must manually accept or
	 * deny this payment. unilateral: The payment is pending
	 * because it was made to an email address that is not yet
	 * registered or confirmed. upgrade: The payment is pending
	 * because it was made via credit card and you must upgrade
	 * your account to Business or Premier status in order to
	 * receive the funds. upgrade can also mean that you have
	 * reached the monthly limit for transactions on your account.
	 * verify: The payment is pending because you are not yet
	 * verified. You must verify your account before you can accept
	 * this payment. regulatory-review: This payment is pending
	 * while we make sure it meets regulatory requirements. We'll
	 * contact you again in 24-72 hours with the outcome of our
	 * review. other: The payment is pending for a reason other
	 * than those listed above. For more information, contact
	 * PayPal Customer Service.
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $PendingReason;

	/**
	 * The reason for a reversal if TransactionType is reversal:
	 * none: No reason code chargeback: A reversal has occurred on
	 * this transaction due to a chargeback by your customer.
	 * guarantee: A reversal has occurred on this transaction due
	 * to your customer triggering a money-back guarantee.
	 * buyer-complaint: A reversal has occurred on this transaction
	 * due to a complaint about the transaction from your customer.
	 * refund: A reversal has occurred on this transaction because
	 * you have given the customer a refund. other: A reversal has
	 * occurred on this transaction due to a reason not listed
	 * above.
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ReasonCode;

	/**
	 * HoldDecision is returned in the response only if
	 * PaymentStatus is Completed-Funds-Held. The reason the funds
	 * are kept in pending balance: newsellerpaymenthold: The
	 * seller is new. paymenthold: A hold is placed on your
	 * transaction due to a reason not listed above. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $HoldDecision;

	/**
	 * Shipping method selected by the user during check-out. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ShippingMethod;

	/**
	 * Protection Eligibility for this Transaction - None, SPP or
	 * ESPP 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ProtectionEligibility;

	/**
	 * Protection Eligibility details for this Transaction 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ProtectionEligibilityType;

	/**
	 * Receipt Reference Number for this Transaction 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ReceiptReferenceNumber;

	/**
	 * The type of POS transaction F: Forced post transaction. POS
	 * merchant can send transactions at a later point if
	 * connectivity is lost. S: Single call checkout, and this is
	 * to identify PayPal Lite API usage. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $POSTransactionType;

	/**
	 * Amount of shipping charged on transaction
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ShipAmount;

	/**
	 * Amount of ship handling charged on transaction
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ShipHandleAmount;

	/**
	 * Amount of shipping discount on transaction
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ShipDiscount;

	/**
	 * Amount of Insurance amount on transaction
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $InsuranceAmount;

	/**
	 * Subject as entered in the transaction
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Subject;

	/**
	 * StoreID as entered in the transaction
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $StoreID;

	/**
	 * TerminalID as entered in the transaction
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $TerminalID;

	/**
	 * Details about the seller. Optional 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var SellerDetailsType 	 
	 */ 
	public $SellerDetails;

	/**
	 * Unique identifier and mandatory for each bucket in case of
	 * split payement 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $PaymentRequestID;

	/**
	 * Thes are filters that could result in accept/deny/pending
	 * action. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var FMFDetailsType 	 
	 */ 
	public $FMFDetails;

	/**
	 * This will be enhanced info for the payment: Example: UATP
	 * details 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var EnhancedPaymentInfoType 	 
	 */ 
	public $EnhancedPaymentInfo;

	/**
	 * This will indicate the payment status for individual payment
	 * request in case of split payment 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var ErrorType 	 
	 */ 
	public $PaymentError;

	/**
	 * Type of the payment instrument. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var InstrumentDetailsType 	 
	 */ 
	public $InstrumentDetails;

	/**
	 * Offer Details. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var OfferDetailsType 	 
	 */ 
	public $OfferDetails;

	/**
	 * This field indicates whether the credit card number used for
	 * this transaction is in a particular bin range registered
	 * with PayPal by the merchant. This filed is optional and will
	 * be present if merchant has a registered bin range. The value
	 * of this field will be "true" if merchant has a registered
	 * bin range and the credit card used in the transaction is
	 * within the registered bin range. The value of this field
	 * will be false if merchant has a registered bin range and
	 * credit card used in the transaction outside registered bin
	 * range or the transaction is not done using a credit card. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $BinEligibility;

	/**
	 * This information holds business name and other data
	 * describing the transaction. This information is usually
	 * displayed in the CC account holder's statement. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $SoftDescriptor;

	/**
	 * CC Information about how consumer should contact the
	 * merchant. This information is usually displayed in the CC
	 * account holder's statement. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $SoftDescriptorCity;


}



/**
 * @hasAttribute
 * SubscriptionTermsType Terms of a PayPal subscription. 
 */
class SubscriptionTermsType  
   extends PPXmlMessage{

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var BasicAmountType 	 
	 */ 
	public $Amount;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 
	 * @attribute 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $period;


}



/**
 * @hasAttribute
 * SubscriptionInfoType Information about a PayPal
 * Subscription. 
 */
class SubscriptionInfoType  
   extends PPXmlMessage{

	/**
	 * ID generated by PayPal for the subscriber. Character length
	 * and limitations: no limit
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $SubscriptionID;

	/**
	 * Subscription start date 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var dateTime 	 
	 */ 
	public $SubscriptionDate;

	/**
	 * Date when the subscription modification will be effective 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var dateTime 	 
	 */ 
	public $EffectiveDate;

	/**
	 * Date PayPal will retry a failed subscription payment 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var dateTime 	 
	 */ 
	public $RetryTime;

	/**
	 * Username generated by PayPal and given to subscriber to
	 * access the subscription. Character length and limitations:
	 * 64 alphanumeric single-byte characters
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Username;

	/**
	 * Password generated by PayPal and given to subscriber to
	 * access the subscription. For security, the value of the
	 * password is hashed. Character length and limitations: 128
	 * alphanumeric single-byte characters
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Password;

	/**
	 * The number of payment installments that will occur at the
	 * regular rate. Character length and limitations: no limit
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Recurrences;

	/**
	 * Subscription duration and charges
     * @array
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var SubscriptionTermsType 	 
	 */ 
	public $Terms;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 
	 * @attribute 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $reattempt;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 
	 * @attribute 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $recurring;


}



/**
 * @hasAttribute
 * AuctionInfoType Basic information about an auction. 
 */
class AuctionInfoType  
   extends PPXmlMessage{

	/**
	 * Customer's auction ID 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $BuyerID;

	/**
	 * Auction's close date 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var dateTime 	 
	 */ 
	public $ClosingDate;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 
	 * @attribute 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $multiItem;


}



/**
 * @hasAttribute
 * OptionType PayPal item options for shopping cart. 
 */
class OptionType  
   extends PPXmlMessage{

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 
	 * @attribute 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $name;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 
	 * @attribute 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $value;


}



/**
 * EbayItemPaymentDetailsItemType - Type declaration to be used
 * by other schemas. Information about an Ebay Payment Item. 
 */
class EbayItemPaymentDetailsItemType  
   extends PPXmlMessage{

	/**
	 * Auction ItemNumber. Optional Character length and
	 * limitations: 765 single-byte characters
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ItemNumber;

	/**
	 * Auction Transaction ID. Optional Character length and
	 * limitations: 255 single-byte characters
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $AuctionTransactionId;

	/**
	 * Ebay Order ID. Optional Character length and limitations: 64
	 * single-byte characters
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $OrderId;

	/**
	 * Ebay Cart ID. Optional Character length and limitations: 64
	 * single-byte characters 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $CartID;


  
 
}



/**
 * PaymentDetailsItemType Information about a Payment Item. 
 */
class PaymentDetailsItemType  
   extends PPXmlMessage{

	/**
	 * Item name. Optional Character length and limitations: 127
	 * single-byte characters
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Name;

	/**
	 * Item number. Optional Character length and limitations: 127
	 * single-byte characters
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Number;

	/**
	 * Item quantity. Optional Character length and limitations:
	 * Any positive integer
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var integer 	 
	 */ 
	public $Quantity;

	/**
	 * Item sales tax. Optional Character length and limitations:
	 * any valid currency amount; currency code is set the same as
	 * for OrderTotal.
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var BasicAmountType 	 
	 */ 
	public $Tax;

	/**
	 * Cost of item You must set the currencyID attribute to one of
	 * the three-character currency codes for any of the supported
	 * PayPal currencies. Optional Limitations: Must not exceed
	 * $10,000 USD in any currency. No currency symbol. Decimal
	 * separator must be a period (.), and the thousands separator
	 * must be a comma (,).
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var BasicAmountType 	 
	 */ 
	public $Amount;

	/**
	 * Ebay specific details. Optional 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var EbayItemPaymentDetailsItemType 	 
	 */ 
	public $EbayItemPaymentDetailsItem;

	/**
	 * Promotional financing code for item. Part of the Merchant
	 * Services Promotion Financing feature. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $PromoCode;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ProductCategory;

	/**
	 * Item description. Optional Character length and limitations:
	 * 127 single-byte characters 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Description;

	/**
	 * Information about the Item weight. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var MeasureType 	 
	 */ 
	public $ItemWeight;

	/**
	 * Information about the Item length. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var MeasureType 	 
	 */ 
	public $ItemLength;

	/**
	 * Information about the Item width. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var MeasureType 	 
	 */ 
	public $ItemWidth;

	/**
	 * Information about the Item height. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var MeasureType 	 
	 */ 
	public $ItemHeight;

	/**
	 * URL for the item. Optional Character length and limitations:
	 * no limit. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ItemURL;

	/**
	 * Enhanced data for each item in the cart. Optional 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var EnhancedItemDataType 	 
	 */ 
	public $EnhancedItemData;

	/**
	 * Item category - physical or digital. Optional 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ItemCategory;


  
 
}



/**
 * PaymentItemType Information about a Payment Item. 
 */
class PaymentItemType  
   extends PPXmlMessage{

	/**
	 * eBay Auction Transaction ID of the Item Optional Character
	 * length and limitations: 255 single-byte characters 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $EbayItemTxnId;

	/**
	 * Item name set by you or entered by the customer. Character
	 * length and limitations: 127 single-byte alphanumeric
	 * characters
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Name;

	/**
	 * Item number set by you. Character length and limitations:
	 * 127 single-byte alphanumeric characters
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Number;

	/**
	 * Quantity set by you or entered by the customer. Character
	 * length and limitations: no limit
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Quantity;

	/**
	 * Amount of tax charged on payment 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $SalesTax;

	/**
	 * Amount of shipping charged on payment 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ShippingAmount;

	/**
	 * Amount of handling charged on payment 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $HandlingAmount;

	/**
	 * Invoice item details 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var InvoiceItemType 	 
	 */ 
	public $InvoiceItemDetails;

	/**
	 * Coupon ID Number 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $CouponID;

	/**
	 * Amount Value of The Coupon 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $CouponAmount;

	/**
	 * Currency of the Coupon Amount 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $CouponAmountCurrency;

	/**
	 * Amount of Discount on this Loyalty Card
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $LoyaltyCardDiscountAmount;

	/**
	 * Currency of the Discount
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $LoyaltyCardDiscountCurrency;

	/**
	 * Cost of item 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var BasicAmountType 	 
	 */ 
	public $Amount;

	/**
	 * Item options selected in PayPal shopping cart 
     * @array
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var OptionType 	 
	 */ 
	public $Options;


}



/**
 * PaymentItemInfoType Information about a PayPal item. 
 */
class PaymentItemInfoType  
   extends PPXmlMessage{

	/**
	 * Invoice number you set in the original transaction.
	 * Character length and limitations: 127 single-byte
	 * alphanumeric characters 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $InvoiceID;

	/**
	 * Custom field you set in the original transaction. Character
	 * length and limitations: 127 single-byte alphanumeric
	 * characters
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Custom;

	/**
	 * Memo entered by your customer in PayPal Website Payments
	 * note field. Character length and limitations: 255
	 * single-byte alphanumeric characters
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Memo;

	/**
	 * Amount of tax charged on transaction
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $SalesTax;

	/**
	 * Details about the indivudal purchased item
     * @array
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var PaymentItemType 	 
	 */ 
	public $PaymentItem;

	/**
	 * Information about the transaction if it was created via
	 * PayPal Subcriptions
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var SubscriptionInfoType 	 
	 */ 
	public $Subscription;

	/**
	 * Information about the transaction if it was created via an
	 * auction
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var AuctionInfoType 	 
	 */ 
	public $Auction;


}



/**
 * OffersAndCouponsInfoType Information about a Offers and
 * Coupons. 
 */
class OfferCouponInfoType  
   extends PPXmlMessage{

	/**
	 * Type of the incentive 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Type;

	/**
	 * ID of the Incentive used in transaction
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ID;

	/**
	 * Amount used on transaction
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Amount;

	/**
	 * Amount Currency
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $AmountCurrency;


}



/**
 * PaymentDetailsType Information about a payment. Used by DCC
 * and Express Checkout. 
 */
class PaymentDetailsType  
   extends PPXmlMessage{

	/**
	 * Total of order, including shipping, handling, and tax. You
	 * must set the currencyID attribute to one of the
	 * three-character currency codes for any of the supported
	 * PayPal currencies. Limitations: Must not exceed $10,000 USD
	 * in any currency. No currency symbol. Decimal separator must
	 * be a period (.), and the thousands separator must be a comma
	 * (,). 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var BasicAmountType 	 
	 */ 
	public $OrderTotal;

	/**
	 * Sum of cost of all items in this order. You must set the
	 * currencyID attribute to one of the three-character currency
	 * codes for any of the supported PayPal currencies. Optional
	 * separator must be a comma (,).
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var BasicAmountType 	 
	 */ 
	public $ItemTotal;

	/**
	 * Total shipping costs for this order. You must set the
	 * currencyID attribute to one of the three-character currency
	 * codes for any of the supported PayPal currencies. Optional
	 * Limitations: Must not exceed $10,000 USD in any currency. No
	 * currency symbol. Decimal separator must be a period (.), and
	 * the thousands separator must be a comma (,).
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var BasicAmountType 	 
	 */ 
	public $ShippingTotal;

	/**
	 * Total handling costs for this order. You must set the
	 * currencyID attribute to one of the three-character currency
	 * codes for any of the supported PayPal currencies. Optional
	 * Limitations: Must not exceed $10,000 USD in any currency. No
	 * currency symbol. Decimal separator must be a period (.), and
	 * the thousands separator must be a comma (,).
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var BasicAmountType 	 
	 */ 
	public $HandlingTotal;

	/**
	 * Sum of tax for all items in this order. You must set the
	 * currencyID attribute to one of the three-character currency
	 * codes for any of the supported PayPal currencies. Optional
	 * Limitations: Must not exceed $10,000 USD in any currency. No
	 * currency symbol. Decimal separator must be a period (.), and
	 * the thousands separator must be a comma (,).
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var BasicAmountType 	 
	 */ 
	public $TaxTotal;

	/**
	 * Description of items the customer is purchasing. Optional
	 * Character length and limitations: 127 single-byte
	 * alphanumeric characters
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $OrderDescription;

	/**
	 * A free-form field for your own use. Optional Character
	 * length and limitations: 256 single-byte alphanumeric
	 * characters
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Custom;

	/**
	 * Your own invoice or tracking number. Optional Character
	 * length and limitations: 127 single-byte alphanumeric
	 * characters
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $InvoiceID;

	/**
	 * An identification code for use by third-party applications
	 * to identify transactions. Optional Character length and
	 * limitations: 32 single-byte alphanumeric characters
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ButtonSource = "PayPal_SDK";

	/**
	 * Your URL for receiving Instant Payment Notification (IPN)
	 * about this transaction. Optional If you do not specify
	 * NotifyURL in the request, the notification URL from your
	 * Merchant Profile is used, if one exists. Character length
	 * and limitations: 2,048 single-byte alphanumeric characters
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $NotifyURL;

	/**
	 * Address the order will be shipped to. Optional If you
	 * include the ShipToAddress element, the AddressType elements
	 * are required: Name Street1 CityName CountryCode Do not set
	 * set the CountryName element. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var AddressType 	 
	 */ 
	public $ShipToAddress;

	/**
	 * The value 1 indicates that this payment is associated with
	 * multiple shipping addresses. Optional Character length and
	 * limitations: Four single-byte numeric characters. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $MultiShipping;

	/**
	 * Thirdparty Fulfillment Reference Number. Optional Character
	 * length and limitations: 32 alphanumeric characters. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $FulfillmentReferenceNumber;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var AddressType 	 
	 */ 
	public $FulfillmentAddress;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $PaymentCategoryType;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $LocationType;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ShippingMethod;

	/**
	 * Date and time (in GMT in the format yyyy-MM-ddTHH:mm:ssZ) at
	 * which address was changed by the user. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var dateTime 	 
	 */ 
	public $ProfileAddressChangeDate;

	/**
	 * Information about the individual purchased items
     * @array
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var PaymentDetailsItemType 	 
	 */ 
	public $PaymentDetailsItem;

	/**
	 * Total shipping insurance costs for this order. Optional 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var BasicAmountType 	 
	 */ 
	public $InsuranceTotal;

	/**
	 * Shipping discount for this order, specified as a negative
	 * number. Optional 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var BasicAmountType 	 
	 */ 
	public $ShippingDiscount;

	/**
	 * Information about the Insurance options. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $InsuranceOptionOffered;

	/**
	 * Allowed payment methods for this transaction. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $AllowedPaymentMethod;

	/**
	 * Enhanced Data section to accept channel specific data.
	 * Optional Refer to EnhancedPaymentDataType for details. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var EnhancedPaymentDataType 	 
	 */ 
	public $EnhancedPaymentData;

	/**
	 * Details about the seller. Optional 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var SellerDetailsType 	 
	 */ 
	public $SellerDetails;

	/**
	 * Note to recipient/seller. Optional Character length and
	 * limitations: 127 single-byte alphanumeric characters. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $NoteText;

	/**
	 * PayPal Transaction Id, returned once DoExpressCheckout is
	 * completed. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $TransactionId;

	/**
	 * How you want to obtain payment. This payment action input
	 * will be used for split payments Authorization indicates that
	 * this payment is a basic authorization subject to settlement
	 * with PayPal Authorization and Capture. Order indicates that
	 * this payment is is an order authorization subject to
	 * settlement with PayPal Authorization and Capture. Sale
	 * indicates that this is a final sale for which you are
	 * requesting payment. IMPORTANT: You cannot set PaymentAction
	 * to Sale on SetExpressCheckoutRequest and then change
	 * PaymentAction to Authorization on the final Express Checkout
	 * API, DoExpressCheckoutPaymentRequest. Character length and
	 * limit: Up to 13 single-byte alphabetic characters 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $PaymentAction;

	/**
	 * Unique identifier and mandatory for the particular payment
	 * request in case of multiple payment 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $PaymentRequestID;

	/**
	 * URL on Merchant site pertaining to this invoice. Optional 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $OrderURL;

	/**
	 * Soft Descriptor supported for Sale and Auth in DEC only. For
	 * Order this will be ignored. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $SoftDescriptor;

	/**
	 * BranchLevel is used to identify chain payment. If
	 * BranchLevel is 0 or 1, this payment is where money moves to.
	 * If BranchLevel greater than 1, this payment contains the
	 * actual seller info. Optional 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var integer 	 
	 */ 
	public $BranchLevel;

	/**
	 * Soft Descriptor supported for Sale and Auth in DEC only. For
	 * Order this will be ignored. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var OfferDetailsType 	 
	 */ 
	public $OfferDetails;

	/**
	 * Flag to indicate the recurring transaction 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Recurring;

	/**
	 * Indicates the purpose of this payment like Refund 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $PaymentReason;

	/**
	 * Location ID Specified by merchant Optional Character length
	 * and limitations: 50 single-byte alphanumeric characters 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $LocationID;

	/**
	 * For instance single use coupons should not be returned in
	 * future CheckIn calls once they are redeemed. 
     * @array
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var DiscountInfoType 	 
	 */ 
	public $RedeemedOffers;

	/**
	 * Total loyalty points for a given id accumulated by the
	 * consumre so far. 
     * @array
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var DiscountInfoType 	 
	 */ 
	public $CummulativePoints;

	/**
	 * Merchant Data that is passed through from Merchant to
	 * Processor 
     * @array
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var MerchantDataType 	 
	 */ 
	public $MerchantData;


  
 
}



/**
 * Information about the incentives that were applied from Ebay
 * RYP page and PayPal RYP page. 
 */
class IncentiveDetailsType  
   extends PPXmlMessage{

	/**
	 * Unique Identifier consisting of redemption code, user
	 * friendly descripotion, incentive type, campaign code,
	 * incenitve application order and site redeemed on. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $UniqueIdentifier;

	/**
	 * Defines if the incentive has been applied on Ebay or PayPal.
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $SiteAppliedOn;

	/**
	 * The total discount amount for the incentive, summation of
	 * discounts up across all the buckets/items. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var BasicAmountType 	 
	 */ 
	public $TotalDiscountAmount;

	/**
	 * Status of incentive processing. Sussess or Error. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Status;

	/**
	 * Error code if there are any errors. Zero otherwise. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var integer 	 
	 */ 
	public $ErrorCode;

	/**
	 * Details of incentive application on individual bucket/item. 
     * @array
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var IncentiveAppliedDetailsType 	 
	 */ 
	public $IncentiveAppliedDetails;


}



/**
 * Details of incentive application on individual bucket/item. 
 */
class IncentiveAppliedDetailsType  
   extends PPXmlMessage{

	/**
	 * PaymentRequestID uniquely identifies a bucket. It is the
	 * "bucket id" in the world of EC API. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $PaymentRequestID;

	/**
	 * The item id passed through by the merchant. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ItemId;

	/**
	 * The item transaction id passed through by the merchant. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ExternalTxnId;

	/**
	 * Discount offerred for this bucket or item. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var BasicAmountType 	 
	 */ 
	public $DiscountAmount;

	/**
	 * SubType for coupon. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $SubType;


}



/**
 * Details about the seller. 
 */
class SellerDetailsType  
   extends PPXmlMessage{

	/**
	 * Unique identifier for the seller. Optional 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $SellerId;

	/**
	 * The user name of the user at the marketplaces site. Optional
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $SellerUserName;

	/**
	 * Date when the user registered with the marketplace. Optional
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var dateTime 	 
	 */ 
	public $SellerRegistrationDate;

	/**
	 * Seller Paypal Account Id contains the seller EmailId or
	 * PayerId or PhoneNo passed during the Request. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $PayPalAccountID;

	/**
	 * Unique PayPal customer account identification number (of the
	 * seller). This feild is meant for Response. This field is
	 * ignored, if passed in the Request. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $SecureMerchantAccountID;


  
 
}



/**
 * Lists the Payment Methods (other than PayPal) that the use
 * can pay with e.g. Money Order. Optional. 
 */
class OtherPaymentMethodDetailsType  
   extends PPXmlMessage{

	/**
	 * The identifier of the Payment Method. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $OtherPaymentMethodId;

	/**
	 * Valid values are 'Method', 'SubMethod'. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $OtherPaymentMethodType;

	/**
	 * The name of the Payment Method. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $OtherPaymentMethodLabel;

	/**
	 * The short description of the Payment Method, goes along with
	 * the label. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $OtherPaymentMethodLabelDescription;

	/**
	 * The title for the long description. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $OtherPaymentMethodLongDescriptionTitle;

	/**
	 * The long description of the Payment Method. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $OtherPaymentMethodLongDescription;

	/**
	 * The icon of the Payment Method. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $OtherPaymentMethodIcon;

	/**
	 * If this flag is true, then OtherPaymentMethodIcon is
	 * required to have a valid value; the label will be hidden and
	 * only ICON will be shown. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var boolean 	 
	 */ 
	public $OtherPaymentMethodHideLabel;


  
 
}



/**
 * Details about the buyer's account passed in by the merchant
 * or partner. Optional. 
 */
class BuyerDetailsType  
   extends PPXmlMessage{

	/**
	 * The client's unique ID for this user. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $BuyerId;

	/**
	 * The user name of the user at the marketplaces site. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $BuyerUserName;

	/**
	 * Date when the user registered with the marketplace. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var dateTime 	 
	 */ 
	public $BuyerRegistrationDate;

	/**
	 * Details about payer's tax info. Refer to the
	 * TaxIdDetailsType for more details. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var TaxIdDetailsType 	 
	 */ 
	public $TaxIdDetails;

	/**
	 * Contains information that identifies the buyer. e.g. email
	 * address or the external remember me id. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var IdentificationInfoType 	 
	 */ 
	public $IdentificationInfo;


  
 
}



/**
 * Details about the payer's tax info passed in by the merchant
 * or partner. Optional. 
 */
class TaxIdDetailsType  
   extends PPXmlMessage{

	/**
	 * The payer's Tax ID type; CNPJ/CPF for BR country. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $TaxIdType;

	/**
	 * The payer's Tax ID 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $TaxId;


  
 
}



/**
 * The Common 3DS fields. Common for both GTD and DCC API's. 
 */
class ThreeDSecureRequestType  
   extends PPXmlMessage{

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Eci3ds;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Cavv;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Xid;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $MpiVendor3ds;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $AuthStatus3ds;


  
 
}



/**
 * 3DS remaining fields. 
 */
class ThreeDSecureResponseType  
   extends PPXmlMessage{

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Vpas;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $EciSubmitted3DS;


}



/**
 * 3DSecureInfoType Information about 3D Secure parameters. 
 */
class ThreeDSecureInfoType  
   extends PPXmlMessage{

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var ThreeDSecureRequestType 	 
	 */ 
	public $ThreeDSecureRequest;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var ThreeDSecureResponseType 	 
	 */ 
	public $ThreeDSecureResponse;


}



/**
 * CreditCardDetailsType Information about a Credit Card. 
 */
class CreditCardDetailsType  
   extends PPXmlMessage{

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $CreditCardType;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $CreditCardNumber;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var integer 	 
	 */ 
	public $ExpMonth;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var integer 	 
	 */ 
	public $ExpYear;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var PayerInfoType 	 
	 */ 
	public $CardOwner;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $CVV2;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var integer 	 
	 */ 
	public $StartMonth;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var integer 	 
	 */ 
	public $StartYear;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $IssueNumber;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var ThreeDSecureRequestType 	 
	 */ 
	public $ThreeDSecureRequest;


  
 
}



/**
 * Fallback shipping options type. 
 */
class ShippingOptionType  
   extends PPXmlMessage{

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ShippingOptionIsDefault;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var BasicAmountType 	 
	 */ 
	public $ShippingOptionAmount;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ShippingOptionName;


  
 
}



/**
 * Information on user selected options 
 */
class UserSelectedOptionType  
   extends PPXmlMessage{

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ShippingCalculationMode;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $InsuranceOptionSelected;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ShippingOptionIsDefault;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var BasicAmountType 	 
	 */ 
	public $ShippingOptionAmount;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ShippingOptionName;


  
 
}



/**
 * 
 */
class CreditCardNumberTypeType  
   extends PPXmlMessage{

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $CreditCardType;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $CreditCardNumber;


  
 
}



/**
 * CreditCardDetailsType for DCC Reference Transaction
 * Information about a Credit Card. 
 */
class ReferenceCreditCardDetailsType  
   extends PPXmlMessage{

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var CreditCardNumberTypeType 	 
	 */ 
	public $CreditCardNumberType;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var integer 	 
	 */ 
	public $ExpMonth;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var integer 	 
	 */ 
	public $ExpYear;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var PersonNameType 	 
	 */ 
	public $CardOwnerName;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var AddressType 	 
	 */ 
	public $BillingAddress;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $CVV2;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var integer 	 
	 */ 
	public $StartMonth;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var integer 	 
	 */ 
	public $StartYear;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $IssueNumber;


  
 
}



/**
 * 
 */
class SetCustomerBillingAgreementRequestDetailsType  
   extends PPXmlMessage{

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var BillingAgreementDetailsType 	 
	 */ 
	public $BillingAgreementDetails;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ReturnURL;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $CancelURL;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $LocaleCode;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $PageStyle;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 
	 * @name cpp-header-image
	 	 	 	 
	 * @var string 	 
	 */ 
	public $cppheaderimage;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 
	 * @name cpp-header-border-color
	 	 	 	 
	 * @var string 	 
	 */ 
	public $cppheaderbordercolor;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 
	 * @name cpp-header-back-color
	 	 	 	 
	 * @var string 	 
	 */ 
	public $cppheaderbackcolor;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 
	 * @name cpp-payflow-color
	 	 	 	 
	 * @var string 	 
	 */ 
	public $cpppayflowcolor;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $BuyerEmail;

	/**
	 * The value 1 indicates that you require that the customer's
	 * billing address on file. Setting this element overrides the
	 * setting you have specified in Admin. Optional Character
	 * length and limitations: One single-byte numeric character.
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ReqBillingAddress;

	/**
	 * Constructor with arguments
	 */
	public function __construct($BillingAgreementDetails = NULL, $ReturnURL = NULL, $CancelURL = NULL) {
		$this->BillingAgreementDetails = $BillingAgreementDetails;
		$this->ReturnURL = $ReturnURL;
		$this->CancelURL = $CancelURL;
	}


  
 
}



/**
 * 
 */
class GetBillingAgreementCustomerDetailsResponseDetailsType  
   extends PPXmlMessage{

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var PayerInfoType 	 
	 */ 
	public $PayerInfo;

	/**
	 * Customer's billing address. Optional If you have a credit
	 * card mapped in your PayPal account, PayPal returns the
	 * billing address of the credit billing address otherwise your
	 * primary address as billing address in
	 * GetBillingAgreementCustomerDetails.
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var AddressType 	 
	 */ 
	public $BillingAddress;


}



/**
 * Device ID Optional  Character length and limits: 256
 * single-byte characters DeviceID length morethan 256 is
 * truncated  
 */
class DeviceDetailsType  
   extends PPXmlMessage{

	/**
	 * Device ID Optional  Character length and limits: 256
	 * single-byte characters DeviceID length morethan 256 is
	 * truncated  
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $DeviceID;


  
 
}



/**
 * 
 */
class SenderDetailsType  
   extends PPXmlMessage{

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var DeviceDetailsType 	 
	 */ 
	public $DeviceDetails;


  
 
}



/**
 * 
 */
class DoReferenceTransactionRequestDetailsType  
   extends PPXmlMessage{

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ReferenceID;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $PaymentAction;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $PaymentType;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var PaymentDetailsType 	 
	 */ 
	public $PaymentDetails;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var ReferenceCreditCardDetailsType 	 
	 */ 
	public $CreditCard;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $IPAddress;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $MerchantSessionId;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ReqConfirmShipping;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $SoftDescriptor;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $SoftDescriptorCity;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var SenderDetailsType 	 
	 */ 
	public $SenderDetails;

	/**
	 * Unique id for each API request to prevent duplicate
	 * payments. Optional Character length and limits: 38
	 * single-byte characters maximum. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $MsgSubID;

	/**
	 * Constructor with arguments
	 */
	public function __construct($ReferenceID = NULL, $PaymentAction = NULL, $PaymentDetails = NULL) {
		$this->ReferenceID = $ReferenceID;
		$this->PaymentAction = $PaymentAction;
		$this->PaymentDetails = $PaymentDetails;
	}


  
 
}



/**
 * 
 */
class DoReferenceTransactionResponseDetailsType  
   extends PPXmlMessage{

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $BillingAgreementID;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var PaymentInfoType 	 
	 */ 
	public $PaymentInfo;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var BasicAmountType 	 
	 */ 
	public $Amount;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $AVSCode;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $CVV2Code;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $TransactionID;

	/**
	 * Response code from the processor when a recurring
	 * transaction is declined 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $PaymentAdviceCode;

	/**
	 * Return msgsubid back to merchant 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $MsgSubID;


}



/**
 * 
 */
class DoNonReferencedCreditRequestDetailsType  
   extends PPXmlMessage{

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var BasicAmountType 	 
	 */ 
	public $Amount;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var BasicAmountType 	 
	 */ 
	public $NetAmount;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var BasicAmountType 	 
	 */ 
	public $TaxAmount;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var BasicAmountType 	 
	 */ 
	public $ShippingAmount;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var CreditCardDetailsType 	 
	 */ 
	public $CreditCard;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ReceiverEmail;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Comment;


  
 
}



/**
 * 
 */
class DoNonReferencedCreditResponseDetailsType  
   extends PPXmlMessage{

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var BasicAmountType 	 
	 */ 
	public $Amount;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $TransactionID;


}



/**
 * Onboarding program code given to you by PayPal. Required
 * Character length and limitations: 64 alphanumeric characters
 * 
 */
class EnterBoardingRequestDetailsType  
   extends PPXmlMessage{

	/**
	 * Onboarding program code given to you by PayPal. Required
	 * Character length and limitations: 64 alphanumeric characters
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ProgramCode;

	/**
	 * A list of comma-separated values that indicate the PayPal
	 * products you are implementing for this merchant: Direct
	 * Payment (dp) allows payments by credit card without
	 * requiring the customer to have a PayPal account. Express
	 * Checkout (ec) allows customers to fund transactions with
	 * their PayPal account. Authorization and Capture
	 * (auth_settle) allows merchants to verify availability of
	 * funds in a PayPal account, but capture them at a later time.
	 * Administrative APIs (admin_api) is a collection of the
	 * PayPal APIs for transaction searching, getting transaction
	 * details, refunding, and mass payments. Required Character
	 * length and limitations: 64 alphanumeric characters
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ProductList;

	/**
	 * Any custom information you want to store for this partner
	 * Optional Character length and limitations: 256 alphanumeric
	 * characters
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $PartnerCustom;

	/**
	 * The URL for the logo displayed on the PayPal Partner Welcome
	 * Page. Optional Character length and limitations: 2,048
	 * alphanumeric characters
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ImageUrl;

	/**
	 * Marketing category tha configures the graphic displayed n
	 * the PayPal Partner Welcome page.
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $MarketingCategory;

	/**
	 * Information about the merchantâs business
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var BusinessInfoType 	 
	 */ 
	public $BusinessInfo;

	/**
	 * Information about the merchant (the business owner)
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var BusinessOwnerInfoType 	 
	 */ 
	public $OwnerInfo;

	/**
	 * Information about the merchant's bank account
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var BankAccountDetailsType 	 
	 */ 
	public $BankAccount;


  
 
}



/**
 * BusinessInfoType 
 */
class BusinessInfoType  
   extends PPXmlMessage{

	/**
	 * Type of business, such as corporation or sole proprietorship
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Type;

	/**
	 * Official name of business Character length and limitations:
	 * 75 alphanumeric characters
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Name;

	/**
	 * Merchantâs business postal address
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var AddressType 	 
	 */ 
	public $Address;

	/**
	 * Businessâs primary telephone number Character length and
	 * limitations: 20 alphanumeric characters
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $WorkPhone;

	/**
	 * Line of business, as defined in the enumerations
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Category;

	/**
	 * Business sub-category, as defined in the enumerations
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $SubCategory;

	/**
	 * Average transaction price, as defined by the enumerations.
	 * Enumeration Meaning AverageTransactionPrice-Not-Applicable
	 * AverageTransactionPrice-Range1 Less than $25 USD
	 * AverageTransactionPrice-Range2 $25 USD to $50 USD
	 * AverageTransactionPrice-Range3 $50 USD to $100 USD
	 * AverageTransactionPrice-Range4 $100 USD to $250 USD
	 * AverageTransactionPrice-Range5 $250 USD to $500 USD
	 * AverageTransactionPrice-Range6 $500 USD to $1,000 USD
	 * AverageTransactionPrice-Range7 $1,000 USD to $2,000 USD
	 * AverageTransactionPrice-Range8 $2,000 USD to $5,000 USD
	 * AverageTransactionPrice-Range9 $5,000 USD to $10,000 USD
	 * AverageTransactionPrice-Range10 More than $10,000 USD 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $AveragePrice;

	/**
	 * Average monthly sales volume, as defined by the
	 * enumerations. Enumeration Meaning
	 * AverageMonthlyVolume-Not-Applicable
	 * AverageMonthlyVolume-Range1 Less than $1,000 USD
	 * AverageMonthlyVolume-Range2 $1,000 USD to $5,000 USD
	 * AverageMonthlyVolume-Range3 $5,000 USD to $25,000 USD
	 * AverageMonthlyVolume-Range4 $25,000 USD to $100,000 USD
	 * AverageMonthlyVolume-Range5 $100,000 USD to $1,000,000 USD
	 * AverageMonthlyVolume-Range6 More than $1,000,000 USD 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $AverageMonthlyVolume;

	/**
	 * Main sales venue, such as eBay
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $SalesVenue;

	/**
	 * Primary URL of business Character length and limitations:
	 * 2,048 alphanumeric characters
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Website;

	/**
	 * Percentage of revenue attributable to online sales, as
	 * defined by the enumerations Enumeration Meaning
	 * PercentageRevenueFromOnlineSales-Not-Applicable
	 * PercentageRevenueFromOnlineSales-Range1 Less than 25%
	 * PercentageRevenueFromOnlineSales-Range2 25% to 50%
	 * PercentageRevenueFromOnlineSales-Range3 50% to 75%
	 * PercentageRevenueFromOnlineSales-Range4 75% to 100% 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $RevenueFromOnlineSales;

	/**
	 * Date the merchantâs business was established
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var dateTime 	 
	 */ 
	public $BusinessEstablished;

	/**
	 * Email address to contact businessâs customer service
	 * Character length and limitations: 127 alphanumeric
	 * characters
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $CustomerServiceEmail;

	/**
	 * Telephone number to contact businessâs customer service
	 * Character length and limitations: 32 alphanumeric characters
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $CustomerServicePhone;


  
 
}



/**
 * BusinessOwnerInfoType 
 */
class BusinessOwnerInfoType  
   extends PPXmlMessage{

	/**
	 * Details about the business owner
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var PayerInfoType 	 
	 */ 
	public $Owner;

	/**
	 * Business ownerâs home telephone number Character length and
	 * limitations: 32 alphanumeric characters
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $HomePhone;

	/**
	 * Business ownerâs mobile telephone number Character length
	 * and limitations: 32 alphanumeric characters
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $MobilePhone;

	/**
	 * Business ownerâs social security number Character length
	 * and limitations: 9 alphanumeric characters
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $SSN;


  
 
}



/**
 * BankAccountDetailsType 
 */
class BankAccountDetailsType  
   extends PPXmlMessage{

	/**
	 * Name of bank Character length and limitations: 192
	 * alphanumeric characters
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Name;

	/**
	 * Type of bank account: Checking or Savings
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Type;

	/**
	 * Merchantâs bank routing number Character length and
	 * limitations: 23 alphanumeric characters
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $RoutingNumber;

	/**
	 * Merchantâs bank account number Character length and
	 * limitations: 256 alphanumeric characters
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $AccountNumber;


  
 
}



/**
 * Status of merchant's onboarding process:
 * CompletedCancelledPending Character length and limitations:
 * Eight alphabetic characters 
 */
class GetBoardingDetailsResponseDetailsType  
   extends PPXmlMessage{

	/**
	 * Status of merchant's onboarding process:
	 * CompletedCancelledPending Character length and limitations:
	 * Eight alphabetic characters
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Status;

	/**
	 * Date the boarding process started
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var dateTime 	 
	 */ 
	public $StartDate;

	/**
	 * Date the merchantâs status or progress was last updated
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var dateTime 	 
	 */ 
	public $LastUpdated;

	/**
	 * Reason for merchantâs cancellation of sign-up. Character
	 * length and limitations: 1,024 alphanumeric characters
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Reason;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ProgramName;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ProgramCode;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $CampaignID;

	/**
	 * Indicates if there is a limitation on the amount of money
	 * the business can withdraw from PayPal
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $UserWithdrawalLimit;

	/**
	 * Custom information you set on the EnterBoarding API call
	 * Character length and limitations: 256 alphanumeric
	 * characters
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $PartnerCustom;

	/**
	 * Details about the owner of the account
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var PayerInfoType 	 
	 */ 
	public $AccountOwner;

	/**
	 * Merchantâs PayPal API credentials
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var APICredentialsType 	 
	 */ 
	public $Credentials;

	/**
	 * The APIs that this merchant has granted the business partner
	 * permission to call on his behalf. For example:
	 * SetExpressCheckout,GetExpressCheckoutDetails,DoExpressCheckoutPayment
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ConfigureAPIs;

	/**
	 * Primary email verification status. Confirmed, Unconfirmed
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $EmailVerificationStatus;

	/**
	 * Gives VettingStatus - Pending, Cancelled, Approved,
	 * UnderReview Character length and limitations: 256
	 * alphanumeric characters
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $VettingStatus;

	/**
	 * Gives BankAccountVerificationStatus - Added, Confirmed
	 * Character length and limitations: 256 alphanumeric
	 * characters
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $BankAccountVerificationStatus;


}



/**
 * APICredentialsType 
 */
class APICredentialsType  
   extends PPXmlMessage{

	/**
	 * Merchantâs PayPal API usernameCharacter length and
	 * limitations: 128 alphanumeric characters
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Username;

	/**
	 * Merchantâs PayPal API passwordCharacter length and
	 * limitations: 40 alphanumeric characters
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Password;

	/**
	 * Merchantâs PayPal API signature, if one exists. Character
	 * length and limitations: 256 alphanumeric characters
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Signature;

	/**
	 * Merchantâs PayPal API certificate in PEM format, if one
	 * exists The certificate consists of two parts: the private
	 * key (2,048 bytes) and the certificate proper (4,000 bytes).
	 * Character length and limitations: 6,048 alphanumeric
	 * characters
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Certificate;

	/**
	 * Merchantâs PayPal API authentication mechanism. Auth-None:
	 * no authentication mechanism on file Cert: API certificate
	 * Sign: API signature Character length and limitations: 9
	 * alphanumeric characters
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Type;


}



/**
 * The phone number of the buyer's mobile device, if available.
 * Optional 
 */
class SetMobileCheckoutRequestDetailsType  
   extends PPXmlMessage{

	/**
	 * The phone number of the buyer's mobile device, if available.
	 * Optional 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var PhoneNumberType 	 
	 */ 
	public $BuyerPhone;

	/**
	 * Cost of this item before tax and shipping.You must set the
	 * currencyID attribute to one of the three-character currency
	 * codes for any of the supported PayPal currencies. Required
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var BasicAmountType 	 
	 */ 
	public $ItemAmount;

	/**
	 * Tax amount for this item.You must set the currencyID
	 * attribute to one of the three-character currency codes for
	 * any of the supported PayPal currencies. Optional
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var BasicAmountType 	 
	 */ 
	public $Tax;

	/**
	 * Shipping amount for this item.You must set the currencyID
	 * attribute to one of the three-character currency codes for
	 * any of the supported PayPal currencies. Optional
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var BasicAmountType 	 
	 */ 
	public $Shipping;

	/**
	 * Description of the item that the customer is purchasing.
	 * Required Character length and limitations: 127 single-byte
	 * alphanumeric characters
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ItemName;

	/**
	 * Reference number of the item that the customer is
	 * purchasing. Optional Character length and limitations: 127
	 * single-byte alphanumeric characters
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ItemNumber;

	/**
	 * A free-form field for your own use, such as a tracking
	 * number or other value you want returned to you in IPN.
	 * Optional Character length and limitations: 256 single-byte
	 * alphanumeric characters
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Custom;

	/**
	 * Your own unique invoice or tracking number. Optional
	 * Character length and limitations: 127 single-byte
	 * alphanumeric characters
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $InvoiceID;

	/**
	 * URL to which the customer's browser is returned after
	 * choosing to pay with PayPal. PayPal recommends that the
	 * value of ReturnURL be the final review page on which the
	 * customer confirms the order and payment. Required Character
	 * length and limitations: no limit. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ReturnURL;

	/**
	 * URL to which the customer is returned if he does not approve
	 * the use of PayPal to pay you. PayPal recommends that the
	 * value of CancelURL be the original page on which the
	 * customer chose to pay with PayPal. Optional Character length
	 * and limitations: no limit
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $CancelURL;

	/**
	 * The value 1 indicates that you require that the customer's
	 * shipping address on file with PayPal be a confirmed address.
	 * Setting this element overrides the setting you have
	 * specified in your Merchant Account Profile. Optional
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var integer 	 
	 */ 
	public $AddressDisplayOptions;

	/**
	 * The value 1 indicates that you require that the customer
	 * specifies a contact phone for the transactxion. Default is 0
	 * / none required. Optional
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var integer 	 
	 */ 
	public $SharePhone;

	/**
	 * Customer's shipping address. Optional
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var AddressType 	 
	 */ 
	public $ShipToAddress;

	/**
	 * Email address of the buyer as entered during checkout.
	 * PayPal uses this value to pre-fill the login portion of the
	 * PayPal login page. Optional Character length and limit: 127
	 * single-byte alphanumeric characters 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $BuyerEmail;

	/**
	 * Constructor with arguments
	 */
	public function __construct($ItemAmount = NULL, $ItemName = NULL, $ReturnURL = NULL) {
		$this->ItemAmount = $ItemAmount;
		$this->ItemName = $ItemName;
		$this->ReturnURL = $ReturnURL;
	}


  
 
}



/**
 * A free-form field for your own use, such as a tracking
 * number or other value you want returned to you in IPN.
 * Optional Character length and limitations: 256 single-byte
 * alphanumeric characters 
 */
class DoMobileCheckoutPaymentResponseDetailsType  
   extends PPXmlMessage{

	/**
	 * A free-form field for your own use, such as a tracking
	 * number or other value you want returned to you in IPN.
	 * Optional Character length and limitations: 256 single-byte
	 * alphanumeric characters
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Custom;

	/**
	 * Your own unique invoice or tracking number. Optional
	 * Character length and limitations: 127 single-byte
	 * alphanumeric characters
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $InvoiceID;

	/**
	 * Information about the payer
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var PayerInfoType 	 
	 */ 
	public $PayerInfo;

	/**
	 * Information about the transaction
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var PaymentInfoType 	 
	 */ 
	public $PaymentInfo;


}



/**
 * UATP Card Details Type 
 */
class UATPDetailsType  
   extends PPXmlMessage{

	/**
	 * UATP Card Number
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $UATPNumber;

	/**
	 * UATP Card expirty month
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var integer 	 
	 */ 
	public $ExpMonth;

	/**
	 * UATP Card expirty year
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var integer 	 
	 */ 
	public $ExpYear;


  
 
}



/**
 * 
 */
class RecurringPaymentsSummaryType  
   extends PPXmlMessage{

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var dateTime 	 
	 */ 
	public $NextBillingDate;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var integer 	 
	 */ 
	public $NumberCyclesCompleted;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var integer 	 
	 */ 
	public $NumberCyclesRemaining;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var BasicAmountType 	 
	 */ 
	public $OutstandingBalance;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var integer 	 
	 */ 
	public $FailedPaymentCount;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var dateTime 	 
	 */ 
	public $LastPaymentDate;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var BasicAmountType 	 
	 */ 
	public $LastPaymentAmount;


}



/**
 * 
 */
class ActivationDetailsType  
   extends PPXmlMessage{

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var BasicAmountType 	 
	 */ 
	public $InitialAmount;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $FailedInitialAmountAction;

	/**
	 * Constructor with arguments
	 */
	public function __construct($InitialAmount = NULL) {
		$this->InitialAmount = $InitialAmount;
	}


  
 
}



/**
 * Unit of meausre for billing cycle 
 */
class BillingPeriodDetailsType  
   extends PPXmlMessage{

	/**
	 * Unit of meausre for billing cycle 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $BillingPeriod;

	/**
	 * Number of BillingPeriod that make up one billing cycle 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var integer 	 
	 */ 
	public $BillingFrequency;

	/**
	 * Total billing cycles in this portion of the schedule 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var integer 	 
	 */ 
	public $TotalBillingCycles;

	/**
	 * Amount to charge 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var BasicAmountType 	 
	 */ 
	public $Amount;

	/**
	 * Additional shipping amount to charge 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var BasicAmountType 	 
	 */ 
	public $ShippingAmount;

	/**
	 * Additional tax amount to charge 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var BasicAmountType 	 
	 */ 
	public $TaxAmount;

	/**
	 * Constructor with arguments
	 */
	public function __construct($BillingPeriod = NULL, $BillingFrequency = NULL, $Amount = NULL) {
		$this->BillingPeriod = $BillingPeriod;
		$this->BillingFrequency = $BillingFrequency;
		$this->Amount = $Amount;
	}


  
 
}



/**
 * Unit of meausre for billing cycle 
 */
class BillingPeriodDetailsType_Update  
   extends PPXmlMessage{

	/**
	 * Unit of meausre for billing cycle 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $BillingPeriod;

	/**
	 * Number of BillingPeriod that make up one billing cycle 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var integer 	 
	 */ 
	public $BillingFrequency;

	/**
	 * Total billing cycles in this portion of the schedule 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var integer 	 
	 */ 
	public $TotalBillingCycles;

	/**
	 * Amount to charge 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var BasicAmountType 	 
	 */ 
	public $Amount;

	/**
	 * Additional shipping amount to charge 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var BasicAmountType 	 
	 */ 
	public $ShippingAmount;

	/**
	 * Additional tax amount to charge 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var BasicAmountType 	 
	 */ 
	public $TaxAmount;


  
 
}



/**
 * Schedule details for the Recurring Payment 
 */
class ScheduleDetailsType  
   extends PPXmlMessage{

	/**
	 * Schedule details for the Recurring Payment 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Description;

	/**
	 * Trial period of this schedule 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var BillingPeriodDetailsType 	 
	 */ 
	public $TrialPeriod;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var BillingPeriodDetailsType 	 
	 */ 
	public $PaymentPeriod;

	/**
	 * The max number of payments the buyer can fail before this
	 * Recurring Payments profile is cancelled 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var integer 	 
	 */ 
	public $MaxFailedPayments;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var ActivationDetailsType 	 
	 */ 
	public $ActivationDetails;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $AutoBillOutstandingAmount;

	/**
	 * Constructor with arguments
	 */
	public function __construct($Description = NULL, $PaymentPeriod = NULL) {
		$this->Description = $Description;
		$this->PaymentPeriod = $PaymentPeriod;
	}


  
 
}



/**
 * Subscriber name - if missing, will use name in buyer's
 * account 
 */
class RecurringPaymentsProfileDetailsType  
   extends PPXmlMessage{

	/**
	 * Subscriber name - if missing, will use name in buyer's
	 * account 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $SubscriberName;

	/**
	 * Subscriber address - if missing, will use address in buyer's
	 * account 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var AddressType 	 
	 */ 
	public $SubscriberShippingAddress;

	/**
	 * When does this Profile begin billing? 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var dateTime 	 
	 */ 
	public $BillingStartDate;

	/**
	 * Your own unique invoice or tracking number. Optional
	 * Character length and limitations: 127 single-byte
	 * alphanumeric characters 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ProfileReference;

	/**
	 * Constructor with arguments
	 */
	public function __construct($BillingStartDate = NULL) {
		$this->BillingStartDate = $BillingStartDate;
	}


  
 
}



/**
 * Billing Agreement token (required if Express Checkout) 
 */
class CreateRecurringPaymentsProfileRequestDetailsType  
   extends PPXmlMessage{

	/**
	 * Billing Agreement token (required if Express Checkout) 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Token;

	/**
	 * Information about the credit card to be charged (required if
	 * Direct Payment) 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var CreditCardDetailsType 	 
	 */ 
	public $CreditCard;

	/**
	 * Customer Information for this Recurring Payments 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var RecurringPaymentsProfileDetailsType 	 
	 */ 
	public $RecurringPaymentsProfileDetails;

	/**
	 * Schedule Information for this Recurring Payments 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var ScheduleDetailsType 	 
	 */ 
	public $ScheduleDetails;

	/**
	 * Information about the Item Details. 
     * @array
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var PaymentDetailsItemType 	 
	 */ 
	public $PaymentDetailsItem;

	/**
	 * Use this optional parameter to pass in your business name
	 * and other data describing the transaction. Optional This
	 * information is usually displayed in the CC account holder's
	 * statement. Example: RedCross Haiti, RedCross Uganda,
	 * Realtor.com dues, Realtor.com list fee Length 25 characters.
	 * Alphanumeric characters and dash(-), dot(.), asterisk(*),
	 * space( ) On the customer's statement, an asterisk is used to
	 * separate the DBA name and product name. The asterisk
	 * delimiter can appear in position 4, 8, or 13. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $SoftDescriptor;

	/**
	 * Use this optional parameter to pass information about how
	 * consumer should contact the merchant. Optional This
	 * information is usually displayed in the CC account holder's
	 * statement. For Ecom trx: phone, email or URL is allowed For
	 * Retail trx: only the actual city is allowed For details on
	 * allowed characters in Soft Descriptor City refer to the API
	 * documentation. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $SoftDescriptorCity;

	/**
	 * Constructor with arguments
	 */
	public function __construct($RecurringPaymentsProfileDetails = NULL, $ScheduleDetails = NULL) {
		$this->RecurringPaymentsProfileDetails = $RecurringPaymentsProfileDetails;
		$this->ScheduleDetails = $ScheduleDetails;
	}


  
 
}



/**
 * Recurring Billing Profile ID 
 */
class CreateRecurringPaymentsProfileResponseDetailsType  
   extends PPXmlMessage{

	/**
	 * Recurring Billing Profile ID 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ProfileID;

	/**
	 * Recurring Billing Profile Status 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ProfileStatus;

	/**
	 * Transaction id from DCC initial payment 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $TransactionID;

	/**
	 * Response from DCC initial payment 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $DCCProcessorResponse;

	/**
	 * Return code if DCC initial payment fails 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $DCCReturnCode;


}



/**
 * Recurring Billing Profile ID 
 */
class GetRecurringPaymentsProfileDetailsResponseDetailsType  
   extends PPXmlMessage{

	/**
	 * Recurring Billing Profile ID 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ProfileID;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ProfileStatus;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Description;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $AutoBillOutstandingAmount;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var integer 	 
	 */ 
	public $MaxFailedPayments;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var RecurringPaymentsProfileDetailsType 	 
	 */ 
	public $RecurringPaymentsProfileDetails;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var BillingPeriodDetailsType 	 
	 */ 
	public $CurrentRecurringPaymentsPeriod;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var RecurringPaymentsSummaryType 	 
	 */ 
	public $RecurringPaymentsSummary;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var CreditCardDetailsType 	 
	 */ 
	public $CreditCard;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var BillingPeriodDetailsType 	 
	 */ 
	public $TrialRecurringPaymentsPeriod;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var BillingPeriodDetailsType 	 
	 */ 
	public $RegularRecurringPaymentsPeriod;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var BasicAmountType 	 
	 */ 
	public $TrialAmountPaid;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var BasicAmountType 	 
	 */ 
	public $RegularAmountPaid;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var BasicAmountType 	 
	 */ 
	public $AggregateAmount;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var BasicAmountType 	 
	 */ 
	public $AggregateOptionalAmount;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var dateTime 	 
	 */ 
	public $FinalPaymentDueDate;

	/**
	 * Use this optional parameter to pass in your business name
	 * and other data describing the transaction. Optional This
	 * information is usually displayed in the account holder's
	 * statement. Example: RedCross Haiti, RedCross Uganda,
	 * Realtor.com dues, Realtor.com list fee Length 25 characters.
	 * Alphanumeric characters and dash(-), dot(.), asterisk(*),
	 * space( ) On the customer's statement, an asterisk is used to
	 * separate the DBA name and product name. The asterisk
	 * delimiter can appear in position 4, 8, or 13. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $SoftDescriptor;

	/**
	 * Use this optional parameter to pass information about how
	 * consumer should contact the merchant. Optional This
	 * information is usually displayed in the account holder's
	 * statement. For Ecom trx: phone, email or URL is allowed For
	 * Retail trx: only the actual city is allowed For details on
	 * allowed characters in Soft Descriptor City refer to the API
	 * documentation. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $SoftDescriptorCity;


}



/**
 * 
 */
class ManageRecurringPaymentsProfileStatusRequestDetailsType  
   extends PPXmlMessage{

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ProfileID;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Action;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Note;

	/**
	 * Constructor with arguments
	 */
	public function __construct($ProfileID = NULL, $Action = NULL) {
		$this->ProfileID = $ProfileID;
		$this->Action = $Action;
	}


  
 
}



/**
 * 
 */
class ManageRecurringPaymentsProfileStatusResponseDetailsType  
   extends PPXmlMessage{

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ProfileID;


}



/**
 * 
 */
class BillOutstandingAmountRequestDetailsType  
   extends PPXmlMessage{

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ProfileID;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var BasicAmountType 	 
	 */ 
	public $Amount;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Note;

	/**
	 * Constructor with arguments
	 */
	public function __construct($ProfileID = NULL) {
		$this->ProfileID = $ProfileID;
	}


  
 
}



/**
 * 
 */
class BillOutstandingAmountResponseDetailsType  
   extends PPXmlMessage{

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ProfileID;


}



/**
 * 
 */
class UpdateRecurringPaymentsProfileRequestDetailsType  
   extends PPXmlMessage{

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ProfileID;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Note;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Description;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $SubscriberName;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var AddressType 	 
	 */ 
	public $SubscriberShippingAddress;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ProfileReference;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var integer 	 
	 */ 
	public $AdditionalBillingCycles;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var BasicAmountType 	 
	 */ 
	public $Amount;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var BasicAmountType 	 
	 */ 
	public $ShippingAmount;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var BasicAmountType 	 
	 */ 
	public $TaxAmount;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var BasicAmountType 	 
	 */ 
	public $OutstandingBalance;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $AutoBillOutstandingAmount;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var integer 	 
	 */ 
	public $MaxFailedPayments;

	/**
	 * Information about the credit card to be charged (required if
	 * Direct Payment) 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var CreditCardDetailsType 	 
	 */ 
	public $CreditCard;

	/**
	 * When does this Profile begin billing? 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var dateTime 	 
	 */ 
	public $BillingStartDate;

	/**
	 * Trial period of this schedule 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var BillingPeriodDetailsType_Update 	 
	 */ 
	public $TrialPeriod;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var BillingPeriodDetailsType_Update 	 
	 */ 
	public $PaymentPeriod;

	/**
	 * Constructor with arguments
	 */
	public function __construct($ProfileID = NULL) {
		$this->ProfileID = $ProfileID;
	}


  
 
}



/**
 * 
 */
class UpdateRecurringPaymentsProfileResponseDetailsType  
   extends PPXmlMessage{

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ProfileID;


}



/**
 * Details of Risk Filter. 
 */
class RiskFilterDetailsType  
   extends PPXmlMessage{

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var integer 	 
	 */ 
	public $Id;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Name;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Description;


}



/**
 * Details of Risk Filter. 
 */
class RiskFilterListType  
   extends PPXmlMessage{

	/**
	 * 
     * @array
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var RiskFilterDetailsType 	 
	 */ 
	public $Filters;


}



/**
 * Thes are filters that could result in accept/deny/pending
 * action. 
 */
class FMFDetailsType  
   extends PPXmlMessage{

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var RiskFilterListType 	 
	 */ 
	public $AcceptFilters;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var RiskFilterListType 	 
	 */ 
	public $PendingFilters;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var RiskFilterListType 	 
	 */ 
	public $DenyFilters;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var RiskFilterListType 	 
	 */ 
	public $ReportFilters;


}



/**
 * Enhanced Data Information. Example: AID for Airlines 
 */
class EnhancedDataType  
   extends PPXmlMessage{

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var AirlineItineraryType 	 
	 */ 
	public $AirlineItinerary;


  
 
}



/**
 * AID for Airlines 
 */
class AirlineItineraryType  
   extends PPXmlMessage{

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $PassengerName;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $IssueDate;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $TravelAgencyName;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $TravelAgencyCode;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $TicketNumber;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $IssuingCarrierCode;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $CustomerCode;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var BasicAmountType 	 
	 */ 
	public $TotalFare;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var BasicAmountType 	 
	 */ 
	public $TotalTaxes;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var BasicAmountType 	 
	 */ 
	public $TotalFee;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $RestrictedTicket;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ClearingSequence;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ClearingCount;

	/**
	 * 
     * @array
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var FlightDetailsType 	 
	 */ 
	public $FlightDetails;


  
 
}



/**
 * Details of leg information 
 */
class FlightDetailsType  
   extends PPXmlMessage{

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ConjuctionTicket;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ExchangeTicket;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $CouponNumber;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ServiceClass;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $TravelDate;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $CarrierCode;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $StopOverPermitted;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $DepartureAirport;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ArrivalAirport;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $FlightNumber;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $DepartureTime;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ArrivalTime;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $FareBasisCode;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var BasicAmountType 	 
	 */ 
	public $Fare;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var BasicAmountType 	 
	 */ 
	public $Taxes;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var BasicAmountType 	 
	 */ 
	public $Fee;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $EndorsementOrRestrictions;


  
 
}



/**
 * Authorization details 
 */
class AuthorizationInfoType  
   extends PPXmlMessage{

	/**
	 * The status of the payment: Pending: The payment is pending.
	 * See "PendingReason" for more information.
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $PaymentStatus;

	/**
	 * The reason the payment is pending:none: No pending reason
	 * address: The payment is pending because your customer did
	 * not include a confirmed shipping address and your Payment
	 * Receiving Preferences is set such that you want to manually
	 * accept or deny each of these payments. To change your
	 * preference, go to the Preferences section of your Profile.
	 * authorization: The authorization is pending at time of
	 * creation if payment is not under review echeck: The payment
	 * is pending because it was made by an eCheck that has not yet
	 * cleared. intl: The payment is pending because you hold a
	 * non-U.S. account and do not have a withdrawal mechanism. You
	 * must manually accept or deny this payment from your Account
	 * Overview. multi-currency: You do not have a balance in the
	 * currency sent, and you do not have your Payment Receiving
	 * Preferences set to automatically convert and accept this
	 * payment. You must manually accept or deny this payment.
	 * unilateral: The payment is pending because it was made to an
	 * email address that is not yet registered or confirmed.
	 * upgrade: The payment is pending because it was made via
	 * credit card and you must upgrade your account to Business or
	 * Premier status in order to receive the funds. upgrade can
	 * also mean that you have reached the monthly limit for
	 * transactions on your account. verify: The payment is pending
	 * because you are not yet verified. You must verify your
	 * account before you can accept this payment. payment_review:
	 * The payment is pending because it is under payment review.
	 * other: The payment is pending for a reason other than those
	 * listed above. For more information, contact PayPal Customer
	 * Service.
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $PendingReason;

	/**
	 * Protection Eligibility for this Transaction - None, SPP or
	 * ESPP 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ProtectionEligibility;

	/**
	 * Protection Eligibility Type for this Transaction 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ProtectionEligibilityType;


}



/**
 * Option Number. Optional 
 */
class OptionTrackingDetailsType  
   extends PPXmlMessage{

	/**
	 * Option Number. Optional 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $OptionNumber;

	/**
	 * Option Quantity. Optional 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $OptionQty;

	/**
	 * Option Select Name. Optional 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $OptionSelect;

	/**
	 * Option Quantity Delta. Optional 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $OptionQtyDelta;

	/**
	 * Option Alert. Optional 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $OptionAlert;

	/**
	 * Option Cost. Optional 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $OptionCost;


  
 
}



/**
 * Item Number. Required 
 */
class ItemTrackingDetailsType  
   extends PPXmlMessage{

	/**
	 * Item Number. Required 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ItemNumber;

	/**
	 * Option Quantity. Optional 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ItemQty;

	/**
	 * Item Quantity Delta. Optional 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ItemQtyDelta;

	/**
	 * Item Alert. Optional 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ItemAlert;

	/**
	 * Item Cost. Optional 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ItemCost;


  
 
}



/**
 * 
 */
class ButtonSearchResultType  
   extends PPXmlMessage{

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $HostedButtonID;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ButtonType;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ItemName;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var dateTime 	 
	 */ 
	public $ModifyDate;


}



/**
 * Identifier of the transaction to reverse. Required Character
 * length and limitations: 17 single-byte alphanumeric
 * characters 
 */
class ReverseTransactionRequestDetailsType  
   extends PPXmlMessage{

	/**
	 * Identifier of the transaction to reverse. Required Character
	 * length and limitations: 17 single-byte alphanumeric
	 * characters 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $TransactionID;


  
 
}



/**
 * Unique transaction identifier of the reversal transaction
 * created. Character length and limitations:17 single-byte
 * characters 
 */
class ReverseTransactionResponseDetailsType  
   extends PPXmlMessage{

	/**
	 * Unique transaction identifier of the reversal transaction
	 * created. Character length and limitations:17 single-byte
	 * characters 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ReverseTransactionID;

	/**
	 * Status of reversal request. Required 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Status;


}



/**
 * Details of incentive application on individual bucket. 
 */
class IncentiveInfoType  
   extends PPXmlMessage{

	/**
	 * Incentive redemption code. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $IncentiveCode;

	/**
	 * Defines which bucket or item that the incentive should be
	 * applied to. 
     * @array
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var IncentiveApplyIndicationType 	 
	 */ 
	public $ApplyIndication;


  
 
}



/**
 * Defines which bucket or item that the incentive should be
 * applied to. 
 */
class IncentiveApplyIndicationType  
   extends PPXmlMessage{

	/**
	 * The Bucket ID that the incentive is applied to. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $PaymentRequestID;

	/**
	 * The item that the incentive is applied to. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ItemId;


  
 
}



/**
 * Contains payment request information for each bucket in the
 * cart.  
 */
class PaymentRequestInfoType  
   extends PPXmlMessage{

	/**
	 * Contains the transaction id of the bucket.  
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $TransactionId;

	/**
	 * Contains the bucket id.  
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $PaymentRequestID;

	/**
	 * Contains the error details.  
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var ErrorType 	 
	 */ 
	public $PaymentError;


}



/**
 * E-mail address or secure merchant account ID of merchant to
 * associate with new external remember-me. 
 */
class ExternalRememberMeOwnerDetailsType  
   extends PPXmlMessage{

	/**
	 * A discriminant that tells SetEC what kind of data the
	 * ExternalRememberMeOwnerID parameter contains. Currently, the
	 * owner must be either the API actor or omitted/none. In the
	 * future, we may allow the owner to be a 3rd party merchant
	 * account. Possible values are: None, ignore the
	 * ExternalRememberMeOwnerID. An empty value for this field
	 * also signifies None. Email, the owner ID is an email address
	 * SecureMerchantAccountID, the owner id is a string
	 * representing the secure merchant account ID 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ExternalRememberMeOwnerIDType;

	/**
	 * When opting in to bypass login via remember me, this
	 * parameter specifies the merchant account associated with the
	 * remembered login. Currentl, the owner must be either the API
	 * actor or omitted/none. In the future, we may allow the owner
	 * to be a 3rd party merchant account. If the Owner ID Type
	 * field is not present or "None", this parameter is ignored. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ExternalRememberMeOwnerID;


  
 
}



/**
 * This element contains information that allows the merchant
 * to request to opt into external remember me on behalf of the
 * buyer or to request login bypass using external remember me.
 * 
 */
class ExternalRememberMeOptInDetailsType  
   extends PPXmlMessage{

	/**
	 * 1 = opt in to external remember me. 0 or omitted = no opt-in
	 * Other values are invalid 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ExternalRememberMeOptIn;

	/**
	 * E-mail address or secure merchant account ID of merchant to
	 * associate with new external remember-me. Currently, the
	 * owner must be either the API actor or omitted/none. In the
	 * future, we may allow the owner to be a 3rd party merchant
	 * account. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var ExternalRememberMeOwnerDetailsType 	 
	 */ 
	public $ExternalRememberMeOwnerDetails;


  
 
}



/**
 * An optional set of values related to flow-specific details. 
 */
class FlowControlDetailsType  
   extends PPXmlMessage{

	/**
	 * The URL to redirect to for an unpayable transaction. This
	 * field is currently used only for the inline checkout flow. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ErrorURL;

	/**
	 * The URL to redirect to after a user clicks the "Pay" or
	 * "Continue" button on the merchant's site. This field is
	 * currently used only for the inline checkout flow. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $InContextReturnURL;


  
 
}



/**
 * Response information resulting from opt-in operation or
 * current login bypass status. 
 */
class ExternalRememberMeStatusDetailsType  
   extends PPXmlMessage{

	/**
	 * Required field that reports status of opt-in or login bypass
	 * attempt. 0 = Success - successful opt-in or
	 * ExternalRememberMeID specified in SetExpressCheckout is
	 * valid. 1 = Invalid ID - ExternalRememberMeID specified in
	 * SetExpressCheckout is invalid. 2 = Internal Error - System
	 * error or outage during opt-in or login bypass. Can retry
	 * opt-in or login bypass next time. Flow will force full
	 * authentication and allow buyer to complete transaction. -1 =
	 * None - the return value does not signify any valid remember
	 * me status. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var integer 	 
	 */ 
	public $ExternalRememberMeStatus;

	/**
	 * Identifier returned on external-remember-me-opt-in to allow
	 * the merchant to request bypass of PayPal login through
	 * external remember me on behalf of the buyer in future
	 * transactions. The ExternalRememberMeID is a 17-character
	 * alphanumeric (encrypted) string. This field has meaning only
	 * to the merchant. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ExternalRememberMeID;


}



/**
 * Response information resulting from opt-in operation or
 * current login bypass status. 
 */
class RefreshTokenStatusDetailsType  
   extends PPXmlMessage{

	/**
	 * Required field that reports status of opt-in or login bypass
	 * attempt.  0 = Success, successful opt-in or RefreshToken
	 * corresponding to AccessToken specified  in
	 * SetExpressCheckout is valid (user is still opted in).  1 =
	 * New RefreshToken was generated (user is still opted in).  2
	 * = Invalid ID, RefreshToken corresponding to AccessToken
	 * specified in SetExpressCheckout  is invalid (user is opted
	 * out). -2 = Internal Error, system error or outage during
	 * opt-in or login bypass. Can retry  opt-in or login bypass
	 * next time. Flow will force full authentication and allow 
	 * buyer to complete transaction. -1 = None, the field does not
	 * represent any valid value of the status. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var integer 	 
	 */ 
	public $RefreshTokenStatus;

	/**
	 * Identifier returned on external-remember-me-opt-in to allow
	 * the merchant to request bypass of PayPal login 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $RefreshToken;

	/**
	 * The immutable_id is the user's unique value per merchant
	 * that should never ever change for that account. This would
	 * be the key used to uniquely identify the user 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ImmutableID;


}



/**
 * Contains elements that allows customization of display (user
 * interface) elements. 
 */
class DisplayControlDetailsType  
   extends PPXmlMessage{

	/**
	 * Optional URL to pay button image for the inline checkout
	 * flow. Currently applicable only to the inline checkout flow
	 * when the FlowControlDetails/InlineReturnURL is present. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $InContextPaymentButtonImage;


  
 
}



/**
 * Contains elements that allow tracking for an external
 * partner. 
 */
class ExternalPartnerTrackingDetailsType  
   extends PPXmlMessage{

	/**
	 * PayPal will just log this string. There will NOT be any
	 * business logic around it, nor any decisions made based on
	 * the value of the string that is passed in. From a
	 * tracking/analytical perspective, PayPal would not infer any
	 * meaning to any specific value. We would just segment the
	 * traffic based on the value passed (Cart and None as an
	 * example) and track different metrics like risk/conversion
	 * etc based on these segments. The external partner would
	 * control the value of what gets passed and we take that value
	 * as is and generate data based on it. Optional 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ExternalPartnerSegmentID;


  
 
}



/**
 * Store IDOptional Character length and limits: 50 single-byte
 * characters 
 */
class MerchantStoreDetailsType  
   extends PPXmlMessage{

	/**
	 * Store IDOptional Character length and limits: 50 single-byte
	 * characters 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $StoreID;

	/**
	 * Terminal IDOptional Character length and limits: 50
	 * single-byte characters 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $TerminalID;

	/**
	 * Constructor with arguments
	 */
	public function __construct($StoreID = NULL) {
		$this->StoreID = $StoreID;
	}


  
 
}



/**
 * 
 */
class AdditionalFeeType  
   extends PPXmlMessage{

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Type;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var BasicAmountType 	 
	 */ 
	public $Amount;


  
 
}



/**
 * Describes discount information 
 */
class DiscountType  
   extends PPXmlMessage{

	/**
	 * Item nameOptional Character length and limits: 127
	 * single-byte characters 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Name;

	/**
	 * description of the discountOptional Character length and
	 * limits: 127 single-byte characters 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Description;

	/**
	 * amount discountedOptional 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var BasicAmountType 	 
	 */ 
	public $Amount;

	/**
	 * offer typeOptional 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $RedeemedOfferType;

	/**
	 * offer IDOptional Character length and limits: 64 single-byte
	 * characters 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $RedeemedOfferID;

	/**
	 * Constructor with arguments
	 */
	public function __construct($Amount = NULL) {
		$this->Amount = $Amount;
	}


  
 
}



/**
 * Describes an individual item for an invoice. 
 */
class InvoiceItemType  
   extends PPXmlMessage{

	/**
	 * a human readable item nameOptional Character length and
	 * limits: 127 single-byte characters 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Name;

	/**
	 * a human readable item descriptionOptional Character length
	 * and limits: 127 single-byte characters 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Description;

	/**
	 * The International Article Number or Universal Product Code
	 * (UPC) for the item. Empty string is allowed. Character
	 * length and limits: 17 single-byte characters 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $EAN;

	/**
	 * The Stock-Keeping Unit or other identification code assigned
	 * to the item. Character length and limits: 64 single-byte
	 * characters 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $SKU;

	/**
	 * A retailer could apply different return policies on
	 * different items. Each return policy would be identified
	 * using a label or identifier. This return policy identifier
	 * should be set here. This identifier will be displayed next
	 * to the item in the e-Receipt. Character length and limits: 8
	 * single-byte characters 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ReturnPolicyIdentifier;

	/**
	 * total price of this item 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var BasicAmountType 	 
	 */ 
	public $Price;

	/**
	 * price per item quantity 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var BasicAmountType 	 
	 */ 
	public $ItemPrice;

	/**
	 * quantity of the item (non-negative) 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var double 	 
	 */ 
	public $ItemCount;

	/**
	 * Unit of measure for the itemCount 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ItemCountUnit;

	/**
	 * discount applied to this item 
     * @array
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var DiscountType 	 
	 */ 
	public $Discount;

	/**
	 * identifies whether this item is taxable or not. If not
	 * passed, this will be assumed to be true. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var boolean 	 
	 */ 
	public $Taxable;

	/**
	 * The tax percentage applied to the item. This is only used
	 * for displaying in the receipt, it is not used in pricing
	 * calculations. Note: we have totalTax at invoice level. It's
	 * up to the caller to do the calculations for setting that
	 * other element. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var double 	 
	 */ 
	public $TaxRate;

	/**
	 * Additional fees to this item 
     * @array
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var AdditionalFeeType 	 
	 */ 
	public $AdditionalFees;

	/**
	 * identifies whether this is reimbursable or not. If not pass,
	 * this will be assumed to be true. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var boolean 	 
	 */ 
	public $Reimbursable;

	/**
	 * Manufacturer part number. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $MPN;

	/**
	 * International Standard Book Number. Reference
	 * http://en.wikipedia.org/wiki/ISBN Character length and
	 * limits: 32 single-byte characters 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ISBN;

	/**
	 * Price Look-Up code Reference
	 * http://en.wikipedia.org/wiki/Price_Look-Up_code Character
	 * length and limits: 5 single-byte characters 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $PLU;

	/**
	 * Character length and limits: 32 single-byte characters 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ModelNumber;

	/**
	 * Character length and limits: 32 single-byte characters 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $StyleNumber;


  
 
}



/**
 * Holds refunds payment status information 
 */
class RefundInfoType  
   extends PPXmlMessage{

	/**
	 * Refund status whether it is Instant or Delayed. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $RefundStatus;

	/**
	 * Tells us the reason when refund payment status is Delayed. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $PendingReason;


}



/**
 * Defines relationship between buckets 
 */
class CoupledBucketsType  
   extends PPXmlMessage{

	/**
	 * Relationship Type - LifeTime (default) 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $CoupleType;

	/**
	 * Identifier for this relation 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $CoupledPaymentRequestID;

	/**
	 * 
     * @array
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $PaymentRequestID;

	/**
	 * Constructor with arguments
	 */
	public function __construct($PaymentRequestID = NULL) {
		$this->PaymentRequestID = $PaymentRequestID;
	}


  
 
}



/**
 * Information about Coupled Payment transactions. 
 */
class CoupledPaymentInfoType  
   extends PPXmlMessage{

	/**
	 * ID received in the Coupled Payment Request
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $CoupledPaymentRequestID;

	/**
	 * ID that uniquely identifies this CoupledPayment. Generated
	 * by PP in Response
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $CoupledPaymentID;


}



/**
 * This holds single key-value pair. 
 */
class TupleType  
   extends PPXmlMessage{

	/**
	 * Key Name.Optional
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Key;

	/**
	 * Value for the above key.Optional
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Value;

	/**
	 * Constructor with arguments
	 */
	public function __construct($Key = NULL, $Value = NULL) {
		$this->Key = $Key;
		$this->Value = $Value;
	}


  
 
}



/**
 * This holds all key-value pairs which merchants wants to pass
 * it to the open wallet(PLCC) processor. 
 */
class MerchantDataType  
   extends PPXmlMessage{

	/**
	 * 
     * @array
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var TupleType 	 
	 */ 
	public $MerchantDataTuple;


  
 
}



/**
 * Details about an Item stored in the PayPal Wallet. 
 */
class WalletItemsType  
   extends PPXmlMessage{

	/**
	 * (Optional)Identifies a wallet item of a given type. The
	 * format varies depending on the type. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Type;

	/**
	 * (Optional)Uniquely identifies a wallet item of given type.
	 * Format varies depending on the type. Character length and
	 * limitations: 64 single-byte characters maximum. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Id;

	/**
	 * (Optional)Description of wallet item. Character length and
	 * limitations: 512 single-byte characters maximum. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Description;


  
 
}



/**
 * Describes discount information. 
 */
class DiscountInfoType  
   extends PPXmlMessage{

	/**
	 * (Optional)Item name. Character length and limits: 127
	 * single-byte characters 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Name;

	/**
	 * (Optional)Description of the discount. Character length and
	 * limits: 127 single-byte characters 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Description;

	/**
	 * (Optional)Amount discounted. The value includes an amount
	 * and a 3-character currency code. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var BasicAmountType 	 
	 */ 
	public $Amount;

	/**
	 * (Optional)Offer type. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $RedeemedOfferType;

	/**
	 * (Optional)Offer ID. Character length and limits: 64
	 * single-byte characters. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $RedeemedOfferId;

	/**
	 * (Optional)Loyalty points accrued. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var double 	 
	 */ 
	public $PointsAccrued;


  
 
}



/**
 * 
 */
class EnhancedCheckoutDataType  
   extends PPXmlMessage{


  
 
}



/**
 * 
 */
class EnhancedPaymentDataType  
   extends PPXmlMessage{


  
 
}



/**
 * 
 */
class EnhancedItemDataType  
   extends PPXmlMessage{


  
 
}



/**
 * 
 */
class EnhancedPaymentInfoType  
   extends PPXmlMessage{


}



/**
 * 
 */
class EnhancedInitiateRecoupRequestDetailsType  
   extends PPXmlMessage{


  
 
}



/**
 * 
 */
class EnhancedCompleteRecoupRequestDetailsType  
   extends PPXmlMessage{


  
 
}



/**
 * 
 */
class EnhancedCompleteRecoupResponseDetailsType  
   extends PPXmlMessage{


}



/**
 * 
 */
class EnhancedCancelRecoupRequestDetailsType  
   extends PPXmlMessage{


  
 
}



/**
 * 
 */
class EnhancedPayerInfoType  
   extends PPXmlMessage{


  
 
}



/**
 * Installment Period. Optional 
 */
class InstallmentDetailsType  
   extends PPXmlMessage{

	/**
	 * Installment Period. Optional 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $BillingPeriod;

	/**
	 * Installment Frequency. Optional 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var integer 	 
	 */ 
	public $BillingFrequency;

	/**
	 * Installment Cycles. Optional 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var integer 	 
	 */ 
	public $TotalBillingCycles;

	/**
	 * Installment Amount. Optional 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Amount;

	/**
	 * Installment Amount. Optional 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ShippingAmount;

	/**
	 * Installment Amount. Optional 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $TaxAmount;


  
 
}



/**
 * Option Selection. Required Character length and limitations:
 * 12 single-byte alphanumeric characters 
 */
class OptionSelectionDetailsType  
   extends PPXmlMessage{

	/**
	 * Option Selection. Required Character length and limitations:
	 * 12 single-byte alphanumeric characters 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $OptionSelection;

	/**
	 * Option Price. Optional 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Price;

	/**
	 * Option Type Optional 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $OptionType;

	/**
	 * 
     * @array
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var InstallmentDetailsType 	 
	 */ 
	public $PaymentPeriod;

	/**
	 * Constructor with arguments
	 */
	public function __construct($OptionSelection = NULL) {
		$this->OptionSelection = $OptionSelection;
	}


  
 
}



/**
 * Option Name. Optional 
 */
class OptionDetailsType  
   extends PPXmlMessage{

	/**
	 * Option Name. Optional 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $OptionName;

	/**
	 * 
     * @array
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var OptionSelectionDetailsType 	 
	 */ 
	public $OptionSelectionDetails;

	/**
	 * Constructor with arguments
	 */
	public function __construct($OptionName = NULL) {
		$this->OptionName = $OptionName;
	}


  
 
}



/**
 * 
 */
class BMCreateButtonReq  
   extends PPXmlMessage{

	/**
	 * 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var BMCreateButtonRequestType 	 
	 */ 
	public $BMCreateButtonRequest;


	public function toXMLString()
	{
		    $str = '';
			$str .= '<ns:BMCreateButtonReq>';
			if($this->BMCreateButtonRequest != NULL)
			{
		   		$str .= '<ns:BMCreateButtonRequest>';
				$str .= $this->BMCreateButtonRequest->toXMLString();
				$str .= '</ns:BMCreateButtonRequest>';
			}
			$str .= '</ns:BMCreateButtonReq>';
			return $str;
	}
  
 
}



/**
 * Type of Button to create.  Required Must be one of the
 * following: BUYNOW, CART, GIFTCERTIFICATE. SUBSCRIBE,
 * PAYMENTPLAN, AUTOBILLING, DONATE, VIEWCART or UNSUBSCRIBE  
 */
class BMCreateButtonRequestType  extends AbstractRequestType  
  {

	/**
	 * Type of Button to create.  Required Must be one of the
	 * following: BUYNOW, CART, GIFTCERTIFICATE. SUBSCRIBE,
	 * PAYMENTPLAN, AUTOBILLING, DONATE, VIEWCART or UNSUBSCRIBE 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ButtonType;

	/**
	 * button code.  optional Must be one of the following: hosted,
	 * encrypted or cleartext 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ButtonCode;

	/**
	 * Button sub type.  optional for button types buynow and cart
	 * only Must Be either PRODUCTS or SERVICES 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ButtonSubType;

	/**
	 * Button Variable information  At least one required recurring
	 * Character length and limitations: 63 single-byte
	 * alphanumeric characters 
     * @array
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ButtonVar;

	/**
	 * 
     * @array
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var OptionDetailsType 	 
	 */ 
	public $OptionDetails;

	/**
	 * Details of each option for the button.  Optional 
     * @array
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $TextBox;

	/**
	 * Button image to use.  Optional Must be one of: REG, SML, or
	 * CC 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ButtonImage;

	/**
	 * Button URL for custom button image.  Optional Character
	 * length and limitations: 127 single-byte alphanumeric
	 * characters 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ButtonImageURL;

	/**
	 * Text to use on Buy Now Button.  Optional Must be either
	 * BUYNOW or PAYNOW 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $BuyNowText;

	/**
	 * Text to use on Subscribe button.  Optional Must be either
	 * BUYNOW or SUBSCRIBE 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $SubscribeText;

	/**
	 * Button Country.  Optional Must be valid ISO country code 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ButtonCountry;

	/**
	 * Button language code.  Optional Character length and
	 * limitations: 3 single-byte alphanumeric characters 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ButtonLanguage;


  
	public function toXMLString()
	{
		$flag = 0;
		foreach($this->ButtonVar as $var){
			if(strpos($var, 'bn=') !== FALSE){
     			$flag = 1;
				break;
			}
		}
		if(!$flag){
		    array_push($this->ButtonVar, "bn=PayPal_SDK");
		}
		return parent::toXMLString();
	}
 
}



/**
 * 
 */
class BMCreateButtonResponseType  extends AbstractResponseType  
  {

	/**
	 * 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Website;

	/**
	 * 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Email;

	/**
	 * 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Mobile;

	/**
	 * 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $HostedButtonID;


}



/**
 * 
 */
class BMUpdateButtonReq  
   extends PPXmlMessage{

	/**
	 * 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var BMUpdateButtonRequestType 	 
	 */ 
	public $BMUpdateButtonRequest;


	public function toXMLString()
	{
		    $str = '';
			$str .= '<ns:BMUpdateButtonReq>';
			if($this->BMUpdateButtonRequest != NULL)
			{
		   		$str .= '<ns:BMUpdateButtonRequest>';
				$str .= $this->BMUpdateButtonRequest->toXMLString();
				$str .= '</ns:BMUpdateButtonRequest>';
			}
			$str .= '</ns:BMUpdateButtonReq>';
			return $str;
	}
  
 
}



/**
 * Hosted Button id of the button to update.  Required
 * Character length and limitations: 10 single-byte numeric
 * characters  
 */
class BMUpdateButtonRequestType  extends AbstractRequestType  
  {

	/**
	 * Hosted Button id of the button to update.  Required
	 * Character length and limitations: 10 single-byte numeric
	 * characters 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $HostedButtonID;

	/**
	 * Type of Button to create.  Required Must be one of the
	 * following: BUYNOW, CART, GIFTCERTIFICATE. SUBSCRIBE,
	 * PAYMENTPLAN, AUTOBILLING, DONATE, VIEWCART or UNSUBSCRIBE 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ButtonType;

	/**
	 * button code.  optional Must be one of the following: hosted,
	 * encrypted or cleartext 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ButtonCode;

	/**
	 * Button sub type.  optional for button types buynow and cart
	 * only Must Be either PRODUCTS or SERVICES 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ButtonSubType;

	/**
	 * Button Variable information  At least one required recurring
	 * Character length and limitations: 63 single-byte
	 * alphanumeric characters 
     * @array
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ButtonVar;

	/**
	 * 
     * @array
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var OptionDetailsType 	 
	 */ 
	public $OptionDetails;

	/**
	 * Details of each option for the button.  Optional 
     * @array
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $TextBox;

	/**
	 * Button image to use.  Optional Must be one of: REG, SML, or
	 * CC 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ButtonImage;

	/**
	 * Button URL for custom button image.  Optional Character
	 * length and limitations: 127 single-byte alphanumeric
	 * characters 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ButtonImageURL;

	/**
	 * Text to use on Buy Now Button.  Optional Must be either
	 * BUYNOW or PAYNOW 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $BuyNowText;

	/**
	 * Text to use on Subscribe button.  Optional Must be either
	 * BUYNOW or SUBSCRIBE 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $SubscribeText;

	/**
	 * Button Country.  Optional Must be valid ISO country code 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ButtonCountry;

	/**
	 * Button language code.  Optional Character length and
	 * limitations: 2 single-byte alphanumeric characters 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ButtonLanguage;

	/**
	 * Constructor with arguments
	 */
	public function __construct($HostedButtonID = NULL) {
		$this->HostedButtonID = $HostedButtonID;
	}


  
	public function toXMLString()
	{
		$flag = 0;
		foreach($this->ButtonVar as $var){
			if(strpos($var, 'bn=') !== FALSE){
     			$flag = 1;
				break;
			}
		}
		if(!$flag){
		    array_push($this->ButtonVar, "bn=PayPal_SDK");
		}
		return parent::toXMLString();
	}
 
}



/**
 * 
 */
class BMUpdateButtonResponseType  extends AbstractResponseType  
  {

	/**
	 * 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Website;

	/**
	 * 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Email;

	/**
	 * 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Mobile;

	/**
	 * 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $HostedButtonID;


}



/**
 * 
 */
class BMManageButtonStatusReq  
   extends PPXmlMessage{

	/**
	 * 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var BMManageButtonStatusRequestType 	 
	 */ 
	public $BMManageButtonStatusRequest;


	public function toXMLString()
	{
		    $str = '';
			$str .= '<ns:BMManageButtonStatusReq>';
			if($this->BMManageButtonStatusRequest != NULL)
			{
		   		$str .= '<ns:BMManageButtonStatusRequest>';
				$str .= $this->BMManageButtonStatusRequest->toXMLString();
				$str .= '</ns:BMManageButtonStatusRequest>';
			}
			$str .= '</ns:BMManageButtonStatusReq>';
			return $str;
	}
  
 
}



/**
 * Button ID of Hosted button.  Required Character length and
 * limitations: 10 single-byte numeric characters  
 */
class BMManageButtonStatusRequestType  extends AbstractRequestType  
  {

	/**
	 * Button ID of Hosted button.  Required Character length and
	 * limitations: 10 single-byte numeric characters 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $HostedButtonID;

	/**
	 * Requested Status change for hosted button.  Required
	 * Character length and limitations: 1 single-byte alphanumeric
	 * characters 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ButtonStatus;


  
 
}



/**
 * 
 */
class BMManageButtonStatusResponseType  extends AbstractResponseType  
  {


}



/**
 * 
 */
class BMGetButtonDetailsReq  
   extends PPXmlMessage{

	/**
	 * 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var BMGetButtonDetailsRequestType 	 
	 */ 
	public $BMGetButtonDetailsRequest;


	public function toXMLString()
	{
		    $str = '';
			$str .= '<ns:BMGetButtonDetailsReq>';
			if($this->BMGetButtonDetailsRequest != NULL)
			{
		   		$str .= '<ns:BMGetButtonDetailsRequest>';
				$str .= $this->BMGetButtonDetailsRequest->toXMLString();
				$str .= '</ns:BMGetButtonDetailsRequest>';
			}
			$str .= '</ns:BMGetButtonDetailsReq>';
			return $str;
	}
  
 
}



/**
 * Button ID of button to return.  Required Character length
 * and limitations: 10 single-byte numeric characters  
 */
class BMGetButtonDetailsRequestType  extends AbstractRequestType  
  {

	/**
	 * Button ID of button to return.  Required Character length
	 * and limitations: 10 single-byte numeric characters 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $HostedButtonID;

	/**
	 * Constructor with arguments
	 */
	public function __construct($HostedButtonID = NULL) {
		$this->HostedButtonID = $HostedButtonID;
	}


  
 
}



/**
 * Type of button. One of the following: BUYNOW, CART,
 * GIFTCERTIFICATE. SUBSCRIBE, PAYMENTPLAN, AUTOBILLING,
 * DONATE, VIEWCART or UNSUBSCRIBE 
 */
class BMGetButtonDetailsResponseType  extends AbstractResponseType  
  {

	/**
	 * 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Website;

	/**
	 * 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Email;

	/**
	 * 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Mobile;

	/**
	 * 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $HostedButtonID;

	/**
	 * Type of button. One of the following: BUYNOW, CART,
	 * GIFTCERTIFICATE. SUBSCRIBE, PAYMENTPLAN, AUTOBILLING,
	 * DONATE, VIEWCART or UNSUBSCRIBE 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ButtonType;

	/**
	 * Type of button code. One of the following: hosted, encrypted
	 * or cleartext 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ButtonCode;

	/**
	 * Button sub type. optional for button types buynow and cart
	 * only Either PRODUCTS or SERVICES 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ButtonSubType;

	/**
	 * Button Variable information Character length and
	 * limitations: 63 single-byte alphanumeric characters 
     * @array
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ButtonVar;

	/**
	 * 
     * @array
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var OptionDetailsType 	 
	 */ 
	public $OptionDetails;

	/**
	 * Text field 
     * @array
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $TextBox;

	/**
	 * Button image to use. One of: REG, SML, or CC 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ButtonImage;

	/**
	 * Button URL for custom button image. 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ButtonImageURL;

	/**
	 * Text to use on Buy Now Button. Either BUYNOW or PAYNOW 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $BuyNowText;

	/**
	 * Text to use on Subscribe button. Must be either BUYNOW or
	 * SUBSCRIBE 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $SubscribeText;

	/**
	 * Button Country. Valid ISO country code or 'International' 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ButtonCountry;

	/**
	 * Button language code. Character length and limitations: 3
	 * single-byte alphanumeric characters 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ButtonLanguage;


}



/**
 * 
 */
class BMSetInventoryReq  
   extends PPXmlMessage{

	/**
	 * 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var BMSetInventoryRequestType 	 
	 */ 
	public $BMSetInventoryRequest;


	public function toXMLString()
	{
		    $str = '';
			$str .= '<ns:BMSetInventoryReq>';
			if($this->BMSetInventoryRequest != NULL)
			{
		   		$str .= '<ns:BMSetInventoryRequest>';
				$str .= $this->BMSetInventoryRequest->toXMLString();
				$str .= '</ns:BMSetInventoryRequest>';
			}
			$str .= '</ns:BMSetInventoryReq>';
			return $str;
	}
  
 
}



/**
 * Hosted Button ID of button you wish to change.  Required
 * Character length and limitations: 10 single-byte numeric
 * characters  
 */
class BMSetInventoryRequestType  extends AbstractRequestType  
  {

	/**
	 * Hosted Button ID of button you wish to change.  Required
	 * Character length and limitations: 10 single-byte numeric
	 * characters 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $HostedButtonID;

	/**
	 * Is Inventory tracked.  Required 0 or 1 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $TrackInv;

	/**
	 * Is PNL Tracked.  Required 0 or 1 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $TrackPnl;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var ItemTrackingDetailsType 	 
	 */ 
	public $ItemTrackingDetails;

	/**
	 * Option Index.  Optional Character length and limitations: 1
	 * single-byte alphanumeric characters 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $OptionIndex;

	/**
	 * 
     * @array
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var OptionTrackingDetailsType 	 
	 */ 
	public $OptionTrackingDetails;

	/**
	 * URL of page to display when an item is soldout.  Optional
	 * Character length and limitations: 127 single-byte
	 * alphanumeric characters 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $SoldoutURL;

	/**
	 * Whether to use the same digital download key repeatedly. 
	 * Optional 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ReuseDigitalDownloadKeys;

	/**
	 * Whether to append these keys to the list or not (replace). 
	 * Optional 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $AppendDigitalDownloadKeys;

	/**
	 * Zero or more digital download keys to distribute to
	 * customers after transaction is completed.  Optional
	 * Character length and limitations: 1000 single-byte
	 * alphanumeric characters 
     * @array
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $DigitalDownloadKeys;

	/**
	 * Constructor with arguments
	 */
	public function __construct($HostedButtonID = NULL, $TrackInv = NULL, $TrackPnl = NULL) {
		$this->HostedButtonID = $HostedButtonID;
		$this->TrackInv = $TrackInv;
		$this->TrackPnl = $TrackPnl;
	}


  
 
}



/**
 * 
 */
class BMSetInventoryResponseType  extends AbstractResponseType  
  {


}



/**
 * 
 */
class BMGetInventoryReq  
   extends PPXmlMessage{

	/**
	 * 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var BMGetInventoryRequestType 	 
	 */ 
	public $BMGetInventoryRequest;


	public function toXMLString()
	{
		    $str = '';
			$str .= '<ns:BMGetInventoryReq>';
			if($this->BMGetInventoryRequest != NULL)
			{
		   		$str .= '<ns:BMGetInventoryRequest>';
				$str .= $this->BMGetInventoryRequest->toXMLString();
				$str .= '</ns:BMGetInventoryRequest>';
			}
			$str .= '</ns:BMGetInventoryReq>';
			return $str;
	}
  
 
}



/**
 * Hosted Button ID of the button to return inventory for. 
 * Required Character length and limitations: 10 single-byte
 * numeric characters  
 */
class BMGetInventoryRequestType  extends AbstractRequestType  
  {

	/**
	 * Hosted Button ID of the button to return inventory for. 
	 * Required Character length and limitations: 10 single-byte
	 * numeric characters 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $HostedButtonID;

	/**
	 * Constructor with arguments
	 */
	public function __construct($HostedButtonID = NULL) {
		$this->HostedButtonID = $HostedButtonID;
	}


  
 
}



/**
 * 
 */
class BMGetInventoryResponseType  extends AbstractResponseType  
  {

	/**
	 * 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $HostedButtonID;

	/**
	 * 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $TrackInv;

	/**
	 * 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $TrackPnl;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var ItemTrackingDetailsType 	 
	 */ 
	public $ItemTrackingDetails;

	/**
	 * 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $OptionIndex;

	/**
	 * 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $OptionName;

	/**
	 * 
     * @array
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var OptionTrackingDetailsType 	 
	 */ 
	public $OptionTrackingDetails;

	/**
	 * 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $SoldoutURL;

	/**
	 * 
     * @array
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $DigitalDownloadKeys;


}



/**
 * 
 */
class BMButtonSearchReq  
   extends PPXmlMessage{

	/**
	 * 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var BMButtonSearchRequestType 	 
	 */ 
	public $BMButtonSearchRequest;


	public function toXMLString()
	{
		    $str = '';
			$str .= '<ns:BMButtonSearchReq>';
			if($this->BMButtonSearchRequest != NULL)
			{
		   		$str .= '<ns:BMButtonSearchRequest>';
				$str .= $this->BMButtonSearchRequest->toXMLString();
				$str .= '</ns:BMButtonSearchRequest>';
			}
			$str .= '</ns:BMButtonSearchReq>';
			return $str;
	}
  
 
}



/**
 * The earliest transaction date at which to start the search.
 * No wildcards are allowed. Required 
 */
class BMButtonSearchRequestType  extends AbstractRequestType  
  {

	/**
	 * The earliest transaction date at which to start the search.
	 * No wildcards are allowed. Required 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var dateTime 	 
	 */ 
	public $StartDate;

	/**
	 * The latest transaction date to be included in the search
	 * Optional 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var dateTime 	 
	 */ 
	public $EndDate;


  
 
}



/**
 * 
 */
class BMButtonSearchResponseType  extends AbstractResponseType  
  {

	/**
	 * 
     * @array
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var ButtonSearchResultType 	 
	 */ 
	public $ButtonSearchResult;


}



/**
 * 
 */
class RefundTransactionReq  
   extends PPXmlMessage{

	/**
	 * 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var RefundTransactionRequestType 	 
	 */ 
	public $RefundTransactionRequest;


	public function toXMLString()
	{
		    $str = '';
			$str .= '<ns:RefundTransactionReq>';
			if($this->RefundTransactionRequest != NULL)
			{
		   		$str .= '<ns:RefundTransactionRequest>';
				$str .= $this->RefundTransactionRequest->toXMLString();
				$str .= '</ns:RefundTransactionRequest>';
			}
			$str .= '</ns:RefundTransactionReq>';
			return $str;
	}
  
 
}



/**
 * Unique identifier of the transaction you are refunding.
 * Optional Character length and limitations: 17 single-byte
 * alphanumeric characters 
 */
class RefundTransactionRequestType  extends AbstractRequestType  
  {

	/**
	 * Unique identifier of the transaction you are refunding.
	 * Optional Character length and limitations: 17 single-byte
	 * alphanumeric characters 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $TransactionID;

	/**
	 * Encrypted PayPal customer account identification number.
	 * Optional Character length and limitations: 127 single-byte
	 * alphanumeric characters
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $PayerID;

	/**
	 * Invoice number corresponding to transaction details for
	 * tracking the refund of a payment. This parameter is passed
	 * by the merchant or recipient while refunding the
	 * transaction. This parameter does not affect the business
	 * logic, it is persisted in the DB for transaction reference
	 * Optional 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $InvoiceID;

	/**
	 * Type of refund you are making Required 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $RefundType;

	/**
	 * Refund amount. Amount is required if RefundType is Partial.
	 * NOTE: If RefundType is Full, do not set Amount.
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var BasicAmountType 	 
	 */ 
	public $Amount;

	/**
	 * Custom memo about the refund. Optional Character length and
	 * limitations: 255 single-byte alphanumeric characters
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Memo;

	/**
	 * The maximum time till which refund must be tried. Optional 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var dateTime 	 
	 */ 
	public $RetryUntil;

	/**
	 * The type of funding source for refund. Optional 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $RefundSource;

	/**
	 * Flag to indicate that the customer was already given store
	 * credit for a given transaction. This will allow us to make
	 * sure we do not double refund. Optional 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var boolean 	 
	 */ 
	public $RefundAdvice;

	/**
	 * To pass the Merchant store informationOptional 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var MerchantStoreDetailsType 	 
	 */ 
	public $MerchantStoreDetails;

	/**
	 * Information about the individual details of the items to be
	 * refunded.Optional 
     * @array
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var InvoiceItemType 	 
	 */ 
	public $RefundItemDetails;

	/**
	 * Unique id for each API request to prevent duplicate
	 * payments. Optional Character length and limits: 38
	 * single-byte characters maximum. 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $MsgSubID;


  
 
}



/**
 * Unique transaction ID of the refund. Character length and
 * limitations:17 single-byte characters 
 */
class RefundTransactionResponseType  extends AbstractResponseType  
  {

	/**
	 * Unique transaction ID of the refund. Character length and
	 * limitations:17 single-byte characters
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $RefundTransactionID;

	/**
	 * Amount subtracted from PayPal balance of original recipient
	 * of payment to make this refund 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var BasicAmountType 	 
	 */ 
	public $NetRefundAmount;

	/**
	 * Transaction fee refunded to original recipient of payment 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var BasicAmountType 	 
	 */ 
	public $FeeRefundAmount;

	/**
	 * Amount of money refunded to original payer 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var BasicAmountType 	 
	 */ 
	public $GrossRefundAmount;

	/**
	 * Total of all previous refunds
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var BasicAmountType 	 
	 */ 
	public $TotalRefundedAmount;

	/**
	 * Contains Refund Payment status information.
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var RefundInfoType 	 
	 */ 
	public $RefundInfo;

	/**
	 * Any general information like offer details that is
	 * reinstated or any other marketing data
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ReceiptData;

	/**
	 * Return msgsubid back to merchant
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $MsgSubID;


}



/**
 * 
 */
class InitiateRecoupReq  
   extends PPXmlMessage{

	/**
	 * 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var InitiateRecoupRequestType 	 
	 */ 
	public $InitiateRecoupRequest;


	public function toXMLString()
	{
		    $str = '';
			$str .= '<ns:InitiateRecoupReq>';
			if($this->InitiateRecoupRequest != NULL)
			{
		   		$str .= '<ns:InitiateRecoupRequest>';
				$str .= $this->InitiateRecoupRequest->toXMLString();
				$str .= '</ns:InitiateRecoupRequest>';
			}
			$str .= '</ns:InitiateRecoupReq>';
			return $str;
	}
  
 
}



/**
 * 
 */
class InitiateRecoupRequestType  extends AbstractRequestType  
  {

	/**
	 * 
	 * @access public
	 
	 * @namespace ed
	 
	 	 	 	 
	 * @var EnhancedInitiateRecoupRequestDetailsType 	 
	 */ 
	public $EnhancedInitiateRecoupRequestDetails;

	/**
	 * Constructor with arguments
	 */
	public function __construct($EnhancedInitiateRecoupRequestDetails = NULL) {
		$this->EnhancedInitiateRecoupRequestDetails = $EnhancedInitiateRecoupRequestDetails;
	}


  
 
}



/**
 * 
 */
class InitiateRecoupResponseType  extends AbstractResponseType  
  {


}



/**
 * 
 */
class CompleteRecoupReq  
   extends PPXmlMessage{

	/**
	 * 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var CompleteRecoupRequestType 	 
	 */ 
	public $CompleteRecoupRequest;


	public function toXMLString()
	{
		    $str = '';
			$str .= '<ns:CompleteRecoupReq>';
			if($this->CompleteRecoupRequest != NULL)
			{
		   		$str .= '<ns:CompleteRecoupRequest>';
				$str .= $this->CompleteRecoupRequest->toXMLString();
				$str .= '</ns:CompleteRecoupRequest>';
			}
			$str .= '</ns:CompleteRecoupReq>';
			return $str;
	}
  
 
}



/**
 * 
 */
class CompleteRecoupRequestType  extends AbstractRequestType  
  {

	/**
	 * 
	 * @access public
	 
	 * @namespace ed
	 
	 	 	 	 
	 * @var EnhancedCompleteRecoupRequestDetailsType 	 
	 */ 
	public $EnhancedCompleteRecoupRequestDetails;

	/**
	 * Constructor with arguments
	 */
	public function __construct($EnhancedCompleteRecoupRequestDetails = NULL) {
		$this->EnhancedCompleteRecoupRequestDetails = $EnhancedCompleteRecoupRequestDetails;
	}


  
 
}



/**
 * 
 */
class CompleteRecoupResponseType  extends AbstractResponseType  
  {

	/**
	 * 
	 * @access public
	 
	 * @namespace ed
	 
	 	 	 	 
	 * @var EnhancedCompleteRecoupResponseDetailsType 	 
	 */ 
	public $EnhancedCompleteRecoupResponseDetails;


}



/**
 * 
 */
class CancelRecoupReq  
   extends PPXmlMessage{

	/**
	 * 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var CancelRecoupRequestType 	 
	 */ 
	public $CancelRecoupRequest;


	public function toXMLString()
	{
		    $str = '';
			$str .= '<ns:CancelRecoupReq>';
			if($this->CancelRecoupRequest != NULL)
			{
		   		$str .= '<ns:CancelRecoupRequest>';
				$str .= $this->CancelRecoupRequest->toXMLString();
				$str .= '</ns:CancelRecoupRequest>';
			}
			$str .= '</ns:CancelRecoupReq>';
			return $str;
	}
  
 
}



/**
 * 
 */
class CancelRecoupRequestType  extends AbstractRequestType  
  {

	/**
	 * 
	 * @access public
	 
	 * @namespace ed
	 
	 	 	 	 
	 * @var EnhancedCancelRecoupRequestDetailsType 	 
	 */ 
	public $EnhancedCancelRecoupRequestDetails;

	/**
	 * Constructor with arguments
	 */
	public function __construct($EnhancedCancelRecoupRequestDetails = NULL) {
		$this->EnhancedCancelRecoupRequestDetails = $EnhancedCancelRecoupRequestDetails;
	}


  
 
}



/**
 * 
 */
class CancelRecoupResponseType  extends AbstractResponseType  
  {


}



/**
 * 
 */
class GetTransactionDetailsReq  
   extends PPXmlMessage{

	/**
	 * 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var GetTransactionDetailsRequestType 	 
	 */ 
	public $GetTransactionDetailsRequest;


	public function toXMLString()
	{
		    $str = '';
			$str .= '<ns:GetTransactionDetailsReq>';
			if($this->GetTransactionDetailsRequest != NULL)
			{
		   		$str .= '<ns:GetTransactionDetailsRequest>';
				$str .= $this->GetTransactionDetailsRequest->toXMLString();
				$str .= '</ns:GetTransactionDetailsRequest>';
			}
			$str .= '</ns:GetTransactionDetailsReq>';
			return $str;
	}
  
 
}



/**
 * Unique identifier of a transaction. RequiredThe details for
 * some kinds of transactions cannot be retrieved with
 * GetTransactionDetailsRequest. You cannot obtain details of
 * bank transfer withdrawals, for example. Character length and
 * limitations: 17 single-byte alphanumeric characters
 */
class GetTransactionDetailsRequestType  extends AbstractRequestType  
  {

	/**
	 * Unique identifier of a transaction. RequiredThe details for
	 * some kinds of transactions cannot be retrieved with
	 * GetTransactionDetailsRequest. You cannot obtain details of
	 * bank transfer withdrawals, for example. Character length and
	 * limitations: 17 single-byte alphanumeric characters
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $TransactionID;


  
 
}



/**
 * 
 */
class GetTransactionDetailsResponseType  extends AbstractResponseType  
  {

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var PaymentTransactionType 	 
	 */ 
	public $PaymentTransactionDetails;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var ThreeDSecureInfoType 	 
	 */ 
	public $ThreeDSecureDetails;


}



/**
 * 
 */
class BillUserReq  
   extends PPXmlMessage{

	/**
	 * 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var BillUserRequestType 	 
	 */ 
	public $BillUserRequest;


	public function toXMLString()
	{
		    $str = '';
			$str .= '<ns:BillUserReq>';
			if($this->BillUserRequest != NULL)
			{
		   		$str .= '<ns:BillUserRequest>';
				$str .= $this->BillUserRequest->toXMLString();
				$str .= '</ns:BillUserRequest>';
			}
			$str .= '</ns:BillUserReq>';
			return $str;
	}
  
 
}



/**
 * This flag indicates that the response should include
 * FMFDetails 
 */
class BillUserRequestType  extends AbstractRequestType  
  {

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var MerchantPullPaymentType 	 
	 */ 
	public $MerchantPullPaymentDetails;

	/**
	 * This flag indicates that the response should include
	 * FMFDetails
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var integer 	 
	 */ 
	public $ReturnFMFDetails;


  
 
}



/**
 * 
 */
class BillUserResponseType  extends AbstractResponseType  
  {

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var MerchantPullPaymentResponseType 	 
	 */ 
	public $BillUserResponseDetails;

	/**
	 * 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var FMFDetailsType 	 
	 */ 
	public $FMFDetails;


}



/**
 * 
 */
class TransactionSearchReq  
   extends PPXmlMessage{

	/**
	 * 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var TransactionSearchRequestType 	 
	 */ 
	public $TransactionSearchRequest;


	public function toXMLString()
	{
		    $str = '';
			$str .= '<ns:TransactionSearchReq>';
			if($this->TransactionSearchRequest != NULL)
			{
		   		$str .= '<ns:TransactionSearchRequest>';
				$str .= $this->TransactionSearchRequest->toXMLString();
				$str .= '</ns:TransactionSearchRequest>';
			}
			$str .= '</ns:TransactionSearchReq>';
			return $str;
	}
  
 
}



/**
 * The earliest transaction date at which to start the search.
 * No wildcards are allowed. Required
 */
class TransactionSearchRequestType  extends AbstractRequestType  
  {

	/**
	 * The earliest transaction date at which to start the search.
	 * No wildcards are allowed. Required
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var dateTime 	 
	 */ 
	public $StartDate;

	/**
	 * The latest transaction date to be included in the search
	 * Optional
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var dateTime 	 
	 */ 
	public $EndDate;

	/**
	 * Search by the buyer's email address OptionalCharacter length
	 * and limitations: 127 single-byte alphanumeric characters
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Payer;

	/**
	 * Search by the receiver's email address. If the merchant
	 * account has only one email, this is the primary email. Can
	 * also be a non-primary email.Optional
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Receiver;

	/**
	 * Search by the PayPal Account Optional receipt IDOptional
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ReceiptID;

	/**
	 * Search by the transaction ID. OptionalThe returned results
	 * are from the merchant's transaction records. Character
	 * length and limitations: 19 single-byte characters maximum
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $TransactionID;

	/**
	 * Search by Recurring Payment Profile id. The ProfileID is
	 * returned as part of the CreateRecurringPaymentsProfile API
	 * response. Optional
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ProfileID;

	/**
	 * Search by the buyer's name OptionalSalutation: 20
	 * single-byte character limit.FirstName: 25 single-byte
	 * character limit.MiddleName: 25 single-byte character
	 * limit.LastName: 25 single-byte character limit.Suffix: 12
	 * single-byte character limit.
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var PersonNameType 	 
	 */ 
	public $PayerName;

	/**
	 * Search by item number of the purchased goods.OptionalTo
	 * search for purchased items not related to auctions, set the
	 * AuctionItemNumber element to the value of the HTML
	 * item_number variable set in the shopping cart for the
	 * original transaction.
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $AuctionItemNumber;

	/**
	 * Search by invoice identification key, as set by you for the
	 * original transaction. InvoiceID searches the invoice records
	 * for items sold by the merchant, not the items purchased.
	 * OptionalThe value for InvoiceID must exactly match an
	 * invoice identification number. No wildcards are allowed.
	 * Character length and limitations: 127 single-byte characters
	 * maximum
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $InvoiceID;

	/**
	 * 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $CardNumber;

	/**
	 * Search by classification of transaction. Some kinds of
	 * possible classes of transactions are not searchable with
	 * TransactionSearchRequest. You cannot search for bank
	 * transfer withdrawals, for example. OptionalAll: all
	 * transaction classifications.Sent: only payments
	 * sent.Received: only payments received.MassPay: only mass
	 * payments.MoneyRequest: only money requests.FundsAdded: only
	 * funds added to balance.FundsWithdrawn: only funds withdrawn
	 * from balance.Referral: only transactions involving
	 * referrals.Fee: only transactions involving
	 * fees.Subscription: only transactions involving
	 * subscriptions.Dividend: only transactions involving
	 * dividends.Billpay: only transactions involving BillPay
	 * Transactions.Refund: only transactions involving
	 * funds.CurrencyConversions: only transactions involving
	 * currency conversions.BalanceTransfer: only transactions
	 * involving balance transfers.Reversal: only transactions
	 * involving BillPay reversals.Shipping: only transactions
	 * involving UPS shipping fees.BalanceAffecting: only
	 * transactions that affect the account balance.ECheck: only
	 * transactions involving eCheckForcedPostTransaction: forced
	 * post transaction.NonReferencedRefunds: non-referenced
	 * refunds.
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $TransactionClass;

	/**
	 * Search by transaction amount OptionalYou must set the
	 * currencyID attribute to one of the three-character currency
	 * codes for any of the supported PayPal currencies. 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var BasicAmountType 	 
	 */ 
	public $Amount;

	/**
	 * Search by currency codeOptional
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $CurrencyCode;

	/**
	 * Search by transaction status OptionalPending: The payment is
	 * pending. The specific reason the payment is pending is
	 * returned by the GetTransactionDetails APIPendingReason
	 * element. For more information, see PendingReason.Processing:
	 * The payment is being processed.Success: The payment has been
	 * completed and the funds have been added successfully to your
	 * account balance.Denied: You denied the payment. This happens
	 * only if the payment was previously pending.Reversed: A
	 * payment was reversed due to a chargeback or other type of
	 * reversal. The funds have been removed from your account
	 * balance and returned to the buyer.
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Status;

	/**
	 * Constructor with arguments
	 */
	public function __construct($StartDate = NULL) {
		$this->StartDate = $StartDate;
	}


  
 
}



/**
 * Results of a Transaction Search.
 */
class TransactionSearchResponseType  extends AbstractResponseType  
  {

	/**
	 * Results of a Transaction Search.
     * @array
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var PaymentTransactionSearchResultType 	 
	 */ 
	public $PaymentTransactions;


}



/**
 * 
 */
class MassPayReq  
   extends PPXmlMessage{

	/**
	 * 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var MassPayRequestType 	 
	 */ 
	public $MassPayRequest;


	public function toXMLString()
	{
		    $str = '';
			$str .= '<ns:MassPayReq>';
			if($this->MassPayRequest != NULL)
			{
		   		$str .= '<ns:MassPayRequest>';
				$str .= $this->MassPayRequest->toXMLString();
				$str .= '</ns:MassPayRequest>';
			}
			$str .= '</ns:MassPayReq>';
			return $str;
	}
  
 
}



/**
 * Subject line of the email sent to all recipients. This
 * subject is not contained in the input file; you must create
 * it with your application. Optional Character length and
 * limitations: 255 single-byte alphanumeric characters 
 */
class MassPayRequestType  extends AbstractRequestType  
  {

	/**
	 * Subject line of the email sent to all recipients. This
	 * subject is not contained in the input file; you must create
	 * it with your application. Optional Character length and
	 * limitations: 255 single-byte alphanumeric characters
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $EmailSubject;

	/**
	 * Indicates how you identify the recipients of payments in all
	 * MassPayItems: either by EmailAddress (ReceiverEmail in
	 * MassPayItem), PhoneNumber (ReceiverPhone in MassPayItem), or
	 * by UserID (ReceiverID in MassPayItem). Required. You must
	 * specify one or the other of EmailAddress or UserID.
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ReceiverType;

	/**
	 * Known as BN code, to track the partner referred merchant
	 * transactions. OptionalCharacter length and limitations: 32
	 * single-byte alphanumeric characters
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ButtonSource = "PayPal_SDK";

	/**
	 * Details of each payment. A single MassPayRequest can include
	 * up to 250 MassPayItems. Required 
     * @array
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var MassPayRequestItemType 	 
	 */ 
	public $MassPayItem;

	/**
	 * Constructor with arguments
	 */
	public function __construct($MassPayItem = NULL) {
		$this->MassPayItem = $MassPayItem;
	}


  
 
}



/**
 * 
 */
class MassPayResponseType  extends AbstractResponseType  
  {


}



/**
 * MassPayRequestItemType 
 */
class MassPayRequestItemType  
   extends PPXmlMessage{

	/**
	 * Email address of recipient. Required You must specify
	 * ReceiverEmail, ReceiverPhone, or ReceiverID, but all
	 * MassPayItems in a request must use the same field to specify
	 * recipients. Character length and limitations: 127
	 * single-byte characters maximum.
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ReceiverEmail;

	/**
	 * Phone number of recipient. Required You must specify
	 * ReceiverEmail, ReceiverPhone, or ReceiverID, but all
	 * MassPayItems in a request must use the same field to specify
	 * recipients.
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ReceiverPhone;

	/**
	 * Unique PayPal customer account number. This value
	 * corresponds to the value of PayerID returned by
	 * GetTransactionDetails. Required You must specify
	 * ReceiverEmail, ReceiverPhone, or ReceiverID, but all
	 * MassPayItems in a request must use the same field to specify
	 * recipients. Character length and limitations: 17 single-byte
	 * characters maximum.
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ReceiverID;

	/**
	 * Payment amount. You must set the currencyID attribute to one
	 * of the three-character currency codes for any of the
	 * supported PayPal currencies. Required You cannot mix
	 * currencies in a single MassPayRequest. A single request must
	 * include items that are of the same currency.
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var BasicAmountType 	 
	 */ 
	public $Amount;

	/**
	 * Transaction-specific identification number for tracking in
	 * an accounting system. Optional Character length and
	 * limitations: 30 single-byte characters. No whitespace
	 * allowed.
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $UniqueId;

	/**
	 * Custom note for each recipient. Optional Character length
	 * and limitations: 4,000 single-byte alphanumeric characters
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Note;

	/**
	 * Constructor with arguments
	 */
	public function __construct($Amount = NULL) {
		$this->Amount = $Amount;
	}


  
 
}



/**
 * 
 */
class BillAgreementUpdateReq  
   extends PPXmlMessage{

	/**
	 * 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var BAUpdateRequestType 	 
	 */ 
	public $BAUpdateRequest;


	public function toXMLString()
	{
		    $str = '';
			$str .= '<ns:BillAgreementUpdateReq>';
			if($this->BAUpdateRequest != NULL)
			{
		   		$str .= '<ns:BAUpdateRequest>';
				$str .= $this->BAUpdateRequest->toXMLString();
				$str .= '</ns:BAUpdateRequest>';
			}
			$str .= '</ns:BillAgreementUpdateReq>';
			return $str;
	}
  
 
}



/**
 * 
 */
class BAUpdateRequestType  extends AbstractRequestType  
  {

	/**
	 * 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ReferenceID;

	/**
	 * 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $BillingAgreementDescription;

	/**
	 * 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $BillingAgreementStatus;

	/**
	 * 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $BillingAgreementCustom;

	/**
	 * Constructor with arguments
	 */
	public function __construct($ReferenceID = NULL) {
		$this->ReferenceID = $ReferenceID;
	}


  
 
}



/**
 * 
 */
class BAUpdateResponseType  extends AbstractResponseType  
  {

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var BAUpdateResponseDetailsType 	 
	 */ 
	public $BAUpdateResponseDetails;


}



/**
 * 
 */
class AddressVerifyReq  
   extends PPXmlMessage{

	/**
	 * 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var AddressVerifyRequestType 	 
	 */ 
	public $AddressVerifyRequest;


	public function toXMLString()
	{
		    $str = '';
			$str .= '<ns:AddressVerifyReq>';
			if($this->AddressVerifyRequest != NULL)
			{
		   		$str .= '<ns:AddressVerifyRequest>';
				$str .= $this->AddressVerifyRequest->toXMLString();
				$str .= '</ns:AddressVerifyRequest>';
			}
			$str .= '</ns:AddressVerifyReq>';
			return $str;
	}
  
 
}



/**
 * Email address of buyer to be verified. Required Maximum
 * string length: 255 single-byte characters Input mask: ?@?.??
 * 
 */
class AddressVerifyRequestType  extends AbstractRequestType  
  {

	/**
	 * Email address of buyer to be verified. Required Maximum
	 * string length: 255 single-byte characters Input mask: ?@?.??
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Email;

	/**
	 * First line of buyer’s billing or shipping street address
	 * to be verified. Required For verification, input value of
	 * street address must match the first three single-byte
	 * characters of the street address on file for the PayPal
	 * account. Maximum string length: 35 single-byte characters
	 * Alphanumeric plus - , . ‘ # \ Whitespace and case of input
	 * value are ignored.
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Street;

	/**
	 * Postal code to be verified. Required For verification, input
	 * value of postal code must match the first five single-byte
	 * characters of the postal code on file for the PayPal
	 * account. Maximum string length: 16 single-byte characters
	 * Whitespace and case of input value are ignored.
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Zip;

	/**
	 * Constructor with arguments
	 */
	public function __construct($Email = NULL, $Street = NULL, $Zip = NULL) {
		$this->Email = $Email;
		$this->Street = $Street;
		$this->Zip = $Zip;
	}


  
 
}



/**
 * Confirmation of a match, with one of the following tokens:
 * None: The input value of the Email object does not match any
 * email address on file at PayPal. Confirmed: If the value of
 * the StreetMatch object is Matched, PayPal responds that the
 * entire postal address is confirmed. Unconfirmed: PayPal
 * responds that the postal address is unconfirmed 
 */
class AddressVerifyResponseType  extends AbstractResponseType  
  {

	/**
	 * Confirmation of a match, with one of the following tokens:
	 * None: The input value of the Email object does not match any
	 * email address on file at PayPal. Confirmed: If the value of
	 * the StreetMatch object is Matched, PayPal responds that the
	 * entire postal address is confirmed. Unconfirmed: PayPal
	 * responds that the postal address is unconfirmed
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ConfirmationCode;

	/**
	 * PayPal has compared the postal address you want to verify
	 * with the postal address on file at PayPal. None: The input
	 * value of the Email object does not match any email address
	 * on file at PayPal. In addition, an error response is
	 * returned. No further comparison of other input values has
	 * been made. Matched: The street address matches the street
	 * address on file at PayPal. Unmatched: The street address
	 * does not match the street address on file at PayPal. 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $StreetMatch;

	/**
	 * PayPal has compared the zip code you want to verify with the
	 * zip code on file for the email address. None: The street
	 * address was unmatched. No further comparison of other input
	 * values has been made. Matched: The zip code matches the zip
	 * code on file at PayPal. Unmatched: The zip code does not
	 * match the zip code on file at PayPal. 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ZipMatch;

	/**
	 * Two-character country code (ISO 3166) on file for the PayPal
	 * email address. 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $CountryCode;

	/**
	 * The token prevents a buyer from using any street address
	 * other than the address on file at PayPal during additional
	 * purchases he might make from the merchant. It contains
	 * encrypted information about the user’s street address and
	 * email address. You can pass the value of the token with the
	 * Buy Now button HTML address_api_token variable so that
	 * PayPal prevents the buyer from using any street address or
	 * email address other than those verified by PayPal. The token
	 * is valid for 24 hours. Character length and limitations: 94
	 * single-byte characters 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $PayPalToken;


}



/**
 * 
 */
class EnterBoardingReq  
   extends PPXmlMessage{

	/**
	 * 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var EnterBoardingRequestType 	 
	 */ 
	public $EnterBoardingRequest;


	public function toXMLString()
	{
		    $str = '';
			$str .= '<ns:EnterBoardingReq>';
			if($this->EnterBoardingRequest != NULL)
			{
		   		$str .= '<ns:EnterBoardingRequest>';
				$str .= $this->EnterBoardingRequest->toXMLString();
				$str .= '</ns:EnterBoardingRequest>';
			}
			$str .= '</ns:EnterBoardingReq>';
			return $str;
	}
  
 
}



/**
 * 
 */
class EnterBoardingRequestType  extends AbstractRequestType  
  {

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var EnterBoardingRequestDetailsType 	 
	 */ 
	public $EnterBoardingRequestDetails;

	/**
	 * Constructor with arguments
	 */
	public function __construct($EnterBoardingRequestDetails = NULL) {
		$this->EnterBoardingRequestDetails = $EnterBoardingRequestDetails;
	}


  
 
}



/**
 * A unique token that identifies this boarding session. Use
 * this token with the GetBoarding Details API call.Character
 * length and limitations: 64 alphanumeric characters. The
 * token has the following format:OB-61characterstring
 */
class EnterBoardingResponseType  extends AbstractResponseType  
  {

	/**
	 * A unique token that identifies this boarding session. Use
	 * this token with the GetBoarding Details API call.Character
	 * length and limitations: 64 alphanumeric characters. The
	 * token has the following format:OB-61characterstring
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Token;


}



/**
 * 
 */
class GetBoardingDetailsReq  
   extends PPXmlMessage{

	/**
	 * 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var GetBoardingDetailsRequestType 	 
	 */ 
	public $GetBoardingDetailsRequest;


	public function toXMLString()
	{
		    $str = '';
			$str .= '<ns:GetBoardingDetailsReq>';
			if($this->GetBoardingDetailsRequest != NULL)
			{
		   		$str .= '<ns:GetBoardingDetailsRequest>';
				$str .= $this->GetBoardingDetailsRequest->toXMLString();
				$str .= '</ns:GetBoardingDetailsRequest>';
			}
			$str .= '</ns:GetBoardingDetailsReq>';
			return $str;
	}
  
 
}



/**
 * A unique token returned by the EnterBoarding API call that
 * identifies this boarding session. RequiredCharacter length
 * and limitations: 64 alphanumeric characters. The token has
 * the following format:OB-61characterstring
 */
class GetBoardingDetailsRequestType  extends AbstractRequestType  
  {

	/**
	 * A unique token returned by the EnterBoarding API call that
	 * identifies this boarding session. RequiredCharacter length
	 * and limitations: 64 alphanumeric characters. The token has
	 * the following format:OB-61characterstring
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Token;

	/**
	 * Constructor with arguments
	 */
	public function __construct($Token = NULL) {
		$this->Token = $Token;
	}


  
 
}



/**
 * 
 */
class GetBoardingDetailsResponseType  extends AbstractResponseType  
  {

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var GetBoardingDetailsResponseDetailsType 	 
	 */ 
	public $GetBoardingDetailsResponseDetails;


}



/**
 * 
 */
class SetAuthFlowParamReq  
   extends PPXmlMessage{

	/**
	 * 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var SetAuthFlowParamRequestType 	 
	 */ 
	public $SetAuthFlowParamRequest;


	public function toXMLString()
	{
		    $str = '';
			$str .= '<ns:SetAuthFlowParamReq>';
			if($this->SetAuthFlowParamRequest != NULL)
			{
		   		$str .= '<ns:SetAuthFlowParamRequest>';
				$str .= $this->SetAuthFlowParamRequest->toXMLString();
				$str .= '</ns:SetAuthFlowParamRequest>';
			}
			$str .= '</ns:SetAuthFlowParamReq>';
			return $str;
	}
  
 
}



/**
 * 
 */
class SetAuthFlowParamRequestType  extends AbstractRequestType  
  {

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var SetAuthFlowParamRequestDetailsType 	 
	 */ 
	public $SetAuthFlowParamRequestDetails;

	/**
	 * Constructor with arguments
	 */
	public function __construct($SetAuthFlowParamRequestDetails = NULL) {
		$this->SetAuthFlowParamRequestDetails = $SetAuthFlowParamRequestDetails;
	}


  
 
}



/**
 * A timestamped token by which you identify to PayPal that you
 * are processing this user. The token expires after three
 * hours. Character length and limitations: 20 single-byte
 * characters
 */
class SetAuthFlowParamResponseType  extends AbstractResponseType  
  {

	/**
	 * A timestamped token by which you identify to PayPal that you
	 * are processing this user. The token expires after three
	 * hours. Character length and limitations: 20 single-byte
	 * characters
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Token;


}



/**
 * 
 */
class GetAuthDetailsReq  
   extends PPXmlMessage{

	/**
	 * 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var GetAuthDetailsRequestType 	 
	 */ 
	public $GetAuthDetailsRequest;


	public function toXMLString()
	{
		    $str = '';
			$str .= '<ns:GetAuthDetailsReq>';
			if($this->GetAuthDetailsRequest != NULL)
			{
		   		$str .= '<ns:GetAuthDetailsRequest>';
				$str .= $this->GetAuthDetailsRequest->toXMLString();
				$str .= '</ns:GetAuthDetailsRequest>';
			}
			$str .= '</ns:GetAuthDetailsReq>';
			return $str;
	}
  
 
}



/**
 * A timestamped token, the value of which was returned by
 * SetAuthFlowParam Response. RequiredCharacter length and
 * limitations: 20 single-byte characters
 */
class GetAuthDetailsRequestType  extends AbstractRequestType  
  {

	/**
	 * A timestamped token, the value of which was returned by
	 * SetAuthFlowParam Response. RequiredCharacter length and
	 * limitations: 20 single-byte characters
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Token;

	/**
	 * Constructor with arguments
	 */
	public function __construct($Token = NULL) {
		$this->Token = $Token;
	}


  
 
}



/**
 * 
 */
class GetAuthDetailsResponseType  extends AbstractResponseType  
  {

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var GetAuthDetailsResponseDetailsType 	 
	 */ 
	public $GetAuthDetailsResponseDetails;


}



/**
 * 
 */
class SetAccessPermissionsReq  
   extends PPXmlMessage{

	/**
	 * 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var SetAccessPermissionsRequestType 	 
	 */ 
	public $SetAccessPermissionsRequest;


	public function toXMLString()
	{
		    $str = '';
			$str .= '<ns:SetAccessPermissionsReq>';
			if($this->SetAccessPermissionsRequest != NULL)
			{
		   		$str .= '<ns:SetAccessPermissionsRequest>';
				$str .= $this->SetAccessPermissionsRequest->toXMLString();
				$str .= '</ns:SetAccessPermissionsRequest>';
			}
			$str .= '</ns:SetAccessPermissionsReq>';
			return $str;
	}
  
 
}



/**
 * 
 */
class SetAccessPermissionsRequestType  extends AbstractRequestType  
  {

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var SetAccessPermissionsRequestDetailsType 	 
	 */ 
	public $SetAccessPermissionsRequestDetails;

	/**
	 * Constructor with arguments
	 */
	public function __construct($SetAccessPermissionsRequestDetails = NULL) {
		$this->SetAccessPermissionsRequestDetails = $SetAccessPermissionsRequestDetails;
	}


  
 
}



/**
 * A timestamped token by which you identify to PayPal that you
 * are processing this user. The token expires after three
 * hours. Character length and limitations: 20 single-byte
 * characters
 */
class SetAccessPermissionsResponseType  extends AbstractResponseType  
  {

	/**
	 * A timestamped token by which you identify to PayPal that you
	 * are processing this user. The token expires after three
	 * hours. Character length and limitations: 20 single-byte
	 * characters
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Token;


}



/**
 * 
 */
class UpdateAccessPermissionsReq  
   extends PPXmlMessage{

	/**
	 * 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var UpdateAccessPermissionsRequestType 	 
	 */ 
	public $UpdateAccessPermissionsRequest;


	public function toXMLString()
	{
		    $str = '';
			$str .= '<ns:UpdateAccessPermissionsReq>';
			if($this->UpdateAccessPermissionsRequest != NULL)
			{
		   		$str .= '<ns:UpdateAccessPermissionsRequest>';
				$str .= $this->UpdateAccessPermissionsRequest->toXMLString();
				$str .= '</ns:UpdateAccessPermissionsRequest>';
			}
			$str .= '</ns:UpdateAccessPermissionsReq>';
			return $str;
	}
  
 
}



/**
 * Unique PayPal customer account number, the value of which
 * was returned by GetAuthDetails Response. Required Character
 * length and limitations: 20 single-byte characters 
 */
class UpdateAccessPermissionsRequestType  extends AbstractRequestType  
  {

	/**
	 * Unique PayPal customer account number, the value of which
	 * was returned by GetAuthDetails Response. Required Character
	 * length and limitations: 20 single-byte characters 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $PayerID;

	/**
	 * Constructor with arguments
	 */
	public function __construct($PayerID = NULL) {
		$this->PayerID = $PayerID;
	}


  
 
}



/**
 * The status of the update call, Success/Failure. Character
 * length and limitations: 20 single-byte characters 
 */
class UpdateAccessPermissionsResponseType  extends AbstractResponseType  
  {

	/**
	 * The status of the update call, Success/Failure. Character
	 * length and limitations: 20 single-byte characters 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Status;


}



/**
 * 
 */
class GetAccessPermissionDetailsReq  
   extends PPXmlMessage{

	/**
	 * 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var GetAccessPermissionDetailsRequestType 	 
	 */ 
	public $GetAccessPermissionDetailsRequest;


	public function toXMLString()
	{
		    $str = '';
			$str .= '<ns:GetAccessPermissionDetailsReq>';
			if($this->GetAccessPermissionDetailsRequest != NULL)
			{
		   		$str .= '<ns:GetAccessPermissionDetailsRequest>';
				$str .= $this->GetAccessPermissionDetailsRequest->toXMLString();
				$str .= '</ns:GetAccessPermissionDetailsRequest>';
			}
			$str .= '</ns:GetAccessPermissionDetailsReq>';
			return $str;
	}
  
 
}



/**
 * A timestamped token, the value of which was returned by
 * SetAuthFlowParam Response. Required Character length and
 * limitations: 20 single-byte characters 
 */
class GetAccessPermissionDetailsRequestType  extends AbstractRequestType  
  {

	/**
	 * A timestamped token, the value of which was returned by
	 * SetAuthFlowParam Response. Required Character length and
	 * limitations: 20 single-byte characters 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Token;

	/**
	 * Constructor with arguments
	 */
	public function __construct($Token = NULL) {
		$this->Token = $Token;
	}


  
 
}



/**
 * 
 */
class GetAccessPermissionDetailsResponseType  extends AbstractResponseType  
  {

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var GetAccessPermissionDetailsResponseDetailsType 	 
	 */ 
	public $GetAccessPermissionDetailsResponseDetails;


}



/**
 * 
 */
class GetIncentiveEvaluationReq  
   extends PPXmlMessage{

	/**
	 * 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var GetIncentiveEvaluationRequestType 	 
	 */ 
	public $GetIncentiveEvaluationRequest;


	public function toXMLString()
	{
		    $str = '';
			$str .= '<ns:GetIncentiveEvaluationReq>';
			if($this->GetIncentiveEvaluationRequest != NULL)
			{
		   		$str .= '<ns:GetIncentiveEvaluationRequest>';
				$str .= $this->GetIncentiveEvaluationRequest->toXMLString();
				$str .= '</ns:GetIncentiveEvaluationRequest>';
			}
			$str .= '</ns:GetIncentiveEvaluationReq>';
			return $str;
	}
  
 
}



/**
 * 
 */
class GetIncentiveEvaluationRequestType  extends AbstractRequestType  
  {

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var GetIncentiveEvaluationRequestDetailsType 	 
	 */ 
	public $GetIncentiveEvaluationRequestDetails;

	/**
	 * Constructor with arguments
	 */
	public function __construct($GetIncentiveEvaluationRequestDetails = NULL) {
		$this->GetIncentiveEvaluationRequestDetails = $GetIncentiveEvaluationRequestDetails;
	}


  
 
}



/**
 * 
 */
class GetIncentiveEvaluationResponseType  extends AbstractResponseType  
  {

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var GetIncentiveEvaluationResponseDetailsType 	 
	 */ 
	public $GetIncentiveEvaluationResponseDetails;


}



/**
 * 
 */
class SetExpressCheckoutReq  
   extends PPXmlMessage{

	/**
	 * 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var SetExpressCheckoutRequestType 	 
	 */ 
	public $SetExpressCheckoutRequest;


	public function toXMLString()
	{
		    $str = '';
			$str .= '<ns:SetExpressCheckoutReq>';
			if($this->SetExpressCheckoutRequest != NULL)
			{
		   		$str .= '<ns:SetExpressCheckoutRequest>';
				$str .= $this->SetExpressCheckoutRequest->toXMLString();
				$str .= '</ns:SetExpressCheckoutRequest>';
			}
			$str .= '</ns:SetExpressCheckoutReq>';
			return $str;
	}
  
 
}



/**
 * 
 */
class SetExpressCheckoutRequestType  extends AbstractRequestType  
  {

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var SetExpressCheckoutRequestDetailsType 	 
	 */ 
	public $SetExpressCheckoutRequestDetails;

	/**
	 * Constructor with arguments
	 */
	public function __construct($SetExpressCheckoutRequestDetails = NULL) {
		$this->SetExpressCheckoutRequestDetails = $SetExpressCheckoutRequestDetails;
	}


  
 
}



/**
 * A timestamped token by which you identify to PayPal that you
 * are processing this payment with Express Checkout. The token
 * expires after three hours. If you set Token in the
 * SetExpressCheckoutRequest, the value of Token in the
 * response is identical to the value in the request. Character
 * length and limitations: 20 single-byte characters
 */
class SetExpressCheckoutResponseType  extends AbstractResponseType  
  {

	/**
	 * A timestamped token by which you identify to PayPal that you
	 * are processing this payment with Express Checkout. The token
	 * expires after three hours. If you set Token in the
	 * SetExpressCheckoutRequest, the value of Token in the
	 * response is identical to the value in the request. Character
	 * length and limitations: 20 single-byte characters
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Token;


}



/**
 * 
 */
class ExecuteCheckoutOperationsReq  
   extends PPXmlMessage{

	/**
	 * 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var ExecuteCheckoutOperationsRequestType 	 
	 */ 
	public $ExecuteCheckoutOperationsRequest;


	public function toXMLString()
	{
		    $str = '';
			$str .= '<ns:ExecuteCheckoutOperationsReq>';
			if($this->ExecuteCheckoutOperationsRequest != NULL)
			{
		   		$str .= '<ns:ExecuteCheckoutOperationsRequest>';
				$str .= $this->ExecuteCheckoutOperationsRequest->toXMLString();
				$str .= '</ns:ExecuteCheckoutOperationsRequest>';
			}
			$str .= '</ns:ExecuteCheckoutOperationsReq>';
			return $str;
	}
  
 
}



/**
 * 
 */
class ExecuteCheckoutOperationsRequestType  extends AbstractRequestType  
  {

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var ExecuteCheckoutOperationsRequestDetailsType 	 
	 */ 
	public $ExecuteCheckoutOperationsRequestDetails;

	/**
	 * Constructor with arguments
	 */
	public function __construct($ExecuteCheckoutOperationsRequestDetails = NULL) {
		$this->ExecuteCheckoutOperationsRequestDetails = $ExecuteCheckoutOperationsRequestDetails;
	}


  
 
}



/**
 * 
 */
class ExecuteCheckoutOperationsResponseType  extends AbstractResponseType  
  {

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var ExecuteCheckoutOperationsResponseDetailsType 	 
	 */ 
	public $ExecuteCheckoutOperationsResponseDetails;


}



/**
 * 
 */
class GetExpressCheckoutDetailsReq  
   extends PPXmlMessage{

	/**
	 * 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var GetExpressCheckoutDetailsRequestType 	 
	 */ 
	public $GetExpressCheckoutDetailsRequest;


	public function toXMLString()
	{
		    $str = '';
			$str .= '<ns:GetExpressCheckoutDetailsReq>';
			if($this->GetExpressCheckoutDetailsRequest != NULL)
			{
		   		$str .= '<ns:GetExpressCheckoutDetailsRequest>';
				$str .= $this->GetExpressCheckoutDetailsRequest->toXMLString();
				$str .= '</ns:GetExpressCheckoutDetailsRequest>';
			}
			$str .= '</ns:GetExpressCheckoutDetailsReq>';
			return $str;
	}
  
 
}



/**
 * A timestamped token, the value of which was returned by
 * SetExpressCheckoutResponse. RequiredCharacter length and
 * limitations: 20 single-byte characters
 */
class GetExpressCheckoutDetailsRequestType  extends AbstractRequestType  
  {

	/**
	 * A timestamped token, the value of which was returned by
	 * SetExpressCheckoutResponse. RequiredCharacter length and
	 * limitations: 20 single-byte characters
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Token;

	/**
	 * Constructor with arguments
	 */
	public function __construct($Token = NULL) {
		$this->Token = $Token;
	}


  
 
}



/**
 * 
 */
class GetExpressCheckoutDetailsResponseType  extends AbstractResponseType  
  {

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var GetExpressCheckoutDetailsResponseDetailsType 	 
	 */ 
	public $GetExpressCheckoutDetailsResponseDetails;


}



/**
 * 
 */
class DoExpressCheckoutPaymentReq  
   extends PPXmlMessage{

	/**
	 * 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var DoExpressCheckoutPaymentRequestType 	 
	 */ 
	public $DoExpressCheckoutPaymentRequest;


	public function toXMLString()
	{
		    $str = '';
			$str .= '<ns:DoExpressCheckoutPaymentReq>';
			if($this->DoExpressCheckoutPaymentRequest != NULL)
			{
		   		$str .= '<ns:DoExpressCheckoutPaymentRequest>';
				$str .= $this->DoExpressCheckoutPaymentRequest->toXMLString();
				$str .= '</ns:DoExpressCheckoutPaymentRequest>';
			}
			$str .= '</ns:DoExpressCheckoutPaymentReq>';
			return $str;
	}
  
 
}



/**
 * This flag indicates that the response should include
 * FMFDetails 
 */
class DoExpressCheckoutPaymentRequestType  extends AbstractRequestType  
  {

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var DoExpressCheckoutPaymentRequestDetailsType 	 
	 */ 
	public $DoExpressCheckoutPaymentRequestDetails;

	/**
	 * This flag indicates that the response should include
	 * FMFDetails
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var integer 	 
	 */ 
	public $ReturnFMFDetails;

	/**
	 * Constructor with arguments
	 */
	public function __construct($DoExpressCheckoutPaymentRequestDetails = NULL) {
		$this->DoExpressCheckoutPaymentRequestDetails = $DoExpressCheckoutPaymentRequestDetails;
	}


  
 
}



/**
 * 
 */
class DoExpressCheckoutPaymentResponseType  extends AbstractResponseType  
  {

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var DoExpressCheckoutPaymentResponseDetailsType 	 
	 */ 
	public $DoExpressCheckoutPaymentResponseDetails;

	/**
	 * 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var FMFDetailsType 	 
	 */ 
	public $FMFDetails;


}



/**
 * 
 */
class DoUATPExpressCheckoutPaymentReq  
   extends PPXmlMessage{

	/**
	 * 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var DoUATPExpressCheckoutPaymentRequestType 	 
	 */ 
	public $DoUATPExpressCheckoutPaymentRequest;


	public function toXMLString()
	{
		    $str = '';
			$str .= '<ns:DoUATPExpressCheckoutPaymentReq>';
			if($this->DoUATPExpressCheckoutPaymentRequest != NULL)
			{
		   		$str .= '<ns:DoUATPExpressCheckoutPaymentRequest>';
				$str .= $this->DoUATPExpressCheckoutPaymentRequest->toXMLString();
				$str .= '</ns:DoUATPExpressCheckoutPaymentRequest>';
			}
			$str .= '</ns:DoUATPExpressCheckoutPaymentReq>';
			return $str;
	}
  
 
}



/**
 * 
 */
class DoUATPExpressCheckoutPaymentRequestType  extends DoExpressCheckoutPaymentRequestType  
  {


  
 
}



/**
 * 
 */
class DoUATPExpressCheckoutPaymentResponseType  extends DoExpressCheckoutPaymentResponseType  
  {

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var UATPDetailsType 	 
	 */ 
	public $UATPDetails;


}



/**
 * 
 */
class ManagePendingTransactionStatusReq  
   extends PPXmlMessage{

	/**
	 * 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var ManagePendingTransactionStatusRequestType 	 
	 */ 
	public $ManagePendingTransactionStatusRequest;


	public function toXMLString()
	{
		    $str = '';
			$str .= '<ns:ManagePendingTransactionStatusReq>';
			if($this->ManagePendingTransactionStatusRequest != NULL)
			{
		   		$str .= '<ns:ManagePendingTransactionStatusRequest>';
				$str .= $this->ManagePendingTransactionStatusRequest->toXMLString();
				$str .= '</ns:ManagePendingTransactionStatusRequest>';
			}
			$str .= '</ns:ManagePendingTransactionStatusReq>';
			return $str;
	}
  
 
}



/**
 * 
 */
class ManagePendingTransactionStatusRequestType  extends AbstractRequestType  
  {

	/**
	 * 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $TransactionID;

	/**
	 * 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Action;

	/**
	 * Constructor with arguments
	 */
	public function __construct($TransactionID = NULL, $Action = NULL) {
		$this->TransactionID = $TransactionID;
		$this->Action = $Action;
	}


  
 
}



/**
 * 
 */
class ManagePendingTransactionStatusResponseType  extends AbstractResponseType  
  {

	/**
	 * 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $TransactionID;

	/**
	 * 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Status;


}



/**
 * 
 */
class DoDirectPaymentReq  
   extends PPXmlMessage{

	/**
	 * 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var DoDirectPaymentRequestType 	 
	 */ 
	public $DoDirectPaymentRequest;


	public function toXMLString()
	{
		    $str = '';
			$str .= '<ns:DoDirectPaymentReq>';
			if($this->DoDirectPaymentRequest != NULL)
			{
		   		$str .= '<ns:DoDirectPaymentRequest>';
				$str .= $this->DoDirectPaymentRequest->toXMLString();
				$str .= '</ns:DoDirectPaymentRequest>';
			}
			$str .= '</ns:DoDirectPaymentReq>';
			return $str;
	}
  
 
}



/**
 * This flag indicates that the response should include
 * FMFDetails 
 */
class DoDirectPaymentRequestType  extends AbstractRequestType  
  {

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var DoDirectPaymentRequestDetailsType 	 
	 */ 
	public $DoDirectPaymentRequestDetails;

	/**
	 * This flag indicates that the response should include
	 * FMFDetails
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var integer 	 
	 */ 
	public $ReturnFMFDetails;

	/**
	 * Constructor with arguments
	 */
	public function __construct($DoDirectPaymentRequestDetails = NULL) {
		$this->DoDirectPaymentRequestDetails = $DoDirectPaymentRequestDetails;
	}


  
 
}



/**
 * The amount of the payment as specified by you on
 * DoDirectPaymentRequest.
 */
class DoDirectPaymentResponseType  extends AbstractResponseType  
  {

	/**
	 * The amount of the payment as specified by you on
	 * DoDirectPaymentRequest.
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var BasicAmountType 	 
	 */ 
	public $Amount;

	/**
	 * Address Verification System response code. Character limit:
	 * One single-byte alphanumeric character AVS
	 * CodeMeaningMatched Details A AddressAddress only (no ZIP) B
	 * International “A”Address only (no ZIP) CInternational
	 * “N” None DInternational “X” Address and Postal Code
	 * E Not allowed for MOTO (Internet/Phone) transactions Not
	 * applicable F UK-specific “X”Address and Postal Code G
	 * Global Unavailable Not applicable I International
	 * UnavailableNot applicable N NoNone PPostal (International
	 * “Z”)Postal Code only (no Address) RRetryNot applicable S
	 * Service not Supported Not applicable U UnavailableNot
	 * applicable W Whole ZIPNine-digit ZIP code (no Address) X
	 * Exact match Address and nine-digit ZIP code Y YesAddress and
	 * five-digit ZIP Z ZIP Five-digit ZIP code (no Address) All
	 * others Error Not applicable
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $AVSCode;

	/**
	 * Result of the CVV2 check by PayPal. CVV2 CodeMeaningMatched
	 * Details M MatchCVV2 N No match None P Not ProcessedNot
	 * applicable SService not SupportedNot applicable U
	 * UnavailableNot applicable XNo response Not applicable All
	 * others ErrorNot applicable 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $CVV2Code;

	/**
	 * Transaction identification number. Character length and
	 * limitations: 19 characters maximum.
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $TransactionID;

	/**
	 * The reason why a particular transaction went in pending. 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $PendingReason;

	/**
	 * This will identify the actual transaction status. 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $PaymentStatus;

	/**
	 * 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var FMFDetailsType 	 
	 */ 
	public $FMFDetails;

	/**
	 * 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var ThreeDSecureResponseType 	 
	 */ 
	public $ThreeDSecureResponse;

	/**
	 * Response code from the processor when a recurring
	 * transaction is declined.  
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $PaymentAdviceCode;


}



/**
 * 
 */
class DoCancelReq  
   extends PPXmlMessage{

	/**
	 * 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var DoCancelRequestType 	 
	 */ 
	public $DoCancelRequest;


	public function toXMLString()
	{
		    $str = '';
			$str .= '<ns:DoCancelReq>';
			if($this->DoCancelRequest != NULL)
			{
		   		$str .= '<ns:DoCancelRequest>';
				$str .= $this->DoCancelRequest->toXMLString();
				$str .= '</ns:DoCancelRequest>';
			}
			$str .= '</ns:DoCancelReq>';
			return $str;
	}
  
 
}



/**
 * Msg Sub Id that was used for the orginal operation. 
 */
class DoCancelRequestType  extends AbstractRequestType  
  {

	/**
	 * Msg Sub Id that was used for the orginal operation. 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $CancelMsgSubID;

	/**
	 * Original API's type
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $APIType;

	/**
	 * Unique id for each API request to prevent duplicate
	 * payments. Optional Character length and limits: 38
	 * single-byte characters maximum. 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $MsgSubID;

	/**
	 * Constructor with arguments
	 */
	public function __construct($CancelMsgSubID = NULL, $APIType = NULL) {
		$this->CancelMsgSubID = $CancelMsgSubID;
		$this->APIType = $APIType;
	}


  
 
}



/**
 * Return msgsubid back to merchant 
 */
class DoCancelResponseType  extends AbstractResponseType  
  {

	/**
	 * Return msgsubid back to merchant
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $MsgSubID;


}



/**
 * 
 */
class DoCaptureReq  
   extends PPXmlMessage{

	/**
	 * 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var DoCaptureRequestType 	 
	 */ 
	public $DoCaptureRequest;


	public function toXMLString()
	{
		    $str = '';
			$str .= '<ns:DoCaptureReq>';
			if($this->DoCaptureRequest != NULL)
			{
		   		$str .= '<ns:DoCaptureRequest>';
				$str .= $this->DoCaptureRequest->toXMLString();
				$str .= '</ns:DoCaptureRequest>';
			}
			$str .= '</ns:DoCaptureReq>';
			return $str;
	}
  
 
}



/**
 * The authorization identification number of the payment you
 * want to capture. Required Character length and limits: 19
 * single-byte characters maximum 
 */
class DoCaptureRequestType  extends AbstractRequestType  
  {

	/**
	 * The authorization identification number of the payment you
	 * want to capture. Required Character length and limits: 19
	 * single-byte characters maximum
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $AuthorizationID;

	/**
	 * Amount to authorize. You must set the currencyID attribute
	 * to USD. Required Limitations: Must not exceed $10,000 USD in
	 * any currency. No currency symbol. Decimal separator must be
	 * a period (.), and the thousands separator must be a comma
	 * (,)
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var BasicAmountType 	 
	 */ 
	public $Amount;

	/**
	 * Indicates if this capture is the last capture you intend to
	 * make. The default is Complete. If CompleteType is Complete,
	 * any remaining amount of the original reauthorized
	 * transaction is automatically voided. Required Character
	 * length and limits: 12 single-byte alphanumeric characters
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $CompleteType;

	/**
	 * An informational note about this settlement that is
	 * displayed to the payer in email and in transaction history.
	 * Optional Character length and limits: 255 single-byte
	 * characters
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Note;

	/**
	 * Your invoice number or other identification number. The
	 * InvoiceID value is recorded only if the authorization you
	 * are capturing is an order authorization, not a basic
	 * authorization. Optional Character length and limits: 127
	 * single-byte alphanumeric characters
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $InvoiceID;

	/**
	 * Contains enhanced data like airline itinerary information.
	 * Not Required 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var EnhancedDataType 	 
	 */ 
	public $EnhancedData;

	/**
	 * dynamic descriptor Dynamic descriptor is used for merchant
	 * to provide detail of a transaction appears on statement
	 * Optional Character length and limits: <18 characters
	 * alphanumeric characters
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Descriptor;

	/**
	 * To pass the Merchant store informationOptional 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var MerchantStoreDetailsType 	 
	 */ 
	public $MerchantStoreDetails;

	/**
	 * Unique id for each API request to prevent duplicate
	 * payments. Optional Character length and limits: 38
	 * single-byte characters maximum. 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $MsgSubID;

	/**
	 * This holds key-value pair which merchants wants to pass it
	 * to the open wallet-PLCC processorOptional 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var MerchantDataType 	 
	 */ 
	public $MerchantData;

	/**
	 * Constructor with arguments
	 */
	public function __construct($AuthorizationID = NULL, $Amount = NULL, $CompleteType = NULL) {
		$this->AuthorizationID = $AuthorizationID;
		$this->Amount = $Amount;
		$this->CompleteType = $CompleteType;
	}


  
 
}



/**
 * 
 */
class DoCaptureResponseType  extends AbstractResponseType  
  {

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var DoCaptureResponseDetailsType 	 
	 */ 
	public $DoCaptureResponseDetails;


}



/**
 * 
 */
class DoReauthorizationReq  
   extends PPXmlMessage{

	/**
	 * 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var DoReauthorizationRequestType 	 
	 */ 
	public $DoReauthorizationRequest;


	public function toXMLString()
	{
		    $str = '';
			$str .= '<ns:DoReauthorizationReq>';
			if($this->DoReauthorizationRequest != NULL)
			{
		   		$str .= '<ns:DoReauthorizationRequest>';
				$str .= $this->DoReauthorizationRequest->toXMLString();
				$str .= '</ns:DoReauthorizationRequest>';
			}
			$str .= '</ns:DoReauthorizationReq>';
			return $str;
	}
  
 
}



/**
 * The value of a previously authorized transaction
 * identification number returned by a PayPal product. You can
 * obtain a buyer's transaction number from the TransactionID
 * element of the PayerInfo structure returned by
 * GetTransactionDetailsResponse. Required Character length and
 * limits: 19 single-byte characters maximum 
 */
class DoReauthorizationRequestType  extends AbstractRequestType  
  {

	/**
	 * The value of a previously authorized transaction
	 * identification number returned by a PayPal product. You can
	 * obtain a buyer's transaction number from the TransactionID
	 * element of the PayerInfo structure returned by
	 * GetTransactionDetailsResponse. Required Character length and
	 * limits: 19 single-byte characters maximum
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $AuthorizationID;

	/**
	 * Amount to reauthorize. Required Limitations: Must not exceed
	 * $10,000 USD in any currency. No currency symbol. Decimal
	 * separator must be a period (.), and the thousands separator
	 * must be a comma (,).
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var BasicAmountType 	 
	 */ 
	public $Amount;

	/**
	 * Unique id for each API request to prevent duplicate
	 * payments. Optional Character length and limits: 38
	 * single-byte characters maximum. 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $MsgSubID;

	/**
	 * Constructor with arguments
	 */
	public function __construct($AuthorizationID = NULL, $Amount = NULL) {
		$this->AuthorizationID = $AuthorizationID;
		$this->Amount = $Amount;
	}


  
 
}



/**
 * A new authorization identification number. Character length
 * and limits: 19 single-byte characters 
 */
class DoReauthorizationResponseType  extends AbstractResponseType  
  {

	/**
	 * A new authorization identification number. Character length
	 * and limits: 19 single-byte characters 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $AuthorizationID;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var AuthorizationInfoType 	 
	 */ 
	public $AuthorizationInfo;

	/**
	 * Return msgsubid back to merchant
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $MsgSubID;


}



/**
 * 
 */
class DoVoidReq  
   extends PPXmlMessage{

	/**
	 * 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var DoVoidRequestType 	 
	 */ 
	public $DoVoidRequest;


	public function toXMLString()
	{
		    $str = '';
			$str .= '<ns:DoVoidReq>';
			if($this->DoVoidRequest != NULL)
			{
		   		$str .= '<ns:DoVoidRequest>';
				$str .= $this->DoVoidRequest->toXMLString();
				$str .= '</ns:DoVoidRequest>';
			}
			$str .= '</ns:DoVoidReq>';
			return $str;
	}
  
 
}



/**
 * The value of the original authorization identification
 * number returned by a PayPal product. If you are voiding a
 * transaction that has been reauthorized, use the ID from the
 * original authorization, and not the reauthorization.
 * Required Character length and limits: 19 single-byte
 * characters 
 */
class DoVoidRequestType  extends AbstractRequestType  
  {

	/**
	 * The value of the original authorization identification
	 * number returned by a PayPal product. If you are voiding a
	 * transaction that has been reauthorized, use the ID from the
	 * original authorization, and not the reauthorization.
	 * Required Character length and limits: 19 single-byte
	 * characters
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $AuthorizationID;

	/**
	 * An informational note about this settlement that is
	 * displayed to the payer in email and in transaction history.
	 * Optional Character length and limits: 255 single-byte
	 * characters
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Note;

	/**
	 * Unique id for each API request to prevent duplicate
	 * payments. Optional Character length and limits: 38
	 * single-byte characters maximum. 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $MsgSubID;

	/**
	 * Constructor with arguments
	 */
	public function __construct($AuthorizationID = NULL) {
		$this->AuthorizationID = $AuthorizationID;
	}


  
 
}



/**
 * The authorization identification number you specified in the
 * request. Character length and limits: 19 single-byte
 * characters 
 */
class DoVoidResponseType  extends AbstractResponseType  
  {

	/**
	 * The authorization identification number you specified in the
	 * request. Character length and limits: 19 single-byte
	 * characters
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $AuthorizationID;

	/**
	 * Return msgsubid back to merchant
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $MsgSubID;


}



/**
 * 
 */
class DoAuthorizationReq  
   extends PPXmlMessage{

	/**
	 * 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var DoAuthorizationRequestType 	 
	 */ 
	public $DoAuthorizationRequest;


	public function toXMLString()
	{
		    $str = '';
			$str .= '<ns:DoAuthorizationReq>';
			if($this->DoAuthorizationRequest != NULL)
			{
		   		$str .= '<ns:DoAuthorizationRequest>';
				$str .= $this->DoAuthorizationRequest->toXMLString();
				$str .= '</ns:DoAuthorizationRequest>';
			}
			$str .= '</ns:DoAuthorizationReq>';
			return $str;
	}
  
 
}



/**
 * The value of the order’s transaction identification number
 * returned by a PayPal product. Required Character length and
 * limits: 19 single-byte characters maximum 
 */
class DoAuthorizationRequestType  extends AbstractRequestType  
  {

	/**
	 * The value of the order’s transaction identification number
	 * returned by a PayPal product. Required Character length and
	 * limits: 19 single-byte characters maximum
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $TransactionID;

	/**
	 * Type of transaction to authorize. The only allowable value
	 * is Order, which means that the transaction represents a
	 * customer order that can be fulfilled over 29 days. Optional
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $TransactionEntity;

	/**
	 * Amount to authorize. Required Limitations: Must not exceed
	 * $10,000 USD in any currency. No currency symbol. Decimal
	 * separator must be a period (.), and the thousands separator
	 * must be a comma (,).
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var BasicAmountType 	 
	 */ 
	public $Amount;

	/**
	 * Address the order will be shipped to. Optional 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var AddressType 	 
	 */ 
	public $ShipToAddress;

	/**
	 * Information about the individual purchased items 
     * @array
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var PaymentDetailsItemType 	 
	 */ 
	public $PaymentDetailsItem;

	/**
	 * Sum of cost of all items in this order. You must set the
	 * currencyID attribute to one of the three-character currency
	 * codes for any of the supported PayPal currencies. Optional
	 * Limitations: Must not exceed $10,000 USD in any currency. No
	 * currency symbol. Decimal separator must be a period (.), and
	 * the thousands separator must be a comma (,). 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var BasicAmountType 	 
	 */ 
	public $ItemTotal;

	/**
	 * Total shipping costs for this order. You must set the
	 * currencyID attribute to one of the three-character currency
	 * codes for any of the supported PayPal currencies. Optional
	 * Limitations: Must not exceed $10,000 USD in any currency. No
	 * currency symbol. Decimal separator must be a period (.), and
	 * the thousands separator must be a comma (,). 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var BasicAmountType 	 
	 */ 
	public $ShippingTotal;

	/**
	 * Total handling costs for this order. You must set the
	 * currencyID attribute to one of the three-character currency
	 * codes for any of the supported PayPal currencies. Optional
	 * Limitations: Must not exceed $10,000 USD in any currency. No
	 * currency symbol. Decimal separator must be a period (.), and
	 * the thousands separator must be a comma (,). 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var BasicAmountType 	 
	 */ 
	public $HandlingTotal;

	/**
	 * Sum of tax for all items in this order. You must set the
	 * currencyID attribute to one of the three-character currency
	 * codes for any of the supported PayPal currencies. Optional
	 * Limitations: Must not exceed $10,000 USD in any currency. No
	 * currency symbol. Decimal separator must be a period (.), and
	 * the thousands separator must be a comma (,). 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var BasicAmountType 	 
	 */ 
	public $TaxTotal;

	/**
	 * Total shipping insurance costs for this order. Optional 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var BasicAmountType 	 
	 */ 
	public $InsuranceTotal;

	/**
	 * Shipping discount for this order, specified as a negative
	 * number. Optional 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var BasicAmountType 	 
	 */ 
	public $ShippingDiscount;

	/**
	 * Description of items the customer is purchasing. Optional
	 * Character length and limitations: 127 single-byte
	 * alphanumeric characters 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $OrderDescription;

	/**
	 * A free-form field for your own use. Optional Character
	 * length and limitations: 256 single-byte alphanumeric
	 * characters 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Custom;

	/**
	 * Unique id for each API request to prevent duplicate
	 * payments. Optional Character length and limits: 38
	 * single-byte characters maximum. 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $MsgSubID;

	/**
	 * IP Address of the buyer 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $IPAddress;

	/**
	 * A flag indicating that this transaction is a Ship to Store
	 * transaction. Optional 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ShipToStore;

	/**
	 * Constructor with arguments
	 */
	public function __construct($TransactionID = NULL, $Amount = NULL) {
		$this->TransactionID = $TransactionID;
		$this->Amount = $Amount;
	}


  
 
}



/**
 * An authorization identification number. Character length and
 * limits: 19 single-byte characters 
 */
class DoAuthorizationResponseType  extends AbstractResponseType  
  {

	/**
	 * An authorization identification number. Character length and
	 * limits: 19 single-byte characters
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $TransactionID;

	/**
	 * The amount and currency you specified in the request. 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var BasicAmountType 	 
	 */ 
	public $Amount;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var AuthorizationInfoType 	 
	 */ 
	public $AuthorizationInfo;

	/**
	 * Return msgsubid back to merchant
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $MsgSubID;


}



/**
 * 
 */
class UpdateAuthorizationReq  
   extends PPXmlMessage{

	/**
	 * 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var UpdateAuthorizationRequestType 	 
	 */ 
	public $UpdateAuthorizationRequest;


	public function toXMLString()
	{
		    $str = '';
			$str .= '<ns:UpdateAuthorizationReq>';
			if($this->UpdateAuthorizationRequest != NULL)
			{
		   		$str .= '<ns:UpdateAuthorizationRequest>';
				$str .= $this->UpdateAuthorizationRequest->toXMLString();
				$str .= '</ns:UpdateAuthorizationRequest>';
			}
			$str .= '</ns:UpdateAuthorizationReq>';
			return $str;
	}
  
 
}



/**
 * The value of the authorizationâtransaction identification
 * number returned by a PayPal product. Required Character
 * length and limits: 19 single-byte characters maximum 
 */
class UpdateAuthorizationRequestType  extends AbstractRequestType  
  {

	/**
	 * The value of the authorizationâtransaction identification
	 * number returned by a PayPal product. Required Character
	 * length and limits: 19 single-byte characters maximum 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $TransactionID;

	/**
	 * Shipping Address for this transaction. 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var AddressType 	 
	 */ 
	public $ShipToAddress;

	/**
	 * IP Address of the buyer 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $IPAddress;

	/**
	 * A flag indicating that this transaction is a Ship to Store
	 * transaction. Optional 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ShipToStore;

	/**
	 * Constructor with arguments
	 */
	public function __construct($TransactionID = NULL) {
		$this->TransactionID = $TransactionID;
	}


  
 
}



/**
 * An authorization identification number. Character length and
 * limits: 19 single-byte characters 
 */
class UpdateAuthorizationResponseType  extends AbstractResponseType  
  {

	/**
	 * An authorization identification number. Character length and
	 * limits: 19 single-byte characters 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $TransactionID;

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var AuthorizationInfoType 	 
	 */ 
	public $AuthorizationInfo;


}



/**
 * 
 */
class DoUATPAuthorizationReq  
   extends PPXmlMessage{

	/**
	 * 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var DoUATPAuthorizationRequestType 	 
	 */ 
	public $DoUATPAuthorizationRequest;


	public function toXMLString()
	{
		    $str = '';
			$str .= '<ns:DoUATPAuthorizationReq>';
			if($this->DoUATPAuthorizationRequest != NULL)
			{
		   		$str .= '<ns:DoUATPAuthorizationRequest>';
				$str .= $this->DoUATPAuthorizationRequest->toXMLString();
				$str .= '</ns:DoUATPAuthorizationRequest>';
			}
			$str .= '</ns:DoUATPAuthorizationReq>';
			return $str;
	}
  
 
}



/**
 * UATP card details Required 
 */
class DoUATPAuthorizationRequestType  extends AbstractRequestType  
  {

	/**
	 * UATP card details Required 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var UATPDetailsType 	 
	 */ 
	public $UATPDetails;

	/**
	 * Type of transaction to authorize. The only allowable value
	 * is Order, which means that the transaction represents a
	 * customer order that can be fulfilled over 29 days. Optional
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $TransactionEntity;

	/**
	 * Amount to authorize. Required Limitations: Must not exceed
	 * $10,000 USD in any currency. No currency symbol. Decimal
	 * separator must be a period (.), and the thousands separator
	 * must be a comma (,).
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var BasicAmountType 	 
	 */ 
	public $Amount;

	/**
	 * Invoice ID. A pass through. 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $InvoiceID;

	/**
	 * Unique id for each API request to prevent duplicate
	 * payments. Optional Character length and limits: 38
	 * single-byte characters maximum. 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $MsgSubID;

	/**
	 * Constructor with arguments
	 */
	public function __construct($UATPDetails = NULL, $Amount = NULL) {
		$this->UATPDetails = $UATPDetails;
		$this->Amount = $Amount;
	}


  
 
}



/**
 * Auth Authorization Code. 
 */
class DoUATPAuthorizationResponseType  extends DoAuthorizationResponseType  
  {

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var UATPDetailsType 	 
	 */ 
	public $UATPDetails;

	/**
	 * Auth Authorization Code. 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $AuthorizationCode;

	/**
	 * Invoice ID. A pass through. 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $InvoiceID;

	/**
	 * Unique id for each API request to prevent duplicate
	 * payments. Optional Character length and limits: 38
	 * single-byte characters maximum. 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $MsgSubID;


}



/**
 * 
 */
class CreateMobilePaymentReq  
   extends PPXmlMessage{

	/**
	 * 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var CreateMobilePaymentRequestType 	 
	 */ 
	public $CreateMobilePaymentRequest;


	public function toXMLString()
	{
		    $str = '';
			$str .= '<ns:CreateMobilePaymentReq>';
			if($this->CreateMobilePaymentRequest != NULL)
			{
		   		$str .= '<ns:CreateMobilePaymentRequest>';
				$str .= $this->CreateMobilePaymentRequest->toXMLString();
				$str .= '</ns:CreateMobilePaymentRequest>';
			}
			$str .= '</ns:CreateMobilePaymentReq>';
			return $str;
	}
  
 
}



/**
 * 
 */
class CreateMobilePaymentRequestType  extends AbstractRequestType  
  {

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var CreateMobilePaymentRequestDetailsType 	 
	 */ 
	public $CreateMobilePaymentRequestDetails;

	/**
	 * Constructor with arguments
	 */
	public function __construct($CreateMobilePaymentRequestDetails = NULL) {
		$this->CreateMobilePaymentRequestDetails = $CreateMobilePaymentRequestDetails;
	}


  
 
}



/**
 * 
 */
class CreateMobilePaymentResponseType  extends AbstractResponseType  
  {


}



/**
 * 
 */
class GetMobileStatusReq  
   extends PPXmlMessage{

	/**
	 * 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var GetMobileStatusRequestType 	 
	 */ 
	public $GetMobileStatusRequest;


	public function toXMLString()
	{
		    $str = '';
			$str .= '<ns:GetMobileStatusReq>';
			if($this->GetMobileStatusRequest != NULL)
			{
		   		$str .= '<ns:GetMobileStatusRequest>';
				$str .= $this->GetMobileStatusRequest->toXMLString();
				$str .= '</ns:GetMobileStatusRequest>';
			}
			$str .= '</ns:GetMobileStatusReq>';
			return $str;
	}
  
 
}



/**
 * 
 */
class GetMobileStatusRequestType  extends AbstractRequestType  
  {

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var GetMobileStatusRequestDetailsType 	 
	 */ 
	public $GetMobileStatusRequestDetails;

	/**
	 * Constructor with arguments
	 */
	public function __construct($GetMobileStatusRequestDetails = NULL) {
		$this->GetMobileStatusRequestDetails = $GetMobileStatusRequestDetails;
	}


  
 
}



/**
 * Indicates whether the phone is activated for mobile payments
 * 
 */
class GetMobileStatusResponseType  extends AbstractResponseType  
  {

	/**
	 * Indicates whether the phone is activated for mobile payments
	 * 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var integer 	 
	 */ 
	public $IsActivated;

	/**
	 * Indicates whether the password is enabled for particular
	 * account 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var integer 	 
	 */ 
	public $IsPasswordSet;

	/**
	 * Indicates whether there is a payment pending from the phone 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var integer 	 
	 */ 
	public $PaymentPending;


}



/**
 * 
 */
class SetMobileCheckoutReq  
   extends PPXmlMessage{

	/**
	 * 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var SetMobileCheckoutRequestType 	 
	 */ 
	public $SetMobileCheckoutRequest;


	public function toXMLString()
	{
		    $str = '';
			$str .= '<ns:SetMobileCheckoutReq>';
			if($this->SetMobileCheckoutRequest != NULL)
			{
		   		$str .= '<ns:SetMobileCheckoutRequest>';
				$str .= $this->SetMobileCheckoutRequest->toXMLString();
				$str .= '</ns:SetMobileCheckoutRequest>';
			}
			$str .= '</ns:SetMobileCheckoutReq>';
			return $str;
	}
  
 
}



/**
 * 
 */
class SetMobileCheckoutRequestType  extends AbstractRequestType  
  {

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var SetMobileCheckoutRequestDetailsType 	 
	 */ 
	public $SetMobileCheckoutRequestDetails;

	/**
	 * Constructor with arguments
	 */
	public function __construct($SetMobileCheckoutRequestDetails = NULL) {
		$this->SetMobileCheckoutRequestDetails = $SetMobileCheckoutRequestDetails;
	}


  
 
}



/**
 * A timestamped token by which you identify to PayPal that you
 * are processing this payment with Mobile Checkout. The token
 * expires after three hours. Character length and limitations:
 * 20 single-byte characters
 */
class SetMobileCheckoutResponseType  extends AbstractResponseType  
  {

	/**
	 * A timestamped token by which you identify to PayPal that you
	 * are processing this payment with Mobile Checkout. The token
	 * expires after three hours. Character length and limitations:
	 * 20 single-byte characters
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Token;


}



/**
 * 
 */
class DoMobileCheckoutPaymentReq  
   extends PPXmlMessage{

	/**
	 * 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var DoMobileCheckoutPaymentRequestType 	 
	 */ 
	public $DoMobileCheckoutPaymentRequest;


	public function toXMLString()
	{
		    $str = '';
			$str .= '<ns:DoMobileCheckoutPaymentReq>';
			if($this->DoMobileCheckoutPaymentRequest != NULL)
			{
		   		$str .= '<ns:DoMobileCheckoutPaymentRequest>';
				$str .= $this->DoMobileCheckoutPaymentRequest->toXMLString();
				$str .= '</ns:DoMobileCheckoutPaymentRequest>';
			}
			$str .= '</ns:DoMobileCheckoutPaymentReq>';
			return $str;
	}
  
 
}



/**
 * A timestamped token, the value of which was returned by
 * SetMobileCheckoutResponse. RequiredCharacter length and
 * limitations: 20 single-byte characters
 */
class DoMobileCheckoutPaymentRequestType  extends AbstractRequestType  
  {

	/**
	 * A timestamped token, the value of which was returned by
	 * SetMobileCheckoutResponse. RequiredCharacter length and
	 * limitations: 20 single-byte characters
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Token;

	/**
	 * Constructor with arguments
	 */
	public function __construct($Token = NULL) {
		$this->Token = $Token;
	}


  
 
}



/**
 * 
 */
class DoMobileCheckoutPaymentResponseType  extends AbstractResponseType  
  {

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var DoMobileCheckoutPaymentResponseDetailsType 	 
	 */ 
	public $DoMobileCheckoutPaymentResponseDetails;


}



/**
 * 
 */
class GetBalanceReq  
   extends PPXmlMessage{

	/**
	 * 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var GetBalanceRequestType 	 
	 */ 
	public $GetBalanceRequest;


	public function toXMLString()
	{
		    $str = '';
			$str .= '<ns:GetBalanceReq>';
			if($this->GetBalanceRequest != NULL)
			{
		   		$str .= '<ns:GetBalanceRequest>';
				$str .= $this->GetBalanceRequest->toXMLString();
				$str .= '</ns:GetBalanceRequest>';
			}
			$str .= '</ns:GetBalanceReq>';
			return $str;
	}
  
 
}



/**
 * 
 */
class GetBalanceRequestType  extends AbstractRequestType  
  {

	/**
	 * 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ReturnAllCurrencies;


  
 
}



/**
 * 
 */
class GetBalanceResponseType  extends AbstractResponseType  
  {

	/**
	 * 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var BasicAmountType 	 
	 */ 
	public $Balance;

	/**
	 * 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var dateTime 	 
	 */ 
	public $BalanceTimeStamp;

	/**
	 * 
     * @array
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var BasicAmountType 	 
	 */ 
	public $BalanceHoldings;


}



/**
 * 
 */
class SetCustomerBillingAgreementReq  
   extends PPXmlMessage{

	/**
	 * 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var SetCustomerBillingAgreementRequestType 	 
	 */ 
	public $SetCustomerBillingAgreementRequest;


	public function toXMLString()
	{
		    $str = '';
			$str .= '<ns:SetCustomerBillingAgreementReq>';
			if($this->SetCustomerBillingAgreementRequest != NULL)
			{
		   		$str .= '<ns:SetCustomerBillingAgreementRequest>';
				$str .= $this->SetCustomerBillingAgreementRequest->toXMLString();
				$str .= '</ns:SetCustomerBillingAgreementRequest>';
			}
			$str .= '</ns:SetCustomerBillingAgreementReq>';
			return $str;
	}
  
 
}



/**
 * 
 */
class SetCustomerBillingAgreementRequestType  extends AbstractRequestType  
  {

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var SetCustomerBillingAgreementRequestDetailsType 	 
	 */ 
	public $SetCustomerBillingAgreementRequestDetails;

	/**
	 * Constructor with arguments
	 */
	public function __construct($SetCustomerBillingAgreementRequestDetails = NULL) {
		$this->SetCustomerBillingAgreementRequestDetails = $SetCustomerBillingAgreementRequestDetails;
	}


  
 
}



/**
 * 
 */
class SetCustomerBillingAgreementResponseType  extends AbstractResponseType  
  {

	/**
	 * 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Token;


}



/**
 * 
 */
class GetBillingAgreementCustomerDetailsReq  
   extends PPXmlMessage{

	/**
	 * 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var GetBillingAgreementCustomerDetailsRequestType 	 
	 */ 
	public $GetBillingAgreementCustomerDetailsRequest;


	public function toXMLString()
	{
		    $str = '';
			$str .= '<ns:GetBillingAgreementCustomerDetailsReq>';
			if($this->GetBillingAgreementCustomerDetailsRequest != NULL)
			{
		   		$str .= '<ns:GetBillingAgreementCustomerDetailsRequest>';
				$str .= $this->GetBillingAgreementCustomerDetailsRequest->toXMLString();
				$str .= '</ns:GetBillingAgreementCustomerDetailsRequest>';
			}
			$str .= '</ns:GetBillingAgreementCustomerDetailsReq>';
			return $str;
	}
  
 
}



/**
 * 
 */
class GetBillingAgreementCustomerDetailsRequestType  extends AbstractRequestType  
  {

	/**
	 * 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Token;

	/**
	 * Constructor with arguments
	 */
	public function __construct($Token = NULL) {
		$this->Token = $Token;
	}


  
 
}



/**
 * 
 */
class GetBillingAgreementCustomerDetailsResponseType  extends AbstractResponseType  
  {

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var GetBillingAgreementCustomerDetailsResponseDetailsType 	 
	 */ 
	public $GetBillingAgreementCustomerDetailsResponseDetails;


}



/**
 * 
 */
class CreateBillingAgreementReq  
   extends PPXmlMessage{

	/**
	 * 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var CreateBillingAgreementRequestType 	 
	 */ 
	public $CreateBillingAgreementRequest;


	public function toXMLString()
	{
		    $str = '';
			$str .= '<ns:CreateBillingAgreementReq>';
			if($this->CreateBillingAgreementRequest != NULL)
			{
		   		$str .= '<ns:CreateBillingAgreementRequest>';
				$str .= $this->CreateBillingAgreementRequest->toXMLString();
				$str .= '</ns:CreateBillingAgreementRequest>';
			}
			$str .= '</ns:CreateBillingAgreementReq>';
			return $str;
	}
  
 
}



/**
 * 
 */
class CreateBillingAgreementRequestType  extends AbstractRequestType  
  {

	/**
	 * 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Token;

	/**
	 * Constructor with arguments
	 */
	public function __construct($Token = NULL) {
		$this->Token = $Token;
	}


  
 
}



/**
 * 
 */
class CreateBillingAgreementResponseType  extends AbstractResponseType  
  {

	/**
	 * 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $BillingAgreementID;


}



/**
 * 
 */
class DoReferenceTransactionReq  
   extends PPXmlMessage{

	/**
	 * 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var DoReferenceTransactionRequestType 	 
	 */ 
	public $DoReferenceTransactionRequest;


	public function toXMLString()
	{
		    $str = '';
			$str .= '<ns:DoReferenceTransactionReq>';
			if($this->DoReferenceTransactionRequest != NULL)
			{
		   		$str .= '<ns:DoReferenceTransactionRequest>';
				$str .= $this->DoReferenceTransactionRequest->toXMLString();
				$str .= '</ns:DoReferenceTransactionRequest>';
			}
			$str .= '</ns:DoReferenceTransactionReq>';
			return $str;
	}
  
 
}



/**
 * This flag indicates that the response should include
 * FMFDetails 
 */
class DoReferenceTransactionRequestType  extends AbstractRequestType  
  {

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var DoReferenceTransactionRequestDetailsType 	 
	 */ 
	public $DoReferenceTransactionRequestDetails;

	/**
	 * This flag indicates that the response should include
	 * FMFDetails
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var integer 	 
	 */ 
	public $ReturnFMFDetails;

	/**
	 * Constructor with arguments
	 */
	public function __construct($DoReferenceTransactionRequestDetails = NULL) {
		$this->DoReferenceTransactionRequestDetails = $DoReferenceTransactionRequestDetails;
	}


  
 
}



/**
 * 
 */
class DoReferenceTransactionResponseType  extends AbstractResponseType  
  {

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var DoReferenceTransactionResponseDetailsType 	 
	 */ 
	public $DoReferenceTransactionResponseDetails;

	/**
	 * 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var FMFDetailsType 	 
	 */ 
	public $FMFDetails;


}



/**
 * 
 */
class DoNonReferencedCreditReq  
   extends PPXmlMessage{

	/**
	 * 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var DoNonReferencedCreditRequestType 	 
	 */ 
	public $DoNonReferencedCreditRequest;


	public function toXMLString()
	{
		    $str = '';
			$str .= '<ns:DoNonReferencedCreditReq>';
			if($this->DoNonReferencedCreditRequest != NULL)
			{
		   		$str .= '<ns:DoNonReferencedCreditRequest>';
				$str .= $this->DoNonReferencedCreditRequest->toXMLString();
				$str .= '</ns:DoNonReferencedCreditRequest>';
			}
			$str .= '</ns:DoNonReferencedCreditReq>';
			return $str;
	}
  
 
}



/**
 * 
 */
class DoNonReferencedCreditRequestType  extends AbstractRequestType  
  {

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var DoNonReferencedCreditRequestDetailsType 	 
	 */ 
	public $DoNonReferencedCreditRequestDetails;

	/**
	 * Constructor with arguments
	 */
	public function __construct($DoNonReferencedCreditRequestDetails = NULL) {
		$this->DoNonReferencedCreditRequestDetails = $DoNonReferencedCreditRequestDetails;
	}


  
 
}



/**
 * 
 */
class DoNonReferencedCreditResponseType  extends AbstractResponseType  
  {

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var DoNonReferencedCreditResponseDetailsType 	 
	 */ 
	public $DoNonReferencedCreditResponseDetails;


}



/**
 * 
 */
class CreateRecurringPaymentsProfileReq  
   extends PPXmlMessage{

	/**
	 * 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var CreateRecurringPaymentsProfileRequestType 	 
	 */ 
	public $CreateRecurringPaymentsProfileRequest;


	public function toXMLString()
	{
		    $str = '';
			$str .= '<ns:CreateRecurringPaymentsProfileReq>';
			if($this->CreateRecurringPaymentsProfileRequest != NULL)
			{
		   		$str .= '<ns:CreateRecurringPaymentsProfileRequest>';
				$str .= $this->CreateRecurringPaymentsProfileRequest->toXMLString();
				$str .= '</ns:CreateRecurringPaymentsProfileRequest>';
			}
			$str .= '</ns:CreateRecurringPaymentsProfileReq>';
			return $str;
	}
  
 
}



/**
 * 
 */
class CreateRecurringPaymentsProfileRequestType  extends AbstractRequestType  
  {

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var CreateRecurringPaymentsProfileRequestDetailsType 	 
	 */ 
	public $CreateRecurringPaymentsProfileRequestDetails;


  
 
}



/**
 * 
 */
class CreateRecurringPaymentsProfileResponseType  extends AbstractResponseType  
  {

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var CreateRecurringPaymentsProfileResponseDetailsType 	 
	 */ 
	public $CreateRecurringPaymentsProfileResponseDetails;


}



/**
 * 
 */
class GetRecurringPaymentsProfileDetailsReq  
   extends PPXmlMessage{

	/**
	 * 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var GetRecurringPaymentsProfileDetailsRequestType 	 
	 */ 
	public $GetRecurringPaymentsProfileDetailsRequest;


	public function toXMLString()
	{
		    $str = '';
			$str .= '<ns:GetRecurringPaymentsProfileDetailsReq>';
			if($this->GetRecurringPaymentsProfileDetailsRequest != NULL)
			{
		   		$str .= '<ns:GetRecurringPaymentsProfileDetailsRequest>';
				$str .= $this->GetRecurringPaymentsProfileDetailsRequest->toXMLString();
				$str .= '</ns:GetRecurringPaymentsProfileDetailsRequest>';
			}
			$str .= '</ns:GetRecurringPaymentsProfileDetailsReq>';
			return $str;
	}
  
 
}



/**
 * 
 */
class GetRecurringPaymentsProfileDetailsRequestType  extends AbstractRequestType  
  {

	/**
	 * 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ProfileID;

	/**
	 * Constructor with arguments
	 */
	public function __construct($ProfileID = NULL) {
		$this->ProfileID = $ProfileID;
	}


  
 
}



/**
 * 
 */
class GetRecurringPaymentsProfileDetailsResponseType  extends AbstractResponseType  
  {

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var GetRecurringPaymentsProfileDetailsResponseDetailsType 	 
	 */ 
	public $GetRecurringPaymentsProfileDetailsResponseDetails;


}



/**
 * 
 */
class ManageRecurringPaymentsProfileStatusReq  
   extends PPXmlMessage{

	/**
	 * 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var ManageRecurringPaymentsProfileStatusRequestType 	 
	 */ 
	public $ManageRecurringPaymentsProfileStatusRequest;


	public function toXMLString()
	{
		    $str = '';
			$str .= '<ns:ManageRecurringPaymentsProfileStatusReq>';
			if($this->ManageRecurringPaymentsProfileStatusRequest != NULL)
			{
		   		$str .= '<ns:ManageRecurringPaymentsProfileStatusRequest>';
				$str .= $this->ManageRecurringPaymentsProfileStatusRequest->toXMLString();
				$str .= '</ns:ManageRecurringPaymentsProfileStatusRequest>';
			}
			$str .= '</ns:ManageRecurringPaymentsProfileStatusReq>';
			return $str;
	}
  
 
}



/**
 * 
 */
class ManageRecurringPaymentsProfileStatusRequestType  extends AbstractRequestType  
  {

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var ManageRecurringPaymentsProfileStatusRequestDetailsType 	 
	 */ 
	public $ManageRecurringPaymentsProfileStatusRequestDetails;


  
 
}



/**
 * 
 */
class ManageRecurringPaymentsProfileStatusResponseType  extends AbstractResponseType  
  {

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var ManageRecurringPaymentsProfileStatusResponseDetailsType 	 
	 */ 
	public $ManageRecurringPaymentsProfileStatusResponseDetails;


}



/**
 * 
 */
class BillOutstandingAmountReq  
   extends PPXmlMessage{

	/**
	 * 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var BillOutstandingAmountRequestType 	 
	 */ 
	public $BillOutstandingAmountRequest;


	public function toXMLString()
	{
		    $str = '';
			$str .= '<ns:BillOutstandingAmountReq>';
			if($this->BillOutstandingAmountRequest != NULL)
			{
		   		$str .= '<ns:BillOutstandingAmountRequest>';
				$str .= $this->BillOutstandingAmountRequest->toXMLString();
				$str .= '</ns:BillOutstandingAmountRequest>';
			}
			$str .= '</ns:BillOutstandingAmountReq>';
			return $str;
	}
  
 
}



/**
 * 
 */
class BillOutstandingAmountRequestType  extends AbstractRequestType  
  {

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var BillOutstandingAmountRequestDetailsType 	 
	 */ 
	public $BillOutstandingAmountRequestDetails;


  
 
}



/**
 * 
 */
class BillOutstandingAmountResponseType  extends AbstractResponseType  
  {

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var BillOutstandingAmountResponseDetailsType 	 
	 */ 
	public $BillOutstandingAmountResponseDetails;


}



/**
 * 
 */
class UpdateRecurringPaymentsProfileReq  
   extends PPXmlMessage{

	/**
	 * 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var UpdateRecurringPaymentsProfileRequestType 	 
	 */ 
	public $UpdateRecurringPaymentsProfileRequest;


	public function toXMLString()
	{
		    $str = '';
			$str .= '<ns:UpdateRecurringPaymentsProfileReq>';
			if($this->UpdateRecurringPaymentsProfileRequest != NULL)
			{
		   		$str .= '<ns:UpdateRecurringPaymentsProfileRequest>';
				$str .= $this->UpdateRecurringPaymentsProfileRequest->toXMLString();
				$str .= '</ns:UpdateRecurringPaymentsProfileRequest>';
			}
			$str .= '</ns:UpdateRecurringPaymentsProfileReq>';
			return $str;
	}
  
 
}



/**
 * 
 */
class UpdateRecurringPaymentsProfileRequestType  extends AbstractRequestType  
  {

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var UpdateRecurringPaymentsProfileRequestDetailsType 	 
	 */ 
	public $UpdateRecurringPaymentsProfileRequestDetails;


  
 
}



/**
 * 
 */
class UpdateRecurringPaymentsProfileResponseType  extends AbstractResponseType  
  {

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var UpdateRecurringPaymentsProfileResponseDetailsType 	 
	 */ 
	public $UpdateRecurringPaymentsProfileResponseDetails;


}



/**
 * 
 */
class GetPalDetailsReq  
   extends PPXmlMessage{

	/**
	 * 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var GetPalDetailsRequestType 	 
	 */ 
	public $GetPalDetailsRequest;


	public function toXMLString()
	{
		    $str = '';
			$str .= '<ns:GetPalDetailsReq>';
			if($this->GetPalDetailsRequest != NULL)
			{
		   		$str .= '<ns:GetPalDetailsRequest>';
				$str .= $this->GetPalDetailsRequest->toXMLString();
				$str .= '</ns:GetPalDetailsRequest>';
			}
			$str .= '</ns:GetPalDetailsReq>';
			return $str;
	}
  
 
}



/**
 * 
 */
class GetPalDetailsRequestType  extends AbstractRequestType  
  {


  
 
}



/**
 * 
 */
class GetPalDetailsResponseType  extends AbstractResponseType  
  {

	/**
	 * 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Pal;

	/**
	 * 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $Locale;


}



/**
 * 
 */
class ReverseTransactionReq  
   extends PPXmlMessage{

	/**
	 * 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var ReverseTransactionRequestType 	 
	 */ 
	public $ReverseTransactionRequest;


	public function toXMLString()
	{
		    $str = '';
			$str .= '<ns:ReverseTransactionReq>';
			if($this->ReverseTransactionRequest != NULL)
			{
		   		$str .= '<ns:ReverseTransactionRequest>';
				$str .= $this->ReverseTransactionRequest->toXMLString();
				$str .= '</ns:ReverseTransactionRequest>';
			}
			$str .= '</ns:ReverseTransactionReq>';
			return $str;
	}
  
 
}



/**
 * 
 */
class ReverseTransactionRequestType  extends AbstractRequestType  
  {

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var ReverseTransactionRequestDetailsType 	 
	 */ 
	public $ReverseTransactionRequestDetails;

	/**
	 * Constructor with arguments
	 */
	public function __construct($ReverseTransactionRequestDetails = NULL) {
		$this->ReverseTransactionRequestDetails = $ReverseTransactionRequestDetails;
	}


  
 
}



/**
 * 
 */
class ReverseTransactionResponseType  extends AbstractResponseType  
  {

	/**
	 * 
	 * @access public
	 
	 * @namespace ebl
	 
	 	 	 	 
	 * @var ReverseTransactionResponseDetailsType 	 
	 */ 
	public $ReverseTransactionResponseDetails;


}



/**
 * 
 */
class ExternalRememberMeOptOutReq  
   extends PPXmlMessage{

	/**
	 * 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var ExternalRememberMeOptOutRequestType 	 
	 */ 
	public $ExternalRememberMeOptOutRequest;


	public function toXMLString()
	{
		    $str = '';
			$str .= '<ns:ExternalRememberMeOptOutReq>';
			if($this->ExternalRememberMeOptOutRequest != NULL)
			{
		   		$str .= '<ns:ExternalRememberMeOptOutRequest>';
				$str .= $this->ExternalRememberMeOptOutRequest->toXMLString();
				$str .= '</ns:ExternalRememberMeOptOutRequest>';
			}
			$str .= '</ns:ExternalRememberMeOptOutReq>';
			return $str;
	}
  
 
}



/**
 * The merchant passes in the ExternalRememberMeID to identify
 * the user to opt out. This is a 17-character alphanumeric
 * (encrypted) string that identifies the buyer's remembered
 * login with a merchant and has meaning only to the merchant.
 * Required 
 */
class ExternalRememberMeOptOutRequestType  extends AbstractRequestType  
  {

	/**
	 * The merchant passes in the ExternalRememberMeID to identify
	 * the user to opt out. This is a 17-character alphanumeric
	 * (encrypted) string that identifies the buyer's remembered
	 * login with a merchant and has meaning only to the merchant.
	 * Required 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var string 	 
	 */ 
	public $ExternalRememberMeID;

	/**
	 * E-mail address or secure merchant account ID of merchant to
	 * associate with external remember-me. 
	 * @access public
	 
	 * @namespace ns
	 
	 	 	 	 
	 * @var ExternalRememberMeOwnerDetailsType 	 
	 */ 
	public $ExternalRememberMeOwnerDetails;

	/**
	 * Constructor with arguments
	 */
	public function __construct($ExternalRememberMeID = NULL) {
		$this->ExternalRememberMeID = $ExternalRememberMeID;
	}


  
 
}



/**
 * 
 */
class ExternalRememberMeOptOutResponseType  extends AbstractResponseType  
  {


}



