<?php
/**
 * HelloSign PHP SDK (https://github.com/HelloFax/hellosign-php-sdk/)
 */

/**
 * The MIT License (MIT)
 *
 * Copyright (C) 2014 hellosign.com
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

namespace HelloSign;

/**
 * Class that stores signer information for a signature request
 */
class Signer extends AbstractObject
{
    /**
     * The name of the signer
     *
     * @var string
     */
    protected $name = null;

    /**
     * The email address of the signer
     *
     * @var string
     */
    protected $email_address = null;

    /**
     * The order the signer is required to sign in
     *
     * @var integer
     */
    protected $order = null;

    /**
     * The access code that will secure this signer's signature page. You must
     * have a business plan to use this feature. Can be up to 12 alphanumeric characters
     *
     * @var string
     */
    protected $pin = null;

    /**
     * @param  array $options
     * @return array
     * @see    AbstractObject::toArray()
     * @ignore
     */
    public function toArray($options = array())
    {
        !isset($options['include_null']) && $options['include_null'] = false;

        return parent::toArray($options);
    }
}
