<?php
require_once(APPPATH.'libraries/stripeinit.php');
class Stripe
{


    var $CI;
    var $stripe=array();
    function __construct()
    {
        $this->CI =& get_instance();
        $this->CI->load->helper('url');
        $this->CI->load->helper('form');
        $this->CI->load->helper('payment');
        $dataGatewayDetails=paymentGatewayDetails();
        $gateway_id=3;
        $pays = $dataGatewayDetails[$gateway_id];

        $gateway_array = array();
        foreach ($pays as $key => $val) {

            $gateway_array[$val['name']] = $val['value'];
        }

        $site_status = $gateway_array['site_status'];
        $Stripe_key_test_public = $gateway_array['Stripe_key_test_public'];
         $Stripe_key_test_secret = $gateway_array['Stripe_key_test_secret'];
          $Stripe_key_Live_public = $gateway_array['Stripe_key_Live_public'];
           $Stripe_key_Live_secret = $gateway_array['Stripe_key_Live_secret'];
           if( $site_status=="test")
           {
                $stripe = array(
                  "secret_key"      =>$Stripe_key_test_secret,
                  "publishable_key" => $Stripe_key_test_public
                );
           }else
           {
                  $stripe = array(
                  "secret_key"      =>$Stripe_key_Live_secret,
                  "publishable_key" => $Stripe_key_Live_public
                );
           }
            
           $this->stripe= $stripe ;
          \Stripe\Stripe::setApiKey($this->stripe['secret_key']);
       
    }
    /*
    Function name :charge()
    Parameter :gateway_id
    Return : none
    Use : Generate Paypal Required data and redirect to Paypal.com
    */
    function charge($token='',$email='',$amount='',$currency='')
    {
        $data=array();
        $data['status']='fail';
        try 
        {
             \Stripe\Stripe::setApiKey($this->stripe['secret_key']);
              $customer = \Stripe\Customer::create(array(
                  'email' => $email,
                  'source'  => $token
              ));

              $charge = \Stripe\Charge::create(array(
                  'customer' => $customer->id,
                  'amount'   => $amount,
                  'currency' =>  $currency
              ));
              if($charge->captured==true)
              {
                $data['status']='success';
                $data['message']= $charge->id;
              }else
              {
                 $data['message']= $charge->failure_message;
              }
              

          } catch (Exception $ex) {
           if(isset($ex)) {

                $ex_message = $ex->getMessage();             

                $data['message']= $ex_message;
            }
        }

        return $data;    
    }
    /*
    Function name :refund()
    Parameter :gateway_id
    Return : none
    Use : Generate Paypal Required data and redirect to Paypal.com
    */
    function refund( $id)
    {
        $data=array();
        $data['status']='fail'; $data['message']='';
        try 
        {
             \Stripe\Stripe::setApiKey($this->stripe['secret_key']);
            
              $charge = \Stripe\Refund::create(array(
                  'charge' => $id
              ));
              if($charge->status=='succeeded')
              {
                $data['status']='success';
                $data['message']= $charge->id;
              }
              

          } catch (Exception $ex) {
           if(isset($ex)) {

                $ex_message = $ex->getMessage();             

                $data['message']= $ex_message;
            }
        }

        return $data;    
    }
}

