<?php if (!defined('BASEPATH')) exit('No direct script access allowed');


/**
 * return list of payment gateways
 *
 * @access	public
 * @param	string	$status "Active" ,""Inactive"" ,"All"
 * @return	string
 */

function paymentGatewayNames($status="Active",$gateway_id=0)
{      

        $CI =& get_instance();
        if($gateway_id>0)
        {
            $where=array('id'=>$gateway_id);
           $query = $CI->db->get_where("payments_gateways", $where);
          $data = $query->row_array(); 
           return  $data;
        }else
        {
          $where=array('1'=>1);
          if($status!="All") $where=array('1'=>1 ,'status'=>$status);
          $query = $CI->db->get_where("payments_gateways", $where);
          $data = $query->result_array(); 
          return  $data;

        }
        
}
/**
 * return Gateway details with name array index
 *
 * @access  public
 * @param   string  gateway_id 0 return all data and greater then 0 return data for particular gateway
 * @return  string
 */

function paymentGatewayDetails($gateway_id=0)
{      

                 $CI =& get_instance();
                $selectfields="*";
                 $CI->db->select($selectfields);
                $CI->db->from('gateways_details');
                $query = $CI->db->get();
                $result = $query->result_array();
                $data=array();
                if ($result) {
                    foreach ($result as $res) {
                          $payment_gateway_id=$res['payment_gateway_id'];
                           if($gateway_id>0)
                           {
                                if($gateway_id==$payment_gateway_id)$data[$payment_gateway_id][]=$res;
                           }else
                           {
                                $data[$payment_gateway_id][]=$res;
                           }
                           

                    }


                }


        return $data;
}

/**
 * return row of investment
 *
 * @access  public
 * @param string  $status "Active" ,""Inactive"" ,"All"
 * @return  string
 */

function investmentDetailsByTransId($trans_id="")
{      

        $CI =& get_instance();
        $where=array('transaction_id'=>$trans_id);    
      
        $query = $CI->db->get_where("equity_investment_process", $where);
        $data = $query->row_array(); 
        return  $data;
}

/**
 * return row from tmp_preapproval
 *
 * @access  public
 * @param string  $status "Active" ,""Inactive"" ,"All"
 * @return  string
 */

function tmppreapprovalByTransId($trans_id="")
{      

        $CI =& get_instance();
        $where=array('preapprovalKey'=>$trans_id);    
      
        $query = $CI->db->get_where("temp_preapprove", $where);
        $data = $query->row_array(); 
        return  $data;
}
/**
 * return row from withdrawDetailsByEquityId
 *
 * @access  public
 * @param string  equity_id
 * @return  string
 */
function withdrawDetailsByEquityId($equity_id="")
{      

        $CI =& get_instance();
        $where=array('equity_id'=>$equity_id);    
      
        $query = $CI->db->get_where("payment_withdraw", $where);
        $data = $query->row_array(); 
        return  $data;
}
/**
 * return row from gatewayFees
 *
 * @access  public
 * @param string  equity_id
 * @return  string
 */
function gatewayFees($equity_id="")
{      

       $CI =& get_instance();
       $where=array('equity_id'=>$equity_id, 'preapproval_status' => 'SUCCESS');
       $query = $CI->db->get_where("transaction", $where); //echo $CI->db->last_query();
       $data = $query->result_array(); 
        $dataGatewayDetails=paymentGatewayDetails();
       
        $project_detail = $CI->db->query("select * from `equity` where equity_id=".$equity_id);
        $pro_det = $project_detail->row();
         $funding_type= $pro_det->funding_type;
        $project_status= $pro_det->status;
         $site_setting = site_setting();
        if($funding_type == "Fixed")
        {
            $admin_fees =$site_setting['fixed_fees'];
        }else
        {
            $admin_fees =$site_setting['suc_flexible_fees'];
        }

        $gateway_fees=0;$site_fees=0;$get_amount=0;$total_amount=0;  

       // echo "<pre>";print_r($data);   
       foreach( $data as $record)
       {
            $gateway_id=intval($record['gateway_id']);
           
            $preapproval_total_amount=$record['preapproval_total_amount'];
            if( intval( $preapproval_total_amount)>0)
            {
                $amount=$record['amount'];$trans_fees=0;
                if(intval($gateway_id)>0)
                {
                  $pays = $dataGatewayDetails[$gateway_id];
                  $gateway_array = array();
                  foreach ($pays as $key => $val) {

                        $gateway_array[$val['name']] = $val['value'];
                    }
                    if(isset($gateway_array['transaction_fees']))$trans_fees=$gateway_array['transaction_fees'];

                }

                $transaction_fees=0;

                if($trans_fees>0)
                {
                    if($gateway_id==3)
                    {
                      $transaction_fees =truncate_number((($trans_fees*$preapproval_total_amount)/100)+0.30);
                    }else
                    {
                      $transaction_fees =truncate_number(($trans_fees*$preapproval_total_amount)/100);
                    
                    } 
                }
                      // echo "<br>".$trans_fees."=".$preapproval_total_amount."=".$gateway_id."="."=".$transaction_fees."=";
                //for wepay  
  
                 
                
                
                //if project not success or not close thne calculate admin fees
                if( $project_status<3)
                {
                   $pay_fee=truncate_number(($admin_fees* $preapproval_total_amount)/100);
                }else
                {
                   $pay_fee=$record['pay_fee']; //admin fees
                }
                $site_fees=truncate_number($site_fees+$pay_fee);
               if($transaction_fees>0) $gateway_fees=truncate_number($gateway_fees+$transaction_fees);
 //echo "<br>".$trans_fees."=".$gateway_fees."=".$gateway_id."="."=".$transaction_fees."=";
                $get_amount=truncate_number($get_amount+$amount);
                
                  $total_amount=truncate_number($total_amount+$preapproval_total_amount);
              }    

       }
       $recordData=array();
       $recordData['site_fees']=$site_fees; $recordData['gateway_fees']=$gateway_fees;
        $recordData['get_amount']=truncate_number($total_amount-$gateway_fees-$site_fees); $recordData['total_amount']=$total_amount;
         $recordData['site_fees_percentage']=$admin_fees;

        return  $recordData;
}

function truncate_number( $number, $precision = 2) {

    // Are we negative?
    if( $number<=0)return 0;
    $negative = $number / abs($number);

    // Cast the number to a positive to solve rounding

    $number = abs($number);

    // Calculate precision number for dividing / multiplying

    $precision = pow(10, $precision);

    // Run the math, re-applying the negative value to ensure returns correctly negative / positive

    return floor( $number * $precision ) / $precision * $negative;

}
?>
