<?php
/*********************************************************************************
 * This is Crowd Funding Platform by fundraisingscript.com a part of Rockers Technology Inc. is paid software. It is released under the terms of
 * the following BSD License.
 *
 *   Rockers Technology Inc(Head Office)
 *   53 cedar st apt 3416
 *   Woburn, MA- 01801, USA
 *   E-mail Address : nishu@rockersinfo.com
 *
 * Copyright@2012-2020 by Rockers Technology Inc a domestic profit corporation has been
 * duly incorporated under
 * the laws of the state of Georgia , USA. www.rockersinfo.com
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * - Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.
 * - Redistributions in binary form must reproduce the above copyright notice, this
 *   list of conditions and the following disclaimer in the documentation and/or
 *   other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 ********************************************************************************/

/**
 * The Home class is basically the default controller for the script.
 *
 * @author       Rockers Technology Team
 * @copyright   Copyright (c) 2012-15, Rockers Technology Inc
 * @package    Application\Controllers
 */
class User extends ROCKERS_Controller
{
    function __construct()
    {
        parent::__construct();
        $this->load->helper('url');
        $this->load->library('template');
        $this->load->model('home_model');

        $this->load->helper('form');
        $this->load->library('session');
        $this->load->helper('ckeditor');
        $this->load->library('fb_connect');
    }

    // //////////////=================visitor login in any part of site=========================
    /*
        Function name :login()
        Parameter :
        Return : none
        Use : Load login page on ajax popup
        */
    function login()
    {
        $data['error'] = "";
        $data['view'] = "login";
        $data['msg'] = '';
        $this->load->view(THEME_LOCATION.'user_login', $data);
    }

    /*
        Function name :check_login()
        Parameter :
        Return : none
        Use : Validate login data
        */
    function check_login()
    {
        $this->load->library('form_validation');
        $this->form_validation->set_rules('email', 'Email Address', 'trim|required|valid_email');
        $this->form_validation->set_rules('password', 'Password', 'trim|required');
        if ($this->form_validation->run() == FALSE) {
            if (validation_errors()) {
                $data["error"] = validation_errors();
            } else {
                $data["error"] = "";
            }

            $data['view'] = "login";
            $data['msg'] = '';
            $this->load->view(THEME_LOCATION.'user_login', $data);
        } else {
            $login = $this->home_model->is_login();
            if ($login == '1') {
                $data['msg'] = 'success';
                $data["error"] = "";
                $this->load->view(THEME_LOCATION.'user_login', $data);
            } else {
                $data['error'] = "Email or Password is wrong,please try again...!!!";
                $data['view'] = "login";
                $data['msg'] = 'success';
                $this->load->view(THEME_LOCATION.'user_login', $data);
            }
        }
    }

    // //////////////=================visitor login in any part of site=========================

    function index($msg = '')
    {
        redirect('home');
    }

    /*
        Function name :recent_update_user()
        Parameter :
        Return : none
        Use : Latest update of user
        */
    function recent_update_user()
    {
        $data['donation'] = $this->home_model->get_latest_donations();
        $this->load->view(THEME_LOCATION.'recent_update_user', $data);
    }

    /*
        Function name :is_date()
        Parameter :
        Return : none
        Use : Validate data format for date
        */
    function is_date($date)
    {
        if (preg_match("/^([0-9]{2})-([0-9]{2})-([0-9]{4})$/", $date, $parts)) {
            if (checkdate($parts[2], $parts[1], $parts[3])) return true;
            else $this->form_validation->set_message('is_date', 'Please enter %s dd-mm-yyyy format');
            return false;
        } else $this->form_validation->set_message('is_date', 'Please enter %s dd-mm-yyyy format');
        return false;
    }

    /*
        Function name :image_validation()
        Parameter :
        Return : none
        Use : Validate Image
        */
    function image_validation($image)
    {
        $cnt = count($_FILES['file_up']['name']);
        if (count($_FILES['file_up']['name']) == 0) {
            $this->form_validation->set_message('image_validation', 'Please enter %s dd-mm-yyyy format');
            return false;
        } else {
            $this->form_validation->set_message('image_validation', 'Please enter %s ' . $cnt . ' dd-mm-yyyy format');
            return true;
        }
    }


}

?>
