<?php
/*********************************************************************************
 * This is Crowd Funding Platform by fundraisingscript.com a part of Rockers Technology Inc. is paid software. It is released under the terms of
 * the following BSD License.
 *
 *   Rockers Technology Inc(Head Office)
 *   53 cedar st apt 3416
 *   Woburn, MA- 01801, USA
 *   E-mail Address : nishu@rockersinfo.com
 *
 * Copyright@2012-2020 by Rockers Technology Inc a domestic profit corporation has been
 * duly incorporated under
 * the laws of the state of Georgia , USA. www.rockersinfo.com
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * - Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.
 * - Redistributions in binary form must reproduce the above copyright notice, this
 *   list of conditions and the following disclaimer in the documentation and/or
 *   other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 ********************************************************************************/

/**
 * The Home class is basically the default controller for the script.
 *
 * @author       Rockers Technology Team
 * @copyright   Copyright (c) 2012-15, Rockers Technology Inc
 * @package    Application\Controllers
 */
class Search extends ROCKERS_Controller

{
    function __construct()
    {
        parent::__construct();
        $this->load->model('home_model');
        $this->load->model('equity_model');
        $this->load->library('securimage');
    }

    /*
    Function name :index()
    Parameter :none
    Return : none
    Use : user can see feature projects,latest projects and other detail
    Description : site home page its default function which called http://hostname/home
    SEO friendly URL which is declare in config route.php file  http://hostname/
    */
    /**
     * @param string $type
     */
    function index($type = '')
    {
        $data = array();
        $offset = 0;
        $limit = 3;
        $meta = meta_setting();
        $data['site_setting'] = site_setting();
        // all project category
        $CI = &get_instance();
        if (!$this->simple_cache->is_cached('category_array')) {
            // not cached, do our things that need caching
            $category_array = $this->home_model->get_category();
            $data['category_array'] = $category_array;
            // store in cache
            $CI->simple_cache->cache_item('category_array', $category_array);
        } else {
            $category_array = $CI->simple_cache->get_item('category_array');
            $data['category_array'] = $category_array;
        }
        // all country
        if (!$this->simple_cache->is_cached('state_array')) {
            // not cached, do our things that need caching
            $state_array = $this->home_model->get_state();
            $data['state_array'] = $state_array;
            // store in cache
            $CI->simple_cache->cache_item('state_array', $state_array);
        } else {
            $state_array = $CI->simple_cache->get_item('state_array');
            $data['state_array'] = $state_array;
        }
        if (!$this->simple_cache->is_cached('allcategory')) {
            // not cached, do our things that need caching
            $allcategory = $this->home_model->getallsearchcategory();
            $data['allcategory'] = $allcategory;
            // store in cache
            $CI->simple_cache->cache_item('allcategory', $allcategory);
        } else {
            $allcategory = $CI->simple_cache->get_item('allcategory');
            $data['allcategory'] = $allcategory;
        }


        $keyword = '';
        $title = '';
        $category = '';
        $city = '';
        $state = '';
        $goal_size = '';
        $status = '';
        $goal_type = '';

        $search_criteria = array(
            'keyword' => $keyword,
            'title' => $title,
            'category' => $category,
            'city' => $city,
            'state' => $state,
            'goal_size' => $goal_size,
            'status' => $status,
            'goal_type' => $goal_type
        );
        $data['search_criteria'] = $search_criteria;
        $case = $type;
        if ($type == '') {
            $case = 'all';
        }
        $data['type'] = $type;
       
        $search_msg = '';
        switch ($case) {
            case 'featured':
                $search_equities = $this->equity_model->GetAllSearchEquities(1, 2, array(
                    'user'
                ), 100, array(
                    'equity_id' => 'desc'
                ));
                $data['search_equities'] = $search_equities;
                $search_msg = FEATURED_PROJECTS;
                break;

            case 'rounding_off':
                $search_equities = $this->equity_model->GetAllSearchEquities(0, 2, array(
                    'user'
                ), 100, array(
                    'end_date' => 'asc'
                ), array(), '', 'end_soon');
                $data['search_equities'] = $search_equities;
                $search_msg = ROUNDING_OFF_PROJECTS;
                break;

            case 'popular':
                $search_equities = $this->equity_model->GetAllSearchEquities(0, 2, array(
                    'user'
                ), 100, array(
                    'view_counter' => 'desc'
                ));
                $data['search_equities'] = $search_equities;
                $search_msg = POPULAR_PROJECTS;
                break;

            case 'latest_campaign':
                $search_equities = $this->equity_model->GetAllSearchEquities(0, 2, array(
                    'user'
                ), 100, array(
                    'equity_id' => 'desc'
                ));
                $data['search_equities'] = $search_equities;
                $search_msg = LATEST_COMPAIGNS;
                break;

            case 'near_me':
                echo $type;
                break;

            case 'success_story':
                $search_equities = $this->equity_model->GetAllSearchEquities(0, 3, array(
                    'user'
                ), 100, array(
                    'equity_id' => 'desc'
                ));
                $data['search_equities'] = $search_equities;
                $search_msg = SUCCESS_STORY_PROJECTS;
                break;

            case 'most_funded':
                $search_equities = $this->equity_model->GetAllSearchEquities(0, 2, array(
                    'user'
                ), 100, array(
                    'percentage' => 'desc'
                ));
                $data['search_equities'] = $search_equities;
                $search_msg = MOST_FUNDED_PROJECT;
                break;

            case 'all':
                $search_equities = $this->equity_model->GetAllSearchEquities(0, '2', array(
                    'user'
                ), 100, array(
                    'equity_id' => 'desc'
                ));
                $data['search_equities'] = $search_equities;
                $search_msg = ALL_PROJECTS;
                break;

            case 'search':

                $keyword = SecurePostData($this->input->get('keyword'));
                $title = SecurePostData($this->input->get('title'));
                $category = SecurePostData($this->input->get('category_id'));
                $city = SecurePostData($this->input->get('city'));
                $state = SecurePostData($this->input->get('state_id'));
                $goal_size = SecurePostData($this->input->get('goal_size'));
                $status = SecurePostData($this->input->get('status'));
                $goal_type = SecurePostData($this->input->get('goal_type'));

                // default all active project
                if ($status == "") $status = 1;
                $search_criteria = array(
                    'keyword' => $keyword,
                    'title' => $title,
                    'category' => $category,
                    'city' => $city,
                    'state' => $state,
                    'goal_size' => $goal_size,
                    'status' => $status,
                    'goal_type' => $goal_type
                );

                $search_msg = ADVANCED_SEARCH;
                $i = 0;
                foreach ($search_criteria as $key => $val) {
                    if ($val != "") {
                        $i++;
                    }
                }
                $data['search_criteria'] = $search_criteria;
                $search_equities = $this->equity_model->GetAllSearchEquities(0, '', array(
                    'user'
                ), 100, array(
                    'equity_id' => 'desc'
                ), $search_criteria);
                $data['search_equities'] = $search_equities;
                break;

            default:
                $search_criteria = array(
                    'category' => $type
                );
                $search_equities = $this->equity_model->GetAllSearchEquities(0, '2', array(
                    'user',
                    'company_category'
                ), 100, array(
                    'equity_id' => 'desc'
                ), $search_criteria);
                $data['search_equities'] = $search_equities;
                if (isset($catname[$type])) $search_msg = 'Search By ' . $catname[$type];
                else $search_msg = 'Search By ' . $type;
        }
         $category_id_search='';
        if(isset($_GET['category_id']))
        {
            $category_id_search = $_GET['category_id'];
        }
        
        if($type == 'search' || $type == '')
        {
           
            if($type == 'search' &&  $category_id_search != '')
            {

                $category_data = getCategoryTitle('','','',$category_id_search);
                
         
               if($category_data)
               {
                    $data['cat_name'] = $category_data[0]['company_category_name'];
                    
                    $data['company_category_desc'] = $category_data[0]['company_category_desc'];

                    if($category_data[0]['image'])
                    {
                        $data['image'] = $category_data[0]['image'];
                    }
                    else
                    {
                        $category_data_default = getCategoryTitle('','',2);
                        if(isset($category_data_default[0]))
                            $data['image'] = $category_data_default[0]['image'];
                        else
                            $data['image']='';
                    }
                    
                }
                else
                {
                    $data['cat_name'] = '';
                    $data['image']='';
                    $data['project_category_desc']='';
                    $data['company_category_desc'] = '';
                }
            }
            else
            {

                $category_data = getCategoryTitle('','',2);
         
               if($category_data)
               {
                    $data['cat_name'] = $category_data[0]['company_category_name'];
                    $data['image'] = $category_data[0]['image'];
                    $data['company_category_desc'] = $category_data[0]['company_category_desc'];
                   
                }
                else
                {
                    
                    $data['cat_name'] = '';
                    $data['image']='';
                    $data['company_category_desc']='';
                    
                }

            }

            
           
        }
        else
        {
           
            $category_data = getCategoryTitle($type,$search_msg,'',$category_id_search);

            if(is_array($category_data))
            {
                $data['cat_name'] = $category_data[0]['company_category_name'];
                
                $data['company_category_desc'] = $category_data[0]['company_category_desc'];

                if($category_data[0]['image'])
                { 
                     $data['image'] = $category_data[0]['image'];
                }
                else
                {
                   
                    $category_data_default = getCategoryTitle('','',2);
                    if(isset($category_data_default[0]))
                        $data['image'] = $category_data_default[0]['image'];
                    else
                        $data['image']='';
                }
               
            }
            else
            {
               $category_data_default = getCategoryTitle('','',2);
               if(isset($category_data_default[0]))
               {

                    $data['cat_name'] = $category_data_default[0]['company_category_name'];
                    $data['image'] = $category_data_default[0]['image'];
                    $data['company_category_desc'] = $category_data_default[0]['company_category_desc'];

                }
                else
                {
                    $data['cat_name'] = '';
                    $data['image']='';
                    $data['company_category_desc']='';
                }
                
            }

           
        }
        $today = date("Y-m-d H:i:s");
        $week_date = date('Y-m-d H:i:s', strtotime($today . ' -1 Week'));
        $new_weekly_equities = $this->equity_model->GetAllSearchEquities(0, '2', array(
            'user'
        ), 10, array(
            'equity_id' => 'desc'
        ), '', $week_date);
        $data['new_weekly_equities'] = $new_weekly_equities;
        $data['search_msg'] = $search_msg;
        $data['detail_image'] = '';
        if(!$data['image']) {
            $default_category = $this->db->get_where('company_category', array('status' => 2))->row_object();
            $data['detail_image'] = ($default_category && $default_category->image) ? $default_category->image : '';
        }
        $this->template->write('meta_title', $meta['title'], TRUE);
        $this->template->write('meta_description', $meta['meta_description'], TRUE);
        $this->template->write('meta_keyword', $meta['meta_keyword'], TRUE);
        $this->template->front_write_view('header', 'common/header', $data, TRUE);
        $this->template->front_write_view('main_content', 'home/search', $data, TRUE);
        $this->template->front_write_view('footer', 'common/footer', $data, TRUE);
        $this->template->render();
    }

    /*
    Function name :search_auto()
    Parameter :text ,id
    Return : none
    Use : use for auto search
    */
    function search_auto($text = '', $id = '')
    {
        $data = array();
        $offset = 0;
        $limit = 3;
        $keyword = SecurePostData($text);
        $search_criteria = array(
            'title' => $keyword
        );
        $data['search_criteria'] = $search_criteria;
        $search_equities = $this->equity_model->GetAllSearchEquities(0, 2, array(
            'user'
        ), 50, array(
            'equity_id' => 'desc'
        ), $search_criteria);
        if ($search_equities) {
            $str = '<ul id="srhdiv">';
            foreach ($search_equities as $search_equity) {
                $str .= '<li onclick="selecttext(this);">' . $search_equity['company_name'] . '</li>';
            }
            $str .= '</ul>';
            echo $str;
            die();
        }
        die;
    }
}

?>
