<?php
/*********************************************************************************
 * This is Crowd Funding Platform by fundraisingscript.com a part of Rockers Technology Inc. is paid software. It is released under the terms of
 * the following BSD License.
 *
 *   Rockers Technology Inc(Head Office)
 *   53 cedar st apt 3416
 *   Woburn, MA- 01801, USA
 *   E-mail Address : nishu@rockersinfo.com
 *
 * Copyright@2012-2020 by Rockers Technology Inc a domestic profit corporation has been
 * duly incorporated under
 * the laws of the state of Georgia , USA. www.rockersinfo.com
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * - Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.
 * - Redistributions in binary form must reproduce the above copyright notice, this
 *   list of conditions and the following disclaimer in the documentation and/or
 *   other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 ********************************************************************************/

/**
 * The Home class is basically the default controller for the script.
 *
 * @author       Rockers Technology Team
 * @copyright   Copyright (c) 2012-15, Rockers Technology Inc
 * @package    Application\Controllers
 */
class Payment extends ROCKERS_Controller
{
    /**
     * Constructor method
     */
    function __construct()
    {
        parent::__construct();
        $this->load->model('home_model');
        $this->load->model('investment_step_model');
        $this->load->model('message_model');
        $this->load->model('equity_model');
        $this->load->model('startequity_model');
        $this->load->helper('payment');
    }
    function test()
    {
         $this->load->library('paypal_lib');
         $transId='04Y45397ND101702C';
        $dat=$this->paypal_lib->refund( $transId);
echo "<pre>";print_r($dat);
        die;
    }
     /*
    Function name :paypal_pay()
    Parameter :gateway_id
    Return : none
    Use : Generate Paypal Required data and redirect to Paypal.com
    */
    // //---------paypal wallet----------//////
    /**
     * @param $gateway_id
     */
    function paypal_pay($transaction_id)
    {
       // echo $transaction_id;die;
        $login_user_id=$this->session->userdata('user_id');
        if($transaction_id=="")redirect('/');

        $paymentData=investmentDetailsByTransId($transaction_id);

        $in_process_id = $paymentData['id'];
         $equity_id = $paymentData['equity_id'];
        $gateway_id = 2;
        $invest_status_id = $paymentData['invest_status_id'];
        // var_dump($paymentData);die;
        $user_id = $paymentData['user_id']; $id = $paymentData['id'];

        // if($invest_status_id!=5)
        // {
        //     redirect('investment/investment_step_1/'. $equity_id."/". $id);
        // }
         if($login_user_id!=$user_id)
        {
            redirect('investment/investment_step_1/'. encrypt($equity_id)."/". encrypt($id));
        }

        $tmptransData=tmppreapprovalByTransId($transaction_id);
        $total_amount = $tmptransData['total_amount'];

        $where_user = array('user_id' => $user_id);
        $user_data = $this->investment_step_model->get_equity_process('user', $where_user);

        $get_equity_user_detail = $this->equity_model->GetAllEquities(0, $equity_id);
        $equity_data = $get_equity_user_detail[0];

        $dataGatewayDetails=paymentGatewayDetails();
        $site_setting = site_setting();


        $amt = $total_amount;
        $num = 'WL' . randomNumber(12);
        $this->load->library('paypal_lib');
        $pays = $dataGatewayDetails[$gateway_id];

        $gateway_array = array();
        foreach ($pays as $key => $val) {

            $gateway_array[$val['name']] = $val['value'];
        }

        $Paypal_Email = $gateway_array['paypal_email'];
        $Paypal_Status = $gateway_array['site_status'];
        $gateway_fees = $gateway_array['transaction_fees'];
        $Paypal_Url = 'https://www.sandbox.paypal.com/cgi-bin/webscri';
        if ($Paypal_Status == 'sandbox') {
            $Paypal_Url = 'https://www.sandbox.paypal.com/cgi-bin/webscri';
        }
        if ($Paypal_Status == 'live') {
            $Paypal_Url = 'https://www.paypal.com/cgi-bin/webscri';
        }
       
        if ($equity_data['equity_currency_code'] != '') {
            $currency_code = $equity_data['equity_currency_code'];
        } elseif ($site_setting['currency_code'] != '') {
            $currency_code = $site_setting['currency_code'];
        } else {
            $currency_code = 'USD';
        }
        $this->paypal_lib->add_field('currency_code', $currency_code);
        // $this->paypal_lib->add_field('feesPayer', 'SENDER');

        $this->paypal_lib->add_field('business', $Paypal_Email);
        $this->paypal_lib->add_field('return', site_url('payment/paypal_paySuccess/'.$transaction_id));
        $this->paypal_lib->add_field('cancel_return', site_url('payment/paypal_payCancel/'));
        $this->paypal_lib->add_field('notify_url', site_url('payment/paypal_payIpn/')); // <-- IPN url
        $this->paypal_lib->add_field('custom', str_replace(',', '', $amt) . '#' . $gateway_id . '#' .  $user_id . '#' . $equity_id . '#' . str_replace(',', '', $amt) . '#' . $in_process_id ); // <-- Verify return
        $this->paypal_lib->paypal_url = $Paypal_Url;
        $this->paypal_lib->add_field('item_name', 'Investment on  ' . $site_setting['site_name'] . ' by ' . $user_data['user_name'] . ' ' . $user_data['last_name']);
        $this->paypal_lib->add_field('item_number', $num);
        $this->paypal_lib->add_field('amount', str_replace(',', '', $amt));
        $this->paypal_lib->button('Make Donation');
        $data['paypal_form'] = $this->paypal_lib->paypal_auto_form();
    }
 /* Function name :paypal_payCancel()
    Return : none
    Use : Generate Paypal Required data and redirect to Paypal.com
    */
  
    function paypal_payCancel()
    {
          redirect('/');
    }
     /* Function name :paypal_payIpn()
    Return : none
    Use : Generate Paypal Required data and redirect to Paypal.com
    */
  
    function paypal_payIpn()
    {
         
         $vals = array();
        $strtemp = '';
        $gateway_id=2;
        $this->load->library('paypal_lib');
        $dataGatewayDetails=paymentGatewayDetails();
        $pays = $dataGatewayDetails[$gateway_id];
        
        $gateway_array = array();
        foreach ($pays as $key => $val) {

            $gateway_array[$val['name']] = $val['value'];
        }

        $Paypal_Email = $gateway_array['paypal_email'];
        $Paypal_Status = $gateway_array['site_status'];
        $gateway_fees = $gateway_array['transaction_fees'];
        $Paypal_Url = 'https://www.sandbox.paypal.com/cgi-bin/webscri';
        if ($Paypal_Status == 'sandbox') {
            $Paypal_Url = 'https://www.sandbox.paypal.com/cgi-bin/webscri';
        }
        if ($Paypal_Status == 'live') {
            $Paypal_Url = 'https://www.paypal.com/cgi-bin/webscri';
        }
        $this->paypal_lib->paypal_url = $Paypal_Url;
        $validate_ipn=$this->paypal_lib->validate_ipn();
       // print_r( $validate_ipn);die;


        foreach ($_POST as $key => $value) {
            $vals[$key] = $value;
            $strtemp .= $key . "=" . $value . ",";
        }
        
        log_message('error', "IPN DATA:" . $strtemp);
        
        if (isset($_POST['custom'])) {
            $status = $_POST['payment_status'];
            $custom = explode('#', $_POST['custom']);
            $gateway_id = $custom[1];
            $custom_amt = $custom[0];
            $pay_gross = $custom[0];
            $payee_email = $_POST['payer_email'];
            $payer_status = $_POST['payer_status'];
            $txnid = $_POST['txn_id'];
            $date = date('Y-m-d H:i:s');
            $ip = $_SERVER['REMOTE_ADDR'];
            $user_id = $custom[2];
            $project_id = $custom[3];
            $in_process_id = $custom[5];
            $donar_amount = $custom[0];

            $chk_transaction_id = $this->check_unique_transaction($txnid);
            if ((strtolower($status) == 'completed' or strtolower($status) == 'pending') && $pay_gross >= $custom_amt && $chk_transaction_id == 0)
             {
              
                $data = array(
                    'in_process_id' => $in_process_id,
                    'gateway_id' => 2,
                    'user_id' => $user_id,
                     'txnid' => $txnid,
                    'equity_id' => $project_id
                );

                $temp=$this->status_approveByPayment($data);
            } 

            // redirect('investment/investment_step_4/'. encrypt($project_id)."/". encrypt($in_process_id));
        }
    }
    /* Function name :paypal_paySuccess()
    Return : none
    Use : Generate Paypal Required data and redirect to Paypal.com
    */
    
    function paypal_paySuccess($transaction_id='')
    {
        $vals = array();
        $strtemp = '';
        $gateway_id=2;
        $this->load->library('paypal_lib');
        $dataGatewayDetails=paymentGatewayDetails();
        $pays = $dataGatewayDetails[$gateway_id];
        if(!$_POST){
              $paymentData=investmentDetailsByTransId($transaction_id);

            $in_process_id = $paymentData['id'];
             $equity_id = $paymentData['equity_id'];
            $gateway_id = 2;
            $invest_status_id = $paymentData['invest_status_id'];
            // var_dump($paymentData);die;
            $user_id = $paymentData['user_id']; 
            $id = $paymentData['id'];
            redirect('investment/investment_step_4/'. encrypt($equity_id)."/". encrypt($id));

        }
        $gateway_array = array();
        foreach ($pays as $key => $val) {

            $gateway_array[$val['name']] = $val['value'];
        }

        $Paypal_Email = $gateway_array['paypal_email'];
        $Paypal_Status = $gateway_array['site_status'];
        $gateway_fees = $gateway_array['transaction_fees'];
        $Paypal_Url = 'https://www.sandbox.paypal.com/cgi-bin/webscri';
        if ($Paypal_Status == 'sandbox') {
            $Paypal_Url = 'https://www.sandbox.paypal.com/cgi-bin/webscri';
        }
        if ($Paypal_Status == 'live') {
            $Paypal_Url = 'https://www.paypal.com/cgi-bin/webscri';
        }
        $this->paypal_lib->paypal_url = $Paypal_Url;
        $validate_ipn=$this->paypal_lib->validate_ipn();
       // print_r( $validate_ipn);die;


        foreach ($_POST as $key => $value) {
            $vals[$key] = $value;
            $strtemp .= $key . "=" . $value . ",";
        }
        
        log_message('error', "Success DATA:" . $strtemp);
        
        if (isset($_POST['custom'])) {
            $status = $_POST['payment_status'];
            $custom = explode('#', $_POST['custom']);
            $gateway_id = $custom[1];
            $custom_amt = $custom[0];
            $pay_gross = $custom[0];
            $payee_email = $_POST['payer_email'];
            $payer_status = $_POST['payer_status'];
            $txnid = $_POST['txn_id'];
            $date = date('Y-m-d H:i:s');
            $ip = $_SERVER['REMOTE_ADDR'];
            $user_id = $custom[2];
            $project_id = $custom[3];
            $in_process_id = $custom[5];
            $donar_amount = $custom[0];

            $chk_transaction_id = $this->check_unique_transaction($txnid);
            if ((strtolower($status) == 'completed' or strtolower($status) == 'pending') && $pay_gross >= $custom_amt && $chk_transaction_id == 0)
             {
              
                $data = array(
                    'in_process_id' => $in_process_id,
                    'gateway_id' => 2,
                    'user_id' => $user_id,
                     'txnid' => $txnid,
                    'equity_id' => $project_id
                );

                $temp=$this->status_approveByPayment($data);
            } 

            redirect('investment/investment_step_4/'. encrypt($project_id)."/". encrypt($in_process_id));
        }

        //redirect('home/index/' . $msg);
         redirect('/');
    }

    /*
    Function name :check_unique_transaction()
    Parameter : $txn_id
    Return : none
    Use :check uniue transactionID
    */

    function wepay_pay($transaction_id)
    {
       // echo $transaction_id;die;
        $login_user_id=$this->session->userdata('user_id');
        if($transaction_id=="")redirect('/');

        $paymentData=investmentDetailsByTransId($transaction_id);

        $in_process_id = $paymentData['id'];
        $equity_id = $paymentData['equity_id'];
        $gateway_id = 4;
        // $gateway_id = $paymentData['gateway_id'];

        $invest_status_id = $paymentData['invest_status_id'];
        $user_id = $paymentData['user_id']; $id = $paymentData['id'];

        // if($invest_status_id!=5)
        // {
        //     redirect('investment/investment_step_1/'. $equity_id."/". $id);
        // }
         if($login_user_id!=$user_id)
        {
            redirect('investment/investment_step_1/'. $equity_id."/". $id);
        }

        $tmptransData=tmppreapprovalByTransId($transaction_id);
        $total_amount = $tmptransData['total_amount'];

        $where_user = array('user_id' => $user_id);
        $user_data = $this->investment_step_model->get_equity_process('user', $where_user);

        $get_equity_user_detail = $this->equity_model->GetAllEquities(0, $equity_id);
        $equity_data = $get_equity_user_detail[0];

        $dataGatewayDetails=paymentGatewayDetails();
        $site_setting = site_setting();


        $amt = $total_amount;
        $num = 'WL' . randomNumber(12);
       
        $pays = $dataGatewayDetails[$gateway_id];

        $gateway_array = array();
        foreach ($pays as $key => $val) {

            $gateway_array[$val['name']] = $val['value'];
        }
        if ($equity_data['equity_currency_code'] != '') {
            $currency_code = $equity_data['equity_currency_code'];
        } elseif ($site_setting['currency_code'] != '') {
            $currency_code = $site_setting['currency_code'];
        } else {
            $currency_code = 'USD';
        }
          $data['error'] = '';
        try
        {
            $wepay_client_id = $gateway_array['wepay_client_id'];
            $wepay_client_secret = $gateway_array['wepay_client_secret'];
            $wepay_clinet_access_token = $gateway_array['wepay_clinet_access_token'];
             $wepay_account_id = $gateway_array['wepay_account_id'];
              $wepay_status = $gateway_array['wepay_status'];
              $wepay_fees_payer = $gateway_array['wepay_fees_payer'];
               if(intval($wepay_fees_payer)==0)
                {
                    $fees_payer='payee';
                }else
                {
                    $fees_payer='payer';
                }

            $this->load->library('wepay',$wepay_clinet_access_token);
            if($wepay_status=="test")
            { 

                $wepay_url="https://stage.wepayapi.com/v2/";
                Wepay::useStaging($wepay_client_id,$wepay_client_secret);
                 
            }
            else
            {   
                $wepay_url="https://wepayapi.com/v2/";
                Wepay::useProduction($wepay_client_id,$wepay_client_secret);
            }
                 $wepay = new WePay($wepay_clinet_access_token);
                $last_transaction_id=$transaction_id;
                $donar_amount=$total_amount;
                $ip = $_SERVER['REMOTE_ADDR'];
                $short_description="";
                $long_description="";
                $date_time = date("Y-m-d H:i:s");
                $redirect_uri = site_url('payment/wepay_paySuccess/'.$last_transaction_id);
                $ipn_uri = site_url('payment/wepay_payIpn/'.$last_transaction_id);
                $user_name=$user_data['user_name'] . ' ' . $user_data['last_name'];
                if($currency_code=="CAD")
                {
                    $country="CA";
                }else 
                {
                     $country="US";
                }
                $address=array("country"=>$country);
                $prefill_info=array("email"=>$user_data['email'] ,"name"=>$user_name,"address"=>$address);
                $theme_id=time();
                $name="API Theme for API App: My Sample Application";
                $primary_color="FFFFFF";
                $secondary_color="333333";
                $background_color="F1F1F1";
                $button_color="7cb333";$admin_amount=0;
                $wepay_data=array('account_id' => $wepay_account_id, // ID of the account that you want the money to go to
                                    'amount' => $donar_amount, // dollar amount you want to charge the user
                                    'short_description' => $short_description, // a short description of what the payment is for
                                     'long_description' => $long_description, // a short description of what the payment is for
                                    'type' => "donation",
                                    'fee'   => array (
                                          'app_fee'=> $admin_amount,
                                          'fee_payer' => $fees_payer
                                     ),
                                     'hosted_checkout'   => array ('redirect_uri' => $redirect_uri
                                     ,'mode'=>'iframe',"theme_object" => array (
                                          'name'=> $name,
                                          'primary_color' => $primary_color,
                                          'secondary_color' => $secondary_color,
                                          'background_color' => $background_color,
                                          'button_color' => $button_color
                                     ),'prefill_info'=>$prefill_info),
                                    'currency'          => $currency_code,
                                    'callback_uri'=>$ipn_uri
                                    );
                                    //print_r($wepay_data);die;
                                    
                                   
                                    $checkout = $wepay->request('/checkout/create', array(
                                    'account_id' => $wepay_account_id, // ID of the account that you want the money to go to
                                    'amount' => $donar_amount, // dollar amount you want to charge the user
                                    'short_description' => $short_description, // a short description of what the payment is for
                                    'type' => "donation",
                                    'fee'   => array (
                                          'app_fee'=> $admin_amount,
                                          'fee_payer' => $fees_payer
                                     ),
                                     'hosted_checkout'   => array ('redirect_uri' => $redirect_uri
                                     ,'mode'=>'iframe',"theme_object" => array (
                                          'name'=> $name,
                                          'primary_color' => $primary_color,
                                          'secondary_color' => $secondary_color,
                                          'background_color' => $background_color,
                                          'button_color' => $button_color
                                     ),'prefill_info'=>$prefill_info),
                                    'currency'          =>$currency_code,
                                    'callback_uri'=>$ipn_uri
                                    )); 

                $page=$checkout->hosted_checkout->checkout_uri;
                $data['page'] = $page;

        }
        catch (WePayException $e)
         {
             log_message('error','Wepay Error Wepay_payment 330:'.$e->getMessage());
             $error = $e->getMessage() . "Please try again.\n\n\nThank You.";
             $data['error'] = $error;
                        //$this->load->view('default/paypal_error', $data);
                        //die();
        }
           
         $data['site_setting'] = site_setting();
          $meta = meta_setting();
        $this->template->write('meta_title', $meta['title'], TRUE);
        $this->template->write('meta_description', $meta['meta_description'], TRUE);
        $this->template->write('meta_keyword', $meta['meta_keyword'], TRUE);
        $this->template->front_write_view('header', 'common/header', $data, TRUE);
        $this->template->front_write_view('main_content', 'payment/wepay', $data, TRUE);
        $this->template->front_write_view('footer', 'common/footer', $data, TRUE);
        $this->template->render();    
       
    }
    /*
    Function name :wepay_paySuccess()
    Parameter : $txn_id
    Return : none
    Use :check uniue transactionID
    */

    function wepay_paySuccess($transaction_id)
    {
        $checkout_id =0;
        if(isset($_GET['checkout_id']))$checkout_id = $_GET['checkout_id'];
        log_message('error', "1 checkout_id:" . $checkout_id.",time".date("Y-m-d H:m:s"));
         
        $login_user_id=$this->session->userdata('user_id');
        if($transaction_id=="")redirect('/');

        $paymentData=investmentDetailsByTransId($transaction_id);

        $in_process_id = $paymentData['id'];
        $equity_id = $paymentData['equity_id'];
        $gateway_id =4;
        $invest_status_id = $paymentData['invest_status_id'];
        $user_id = $paymentData['user_id']; $id = $paymentData['id'];

        // if($invest_status_id!=5 or $checkout_id<=0)
        // {
        //     redirect('investment/investment_step_1/'. $equity_id."/". $id);
        // }
         if($login_user_id!=$user_id)
        {
            redirect('investment/investment_step_1/'. $equity_id."/". $id);
        }

        $tmptransData=tmppreapprovalByTransId($transaction_id);
        $total_amount = $tmptransData['total_amount'];

        $where_user = array('user_id' => $user_id);
        $user_data = $this->investment_step_model->get_equity_process('user', $where_user);

        $get_equity_user_detail = $this->equity_model->GetAllEquities(0, $equity_id);
        $equity_data = $get_equity_user_detail[0];

        $dataGatewayDetails=paymentGatewayDetails($gateway_id);
        $site_setting = site_setting();


        $amt = $total_amount;
        $num = 'WL' . randomNumber(12);
       // var_dump($dataGatewayDetails);die;
        $pays = $dataGatewayDetails[$gateway_id];

        $gateway_array = array();
        foreach ($pays as $key => $val) {

            $gateway_array[$val['name']] = $val['value'];
        }
        if ($equity_data['equity_currency_code'] != '') {
            $currency_code = $equity_data['equity_currency_code'];
        } elseif ($site_setting['currency_code'] != '') {
            $currency_code = $site_setting['currency_code'];
        } else {
            $currency_code = 'USD';
        }
          $data['error'] = '';
        try
        {

             //log_message('error', "transaction query:" . "select * from temp_preapprove where temp_pre_id='".$transaction_id."'".",time".date("Y-m-d H:m:s"));
            //redirect('home/index/done');
            $txnid=$checkout_id;
            $get_temp_transaction=$this->db->query("select * from transaction where txnid='".$checkout_id."'");
            $chk_transaction=$get_temp_transaction->num_rows();
            //echo $checkout_id; 
            if($chk_transaction<=0)
            {
                    $wepay_client_id = $gateway_array['wepay_client_id'];
                    $wepay_client_secret = $gateway_array['wepay_client_secret'];
                    $wepay_clinet_access_token = $gateway_array['wepay_clinet_access_token'];
                     $wepay_account_id = $gateway_array['wepay_account_id'];
                      $wepay_status = $gateway_array['wepay_status'];
                      $wepay_fees_payer = $gateway_array['wepay_fees_payer'];
                       if(intval($wepay_fees_payer)==0)
                        {
                            $fees_payer='payee';
                        }else
                        {
                            $fees_payer='payer';
                        }

                    $this->load->library('wepay',$wepay_clinet_access_token);
                    if($wepay_status=="test")
                    { 

                        $wepay_url="https://stage.wepayapi.com/v2/";
                        Wepay::useStaging($wepay_client_id,$wepay_client_secret);
                         
                    }
                    else
                    {   
                        $wepay_url="https://wepayapi.com/v2/";
                        Wepay::useProduction($wepay_client_id,$wepay_client_secret);
                    }
                    $wepay = new WePay($wepay_clinet_access_token);
                    $checkout = $wepay->request('checkout',array('checkout_id'=>$checkout_id));

                    $checkout_state = $checkout->state;
                     $trans_status=true;
                    if($checkout_state=='cancelled' or $checkout_state=='expired' or $checkout_state=='failed')
                    {
                        $trans_status=false;
                    }
                     if ($trans_status==true)
                     {
                      
                        $data = array(
                            'in_process_id' => $in_process_id,
                            'gateway_id' => 4,
                            'user_id' => $user_id,
                             'txnid' => $txnid,
                            'equity_id' => $equity_id
                        );

                        $temp=$this->status_approveByPayment($data);
                    } 

                    redirect('investment/investment_step_4/'. $equity_id."/". $in_process_id);
                }    

        }
        catch (WePayException $e)
         {
             log_message('error','Wepay Error Wepay_payment 330:'.$e->getMessage());
             $error = $e->getMessage() . "Please try again.\n\n\nThank You.";
             $data['error'] = $error;
                        //$this->load->view('default/paypal_error', $data);
                        //die();
        }  
        
          $data['site_setting'] = site_setting();
          $meta = meta_setting();
        $this->template->write('meta_title', $meta['title'], TRUE);
        $this->template->write('meta_description', $meta['meta_description'], TRUE);
        $this->template->write('meta_keyword', $meta['meta_keyword'], TRUE);
        $this->template->front_write_view('header', 'common/header', $data, TRUE);
        $this->template->front_write_view('main_content', 'payment/wepay', $data, TRUE);
        $this->template->front_write_view('footer', 'common/footer', $data, TRUE);
        $this->template->render();       
    }
     /* Function name :paypal_payIpn()
    Return : none
    Use : Generate Paypal Required data and redirect to Paypal.com
    */
  
    function wepay_payIpn()
    {
          $vals = array();
        $strtemp = '';

        foreach ($_POST as $key => $value) {
            $vals[$key] = $value;
            $strtemp .= $key . "=" . $value . ",";
        }
        log_message('error', "Wepay IPN DATA:" . $strtemp);
    }

     /*
    Function name :wepay_paySuccess()
    Parameter : $txn_id
    Return : none
    Use :check uniue transactionID
    */

    function stripe_pay($transaction_id)
    {
      // echo $transaction_id;die;
         
        $login_user_id=$this->session->userdata('user_id');
        if($transaction_id=="")redirect('/');

        $paymentData=investmentDetailsByTransId($transaction_id);

        $in_process_id = $paymentData['id'];
        $equity_id = $paymentData['equity_id'];
        $gateway_id = $paymentData['gateway_id'];
        $invest_status_id = $paymentData['invest_status_id'];
        $user_id = $paymentData['user_id']; $id = $paymentData['id'];

        // if($invest_status_id!=5)
        // {
        //     redirect('investment/investment_step_1/'. $equity_id."/". $id);
        // }
         if($login_user_id!=$user_id)
        {
            redirect('investment/investment_step_1/'. $equity_id."/". $id);
        }

        $tmptransData=tmppreapprovalByTransId($transaction_id);
        $total_amount = $tmptransData['total_amount'];

        $where_user = array('user_id' => $user_id);
        $user_data = $this->investment_step_model->get_equity_process('user', $where_user);

        $get_equity_user_detail = $this->equity_model->GetAllEquities(0, $equity_id);
        $equity_data = $get_equity_user_detail[0];

        $dataGatewayDetails=paymentGatewayDetails();
        $site_setting = site_setting();

        $token  = $_POST['stripeToken'];
        $email=$_POST['stripeEmail'];
        $amount=$total_amount;
        $currency= $equity_data['equity_currency_code'];

        

        if(in_array($currency,array('JPY','NZD','BIF','DJF','KRW','PYG','VND','XAF','XPF','CLP','GNF','KMF','MGA','RWF','VUV','XOF'))){
            $amount = $amount;
           
        } else{
            $amount = $amount*100;
         
        }
        $this->load->library('stripe');                            
        $dat=$this->stripe->charge($token,$email,$amount,$currency);
        if($dat['status']=="fail")
        {
            
                $data['site_setting'] = site_setting();
                $meta = meta_setting();
                $data['error']=$dat['message'];
                $this->template->write('meta_title', $meta['title'], TRUE);
                $this->template->write('meta_description', $meta['meta_description'], TRUE);
                $this->template->write('meta_keyword', $meta['meta_keyword'], TRUE);
                $this->template->front_write_view('header', 'common/header', $data, TRUE);
                $this->template->front_write_view('main_content', 'paypal_error', $data, TRUE);
                $this->template->front_write_view('footer', 'common/footer', $data, TRUE);
                $this->template->render();  
           
        }else
        {
                       $txnid=$dat['message'];
                        $data = array(
                            'in_process_id' => $in_process_id,
                            'gateway_id' => 3,
                            'user_id' => $user_id,
                             'txnid' => $txnid,
                            'equity_id' => $equity_id
                        );

                        $temp=$this->status_approveByPayment($data);
                   

                    redirect('investment/investment_step_4/'. $equity_id."/". $in_process_id);
        }
    }        
/*
    Function name :check_unique_transaction()
    Parameter : $txn_id
    Return : none
    Use :check uniue transactionID
    */

    function check_unique_transaction($txn_id)
    {
            $query = $this->db->query("select * from transaction where txnid='" . $txn_id . "'");
            if ($query->num_rows() > 0) {
                return 1;
            }
            return 0;
    }
 /*
    Function name :status_approveByPayment()
    Parameter : $in_process_id
    Return : none
    Use :update status
    */

    function status_approveByPayment($data = array())
    {


            $in_process_id = $data['in_process_id'];
            $user_id = $data['user_id'];
              $txnid = $data['txnid'];
            $equity_id = $data['equity_id'];
              $gateway_id = $data['gateway_id'];
            $update_id = 7;

            $data_update = array(
                'invest_status_id' => $update_id

            );
            admin_activity('approve_acknowledge_contract', $user_id, 0, $equity_id);

            $this->investment_step_model->AddUpdateData('equity_investment_process', $data_update, $in_process_id, 'id');
            $data['success'] = "Step 4. has been confirmed and completed. Proceed to the Step 5. Shares/Documents";

            $where_equity = array(
                'equity_id' => $equity_id
            );


            //$equity_data = $this->investment_step_model->get_equity_process('equity', $where_equity);

            $get_equity_user_detail = $this->equity_model->GetAllEquities(0, $equity_id);

            $equity_data = $get_equity_user_detail[0];



            $where_user = array(
                'user_id' => $user_id
            );

            $user_data = $this->investment_step_model->get_equity_process('user', $where_user);
             $language_id=GetUserLangCode( $user_id);
            $email_template = $this->db->query("select * from `email_template` where task='Payment Reciept Approved' and language_id=".$language_id);

            $email_temp = $email_template->row();

            $email_address_from = $email_temp->from_address;
            $email_address_reply = $email_temp->reply_address;
            $email_subject = $email_temp->subject;
            $email_message = $email_temp->message;


            $username = $user_data['user_name'];
            $email = $user_data['email'];
            $email_to = $email;
            $equity_name = SecureShowData($equity_data['company_name']);

            $site_setting = site_setting();
            $site_name = $site_setting['site_name'];
            $taxonomy_setting = taxonomy_setting();
            $project_name = $taxonomy_setting['project_name'];
            $funds = $taxonomy_setting['funds'];

            $email_subject = str_replace('{site_name}', $site_name, $email_subject);
            $email_subject = str_replace('{funds}', $funds, $email_subject);


            $project_link = '<a href="' . site_url('investment/investor/' . $equity_id.'/'.$in_process_id) . '">click here</a>';

            $message_to_owner_link = '<a href="' . site_url('inbox/sendmessage/' . $equity_id) . '">' . site_url('inbox/sendmessage/' . $equity_id) . '</a>';

            $email_message = str_replace('{break}', '<br/>', $email_message);
            $email_message = str_replace('{user_name}', $username, $email_message);
            $email_message = str_replace('{click_here}', $project_link, $email_message);
            $email_message = str_replace('{site_name}', $site_name, $email_message);
            $email_message = str_replace('{message_to_admin}', $message_to_owner_link, $email_message);

            $str = $email_message;

            email_send($email_address_from, $email_address_reply, $email_to, $email_subject, $str);

            //send message
            //$login_id = $this->session->userdata('admin_id');

            $data_insert = array(
                'sender_id' => $admin_id,
                'receiver_id' => $user_id,
                'is_read' => 0,
                'message_subject' => $email_subject,
                'message_content' => $str,
                'date_added' => date('Y-m-d H:i:s'),
                'type' => $admin_id,
                'equity_id' => $equity_id
            );

            //$message_insert = $this->message_model->insert_project_profile_message($data_insert);
            $message_setting = message_setting();
            $user_id = $user_id;
            $user_detail = UserData($user_id, array());
            $login_user_detail = UserData($admin_id, array());
            $message_setting->message_enable;

            $message_user_profile_link = '';

            $user_name = $user_detail[0]['user_name'];
            $message_user_name = $login_user_detail[0]['user_name'];
            $content = $str;


            //insert into transaction table
            $where_equity = array(
                'id' => $in_process_id
            );

            $investor_data = $this->investment_step_model->get_equity_process('equity_investment_process', $where_equity);

            $preapprovalKey = $investor_data['transaction_id'];
            $get_other_detail_trans = $this->db->query("select * from temp_preapprove where preapprovalKey='" . $preapprovalKey . "'");
            $detail_trans = $get_other_detail_trans->row();

            $equity_id = $detail_trans->equity_id;
            $donor_id = $detail_trans->user_id;
            $user_all_data = UserData($donor_id);
            $detail_trans->donor_email = $user_all_data[0]['email'];
            $donor_id = $user_id;
            $equity_id = $equity_id;
            $perk_id = $detail_trans->perk_id;


            $donar_comment = SecurePostData($detail_trans->comment);
            $total_amount = $detail_trans->total_amount;
            $project_owner_amount = $detail_trans->total_amount;
            $anonymous = $detail_trans->temp_anonymous;


            $get_other_detail_trans = $this->db->query("select * from transaction where preapproval_key='" . $preapprovalKey . "'");
            $nums_rows = $get_other_detail_trans->num_rows();
            if ($nums_rows <= 0) {
                $insert = $this->db->query("insert into transaction (`txnid`,`user_id`,`equity_id`,`perk_id`,`amount`,`host_ip`,`comment`,`transaction_date_time`,`preapproval_key`,`preapproval_status`,`preapproval_total_amount`,`gateway_id`)values('" . $txnid . "','" . $donor_id . "','" . $equity_id . "','" . $perk_id . "','" . $project_owner_amount . "','" . $_SERVER['REMOTE_ADDR'] . "','" . $donar_comment . "','" . date("Y-m-d H:i:s") . "','" . $preapprovalKey . "','SUCCESS','" . $total_amount . "','" .  $gateway_id . "')");

                // activity added
                $amount_array = array('amount' => set_currency($total_amount, $equity_id));
                project_activity('funded', $donor_id, $equity_data['user_id'], $equity_id, $amount_array);

                $this->update_project_perk($equity_id, $perk_id, $project_owner_amount);

                $get_project_user_detail = $this->equity_model->GetAllEquities(0, $equity_id);
                $prj = $get_project_user_detail[0];
                $user_all_data = UserData($donor_id);
                $user_detail = $user_all_data[0];
                $this->adminalerts($prj, $detail_trans, $user_detail);


                //$insert = $this->db->query("delete from temp_preapprove where preapprovalKey='" . $preapprovalKey . "'" );
            }
             return 0;
    }

    function payment_withdraw($equity_id=0)
    {

            $id=$equity_id;  
            check_user_authentication(true);
            if ($id > 0) {
                if (!$this->startequity_model->is_equity_owner($id, false)) {
                    redirect('home/notedit_project');
                }
            }
            $get_other_detail_trans = $this->db->query("select * from payment_withdraw where equity_id='" . $equity_id . "'");
            $nums_rows = $get_other_detail_trans->num_rows();
            if ($nums_rows <= 0) {
                 $status = 5; $request_date = date('Y-m-d H:i:s');
                $insert = $this->db->query("insert into payment_withdraw (`equity_id`,`status`,`request_date`)values('" . $equity_id . "','" . $status . "','" . $request_date . "')");

             
            }else
            {    $status = 5; $request_date = date('Y-m-d H:i:s');
                 $insert = $this->db->query("update payment_withdraw set `status`='" . $status . "',`request_date` = '" . $request_date . "' where equity_id='" . $equity_id . "' ");
            }


                $admin_email_detail = $this->db->query("select * from `admin` where admin_type='1' and active='1'");
                $admin_detail = $admin_email_detail->row();


                $project_detail = $this->db->query("select * from `equity` where equity_id =".$equity_id);
                $proj_detail = $project_detail->row();

                 $language_id = GetUserLangCode($this->session->userdata('user_id'));
                $email_template = $this->db->query("select * from `email_template` where task='Request For Payment Notification Email' and language_id=" . $language_id);
                $email_temp = $email_template->row();

                $email_address_from = $email_temp->from_address;
                $email_address_reply = $email_temp->reply_address;
                $email_subject = $email_temp->subject;
                $email_message = $email_temp->message;
                $email_to = $admin_detail->email;
                $name = $admin_detail->username;
                $equity_url= $proj_detail->equity_url;
                $amount_get= $proj_detail->amount_get;
              
                $project_page_link = site_url('admin/equity/equity_detail/'.$equity_url.'#payout');
                $proj_confirm_link='<a href="' . $project_page_link . '">link</a>';
                $deduct_pro_amt=set_currency($amount_get, $data['equity_id']);
                // $details = '<table border="0" cellpadding="3" cellspacing="0">
                // <tr><td>' . NAME . ': </td><td>' . $u["user_name"] . ' ' . $u["last_name"] . '</td></tr>
                // <tr><td>' . YOUR_EMAIL . ' : </td><td>' . $u["email"] . '</td></tr>
                // <tr><td>' . REQUESTED_AMOUNT . ' : </td><td>' . set_currency($w->withdraw_amount, $data['project_id']) . '</td></tr>
                // <tr><td>' . AMOUNT_PAY . ' : </td><td>' . set_currency($amount, $data['project_id']) . '</td></tr>
                // <tr><td> ' . WITHDRAW_METHOD . ' : </td><td>' . $withdraw_method . '</td></tr>';
                $email_message = str_replace('{break}', '<br/>', $email_message);
                $email_message = str_replace('{user_name}', $name, $email_message);
                $email_message = str_replace('{break}', '<br/>', $email_message);
                $email_message = str_replace('{donote_amount}', $deduct_pro_amt, $email_message);
              //  $email_message = str_replace('{project_name}', $proj_name, $email_message);
                $email_message = str_replace('{link_confirm}', $proj_confirm_link, $email_message);
                //$email_message = str_replace('{details}', $details, $email_message);
                $str = $email_message;
                email_send($email_address_from, $email_address_reply, $email_to, $email_subject, $str);

             redirect('equity/dashboard/'.$equity_id);
    }
    
   
}
?>
