<?php
/*********************************************************************************
 * This is Crowd Funding Platform by fundraisingscript.com a part of Rockers Technology Inc. is paid software. It is released under the terms of
 * the following BSD License.
 *
 *   Rockers Technology Inc(Head Office)
 *   53 cedar st apt 3416
 *   Woburn, MA- 01801, USA
 *   E-mail Address : nishu@rockersinfo.com
 *
 * Copyright@2012-2020 by Rockers Technology Inc a domestic profit corporation has been
 * duly incorporated under
 * the laws of the state of Georgia , USA. www.rockersinfo.com
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * - Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.
 * - Redistributions in binary form must reproduce the above copyright notice, this
 *   list of conditions and the following disclaimer in the documentation and/or
 *   other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 ********************************************************************************/

/**
 * The Home class is basically the default controller for the script.
 *
 * @author       Rockers Technology Team
 * @copyright   Copyright (c) 2012-15, Rockers Technology Inc
 * @package    Application\Controllers
 */
class Accreditation extends ROCKERS_Controller
{

    /*
        Load by default when controller call is made
        args: none
    */

    /**
     *
     */
    function __construct()
    {
        parent::__construct();
        $this->load->model('home_model');
        $this->load->library('securimage');
        $this->load->library('pagination');
        $this->load->model('accreditation_model');
    }


    /*
     Function name :index()
     Parameter :none
     Return : none
     Use : to show the users investment account detail

     */
    public function index()
    {
        $user_id = check_user_authentication(true);
        /* make all fields null on first load */
        $data['legal_first'] = $data['legal_last'] = $data['address1'] = $data['address2'] =
        $data['city'] = $data['state'] = $data['country'] = $data['zip'] = $data['phone'] =
        $data['account_type'] = $data['bank_name'] = $data['account_no'] = $data['account_no_conf'] =
        $data['routing_no'] = $data['accredited'] = $data['accredited'] = $data['accreditation_status'] = null;

        $data['success_msg'] = $this->session->flashdata('common_success_msg');
        $data['error_msg'] = $this->session->flashdata('common_error_msg');

        $user_details = UserData($user_id);

        $accreditation_data = $this->accreditation_model->getTableData('accreditation', array('user_id' => $user_id));
        if ($accreditation_data) {

            $data['legal_first'] = $accreditation_data[0]['legal_first_name'];

            $data['legal_last'] = $accreditation_data[0]['legal_last_name'];

            $data['address1'] = $accreditation_data[0]['address1'];

            $data['address2'] = $accreditation_data[0]['address2'];

            $data['city'] = $accreditation_data[0]['city'];

            $data['state'] = $accreditation_data[0]['state'];

            $data['country'] = $accreditation_data[0]['country'];

            $data['zip'] = $accreditation_data[0]['zip'];

            $data['phone'] = $accreditation_data[0]['verification_phone_number'];

            $data['account_type'] = $accreditation_data[0]['account_type'];

            $data['bank_name'] = $accreditation_data[0]['bank_name'];

            $data['account_no'] = $accreditation_data[0]['account_no'];

            $data['routing_no'] = $accreditation_data[0]['routing_no'];

            $data['accredited'] = $accreditation_data[0]['accredited'];

            $data['accreditation_status'] = $accreditation_data[0]['accreditation_status'];


        } else if ($user_details) {

            $data['legal_first'] = $user_details[0]['user_name'];

            $data['legal_last'] = $user_details[0]['last_name'];

            $data['address1'] = $user_details[0]['address'];

             $data['phone'] = $user_details[0]['phone'];
            $data['zip'] = $user_details[0]['zip_code'];


        }

        /* load meta/site information */
        $meta = meta_setting();
        $data['site_setting'] = site_setting();

        /* render meta information */
        $this->template->write('meta_title', $meta['title'], TRUE);
        $this->template->write('meta_description', $meta['meta_description'], TRUE);
        $this->template->write('meta_keyword', $meta['meta_keyword'], TRUE);

        /* render the template */
        $this->template->front_write_view('header', 'common/header', $data, TRUE);
        $this->template->front_write_view('main_content', 'accreditation/investment_account', $data, TRUE);
        $this->template->front_write_view('footer', 'common/footer', $data, TRUE);
        $this->template->render();
    }

    /*
     Function name :personal()
     Parameter :none
     Return : none
     Use :  edit/add personal information controller

     */
    public function personal()
    {
        $user_id = check_user_authentication(true);
        $data = array();
        $data['user_id'] = $user_id;

        /* make all fields null on first load */
        $data['legal_first'] = $data['legal_last'] = $data['address1'] = $data['address2'] =
        $data['city'] = $data['state'] = $data['country'] = $data['zip'] = $data['phone'] =
        $data['account_type'] = $data['bank_name'] = $data['account_no'] = $data['account_no_conf'] =
        $data['routing_no'] = $data['accre_id'] = null;
        /*get  all country*/
        $country_data = $this->accreditation_model->getTableData('country');
        $data['country_data'] = $country_data;

        // get user details
        $user_details = $this->accreditation_model->getTableData('user', array('user_id' => $user_id));

        $account_type_data = $this->accreditation_model->getTableData('account_type', array('status' => 1));
        $data['account_type_data'] = $account_type_data;

        /*get  accreditation data if already exist in table */

        $accreditation_data = $this->accreditation_model->getTableData('accreditation', array('user_id' => $user_id));
        if ($accreditation_data) {


            $data['accre_id'] = $accreditation_data[0]['id'];

            $data['legal_first'] = $accreditation_data[0]['legal_first_name'];

            $data['legal_last'] = $accreditation_data[0]['legal_last_name'];

            $data['address1'] = $accreditation_data[0]['address1'];

            $data['address2'] = $accreditation_data[0]['address2'];

            $data['city'] = $accreditation_data[0]['city'];

            $data['state'] = $accreditation_data[0]['state'];

            $data['country'] = $accreditation_data[0]['country'];

            $data['zip'] = $accreditation_data[0]['zip'];

            $data['phone'] = $accreditation_data[0]['verification_phone_number'];

            $data['account_type'] = $accreditation_data[0]['account_type'];

            $data['bank_name'] = $accreditation_data[0]['bank_name'];

            $data['account_no'] = $accreditation_data[0]['account_no'];

            $data['account_no_conf'] = $accreditation_data[0]['account_no'];

            $data['routing_no'] = $accreditation_data[0]['routing_no'];
        } else if ($user_details) {

            $data['legal_first'] = $user_details[0]['user_name'];

            $data['legal_last'] = $user_details[0]['last_name'];

            $data['address1'] = $user_details[0]['address'];

            $data['city'] = $user_details[0]['city'];

            $data['state'] = $user_details[0]['state'];

            $data['phone'] = $user_details[0]['phone'];

            $data['country'] = $user_details[0]['country'];

            $data['zip'] = $user_details[0]['zip_code'];


        }


        $this->form_validation->set_rules('legal_first', LEGAL_FIRST_NAME, 'required|min_length[3]|max_length[30]');

        $this->form_validation->set_rules('legal_last', LEGAL_LAST_NAME, 'required|min_length[3]|max_length[30]');

        $this->form_validation->set_rules('address1', ADDRESS, 'required');

        $this->form_validation->set_rules('city', CITY, 'required');

        $this->form_validation->set_rules('state', STATE, 'required');

        $this->form_validation->set_rules('country', COUNTRY, 'required');

        $this->form_validation->set_rules('zip', ZIP_CODE, 'required');

        $this->form_validation->set_rules('phone', PHONE_NUMBER, 'required|numeric|min_length[10]|max_length[15]');

        $this->form_validation->set_rules('account_type', ACCOUNT_TYPE, 'required');

        $this->form_validation->set_rules('bank_name', BANK_NAME, 'required');

        $this->form_validation->set_rules('account_no', ACCOUNT_NUMBER, 'required|min_length[4]|max_length[40]');

        $this->form_validation->set_rules('account_no_conf', CONFIRM_ACCOUNT_NO, 'required|matches[account_no]');

        $this->form_validation->set_rules('routing_no', ROUTING_NUMBER, 'required|min_length[4]|max_length[40]');

        if ($_POST) {
            /* set default form rules */

            /* check if rules are passes or not */
            if ($this->form_validation->run() == false) {


                /* put old values to form for better UX */
                $data['legal_first'] = SecurePostData($this->input->post('legal_first'));

                $data['legal_last'] = SecurePostData($this->input->post('legal_last'));

                $data['address1'] = SecurePostData($this->input->post('address1'));

                $data['city'] = SecurePostData($this->input->post('city'));

                $data['state'] = SecurePostData($this->input->post('state'));

                $data['country'] = SecurePostData($this->input->post('country'));

                $data['zip'] = SecurePostData($this->input->post('zip'));

                $data['phone'] = SecurePostData($this->input->post('phone'));

                $data['account_type'] = SecurePostData($this->input->post('account_type'));

                $data['bank_name'] = SecurePostData($this->input->post('bank_name'));

                $data['account_no'] = SecurePostData($this->input->post('account_no'));

                $data['account_no_conf'] = SecurePostData($this->input->post('account_no_conf'));

                $data['routing_no'] = SecurePostData($this->input->post('routing_no'));
            } else {
                /* prepare array for database insertion */

                $insert = array(
                    'user_id' => $user_id,
                    'legal_first_name' => SecurePostData($this->input->post('legal_first')),
                    'legal_last_name' => SecurePostData($this->input->post('legal_last')),
                    'address1' => SecurePostData($this->input->post('address1')),
                    'address2' => SecurePostData($this->input->post('address2')),
                    'city' => SecurePostData($this->input->post('city')),
                    'state' => SecurePostData($this->input->post('state')),
                    'country' => SecurePostData($this->input->post('country')),
                    'zip' => SecurePostData($this->input->post('zip')),
                    'phone' => SecurePostData($this->input->post('phone')),
                    'verification_phone_number' => SecurePostData($this->input->post('phone')),
                    'account_type' => SecurePostData($this->input->post('account_type')),
                    'bank_name' => SecurePostData($this->input->post('bank_name')),
                    'account_no' => SecurePostData($this->input->post('account_no_conf')),
                    'routing_no' => SecurePostData($this->input->post('routing_no')),
                    'accreditation_date' => date('Y-m-d H:i:s')
                );
                if ($this->input->post('accre_id') > 0) {
                    /* insert prepared array into database */
                   $this->accreditation_model->AddInsertUpdateTable('accreditation', 'id', SecurePostData($this->input->post('accre_id')), $insert);

                } else {
                    $this->accreditation_model->AddInsertUpdateTable('accreditation', '', '', $insert);
                }
                /* set one time message */
                $this->session->set_flashdata('common_success_msg', PERSONAL_INFORMATION_ADDED_SUCCESSFULLY);



                $redirect = true;
                $accreditation_data = $this->accreditation_model->getTableData('accreditation', array('user_id' => $user_id));
                if ($accreditation_data) {


                    if ($accreditation_data[0]['accreditation_status'] != '0') {
                        /* set one time message */
                        $redirect = false;

                    }
                }

                if ($redirect == false) redirect('accreditation');
                else redirect('accreditation/status');
            }
        }

        /* load meta/site information */
        $meta = meta_setting();
        $data['site_setting'] = site_setting();

        /* render meta information */
        $this->template->write('meta_title', $meta['title'], TRUE);
        $this->template->write('meta_description', $meta['meta_description'], TRUE);
        $this->template->write('meta_keyword', $meta['meta_keyword'], TRUE);

        /* render the template */
        $this->template->front_write_view('header', 'common/header', $data, TRUE);
        $this->template->front_write_view('main_content', 'accreditation/personal', $data, TRUE);
        $this->template->front_write_view('footer', 'common/footer', $data, TRUE);
        $this->template->render();
    }

    /*
      Function name :status()
      Parameter :none
      Return : none
      Use :  edit/add accreditation  information controller

      */
    public function status()
    {
        $user_id = check_user_authentication(true);

        $data = array();
        $data['user_id'] = $user_id;
        $data["error"] = '';

        $data['success_msg'] = $this->session->flashdata('common_success_msg');
        $data['error_msg'] = $this->session->flashdata('common_error_msg');

        /* make all fields null on first load */
        $data['accredited'] = $data['accreditation_status'] = $data['income'] = $data['accreditation_type'] = $data['verification_phone_number'] =
        $data['verification_accreditation_letter'] = null;

        /*get  accreditation data if already exist in table */
        $accreditation_id = '';
        $accreditation_data = $this->accreditation_model->getTableData('accreditation', array('user_id' => $user_id));
        if ($accreditation_data) {
            $accreditation_id = $accreditation_data[0]['id'];

            if ($accreditation_data[0]['accreditation_status'] == '1') {
                /* set one time message */
                $this->session->set_flashdata('common_error_msg', YOU_HAVE_ALREADY_APPLIED_FOR_ACCREDITATION);

                /* redirect */
                redirect('accreditation');

            }

        } else {
            /* set one time message */
            $this->session->set_flashdata('common_error_msg', FIRST_FILL_PERSONAL_INFORMATION);
            /* redirect */
            redirect('accreditation/personal');
        }

        if ($this->input->post()) {


            /* set default form rules */
            if(isset($_POST['check_phone_call']))
            {
                
                if($this->input->post('check_phone_call') == '1')
                {
                  
                    $this->form_validation->set_rules('verification_phone_number', REQUEST_A_PHONE_CALL, 'required|numeric|min_length[10]');
                }
            }
           
               
            $this->form_validation->set_rules('accredited', ACCREDITED, 'required');
             $this->form_validation->set_rules('agree1', I_AGREE_ON_TERMS_AND_CONDITION, 'required');
              $this->form_validation->set_rules('agree2', I_AGREE_ON_ACKNOWLEDGEMENT_OF_RISK_WARNING_AND_DISCLOSURE, 'required');
              $data['error_msg']='';
            $data['create_step_error_number']='';
            /* check if rules are passes or not */
            if ($this->form_validation->run() == false ) {
               
                /* put old values to form for better UX */
                $data['accredited'] = SecurePostData($this->input->post('accredited'));

                $data['income'] = SecurePostData($this->input->post('income'));

                $data['accreditation_type'] = SecurePostData($this->input->post('accreditation_type'));

                $data['verification_phone_number'] = SecurePostData($this->input->post('verification_phone_number'));
                $data['error_msg']=  validation_errors();

            } else {
               // echo "012";die;
                switch ($this->input->post('accreditation_type')) {
                    case '0':
                        $income = 1000000;
                        break;
                    case '1':
                        $income = SecurePostData($this->input->post('individual_income'));
                        break;
                    case '2':
                        $income = SecurePostData($this->input->post('combined_income'));
                        break;
                    case '3':
                        $income = SecurePostData($this->input->post('business_income'));
                        break;


                }
                $filename='';
                if ($accreditation_data) {
                    if ($accreditation_data[0]['verification_accreditation_letter'] != '') {
                        $filename = $accreditation_data[0]['verification_accreditation_letter'];
                    }
                }
                
                   $verification_phone_number='';
                 if($this->input->post('check_phone_call') == '1'){
                      $verification_phone_number=$this->input->post('verification_phone_number');
                 }

                /* prepare array for database insertion */
                $insert = array(
                    'user_id' => $user_id,
                    'accredited' => SecurePostData($this->input->post('accredited')),
                    'accreditation_income' => $income,
                    'accreditation_status' => 0,
                    'accreditation_type' => SecurePostData($this->input->post('accreditation_type')),
                    'verification_phone_number' =>$verification_phone_number,
                    'verification_accreditation_letter' => $filename
                );

                /* insert prepared array into database */
                $this->accreditation_model->AddInsertUpdateTable('accreditation', 'id', $accreditation_id, $insert);

                user_activity('accredetial_request', $user_id, 0, 0);

                /* set one time message */
                $this->session->set_flashdata('common_success_msg', ACCREDITATION_ADDED_SUCCESSFULLY);

                /* redirect */
                redirect('accreditation');
            }
        } else if ($accreditation_data) {


            /* put old values to form for better UX */
            $data['accredited'] = $accreditation_data[0]['accredited'];

            $data['income'] = $accreditation_data[0]['accreditation_income'];

            $data['accreditation_type'] = $accreditation_data[0]['accreditation_type'];

            if ($accreditation_data[0]['verification_phone_number'] != '') {
                $data['verification_phone_number'] = $accreditation_data[0]['verification_phone_number'];
            } else {
                $data['verification_phone_number'] = $accreditation_data[0]['phone'];
            }

            $data['verification_accreditation_letter'] = $accreditation_data[0]['verification_accreditation_letter'];

        }


        /* load meta/site information */
        $meta = meta_setting();
        $data['site_setting'] = site_setting();

        /* render meta information */
        $this->template->write('meta_title', $meta['title'], TRUE);
        $this->template->write('meta_description', $meta['meta_description'], TRUE);
        $this->template->write('meta_keyword', $meta['meta_keyword'], TRUE);

        /* render the template */
        $this->template->front_write_view('header', 'common/header', $data, TRUE);
        $this->template->front_write_view('main_content', 'accreditation/status', $data, TRUE);
        $this->template->front_write_view('footer', 'common/footer', $data, TRUE);
        $this->template->render();
    }

    /*
    Function name :accrediated_document()
    Parameter :none
    Return : none
    Use : accrediated document upload
    */
    function accrediated_document()
    {
        $data = array();
        $data["error"] = false;
        $data["msg"] = '';
        $data["url"] = '';
  
        if ($this->session->userdata('user_id') == '') {
            $data["url"] = 'home/login';
            $data["error"] = true;
            echo json_encode($data);
            die;
        } 
        //document_case=0 for executive summary file  ,document_case=1 for term sheet file
        $imagename = '';
       
                
                if (isset($_FILES['accreditation_letter']['name'])) {
                    $_FILES['userfile']['name'] = $_FILES['accreditation_letter']['name'];
                    $_FILES['userfile']['type'] = $_FILES['accreditation_letter']['type'];
                    $_FILES['userfile']['tmp_name'] = $_FILES['accreditation_letter']['tmp_name'];
                   
                    $_FILES['userfile']['error'] = $_FILES['accreditation_letter']['error'];
                    $_FILES['userfile']['size'] = $_FILES['accreditation_letter']['size'];
                    $image_settings = get_image_setting_data();
                    $finfo = new finfo(FILEINFO_MIME_TYPE);
                    $finfo->file($_FILES['userfile']['tmp_name']);
                        $getSupportedFileTypes = array('doc'=>'application/msword', 'pdf'=>'application/pdf', 'zip'=>'application/zip', 'odt'=>'application/vnd.oasis.opendocument.text', 'odt'=>'application/vnd.oasis.opendocument.text', 'rtf'=>'text/rtf', 'jpeg'=>'image/jpeg', 'jpg'=>'image/jpeg', 'png'=>'image/png', 'gif'=>'image/gif');
                    if (false === $file_extention = array_search($finfo->file($_FILES['userfile']['tmp_name']),$getSupportedFileTypes,true)) {
                        $data["create_step_error_doc"] = PLEASE_UPLOAD_DOC_IMAGE_ZIP_PDF;
                        $data["error"] = true;
                        echo json_encode($data);
                        die;
                    } else if ($_FILES["userfile"]["size"] > $image_settings['upload_limit']*1000000) {
                        $data["create_step_error_doc"] = sprintf(SORRY_THIS_FILE_IS_TOO_LARGE_PLEASE_SELECT_A_FILE_THAT_IS_LESS_THAN_MB,$image_settings['upload_limit']);
                        $data["error"] = true;
                        echo json_encode($data);
                        die;
                    } else {


                        $files = $_FILES;
                        $base_path = $this->config->slash_item('base_path');
                        $rand = rand(0, 100000);
                       
                        $path_parts = pathinfo($_FILES['accreditation_letter']['name']);
                        $date = new DateTime();
                        
                        $file_extention = $path_parts['extension'];
                        $new_img = $rand .'-accrediated-doc-'.$date->getTimestamp().'.'.$file_extention;
                       
                        move_uploaded_file($files["userfile"]["tmp_name"], $base_path . "upload/doc/" . $new_img);
                        $imagename = $new_img;

                        $data["image"]["image_name"] = $imagename;
                        $data["image"]["path"] = anchor(base_url() . "upload/doc/" . $imagename ,  $imagename, 'target="_blank"');


                    }
                }
                $data_array = array('verification_accreditation_letter' => $imagename);
                 $accreditation_data = $this->accreditation_model->getTableData('accreditation', array('user_id' => $this->session->userdata('user_id')));
                if ($accreditation_data) 
                {
                    $accreditation_id = $accreditation_data[0]['id'];

                    $this->accreditation_model->AddInsertUpdateTable('accreditation', 'id', $accreditation_id, $data_array);
                   

                } else {

                   $this->accreditation_model->AddInsertUpdateTable('accreditation', '','', $data_array);
                   
                }
              
          
           
        echo json_encode($data);
    }


    /*
    Function name :delete_accrediated_document()
    Parameter :none;
    Return : none
    Use : Delete  Document for accrediated ;
    Auther:Rakesh
    */
    function delete_accrediated_document()
    {
        $data = array();
        $data["error"] = false;
        $data["msg"] = '';
        $data["url"] = '';
       
        if ($this->session->userdata('user_id') == '') {
            $data["url"] = 'home/login';
            $data["error"] = true;
            echo json_encode($data);
            die;
        } 

        $data_array = array('verification_accreditation_letter' => '');
        $this->accreditation_model->AddInsertUpdateTable('accreditation', 'user_id', $this->session->userdata('user_id'), $data_array);

        echo json_encode($data);
    }


}
/* end of file */
